/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.JobExtensionMgr;
import org.eclipse.aperi.agent.handler.job.JobHandler;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.MessageLog;

public class JavaJobHandler
extends JobHandler {
    public void handle(Request request, Response response, Socket socket) {
        Object object;
        int n;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, response, connection");
        }
        this.init(request, response, socket);
        JobRun jobRun = (JobRun)request.requestData;
        StartedJob startedJob = new StartedJob(jobRun, 0L, 0L, 0, -1, 73, 0L);
        String[] stringArray = startedJob.getJobRun().getCommandLine();
        String string2 = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        IExecutable iExecutable = null;
        try {
            iExecutable = (IExecutable)JobExtensionMgr.getExtensionMgr().getExtensionImpl(string2);
        }
        catch (ExtensionException extensionException) {
            response.errorMessage = extensionException.getMessage();
        }
        if (iExecutable == null) {
            MessageLog.logMessage((String)"AGT0259E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName(), (Object)Integer.toString(jobRun.getSchedRunNumber()));
            if (response.errorMessage != null) {
                MessageLog.getThreadLog().println(response.errorMessage);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handle");
            }
            return;
        }
        String string3 = null;
        FileOutputStream fileOutputStream = null;
        if (jobRun.getLogDirectory() != null) {
            string = jobRun.getLogDirectory();
            n = 2;
        } else {
            string = Agent.logFileDirectory;
            n = 1;
        }
        do {
            object = JobUtils.generateLogFileName((RunReq)jobRun, (String)string);
            startedJob.setLogFileName((String)object);
            try {
                fileOutputStream = new FileOutputStream((String)object, true);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)iOException);
                }
                string3 = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)iOException);
            }
            if (fileOutputStream != null) continue;
            string = Agent.logFileDirectory;
        } while (fileOutputStream == null && --n > 0);
        if (fileOutputStream == null) {
            response.status = (short)12;
            response.errorMessage = string3;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handle");
            }
            return;
        }
        object = new PrintWriter(fileOutputStream, true);
        Link link = Agent.jobManager.jobInit(startedJob);
        if (link == null) {
            response.status = (short)12;
            ((PrintWriter)object).close();
            response.errorMessage = MessageLog.getMessage((String)"AGT0040E", null);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handle");
            }
            return;
        }
        response.responseData = startedJob.getLogFileName();
        Executor executor = new Executor(iExecutable, link, (PrintWriter)object, string, stringArray2);
        Agent.breadLine.assign(executor);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle");
        }
    }

    private class Executor
    implements IAssignable {
        private IExecutable toRun;
        private Link link;
        private StartedJob job;
        private PrintWriter output;
        private String dir;
        private String[] args;

        public Executor(IExecutable iExecutable, Link link, PrintWriter printWriter, String string, String[] stringArray) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"Executor", (String)"pToRun, pLink, pOutput, pDir");
            }
            this.toRun = iExecutable;
            this.link = link;
            this.job = (StartedJob)link.datum;
            this.output = printWriter;
            this.dir = string;
            this.args = stringArray;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"Executor");
            }
        }

        public void execute() {
            Error error;
            PrintWriter printWriter;
            block15: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"execute", (String)"");
                }
                JobUtil.purgeLogFiles((RunReq)this.job.getJobRun(), (String)this.dir);
                Agent.jobManager.jobWait(this.job);
                Agent.jobManager.jobExec(this.job);
                printWriter = MessageLog.getThreadLog();
                MessageLog.setThreadLog((PrintWriter)this.output);
                error = null;
                try {
                    this.job.setExitCode(this.toRun.exec(this.job, this.args));
                }
                catch (Throwable throwable) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"execute", (Throwable)throwable);
                    }
                    throwable.printStackTrace(this.output);
                    this.job.setExitCode(8);
                    if (!(throwable instanceof Error)) break block15;
                    error = (Error)throwable;
                }
            }
            MessageLog.setThreadLog((PrintWriter)printWriter);
            this.output.close();
            Agent.jobManager.finalizeJob(this.job.getExitCode(), this.link);
            if (error != null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"execute");
                }
                throw error;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.handler.job.JavaJobHandler$Executor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"execute");
            }
        }
    }
}

