/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.discovery.ExecDiscovery;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ImportManager {
    public static final String HOST_DELIMITER = ":/";
    private Map importMap;
    private Map aliasMap;
    private Computer computer;
    private NameList vendors;
    private Contactor contactor;
    private SnmpPeer peer;
    private boolean handlingAutomounts;
    private boolean rejectNonRoot;

    public ImportManager(Computer computer, String[] stringArray, NameList nameList, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ImportManager", (String)"pComputer, vendorArray, snmpCommunities, pRejectNonRoot");
        }
        this.computer = computer;
        this.rejectNonRoot = bl;
        this.importMap = new HashMap();
        this.aliasMap = new HashMap();
        if (stringArray == null) {
            this.peer = new SnmpPeer(null, null);
            this.contactor = new Contactor(this.peer, null, nameList);
        } else {
            this.vendors = NasUtil.parseVendorArray(stringArray);
            if (this.vendors != null) {
                this.peer = new SnmpPeer(null, null);
                this.contactor = new Contactor(this.peer, this.vendors, nameList);
            }
        }
        this.handlingAutomounts = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ImportManager");
        }
    }

    public void enterAutomountMode() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"enterAutomountMode", (String)"");
        }
        this.handlingAutomounts = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"enterAutomountMode");
        }
    }

    private static native boolean isRoot(String var0, boolean var1) throws LocalizableException;

    public static boolean isNetAppVolume(String string) {
        int n;
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isNetAppVolume", (String)"path");
        }
        int n3 = 0;
        if (string.startsWith("/vol/") && (n2 = string.length()) > 5 && ((n = string.indexOf(47, 5)) < 0 || n == n2 - 1)) {
            n3 = 1;
        }
        n2 = n3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isNetAppVolume", n2 != 0);
        }
        return n2 != 0;
    }

    private boolean isRoot(String string, String string2, short s) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isRoot", (String)"mountPoint, remotePath, osType");
        }
        boolean bl = s == 10 ? ImportManager.isNetAppVolume(string2) : (this.rejectNonRoot ? ImportManager.isRoot(string, this.handlingAutomounts) : false);
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isRoot", (boolean)bl2);
        }
        return bl2;
    }

    public int handleImport(Mounts mounts, String string) {
        boolean bl;
        NasFiler nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleImport", (String)"mounts");
        }
        if (string == null && this.vendors == null) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n);
            }
            return n;
        }
        String string2 = mounts.special;
        int n = string2.indexOf(HOST_DELIMITER);
        if (n <= 0) {
            MessageLog.logMessage((String)"NAA0039W", (Object)string2);
            int n2 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n2);
            }
            return n2;
        }
        String string3 = string2.substring(0, n).toLowerCase();
        String string4 = string2.substring(n + 1);
        Object v = this.aliasMap.get(string3);
        if (v instanceof String) {
            int n3 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n3);
            }
            return n3;
        }
        int n4 = 0;
        if (v instanceof NasFiler) {
            nasFiler = (NasFiler)v;
        } else {
            InetAddress inetAddress;
            block50: {
                inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(string3);
                }
                catch (UnknownHostException unknownHostException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block50;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"handleImport", (Throwable)unknownHostException);
                }
            }
            if (inetAddress == null) {
                MessageLog.logMessage((String)"GEN0039E", (Object)string3);
                int n5 = 4;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n5);
                }
                return n5;
            }
            this.peer.address = inetAddress;
            this.peer.name = string3;
            if (this.contactor.contact() == null) {
                if (!this.contactor.temporaryError) {
                    this.aliasMap.put(string3, HOST_DELIMITER);
                }
                int n6 = this.contactor.rc;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n6);
                }
                return n6;
            }
            nasFiler = this.computer.cmpNasFiler;
            while (nasFiler != null && !nasFiler.nfName.equals(this.peer.name)) {
                nasFiler = nasFiler.nfNext;
            }
            if (nasFiler == null) {
                nasFiler = ExecDiscovery.newFiler(this.peer, string3, this.contactor, null);
                if (!Probe.enumExports(nasFiler.nfComputer, string3)) {
                    n4 = 4;
                }
                nasFiler.nfNext = this.computer.cmpNasFiler;
                this.computer.cmpNasFiler = nasFiler;
            }
            this.aliasMap.put(string3, nasFiler);
        }
        if (nasFiler.nfOSType == 10 && string4.equals("/")) {
            string4 = "/vol/vol0";
        }
        if (this.importMap.containsKey(string2 = String.valueOf(string3) + HOST_DELIMITER + string4)) {
            int n7 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n7);
            }
            return n7;
        }
        this.importMap.put(string2, string2);
        try {
            bl = this.isRoot(mounts.mountPoint, string4, nasFiler.nfOSType);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handleImport", (Throwable)localizableException);
            }
            localizableException.print();
            int n8 = 4;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n8);
            }
            return n8;
        }
        boolean bl2 = this.rejectNonRoot ? bl : true;
        if (bl2) {
            Filesystem filesystem = new Filesystem();
            filesystem.fsNasFiler = nasFiler;
            n4 = mounts.statFS(filesystem);
            filesystem.fsType = bl || nasFiler.nfOSType != 10 ? (short)-1 : (short)16;
            Computer computer = nasFiler.nfComputer;
            computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
            filesystem.fsMountPoint = string4;
            LogicalDisk logicalDisk = new LogicalDisk();
            logicalDisk.ldFilesystem = filesystem;
            filesystem.fsLogicalDisk = logicalDisk;
            logicalDisk.ldCapacity = filesystem.fsCapacity;
            logicalDisk.ldPath = string4;
            logicalDisk.ldType = (byte)7;
            logicalDisk.ldNext = computer.cmpLogicalDisk;
            computer.cmpLogicalDisk = logicalDisk;
        }
        int n9 = n4;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleImport", (int)n9);
        }
        return n9;
    }

    public int handleSANFSMount(Mounts mounts) {
        NasFiler nasFiler;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleSANFSMount", (String)"mounts");
        }
        if (!mounts.type.equals("sanfs")) {
            int n = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleSANFSMount", (int)n);
            }
            return n;
        }
        int n = 0;
        String string = mounts.special;
        Object v = this.aliasMap.get(string);
        if (v instanceof String) {
            int n2 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleSANFSMount", (int)n2);
            }
            return n2;
        }
        if (v instanceof NasFiler) {
            nasFiler = (NasFiler)v;
        } else {
            nasFiler = this.computer.cmpNasFiler;
            while (nasFiler != null && !nasFiler.nfName.equals(string)) {
                nasFiler = nasFiler.nfNext;
            }
            if (nasFiler == null) {
                nasFiler = ExecDiscovery.newSANFSFileset(string);
                nasFiler.nfNext = this.computer.cmpNasFiler;
                this.computer.cmpNasFiler = nasFiler;
            }
            this.aliasMap.put(string, nasFiler);
        }
        if (this.importMap.containsKey(string)) {
            int n3 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleSANFSMount", (int)n3);
            }
            return n3;
        }
        this.importMap.put(string, string);
        MessageLog.logMessage((String)"STA0623I", (Object)nasFiler.nfName, (Object)mounts.mountPoint);
        Filesystem filesystem = new Filesystem();
        filesystem.fsNasFiler = nasFiler;
        n = mounts.statFS(filesystem);
        filesystem.fsType = (short)18;
        Computer computer = nasFiler.nfComputer;
        computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
        StringBuffer stringBuffer = new StringBuffer("/");
        stringBuffer.append(string);
        filesystem.fsMountPoint = stringBuffer.toString();
        LogicalDisk logicalDisk = new LogicalDisk();
        logicalDisk.ldFilesystem = filesystem;
        filesystem.fsLogicalDisk = logicalDisk;
        logicalDisk.ldCapacity = filesystem.fsCapacity;
        logicalDisk.ldPath = string;
        logicalDisk.ldType = (byte)7;
        logicalDisk.ldNext = computer.cmpLogicalDisk;
        computer.cmpLogicalDisk = logicalDisk;
        int n4 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.ImportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleSANFSMount", (int)n4);
        }
        return n4;
    }
}

