/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.netapp.DiskTableHandler;
import org.eclipse.aperi.agent.nas.netapp.FSAvailSpaceHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSAvailSpaceLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FSCapacityHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSCapacityLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FSUsedSpaceHighHandler;
import org.eclipse.aperi.agent.nas.netapp.FSUsedSpaceLowHandler;
import org.eclipse.aperi.agent.nas.netapp.FilesystemTableHandler;
import org.eclipse.aperi.agent.nas.netapp.InodeCapacityHandler;
import org.eclipse.aperi.agent.nas.netapp.InodesAvailHandler;
import org.eclipse.aperi.agent.nas.netapp.InodesUsedHandler;
import org.eclipse.aperi.agent.nas.netapp.ItemHandler;
import org.eclipse.aperi.agent.nas.netapp.PlexNameHandler;
import org.eclipse.aperi.agent.nas.netapp.SCSIAdapterHandler;
import org.eclipse.aperi.agent.nas.netapp.SCSIIDHandler;
import org.eclipse.aperi.agent.nas.netapp.SpareDiskTableHandler;
import org.eclipse.aperi.agent.nas.netapp.TableHandler;
import org.eclipse.aperi.agent.nas.netapp.TotalBloxHandler;
import org.eclipse.aperi.agent.nas.netapp.UsedBloxHandler;
import org.eclipse.aperi.agent.nas.netapp.VolAggrNameHandler;
import org.eclipse.aperi.agent.nas.netapp.VolNameHandler;
import org.eclipse.aperi.agent.nas.netapp.VolTypeHandler;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.LongInput;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeNetAppFiler {
    private SnmpPDU getPDU;
    public static final long[] NETAPP_RAIDV_TABLE = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 789L, 1L, 6L, 2L, 1L};
    public static final long[] NETAPP_VOL_TABLE = new long[]{1L, 3L, 6L, 1L, 4L, 1L, 789L, 1L, 5L, 8L, 1L};
    public static final int NETAPP_PREFIX_LENGTH = 8;
    static final int SPARE_PREFIX_LENGTH = NETAPP_RAIDV_TABLE.length;
    public static final int FS_PREFIX_LENGTH = 11;
    private static final int VOL_NAME = 2;
    private static final int VOL_AGGR_NAME = 9;
    private static final int VOL_TYPE = 10;
    private static final int RAIDV_DISK_ID = 4;
    private static final int RAIDV_SCSI_ADAPTER = 5;
    private static final int RAIDV_SCSI_ID = 6;
    private static final int RAIDV_USED_BLOCKS = 8;
    private static final int RAIDV_TOTAL_BLOCKS = 10;
    private static final int RAIDV_PLEX_NAME = 24;
    private static final int SPARE_DISK_ID = 4;
    private static final int SPARE_SCSI_ADAPTER = 5;
    private static final int SPARE_SCSI_ID = 6;
    private static final int SPARE_TOTAL_BLOCKS = 8;
    public static final int FS_NAME = 2;
    private static final int FS_INODES_USED = 7;
    private static final int FS_INODES_AVAIL = 8;
    private static final int FS_INODE_CAPCTY = 11;
    private static final int FS_CAPACITY_KB = 14;
    private static final int FS_USED_KB = 16;
    private static final int FS_AVAIL_KB = 18;
    private static final int GLOBAL_OS_VERSION = 2;
    private static final int GLOBAL_SERIAL_NO = 3;
    private static final int GLOBAL_MODEL = 5;
    private static final int GLOBAL_UPTIME = 1;
    private static final int GLOBAL_NCPUS = 6;
    private static final long[] RAIDV_ITEM_CODES = new long[]{5L, 6L, 10L, 8L, 24L};
    private static final long[] VOLTABLE_ITEM_CODES = new long[]{2L, 9L, 10L};
    private static final long[] SPARE_ITEM_CODES = new long[]{5L, 6L, 8L};
    private static ItemHandler[] diskItemHandlers;
    private static ItemHandler[] volItemHandlers;
    private static final long[] FS_ITEM_CODES;
    private static ItemHandler[] fsItemHandlers;
    int rc;
    Disk disk;
    Filesystem fs;
    Computer computer;
    Controller controller;
    private NasFiler filer;
    private SnmpSession listener;

    static {
        FS_ITEM_CODES = new long[]{7L, 8L, 11L, 14L, 15L, 16L, 17L, 18L, 19L};
        diskItemHandlers = new ItemHandler[RAIDV_ITEM_CODES.length];
        ProbeNetAppFiler.diskItemHandlers[0] = new SCSIAdapterHandler();
        ProbeNetAppFiler.diskItemHandlers[1] = new SCSIIDHandler();
        ProbeNetAppFiler.diskItemHandlers[2] = new TotalBloxHandler();
        ProbeNetAppFiler.diskItemHandlers[3] = new UsedBloxHandler();
        ProbeNetAppFiler.diskItemHandlers[4] = new PlexNameHandler();
        volItemHandlers = new ItemHandler[VOLTABLE_ITEM_CODES.length];
        ProbeNetAppFiler.volItemHandlers[0] = new VolNameHandler();
        ProbeNetAppFiler.volItemHandlers[1] = new VolAggrNameHandler();
        ProbeNetAppFiler.volItemHandlers[2] = new VolTypeHandler();
        fsItemHandlers = new ItemHandler[FS_ITEM_CODES.length];
        ProbeNetAppFiler.fsItemHandlers[0] = new InodesUsedHandler();
        ProbeNetAppFiler.fsItemHandlers[1] = new InodesAvailHandler();
        ProbeNetAppFiler.fsItemHandlers[2] = new InodeCapacityHandler();
        ProbeNetAppFiler.fsItemHandlers[3] = new FSCapacityHighHandler();
        ProbeNetAppFiler.fsItemHandlers[4] = new FSCapacityLowHandler();
        ProbeNetAppFiler.fsItemHandlers[5] = new FSUsedSpaceHighHandler();
        ProbeNetAppFiler.fsItemHandlers[6] = new FSUsedSpaceLowHandler();
        ProbeNetAppFiler.fsItemHandlers[7] = new FSAvailSpaceHighHandler();
        ProbeNetAppFiler.fsItemHandlers[8] = new FSAvailSpaceLowHandler();
    }

    private static InetAddress getInetAddr(String string) {
        InetAddress inetAddress;
        block10: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getInetAddr", (String)"hostName");
            }
            inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getInetAddr", (Throwable)unknownHostException);
            }
        }
        InetAddress inetAddress2 = inetAddress;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getInetAddr", (Object)inetAddress2);
        }
        return inetAddress2;
    }

    public static SnmpSession contact(NasFiler nasFiler, MutableInteger mutableInteger) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"contact", (String)"filer, pRC");
        }
        mutableInteger.value = 0;
        String string = nasFiler.nfName;
        InetAddress inetAddress = ProbeNetAppFiler.getInetAddr(string);
        if (inetAddress == null) {
            string = nasFiler.nfNetworkName;
            inetAddress = ProbeNetAppFiler.getInetAddr(string);
        }
        if (inetAddress == null) {
            Object[] objectArray = new Object[]{nasFiler.nfName, nasFiler.nfNetworkName};
            MessageLog.logMessage((String)"NAA0101E", (Object[])objectArray);
            SnmpSession snmpSession = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"contact", snmpSession);
            }
            return snmpSession;
        }
        SnmpPeer snmpPeer = new SnmpPeer(string, inetAddress);
        NameList nameList = new NameList();
        nameList.nlID = 789;
        nameList.nlName = nasFiler.nfManufacturer;
        Contactor contactor = new Contactor(snmpPeer, nameList, nasFiler.nfSnmpCommunity, false);
        if (contactor.contact() == null) {
            SnmpSession snmpSession = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"contact", snmpSession);
            }
            return snmpSession;
        }
        if (contactor.rc > mutableInteger.value) {
            mutableInteger.value = contactor.rc;
        }
        nasFiler.nfName = snmpPeer.name;
        SnmpSession snmpSession = contactor.listener;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"contact", (Object)snmpSession);
        }
        return snmpSession;
    }

    private static void fillVolTableOID(long[] lArray) {
        System.arraycopy(NETAPP_VOL_TABLE, 0, lArray, 0, NETAPP_VOL_TABLE.length);
    }

    private static void fillRaidVTableOID(long[] lArray) {
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, lArray, 0, NETAPP_RAIDV_TABLE.length);
    }

    private static void fillSpareTableOID(long[] lArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillSpareTableOID", (String)"output");
        }
        ProbeNetAppFiler.fillRaidVTableOID(lArray);
        lArray[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length - 2] = 3L;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillSpareTableOID");
        }
    }

    public static void fillFSTableOID(long[] lArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fillFSTableOID", (String)"output");
        }
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, lArray, 0, 8);
        lArray[8] = 5L;
        lArray[9] = 4L;
        lArray[10] = 1L;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fillFSTableOID");
        }
    }

    private static long[] makeFilerLevelOID() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeFilerLevelOID", (String)"");
        }
        long[] lArray = new long[11];
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, lArray, 0, 8);
        lArray[8] = 1L;
        long[] lArray2 = lArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeFilerLevelOID", (Object)lArray2);
        }
        return lArray2;
    }

    private static long[] makeVolNumOID() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeVolNumOID", (String)"");
        }
        long[] lArray = new long[11];
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, lArray, 0, 8);
        lArray[8] = 5L;
        lArray[9] = 9L;
        long[] lArray2 = lArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeVolNumOID", (Object)lArray2);
        }
        return lArray2;
    }

    private static long[] makeCPUStatsOID() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeCPUStatsOID", (String)"");
        }
        long[] lArray = new long[12];
        System.arraycopy(NETAPP_RAIDV_TABLE, 0, lArray, 0, 8);
        lArray[8] = 2L;
        lArray[9] = 1L;
        long[] lArray2 = lArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeCPUStatsOID", (Object)lArray2);
        }
        return lArray2;
    }

    static void encodeTriple(long[] lArray, Device device) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"encodeTriple", (String)"array, dev");
        }
        int n = lArray.length - 3;
        long l = lArray[n];
        l <<= 21;
        l |= lArray[++n];
        l <<= 21;
        device.devDiscoveredTime = l |= lArray[++n];
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"encodeTriple");
        }
    }

    private static void decodeTriple(Device device, long[] lArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"decodeTriple", (String)"dev, array");
        }
        long l = device.devDiscoveredTime;
        int n = 0x1FFFFF;
        int n2 = lArray.length - 1;
        lArray[n2] = (int)l & n;
        lArray[--n2] = (int)(l >>= 21) & n;
        lArray[--n2] = (int)(l >>= 21) & n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"decodeTriple");
        }
    }

    static long high32KB2Long(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"high32KB2Long", (String)"high32KB");
        }
        long l = n;
        long l2 = l <<= 33;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"high32KB2Long", (long)l2);
        }
        return l2;
    }

    static long low32KB2Long(int n, long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"low32KB2Long", (String)"low32KB, originalField");
        }
        if ((l & 1L) != 0L) {
            l = 0L;
        }
        long l2 = n;
        long l3 = l | (l2 <<= 1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"low32KB2Long", (long)l3);
        }
        return l3;
    }

    static Device newDisk() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"newDisk", (String)"");
        }
        Disk disk = new Disk();
        disk.devModel = disk.devManufacturer = "NETWORK APPLIANCE";
        disk.devFirmwareRev = " ";
        disk.devType = 0;
        disk.devFlags = (short)2;
        disk.devUnsupportedModel = true;
        Disk disk2 = disk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"newDisk", (Object)disk2);
        }
        return disk2;
    }

    public static Number checkNumber(Serializable serializable, NasFiler nasFiler) {
        Number number;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkNumber", (String)"value, pFiler");
        }
        if (serializable instanceof LongInput) {
            number = new Long(((LongInput)serializable).getValue());
        } else if (serializable instanceof Number) {
            number = (Number)serializable;
        } else {
            number = null;
            MessageLog.logMessage((String)"NAA0079E", (Object)nasFiler.nfName);
            MessageLog.logMessage((String)"NAA0084E", (Object)serializable.getClass().getName());
        }
        Number number2 = number;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkNumber", (Object)number2);
        }
        return number2;
    }

    public static String checkString(Serializable serializable, NasFiler nasFiler) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkString", (String)"value, pFiler");
        }
        if (serializable instanceof OctetString) {
            string = ((OctetString)serializable).toDisplayString();
        } else {
            string = null;
            MessageLog.logMessage((String)"NAA0086W", (Object)nasFiler.nfName, (Object)serializable.getClass().getName());
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkString", (Object)string2);
        }
        return string2;
    }

    Number checkNumber(Serializable serializable) {
        return ProbeNetAppFiler.checkNumber(serializable, this.filer);
    }

    String checkString(Serializable serializable) {
        return ProbeNetAppFiler.checkString(serializable, this.filer);
    }

    public static Serializable sendGetRequest(OID oID, boolean bl, SnmpSession snmpSession, SnmpPDU snmpPDU, NasFiler nasFiler) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendGetRequest", (String)"oid, whine, pListener, pPDU, pFiler");
        }
        SnmpVarBind snmpVarBind = null;
        Serializable serializable = null;
        snmpPDU.operation = 0;
        Vector<SnmpVarBind> vector = snmpPDU.varBindList;
        if (vector == null) {
            snmpPDU.varBindList = vector = new Vector<SnmpVarBind>();
        }
        vector.clear();
        vector.addElement(new SnmpVarBind(oID));
        snmpPDU.communityString = null;
        SnmpPDU snmpPDU2 = snmpSession.send(snmpPDU);
        if (snmpPDU2 != null) {
            if (snmpPDU2.errorStatus != 0) {
                if (bl || snmpPDU2.errorStatus != 2) {
                    MessageLog.logMessage((String)"NAA0078E", (Object)nasFiler.nfName);
                }
            } else {
                if (snmpPDU2.varBindListSize() > 0) {
                    snmpVarBind = snmpPDU2.varBindAt(0);
                }
                if (snmpVarBind != null) {
                    serializable = snmpVarBind.getVar();
                }
                if (serializable == null) {
                    MessageLog.logMessage((String)"NAA0085W", (Object)nasFiler.nfName);
                }
            }
        }
        if (serializable == null && bl) {
            MessageLog.logMessage((String)"NAA0081I", (Object)oID.toString());
        }
        Serializable serializable2 = serializable;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendGetRequest", (Object)serializable2);
        }
        return serializable2;
    }

    private Serializable sendGetRequest(OID oID, boolean bl) {
        return ProbeNetAppFiler.sendGetRequest(oID, bl, this.listener, this.getPDU, this.filer);
    }

    private Serializable sendGetRequest(OID oID) {
        return this.sendGetRequest(oID, true);
    }

    private boolean requestAndHandle(OID oID, ItemHandler itemHandler) {
        Serializable serializable;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"requestAndHandle", (String)"oid, handler");
        }
        boolean bl2 = bl = (serializable = this.sendGetRequest(oID)) != null;
        if (bl && !(bl = itemHandler.handle(this, serializable))) {
            MessageLog.logMessage((String)"NAA0081I", (Object)oID.toString());
        }
        boolean bl3 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"requestAndHandle", (boolean)bl3);
        }
        return bl3;
    }

    private void finishOffLogicalDisk(LogicalDisk logicalDisk, LogicalDisk logicalDisk2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"finishOffLogicalDisk", (String)"ld, lastLD");
        }
        logicalDisk.ldCapacity = 0L;
        ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
        while (chunkCollection != null) {
            Chunk chunk = chunkCollection.ccChunkList;
            if (chunk.chkNextInCollection == null) {
                chunkCollection.ccType = 0;
                logicalDisk.ldCapacity += chunk.chkSize;
            } else {
                do {
                    chunk = chunk.chkNextInCollection;
                    logicalDisk.ldCapacity += chunk.chkSize;
                } while (chunk.chkNextInCollection != null);
            }
            chunkCollection = chunkCollection.ccNext;
        }
        if (logicalDisk2 != null) {
            logicalDisk2.ldNext = logicalDisk;
        } else {
            this.computer.cmpLogicalDisk = logicalDisk;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finishOffLogicalDisk");
        }
    }

    private void finishOffLogicalDisk(LogicalDisk logicalDisk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"finishOffLogicalDisk", (String)"ld");
        }
        logicalDisk.ldCapacity = 0L;
        while (logicalDisk != null) {
            ChunkCollection chunkCollection = logicalDisk.ldCollectionList;
            while (chunkCollection != null) {
                Chunk chunk = chunkCollection.ccChunkList;
                if (chunk.chkNextInCollection == null) {
                    chunkCollection.ccType = 0;
                    logicalDisk.ldCapacity += chunk.chkSize;
                } else {
                    do {
                        chunk = chunk.chkNextInCollection;
                        logicalDisk.ldCapacity += chunk.chkSize;
                    } while (chunk.chkNextInCollection != null);
                }
                chunkCollection = chunkCollection.ccNext;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"finishOffLogicalDisk");
        }
    }

    private void makeDiskHistory() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeDiskHistory", (String)"");
        }
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            DiskHistory diskHistory;
            this.disk.dskSectorSize = 512;
            this.disk.dskLogicalBlockSize = 512;
            this.disk.dskSectorsPerAvgTrack = -1;
            this.disk.dskSectorsPerOuterTrack = -1;
            this.disk.dskSectorsPerInnerTrack = -1;
            this.disk.dskHeads = -1;
            this.disk.dskCylinders = -1;
            this.disk.dskCapacity = -1L;
            this.disk.dskRPM = -1;
            this.disk.dskMinutesPoweredOn = -1;
            this.disk.dskSpareBlocks = -1;
            this.disk.dskHistory = diskHistory = new DiskHistory();
            diskHistory.dkhPrimaryDefects = -1;
            diskHistory.dkhGrownDefects = -1;
            diskHistory.dkhRecoveredWriteErrors = -1;
            diskHistory.dkhUnrecoveredWriteErrors = -1;
            diskHistory.dkhBytesWritten = -1L;
            diskHistory.dkhRecoveredReadErrors = -1;
            diskHistory.dkhUnrecoveredReadErrors = -1;
            diskHistory.dkhBytesRead = -1L;
            diskHistory.dkhRecoveredVerifyErrors = -1;
            diskHistory.dkhUnrecoveredVerifyErrors = -1;
            diskHistory.dkhNonMediumErrors = -1;
            diskHistory.dkhTemperature = (short)-274;
            diskHistory.dkhCapacity = -1L;
            diskHistory.dkhFreeSpace = -1L;
            this.disk = (Disk)this.disk.devNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeDiskHistory");
        }
    }

    public int probe(NasFiler nasFiler, Domain domain) {
        DiskHistory diskHistory;
        ItemHandler itemHandler;
        Object object;
        Object object2;
        ItemHandler itemHandler2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"probe", (String)"pFiler, domain");
        }
        this.filer = nasFiler;
        MutableInteger mutableInteger = new MutableInteger();
        this.listener = ProbeNetAppFiler.contact(this.filer, mutableInteger);
        if (this.listener == null) {
            int n = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n);
            }
            return n;
        }
        this.rc = mutableInteger.value;
        mutableInteger = null;
        this.getPDU = this.listener.makePDU();
        this.computer = new Computer();
        this.computer.cmpDomain = domain;
        if (domain != null) {
            this.computer.cmpDomainID = domain.domID;
        }
        this.computer.cmpID = this.filer.nfComputerID;
        this.computer.cmpProcessorType = this.computer.cmpOSVersion = " ";
        this.computer.cmpManufacturer = this.filer.nfManufacturer;
        this.computer.cmpModel = this.computer.cmpOSVersion;
        this.computer.cmpSerialNumber = this.computer.cmpOSVersion;
        this.computer.cmpRAM = -1;
        this.computer.cmpSwapSpace = -1;
        this.computer.cmpLastBootTime = 0L;
        this.computer.cmpOSType = (short)10;
        this.computer.cmpProcessorCount = 1;
        this.computer.cmpProcessorSpeed = (short)-1;
        long[] lArray = ProbeNetAppFiler.makeFilerLevelOID();
        lArray[lArray.length - 2] = 2L;
        String string = null;
        Serializable serializable = this.sendGetRequest(new OID(lArray));
        if (serializable != null) {
            string = this.checkString(serializable);
        }
        if (string == null) {
            this.rc = 4;
        } else {
            if (string.length() > 32) {
                string = string.substring(0, 32);
            }
            this.computer.cmpOSVersion = string;
        }
        lArray[lArray.length - 2] = 3L;
        string = null;
        serializable = this.sendGetRequest(new OID(lArray));
        if (serializable != null) {
            string = this.checkString(serializable);
        }
        if (string == null) {
            this.rc = 4;
        } else {
            this.computer.cmpSerialNumber = string;
        }
        lArray[lArray.length - 2] = 5L;
        string = null;
        serializable = this.sendGetRequest(new OID(lArray), false);
        if (serializable != null) {
            string = this.checkString(serializable);
        }
        if (string != null) {
            this.computer.cmpModel = string;
        }
        lArray = ProbeNetAppFiler.makeCPUStatsOID();
        lArray[lArray.length - 2] = 1L;
        Number number = null;
        serializable = this.sendGetRequest(new OID(lArray));
        if (serializable != null) {
            number = this.checkNumber(serializable);
        }
        if (number == null) {
            this.rc = 4;
        } else {
            long l = number.longValue();
            l *= 10L;
            l += 50L;
            if (Variables.whoAmI == 2) {
                this.computer.cmpLastBootTime = System.currentTimeMillis() - l;
            } else {
                try {
                    this.computer.cmpLastBootTime = CurrentTime.getTimestamp().getTime() - l;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    int n = 8;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"probe", (Throwable)exception);
                    }
                    return n;
                }
            }
        }
        lArray[lArray.length - 2] = 6L;
        number = null;
        serializable = this.sendGetRequest(new OID(lArray), false);
        if (serializable != null) {
            number = this.checkNumber(serializable);
        }
        if (number != null) {
            this.computer.cmpProcessorCount = number.shortValue();
        }
        if ((serializable = this.sendGetRequest(new OID(lArray = ProbeNetAppFiler.makeVolNumOID()))) != null) {
            number = this.checkNumber(serializable);
        }
        if (number == null) {
            this.rc = 4;
        } else {
            this.computer.cmpNLogicalDisks = number.intValue();
        }
        this.filer.nfComputer = this.computer;
        lArray = new long[NETAPP_RAIDV_TABLE.length + 4];
        ProbeNetAppFiler.fillRaidVTableOID(lArray);
        lArray[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length] = 4L;
        TableHandler tableHandler = new DiskTableHandler(new OID(lArray), this.filer, this.listener);
        if (!tableHandler.go()) {
            this.listener.close();
            int n = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n);
            }
            return n;
        }
        this.makeDiskHistory();
        int n = 0;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            n = 0;
            while (n < RAIDV_ITEM_CODES.length) {
                lArray[ProbeNetAppFiler.NETAPP_RAIDV_TABLE.length] = RAIDV_ITEM_CODES[n];
                itemHandler2 = diskItemHandlers[n];
                ProbeNetAppFiler.decodeTriple((Device)this.disk, lArray);
                if (!this.requestAndHandle(new OID(lArray), itemHandler2)) {
                    this.listener.close();
                    int n2 = 8;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n2);
                    }
                    return n2;
                }
                ++n;
            }
            this.disk = (Disk)this.disk.devNext;
        }
        itemHandler2 = null;
        ChunkCollection chunkCollection = null;
        this.disk = (Disk)this.computer.cmpDevice;
        int n3 = 0;
        lArray = new long[NETAPP_VOL_TABLE.length + 2];
        ProbeNetAppFiler.fillVolTableOID(lArray);
        n3 = this.computer.cmpNLogicalDisks;
        int n4 = VOLTABLE_ITEM_CODES.length;
        if (this.computer.cmpOSVersion.indexOf("Release 7.") == -1) {
            n4 = 1;
        }
        while (n3 > 0) {
            n = 0;
            while (n < n4) {
                object2 = volItemHandlers[n];
                lArray[ProbeNetAppFiler.NETAPP_VOL_TABLE.length] = VOLTABLE_ITEM_CODES[n];
                lArray[ProbeNetAppFiler.NETAPP_VOL_TABLE.length + 1] = n3;
                if (!this.requestAndHandle(new OID(lArray), (ItemHandler)object2)) {
                    this.listener.close();
                    int n5 = 8;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n5);
                    }
                    return n5;
                }
                ++n;
            }
            --n3;
        }
        lArray = new long[3];
        object2 = new HashSet();
        while (this.disk != null) {
            ProbeNetAppFiler.decodeTriple((Device)this.disk, lArray);
            if (!((HashSet)object2).contains(this.disk.dskPlexName)) {
                chunkCollection = new ChunkCollection();
                chunkCollection.ccType = (byte)3;
                chunkCollection.ccSeqno = (short)lArray[1];
                chunkCollection.ccStripingSize = -1;
                chunkCollection.ccAggrName = this.disk.dskPlexName.substring(1, this.disk.dskPlexName.indexOf("/plex"));
                itemHandler2 = this.computer.cmpLogicalDisk;
                chunkCollection.ccLogicalDiskID = -1;
                ((HashSet)object2).add(this.disk.dskPlexName);
                while (itemHandler2 != null) {
                    if (((LogicalDisk)itemHandler2).ldAggrName.equals(chunkCollection.ccAggrName) || ((LogicalDisk)itemHandler2).ldName.equals(chunkCollection.ccAggrName)) {
                        chunkCollection.ccNext = ((LogicalDisk)itemHandler2).ldCollectionList;
                        ((LogicalDisk)itemHandler2).ldCollectionList = chunkCollection;
                    }
                    if (((LogicalDisk)itemHandler2).ldName.equals(chunkCollection.ccAggrName)) {
                        chunkCollection.ccLogicalDisk = itemHandler2;
                    }
                    itemHandler2 = ((LogicalDisk)itemHandler2).ldNext;
                }
            }
            Chunk chunk = new Chunk();
            chunk.chkDisk = this.disk;
            chunk.chkNextOnDisk = this.disk.dskChunk;
            this.disk.dskChunk = chunk;
            chunk.chkOffset = 0L;
            chunk.chkSize = this.disk.dskCapacity - this.disk.dskHistory.dkhFreeSpace;
            chunk.chkSeqno = (short)lArray[2];
            chunk.chkPartition = (short)-1;
            chunk.chkUnitSize = 512;
            chunk.chkLogicalDiskID = -1;
            this.disk.devDiscoveredTime = 0L;
            if (chunk.chkDisk.dskPlexName.startsWith(chunkCollection.ccAggrName, 1)) {
                chunk.chkCollection = chunkCollection;
                chunk.chkNextInCollection = chunkCollection.ccChunkList;
                chunkCollection.ccChunkList = chunk;
            } else {
                itemHandler2 = this.computer.cmpLogicalDisk;
                while (itemHandler2 != null) {
                    if (chunk.chkDisk.dskPlexName.startsWith(((LogicalDisk)itemHandler2).ldCollectionList.ccAggrName, 1)) {
                        chunk.chkCollection = ((LogicalDisk)itemHandler2).ldCollectionList;
                        chunk.chkNextInCollection = ((LogicalDisk)itemHandler2).ldCollectionList.ccChunkList;
                        ((LogicalDisk)itemHandler2).ldCollectionList.ccChunkList = chunk;
                    }
                    itemHandler2 = ((LogicalDisk)itemHandler2).ldNext;
                }
            }
            this.disk = (Disk)this.disk.devNext;
        }
        if (this.computer.cmpLogicalDisk != null) {
            this.finishOffLogicalDisk(this.computer.cmpLogicalDisk);
        }
        lArray = new long[13];
        ProbeNetAppFiler.fillFSTableOID(lArray);
        lArray[11] = 2L;
        tableHandler = new FilesystemTableHandler(new OID(lArray), this.filer, this.listener, this.computer.cmpNLogicalDisks);
        if (!tableHandler.go()) {
            this.listener.close();
            int n6 = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n6);
            }
            return n6;
        }
        n = 0;
        while (n < FS_ITEM_CODES.length) {
            lArray[11] = FS_ITEM_CODES[n];
            object = fsItemHandlers[n];
            itemHandler2 = this.computer.cmpLogicalDisk;
            while (itemHandler2 != null) {
                this.fs = ((LogicalDisk)itemHandler2).ldFilesystem;
                if (this.fs != null) {
                    lArray[lArray.length - 1] = this.fs.fsClusterSize;
                    if (!this.requestAndHandle(new OID(lArray), (ItemHandler)object)) {
                        this.listener.close();
                        int n7 = 8;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n7);
                        }
                        return n7;
                    }
                }
                itemHandler2 = ((LogicalDisk)itemHandler2).ldNext;
            }
            ++n;
        }
        object = this.computer.cmpDevice;
        this.computer.cmpDevice = null;
        lArray = new long[SPARE_PREFIX_LENGTH + 2];
        ProbeNetAppFiler.fillSpareTableOID(lArray);
        lArray[ProbeNetAppFiler.SPARE_PREFIX_LENGTH] = 4L;
        tableHandler = new SpareDiskTableHandler(new OID(lArray), this.filer, this.listener);
        if (!tableHandler.go()) {
            this.listener.close();
            int n8 = 8;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n8);
            }
            return n8;
        }
        this.makeDiskHistory();
        n = 0;
        while (n < SPARE_ITEM_CODES.length) {
            lArray[ProbeNetAppFiler.SPARE_PREFIX_LENGTH] = SPARE_ITEM_CODES[n];
            itemHandler = diskItemHandlers[n];
            this.disk = (Disk)this.computer.cmpDevice;
            while (this.disk != null) {
                lArray[lArray.length - 1] = (int)this.disk.devDiscoveredTime;
                if (!this.requestAndHandle(new OID(lArray), itemHandler)) {
                    this.listener.close();
                    int n9 = 8;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n9);
                    }
                    return n9;
                }
                this.disk = (Disk)this.disk.devNext;
            }
            ++n;
        }
        this.listener.close();
        this.listener = null;
        itemHandler = null;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            this.disk.devDiscoveredTime = 0L;
            this.disk.dskHistory.dkhFreeSpace = this.disk.dskCapacity;
            itemHandler = this.disk;
            this.disk = (Disk)this.disk.devNext;
        }
        if (itemHandler != null) {
            ((Device)itemHandler).devNext = object;
        } else {
            this.computer.cmpDevice = object;
        }
        this.computer.cmpDiskCapacity = 0L;
        this.computer.cmpDiskFreeSpace = 0L;
        this.disk = (Disk)this.computer.cmpDevice;
        while (this.disk != null) {
            diskHistory = this.disk.dskHistory;
            this.computer.cmpDiskCapacity += diskHistory.dkhCapacity;
            this.computer.cmpDiskFreeSpace += diskHistory.dkhFreeSpace;
            Device device = this.disk.devNext;
            this.disk.devNext = null;
            this.disk = (Disk)device;
        }
        this.computer.cmpOwnedDiskCap = this.computer.cmpDiskCapacity;
        this.computer.cmpOwnedDiskFreeSp = this.computer.cmpDiskFreeSpace;
        this.computer.cmpFilesystemFreeSpace = 0L;
        itemHandler2 = this.computer.cmpLogicalDisk;
        while (itemHandler2 != null) {
            this.fs = ((LogicalDisk)itemHandler2).ldFilesystem;
            if (this.fs != null) {
                if (this.fs.fsFreeSpace + this.fs.fsUsedSpace > this.fs.fsCapacity) {
                    this.fs.fsFreeSpace = this.fs.fsCapacity - this.fs.fsUsedSpace;
                }
                this.computer.cmpFilesystemFreeSpace += this.fs.fsFreeSpace;
            }
            itemHandler2 = ((LogicalDisk)itemHandler2).ldNext;
        }
        this.fs = this.filer.nfFilesystems;
        while (this.fs != null) {
            diskHistory = this.fs.fsNext;
            this.fs.fsNext = null;
            itemHandler2 = new LogicalDisk();
            ((LogicalDisk)itemHandler2).ldPath = this.fs.fsMountPoint;
            ((LogicalDisk)itemHandler2).ldFilesystem = this.fs;
            this.fs.fsLogicalDisk = itemHandler2;
            ((LogicalDisk)itemHandler2).ldType = (byte)7;
            ((LogicalDisk)itemHandler2).ldNext = this.computer.cmpLogicalDisk;
            this.computer.cmpLogicalDisk = itemHandler2;
            this.fs = diskHistory;
        }
        this.filer.nfFilesystems = null;
        Probe.arrangeDevices(this.computer, null);
        Probe.calculateLDOverhead(this.computer);
        int n10 = this.rc;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"probe", (int)n10);
        }
        return n10;
    }
}

