/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.report;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.aperi.TStorm.common.BatchReport;
import org.eclipse.aperi.TStorm.common.MakeBatchGraph;
import org.eclipse.aperi.TStorm.common.PrintHistoryChart;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.agent.handler.HandlerExtensionMgr;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.identity.SuperUser;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecReport
implements IExecutable {
    private GuiReportReq grr;
    private JobRun jobRun;
    private MutableLong keyObj;
    private ReportDataAdjuster adjuster;
    private StartedJob startedJob;
    private String outputFileName;
    private boolean chartReport;
    private String[] values = new String[7];
    private Object[] parms = new Object[5];
    private String[] keywords;
    private byte reportType = 0;

    public int exec(StartedJob startedJob, String[] stringArray) {
        return this.exec(startedJob);
    }

    private int exec(StartedJob startedJob) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"main", (String)"");
        }
        this.init(startedJob);
        ReportDataAdjuster reportDataAdjuster = null;
        int n = 8;
        int[] nArray = null;
        this.parms[0] = this.jobRun.getSchedCreator();
        this.parms[1] = this.jobRun.getSchedName();
        MessageLog.logMessage((String)"STA2000I", (Object[])this.parms);
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.subType = "org.eclipse.aperi.server.handler.agent.BatchReportHndlr";
        request.serviceName = RequestTypeManager.getInternalName((String)"org.eclipse.aperi.server.svp.AgentSvp");
        request.requestData = this.keyObj;
        BatchReport batchReport = null;
        Response response = Agent.reporter.sendRequest(request);
        if (response == null || response.status > 4) {
            MessageLog.logMessage((String)"AGT0151E");
        } else {
            Object[] objectArray;
            Object object;
            batchReport = (BatchReport)response.responseData;
            this.grr = batchReport.grr;
            this.keywords = BatchReport.keywords;
            String string = this.getFileName(batchReport, this.grr);
            this.reportType = batchReport.reportType;
            this.chartReport = false;
            if (this.reportType == 8 || this.reportType == 9) {
                this.chartReport = true;
                object = new GuiChartSettingsReq();
                ((GuiChartSettingsReq)object).creator = this.jobRun.getSchedCreator();
                ((GuiChartSettingsReq)object).reqType = 5;
                objectArray = new Request();
                objectArray.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                objectArray.serviceName = RequestTypeManager.getInternalName((String)objectArray.typeCode);
                objectArray.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
                objectArray.flags = (byte)4;
                objectArray.userName = this.jobRun.getSchedCreator();
                objectArray.requestData = object;
                Response response2 = Agent.reporter.sendRequest((Request)objectArray);
                if (response2.status <= 4) {
                    AperiChartCustomizationManager.initManager((String)this.jobRun.getSchedCreator(), (ArrayList)((ArrayList)response2.responseData));
                }
            }
            object = null;
            switch (this.reportType) {
                case 8: {
                    object = MessageLog.getMessageNoID((String)"STG5269L");
                    break;
                }
                case 6: 
                case 9: {
                    object = MessageLog.getMessageNoID((String)"STG5270L");
                    break;
                }
                case 1: 
                case 7: {
                    object = ".csv";
                    break;
                }
                case 2: {
                    object = ".txt";
                }
            }
            if (string.length() > ((String)object).length() && !string.substring(string.length() - 1 - (((String)object).length() - 1)).equalsIgnoreCase((String)object)) {
                string = String.valueOf(string) + (String)object;
            }
            int n2 = 0;
            this.parms[0] = string;
            MessageLog.logMessage((String)"STA2001I", (Object[])this.parms);
            Object object2 = this.getPrintWriter(string);
            if (object2 != null) {
                PrintWriter printWriter = null;
                FileOutputStream fileOutputStream = null;
                if (this.chartReport) {
                    fileOutputStream = (FileOutputStream)object2;
                } else {
                    printWriter = (PrintWriter)object2;
                }
                objectArray = batchReport.data instanceof PartitionedReport ? this.getArray((PartitionedReport)batchReport.data) : (Object[])batchReport.data;
                if (objectArray == null || objectArray.length == 0) {
                    if (this.reportType == 2) {
                        printWriter.println(MessageLog.getMessageNoID((String)"STG5171M"));
                    } else if (this.reportType == 6) {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.GuiResources");
                        String string2 = String.valueOf(MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[this.grr.reportType][2])) + resourceBundle.getString("COLON") + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[this.grr.reportSubtype][0]);
                        new PrintHtmlTable().printPrelude(printWriter, this.jobRun.getSchedCreator(), string2, 777, false);
                        printWriter.println(" ");
                        printWriter.println(MessageLog.getMessageNoID((String)"STG5171M"));
                        printWriter.println(" ");
                        printWriter.println("</body>");
                        printWriter.println("</html>");
                    }
                    n = 4;
                } else {
                    reportDataAdjuster = null;
                    try {
                        reportDataAdjuster = ReportDataAdjuster.makeAdjuster((GuiReportReq)this.grr);
                    }
                    catch (GeneralException generalException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"main", (Throwable)generalException);
                        }
                        generalException.print();
                    }
                    if (reportDataAdjuster != null) {
                        Variables.spaceUnits = batchReport.spaceUnits;
                        reportDataAdjuster.adjust(objectArray, true);
                        if (this.chartReport) {
                            MakeBatchGraph makeBatchGraph = new MakeBatchGraph();
                            n = makeBatchGraph.makeGraph(this.grr, reportDataAdjuster, objectArray, fileOutputStream, this.outputFileName, this.reportType, this.jobRun.getSchedCreator(), batchReport);
                        } else if (this.reportType == 7) {
                            this.grr.selectedStatIDs = reportDataAdjuster.initHistoryLegend();
                            if (this.grr.selectedResources == null) {
                                this.grr.selectedResources = reportDataAdjuster.getSelectedIDs();
                            }
                            this.grr.selectedUsers = reportDataAdjuster.getSelectedUsers();
                            MessageLog.logMessage((String)"AGT0149I");
                            request = new Request();
                            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                            request.subType = "org.eclipse.aperi.server.handler.gui.GuiReportHndlr";
                            request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
                            request.requestData = this.grr;
                            int n3 = this.grr.reportSubtype;
                            this.grr.reportSubtype = 28;
                            response = Agent.reporter.sendRequest(request);
                            this.grr.reportSubtype = n3;
                            if (response == null || response.status > 4) {
                                n = 8;
                            } else {
                                MessageLog.logMessage((String)"AGT0148I");
                                objectArray = response.responseData instanceof PartitionedReport ? (Object[])((PartitionedReport)response.responseData).prData : (Object[])response.responseData;
                                if (objectArray == null || objectArray.length == 0) {
                                    n = 4;
                                } else {
                                    this.grr.reportSubtype = n3;
                                    String string3 = null;
                                    if (batchReport.includeHeaders) {
                                        string3 = batchReport.historyHeader;
                                    }
                                    n2 = new PrintHistoryChart().printBatch(this.grr, (Object)objectArray, printWriter, string3);
                                    n = 0;
                                }
                            }
                        } else {
                            MessageLog.logMessage((String)"AGT0148I");
                            int[] nArray2 = reportDataAdjuster.fixColumnArray(null);
                            if (this.reportType == 6) {
                                ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.xmsg.GuiResources");
                                String string4 = String.valueOf(MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[this.grr.reportType][2])) + resourceBundle.getString("COLON") + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[this.grr.reportSubtype][0]);
                                new PrintHtmlTable().printHtml(reportDataAdjuster, printWriter, nArray2, this.jobRun.getSchedCreator(), string4, nArray);
                            } else {
                                WriteReports writeReports = new WriteReports();
                                if (this.reportType == 1) {
                                    writeReports.writeCSV(reportDataAdjuster, printWriter, nArray2, batchReport.includeHeaders, batchReport.includeTotals, nArray);
                                } else {
                                    writeReports.writeFormatted(reportDataAdjuster, printWriter, nArray2, nArray);
                                }
                            }
                            n2 = reportDataAdjuster.getNumberRows();
                            n = 0;
                        }
                    }
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            if (this.chartReport) {
                if (n == 4) {
                    MessageLog.logMessage((String)"STA2012I");
                }
            } else if (n2 == 1) {
                MessageLog.logMessage((String)"STA2006I");
            } else {
                this.parms[0] = Integer.toString(n2);
                MessageLog.logMessage((String)"STA2002I", (Object[])this.parms);
            }
        }
        if (n > 4) {
            MessageLog.logMessage((String)"STA2008I");
        } else {
            if (n == 0) {
                MessageLog.logMessage((String)"STA2003I");
            } else {
                MessageLog.logMessage((String)"STA2007I");
            }
            if (!Util.isEmpty((String)batchReport.scriptName)) {
                this.kickOffScript(batchReport);
            }
        }
        int n4 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"main", (int)n4);
        }
        return n4;
    }

    private void init(StartedJob startedJob) {
        this.startedJob = startedJob;
        this.jobRun = startedJob.getJobRun();
        long l = this.jobRun.getSchedID();
        l = Agent.isWindows ? (l |= 0x100000000L) : (l &= 0xFFFFFFFFL);
        this.keyObj = new MutableLong(l);
    }

    private String getFileName(BatchReport batchReport, GuiReportReq guiReportReq) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFileName", (String)"bp, grr");
        }
        this.values[0] = this.jobRun.getSchedCreator();
        this.values[1] = this.jobRun.getSchedName();
        this.values[2] = WriteReports.adjustFileName((String)(String.valueOf(MessageLog.getMessageNoID((String)GuiReportReq.guiClasses[guiReportReq.reportType][2])) + MessageLog.getMessageNoID((String)GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0])));
        int n = this.jobRun.getSchedRunNumber();
        String string = "000" + Integer.toString(this.jobRun.getSchedRunNumber());
        this.values[3] = n < 10000 ? string.substring(string.length() - 4) : (n < 100000 ? string.substring(string.length() - 5) : (n < 1000000 ? string.substring(string.length() - 6) : (n < 10000000 ? string.substring(string.length() - 7) : (n < 100000000 ? string.substring(string.length() - 8) : string.substring(string.length() - 9)))));
        Date date = new Date();
        this.values[4] = new SimpleDateFormat("yyyy_MM_dd").format(date);
        this.values[5] = new SimpleDateFormat("kk_mm").format(date);
        string = "0000000" + Integer.toString(this.jobRun.getRunNumber());
        this.values[6] = this.jobRun.getRunNumber() < 100000000 ? string.substring(string.length() - 8) : string.substring(string.length() - 9);
        String string2 = batchReport.maskToText(null, this.values);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFileName", (Object)string2);
        }
        return string2;
    }

    private Object[] getArray(PartitionedReport partitionedReport) {
        Object[] objectArray;
        PartitionedReport partitionedReport2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getArray", (String)"partition");
        }
        Object[] objectArray2 = null;
        long[] lArray = new long[]{partitionedReport.prID};
        if (partitionedReport.prLastPart) {
            objectArray2 = (Object[])partitionedReport.prData;
        } else {
            Response response;
            Object[] objectArray3;
            partitionedReport2 = partitionedReport;
            short s = partitionedReport.prPartition;
            while (!partitionedReport2.prLastPart) {
                s = (short)(s + 1);
                objectArray = (Object[])partitionedReport.clone();
                objectArray.prPartition = s;
                objectArray.prData = null;
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
                request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
                request.requestData = objectArray;
                objectArray3 = new Object[]{new Integer(s)};
                MessageLog.logMessage((String)"AGT0147I", (Object[])objectArray3);
                response = Agent.reporter.sendRequest(request);
                if (response == null || response.status > 4 || response.responseData == null) {
                    partitionedReport = null;
                    break;
                }
                partitionedReport2 = partitionedReport2.next = (PartitionedReport)response.responseData;
            }
            if (partitionedReport != null) {
                int n = 0;
                partitionedReport2 = partitionedReport;
                while (partitionedReport2 != null) {
                    n += ((Object[])partitionedReport2.prData).length;
                    partitionedReport2 = partitionedReport2.next;
                }
                objectArray3 = (Object[])partitionedReport.prData;
                response = objectArray3[0].getClass();
                objectArray2 = (Object[])Array.newInstance(response, n);
                int n2 = 0;
                while (partitionedReport != null) {
                    objectArray3 = (Object[])partitionedReport.prData;
                    System.arraycopy(objectArray3, 0, objectArray2, n2, objectArray3.length);
                    n2 += objectArray3.length;
                    partitionedReport = partitionedReport.next;
                }
            }
        }
        partitionedReport2 = new Request();
        partitionedReport2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        partitionedReport2.serviceName = RequestTypeManager.getInternalName((String)partitionedReport2.typeCode);
        partitionedReport2.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
        partitionedReport2.requestData = lArray;
        partitionedReport2.userName = this.jobRun.getSchedCreator();
        MessageLog.logMessage((String)"AGT0150I");
        if (!Agent.reporter.sendNoWaitRequest((Request)partitionedReport2)) {
            MessageLog.logMessage((String)"STA2005W");
        }
        objectArray = objectArray2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getArray", (Object)objectArray);
        }
        return objectArray;
    }

    private Object getPrintWriter(String string) {
        FileOutputStream fileOutputStream;
        File file;
        String string2;
        Closeable closeable;
        block28: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getPrintWriter", (String)"fileMask");
            }
            closeable = null;
            string2 = String.valueOf(Agent.logFileDirectory) + File.separator + "reports";
            file = new File(string2);
            try {
                if (file.isDirectory()) break block28;
                if (!file.mkdir()) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getPrintWriter");
                    }
                    throw new SecurityException();
                }
                SuperUser.secureDirectory((String)string2);
            }
            catch (SecurityException securityException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getPrintWriter", (Throwable)securityException);
                }
                MessageLog.logException((String)"AGT0124E", (Exception)securityException, (Object)string2);
                file = null;
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getPrintWriter", (Throwable)localizableException);
                }
                localizableException.print();
                file = null;
            }
        }
        if (file != null) {
            this.outputFileName = String.valueOf(string2) + File.separator + string;
            try {
                fileOutputStream = new FileOutputStream(this.outputFileName);
                if (this.chartReport) {
                    closeable = fileOutputStream;
                } else {
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = this.reportType == 6 ? new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8") : new OutputStreamWriter(fileOutputStream);
                    if (outputStreamWriter != null) {
                        closeable = new PrintWriter((Writer)outputStreamWriter, true);
                    }
                }
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getPrintWriter", (Throwable)iOException);
                }
                this.parms[0] = iOException.getMessage();
                MessageLog.logMessage((String)"STA2010E", (Object[])this.parms);
            }
        }
        fileOutputStream = closeable;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPrintWriter", fileOutputStream);
        }
        return fileOutputStream;
    }

    private void kickOffScript(BatchReport batchReport) {
        block19: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"kickOffScript", (String)"batchReport");
            }
            RunScriptReq runScriptReq = new RunScriptReq();
            runScriptReq.scrArgv = new String[2];
            runScriptReq.scrArgv[0] = batchReport.scriptName;
            runScriptReq.scrArgv[1] = this.outputFileName;
            runScriptReq.scrExtension = batchReport.scriptExtension;
            runScriptReq.scrData = new byte[1][];
            runScriptReq.scrData[0] = batchReport.scriptBody;
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.startedJob.getLogFileName(), true);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"kickOffScript", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)iOException);
            }
            if (fileWriter == null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"kickOffScript");
                }
                return;
            }
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
            try {
                HandlerExtensionMgr handlerExtensionMgr = HandlerExtensionMgr.getExtensionMgr();
                AbstractScriptHandler abstractScriptHandler = (AbstractScriptHandler)handlerExtensionMgr.getExtensionImpl("org.eclipse.aperi.agent.handler.script.ScriptHandlerFactory");
                IAssignable iAssignable = abstractScriptHandler.makeRunner(runScriptReq, this.startedJob.getLogFileName(), printWriter, false);
                Agent.breadLine.assign(iAssignable);
            }
            catch (ExtensionException extensionException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block19;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"kickOffScript", (Throwable)extensionException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.report.ExecReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"kickOffScript");
        }
    }
}

