/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.worker;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.agent.worker.Worker;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;

public class BreadLine {
    private List<Worker> workerList = new LinkedList<Worker>();
    private int maxIdleThreads;

    public BreadLine(int n) {
        this.maxIdleThreads = n;
    }

    synchronized boolean join(Worker worker) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.worker.BreadLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"join", (String)"worker");
        }
        if (this.workerList.size() >= this.maxIdleThreads) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.worker.BreadLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"join", (boolean)false);
            }
            return false;
        }
        this.workerList.add(worker);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.worker.BreadLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"join", (boolean)true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(IAssignable iAssignable) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.worker.BreadLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"assign", (String)"task");
        }
        Worker worker = null;
        BreadLine breadLine = this;
        synchronized (breadLine) {
            if (this.workerList.size() > 0) {
                worker = this.workerList.remove(0);
            }
        }
        if (worker != null) {
            worker.dispatch(iAssignable);
        } else {
            worker = new Worker(iAssignable);
            breadLine = new TSThread(Agent.threadGroup, (Runnable)worker, "Breadline");
            ((Thread)((Object)breadLine)).start();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.worker.BreadLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"assign");
        }
    }

    public int getMaxIdleThreads() {
        return this.maxIdleThreads;
    }

    public void setMaxIdleThreads(int n) {
        this.maxIdleThreads = n;
    }
}

