/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.DefaultHttpContext;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private Bundle bundle;
    private ProxyServlet proxy;
    Set aliases = new HashSet();

    public HttpServiceImpl(Bundle bundle, ProxyServlet proxy) {
        this.bundle = bundle;
        this.proxy = proxy;
    }

    public synchronized void unregisterAliases() {
        for (String alias : this.aliases) {
            this.proxy.unregister(alias, false);
        }
        this.aliases.clear();
    }

    public synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, NamespaceException {
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerServlet(alias, servlet, initparams, context, this.bundle);
        this.aliases.add(alias);
    }

    public synchronized void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.proxy.registerResources(alias, name, context);
        this.aliases.add(alias);
    }

    public synchronized void unregister(String alias) {
        if (!this.aliases.remove(alias)) {
            throw new IllegalArgumentException("Alias not found.");
        }
        this.proxy.unregister(alias, true);
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }
}

