/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.aperi.San.gui.DiskArrayData;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class RankDDI
extends DataDisplayInfo {
    private Rank rank;
    private NameList computer;
    private static String unknownMsg = MessageLog.getMessageNoID("GUI0129T");

    public RankDDI(BaseTreeNode baseTreeNode, Rank rank, NameList nameList) {
        super(String.valueOf(MessageLog.getMessageNoID("SAG0088L")) + ":  " + rank.rankName);
        this.rank = rank;
        this.computer = nameList;
        this.treeNode = baseTreeNode;
        this.helpID = "reasss50";
        this.reDisplay();
    }

    public void reDisplay() {
        if (this.panel == null) {
            this.buildPanel();
        }
        this.show();
    }

    private void buildPanel() {
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.insets.bottom = 20;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0090L", this.rank.rankName);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 12;
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0001L", this.computer.nlName);
        gridBagConstraints.insets.bottom = 0;
        String string = Rank.CONFIGS[this.rank.rankConfig];
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0091L", string);
        string = this.rank.getRankType(this.rank.rankType);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0092L", string);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0093L", this.rank.rankArraySiteNames);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0094L", Util.formatPrefBytes(this.rank.rankSize * 512L));
        string = this.rank.getRankStatus();
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0095L", string);
        DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0096L", this.rank.rankArrays);
        if (this.rank.rankGroup != -1) {
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0097L", Short.toString(this.rank.rankGroup));
        } else {
            DiskArrayData.addItem(this.panel, gridBagConstraints, "SAG0097L", MessageLog.getMessageNoID("SAG0600L"));
        }
        this.panel.add(Box.createVerticalStrut(14), gridBagConstraints);
        GuiUtil.completePanel((JPanel)this.panel);
    }
}

