/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;

public class ServiceUtils {
    public static final int FAILED = 8;
    public static final int WARNING = 4;
    private static IDeviceServiceManager serviceManagerProxy;
    private static IDiscover discoveryServiceProxy;
    private static IEventMonitorService eventMonitor;
    private static int nextNumber;
    public static Hashtable activeJobs;
    public static Hashtable completedJobResults;
    public static Hashtable jobResults;
    public static Hashtable jobExceptions;
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverRouter";
    public static ILogger traceLogger;
    public static String className;
    public static ILogger auditLogger;
    private static final String BUNDLE_NAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";

    static {
        Class<?> clazz;
        serviceManagerProxy = null;
        discoveryServiceProxy = null;
        eventMonitor = null;
        nextNumber = 0;
        activeJobs = new Hashtable();
        completedJobResults = new Hashtable();
        jobResults = new Hashtable();
        jobExceptions = new Hashtable();
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.ServiceUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        auditLogger = null;
        auditLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.audit");
        auditLogger.setMessageFile(BUNDLE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }

    public static boolean populateResults(AsyncResult asyncResult, boolean bl) {
        AsyncResult[] asyncResultArray;
        Exception exception;
        boolean bl2 = false;
        String string = asyncResult.getJobId();
        Result result = (Result)jobResults.get(string);
        if (result != null) {
            if (result.getSRMMessage() != null) {
                bl2 = true;
                asyncResult.setSRMMessage(result.getSRMMessage());
            }
            if (bl) {
                jobResults.remove(string);
            }
        }
        if ((exception = (Exception)jobExceptions.get(string)) != null) {
            bl2 = true;
            asyncResult.setReturnException(exception);
            if (bl) {
                jobExceptions.remove(string);
            }
        }
        if ((asyncResultArray = asyncResult.getSubJobResults()) != null) {
            int n = 0;
            while (n < asyncResultArray.length) {
                bl2 |= ServiceUtils.populateResults(asyncResultArray[n], bl);
                ++n;
            }
        }
        return bl2;
    }

    public static String getDiscoverRequestInfo(String string, Object[] objectArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        stringBuffer.append(String.valueOf(string) + "Request:" + objectArray[0] + '\n');
        String string2 = String.valueOf(string) + "   ";
        Iterator iterator = ((ArrayList)objectArray[1]).iterator();
        while (iterator.hasNext()) {
            object = (Object[])iterator.next();
            stringBuffer.append(ServiceUtils.getDiscoverRequestInfo(string2, (Object[])object));
        }
        iterator = ((ArrayList)objectArray[2]).iterator();
        while (iterator.hasNext()) {
            object = (JobInfo)iterator.next();
            l += ((JobInfo)object).getEndTime() - ((JobInfo)object).getStartTime();
            stringBuffer.append(String.valueOf(string2) + "Job ID=" + ((JobInfo)object).getId() + (((JobInfo)object).getStatus() == 4 ? " replaced by job " + ((JobInfo)object).getReplacementJob().getId() : " QueueName=" + ((JobInfo)object).getResourceQueue() + " Request=" + ((JobInfo)object).getRequest() + " Duration=" + (((JobInfo)object).getEndTime() - ((JobInfo)object).getStartTime()) / 1000L + " seconds\n"));
        }
        stringBuffer.append(String.valueOf(string) + "total duration = " + l / 1000L + " seconds\n\n");
        return stringBuffer.toString();
    }

    public static AsyncResult getJobStatus(String string) {
        AsyncResult asyncResult = null;
        Object v = activeJobs.get(string);
        if (v != null) {
            if (v instanceof org.eclipse.aperi.control.data.JobInfo) {
                ControlEngine controlEngine = ControlEngine.getInstance();
                asyncResult = controlEngine.getActiveJobResults(string);
            } else if (v instanceof AsyncResult) {
                asyncResult = (AsyncResult)v;
            }
        } else {
            v = completedJobResults.get(string);
            if (v != null && v instanceof AsyncResult) {
                completedJobResults.remove(string);
                JobEngine.getInstance().cleanupRequestInformation(string);
                asyncResult = (AsyncResult)v;
            } else {
                asyncResult = ServiceUtils.getJobRecord(Integer.parseInt(string));
            }
        }
        return asyncResult;
    }

    public static DBConnection getConnection() {
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            return (DBConnection)dBConnPoolDataSource.getPooledConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean createJobRecord(int var0, int var1_1, String var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 162->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean updateJobRecord(int var0, int var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 298->301)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static AsyncResult[] getJobRecords() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [2 : 142->148)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static AsyncResult getJobRecord(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [2 : 435->441)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized int getJobIdentifier(boolean bl, int n) {
        if (bl) {
            try {
                return AutoIdentifier.getIdentifier(n, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (--nextNumber >= 0) {
                nextNumber = -1;
            }
            return nextNumber;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public static int getDeviceServerId() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 158->161)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void recordInAuditLog(String string, String string2, String string3, int n) {
        ServiceUtils.recordInAuditLog(string, string2, string3, new Integer(n).toString());
    }

    public static void recordInAuditLog(String string, String string2, String string3, AsyncResult asyncResult) {
        if (asyncResult.getStatus() == 2) {
            ServiceUtils.recordInAuditLog(string, string2, string3, "JobID=" + asyncResult.getJobId());
        } else {
            ServiceUtils.recordInAuditLog(string, string2, string3, asyncResult.toString());
        }
    }

    public static void recordInAuditLog(String string, String string2, String string3, String string4) {
        String string5 = "recordInAuditLog";
        Map map = ServiceUtils.getUserProperties();
        if (map != null) {
            String string6 = null;
            String string7 = null;
            try {
                string6 = (String)map.get("USER");
            }
            catch (Exception exception) {}
            if (string6 != null) {
                try {
                    Integer cfr_ignored_0 = (Integer)map.get("ROLE");
                }
                catch (Exception exception) {}
                try {
                    string7 = (String)map.get("HOST");
                }
                catch (Exception exception) {}
                Object[] objectArray = new String[]{String.valueOf(string) + "." + string2, string6, string7, string3, string4};
                auditLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, string5, "TSNMServiceManager_AuthorizedRequest", objectArray);
            }
        }
    }

    public static Map getUserProperties() {
        return RPCSecureJavaProvider.getUserProperties();
    }

    public static IDeviceServiceManager getServiceManagerProxy() {
        if (serviceManagerProxy == null) {
            serviceManagerProxy = (IDeviceServiceManager)Activator._serviceHelper.bindLocal("DeviceServiceManager");
        }
        return serviceManagerProxy;
    }

    public static IDiscover getDiscoveryServiceProxy() {
        if (discoveryServiceProxy == null) {
            discoveryServiceProxy = (IDiscover)Activator._serviceHelper.bindLocal("DiscoverService");
        }
        return discoveryServiceProxy;
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }
}

