/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.DevAccess;

public class Device
implements Serializable {
    static final long serialVersionUID = -3174909751779696618L;
    public transient Device devNext;
    public int devID;
    public String devName;
    public String devManufacturer;
    public String devModel;
    public String devFirmwareRev;
    public String devSerialNumber;
    public String devSubsystemSerialNumber;
    public long devManufactureDate;
    public short devUseCount;
    public short devType;
    public long devDiscoveredTime;
    public String lunSSID;
    public static final short HARD_DISK = 0;
    public static final short CD_ROM = 1;
    public static final short CD_WRITER = 2;
    public static final short MAGNETO_OPTICAL = 3;
    public static final short FLOPPY = 4;
    public static final short REMOTE_MIRROR = 5;
    public static final short TAPE = 256;
    public static final short SCANNER = 2048;
    public static final short PRINTER = 2304;
    public static final short MEDIUM_CHANGER = 4096;
    public static final short ENCLOSURE = 4352;
    public short devStorageSystemType;
    public short devFlags;
    public static final short GENERATED_MANUFACTURER = 1;
    public static final short GENERATED_SERIAL_NUMBER = 2;
    public static final short NEW_DEVICE = 4;
    public static final short SPARE_DEVICE = 8;
    public boolean devRemovableMedium;
    public boolean devMultiPort;
    public boolean devUnsupportedModel;
    public transient DevAccess devControllers;
    public DevAccess[] devPackedControllers;
    public transient String devCanonicalName;

    private void packControllers() {
        int n = 0;
        DevAccess devAccess = this.devControllers;
        while (devAccess != null) {
            ++n;
            devAccess = devAccess.daNextController;
        }
        this.devPackedControllers = new DevAccess[n];
        n = 0;
        devAccess = this.devControllers;
        while (devAccess != null) {
            this.devPackedControllers[n] = devAccess;
            ++n;
            devAccess = devAccess.daNextController;
        }
    }

    private void unpackControllers() {
        int n = this.devPackedControllers != null ? this.devPackedControllers.length : 0;
        while (n > 0) {
            DevAccess devAccess = this.devPackedControllers[--n];
            devAccess.daNextController = this.devControllers;
            this.devControllers = devAccess;
        }
    }

    public static Device[] pack(Device device) {
        int n = 0;
        Device device2 = device;
        while (device2 != null) {
            ++n;
            device2.packControllers();
            device2 = device2.devNext;
        }
        Device[] deviceArray = new Device[n];
        n = 0;
        while (device != null) {
            deviceArray[n] = device;
            ++n;
            device2 = device.devNext;
            device.devNext = null;
            device = device2;
        }
        return deviceArray;
    }

    public static Device unpack(Device[] deviceArray) {
        Device device;
        int n = 0;
        if (deviceArray != null) {
            n = deviceArray.length;
        }
        if (n == 0) {
            return null;
        }
        Device device2 = device = deviceArray[0];
        device.unpackControllers();
        int n2 = 1;
        while (n2 < n) {
            Device device3;
            device2.devNext = device3 = deviceArray[n2];
            device2 = device3;
            device3.unpackControllers();
            ++n2;
        }
        return device;
    }

    public static boolean isFixedDisk(short s) {
        return s == 0 || s == 5;
    }

    public boolean isFixedDisk() {
        return Device.isFixedDisk(this.devType);
    }
}

