/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String DVNAME = MessageLog.getMessageNoID("STG6201L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1132L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    private static final String FREESPACE = MessageLog.getMessageNoID("STG1184L");
    private static final String PCTFREE = MessageLog.getMessageNoID("STG2040L");
    private static final String NBRDISKS = MessageLog.getMessageNoID("STG6057L");
    private static final String NBRVOLUMES = MessageLog.getMessageNoID("STG6202L");
    private static final String PROBE_TIME = MessageLog.getMessageNoID("STG1119L");
    private static final String DISC_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    public String[] columnNameList = new String[]{COMPUTER, DVNAME, CAPACITY, FREESPACE, PCTFREE, TYPE, NBRDISKS, NBRVOLUMES, PROBE_TIME, DISC_TIME};
    private static final int COMPUTER_COL = 0;
    private static final int DVNAME_COL = 1;
    private static final int CAPACITY_COL = 2;
    private static final int FREESPACE_COL = 3;
    private static final int PCTFREE_COL = 4;
    private static final int TYPE_COL = 5;
    private static final int NBRDISKS_COL = 6;
    private static final int NBRVOLUMES_COL = 7;
    private static final int LAST_PROBE_COL = 8;
    private static final int DISC_TIME_COL = 9;
    public RespVolGroup[] volGroups;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private MutableShort[] mShort;
    private GuiReportReq grr;
    private int[] rendererArray;
    public int frozenRows = 0;

    public VolGroupAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 2;
        switch (guiReportReq.reportSubtype) {
            case 80: {
                this.firstColumn = 0;
                break;
            }
            case 12: {
                this.firstColumn = 0;
                break;
            }
            case 78: {
                this.firstColumn = 2;
                break;
            }
            case 17: {
                this.firstColumn = 3;
                break;
            }
            case 18: {
                this.firstColumn = 8;
                break;
            }
            case 37: {
                this.firstColumn = 9;
            }
        }
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[2] = 7;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 6;
        this.rendererArray[6] = 5;
        this.rendererArray[7] = 5;
        this.rendererArray[8] = 1;
        this.rendererArray[9] = 1;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.volGroups = (RespVolGroup[])objectArray;
        int n = this.volGroups.length;
        if (n > 1) {
            ++n;
        }
        this.mDate = new Date[n];
        this.mInt = new MutableInteger[n];
        this.mLong = new MutableLong[n];
        this.mShort = new MutableShort[n];
        int n2 = 0;
        while (n2 < n) {
            this.mDate[n2] = new Date();
            this.mInt[n2] = new MutableInteger();
            this.mLong[n2] = new MutableLong();
            this.mShort[n2] = new MutableShort();
            ++n2;
        }
    }

    public void adjustData() {
        int n = this.volGroups.length;
        if (n > 1) {
            this.addTotal(++n);
        }
        int n2 = 0;
        while (n2 < n) {
            RespVolGroup respVolGroup = this.volGroups[n2];
            respVolGroup.vgFreeSpace *= 512L;
            respVolGroup.vgTotalSpace *= 512L;
            respVolGroup.rvgPercent = respVolGroup.vgTotalSpace > 0L ? (short)(respVolGroup.vgFreeSpace * 100L / respVolGroup.vgTotalSpace) : (short)-1;
            ++n2;
        }
    }

    public void undo() {
        RespVolGroup respVolGroup = this.volGroups[0];
        respVolGroup.vgFreeSpace /= 512L;
        respVolGroup.vgTotalSpace /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        columnDescriptorArray[5].cdValidValue = ColumnDescriptor.VOLGROUP_TYPES;
    }

    public int getNumberRows() {
        return this.volGroups.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.volGroups;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public Object getCellData(int n, int n2) {
        switch (n2) {
            case 1: {
                return this.volGroups[n].vgName;
            }
            case 0: {
                return this.volGroups[n].rvgComputerName;
            }
            case 5: {
                if (n == 0 && this.bHasTotalRow) {
                    return " ";
                }
                return this.volGroups[n].getType();
            }
            case 2: {
                this.mLong[n].value = this.volGroups[n].vgTotalSpace;
                return this.mLong[n];
            }
            case 3: {
                this.mLong[n].value = this.volGroups[n].vgFreeSpace;
                return this.mLong[n];
            }
            case 4: {
                this.mShort[n].value = this.volGroups[n].rvgPercent;
                return this.mShort[n];
            }
            case 6: {
                this.mInt[n].value = this.volGroups[n].vgDisks;
                return this.mInt[n];
            }
            case 7: {
                this.mInt[n].value = this.volGroups[n].vgVolumes;
                return this.mInt[n];
            }
            case 8: {
                this.mDate[n].setTime(this.volGroups[n].vgProbeTime);
                return this.mDate[n];
            }
            case 9: {
                this.mDate[n].setTime(this.volGroups[n].vgDiscoveredTime);
                return this.mDate[n];
            }
        }
        return null;
    }

    private void addTotal(int n) {
        this.bHasTotalRow = true;
        RespVolGroup[] respVolGroupArray = new RespVolGroup[n];
        respVolGroupArray[0] = new RespVolGroup();
        respVolGroupArray[0].rvgComputerName = MessageLog.getMessageNoID("STG4136L");
        respVolGroupArray[0].vgName = " ";
        respVolGroupArray[0].vgProbeTime = 86400000L;
        respVolGroupArray[0].vgDiscoveredTime = 86400000L;
        int n2 = 0;
        while (n2 < n - 1) {
            if (this.volGroups[n2].vgTotalSpace > 0L) {
                respVolGroupArray[0].vgTotalSpace += this.volGroups[n2].vgTotalSpace;
            }
            if (this.volGroups[n2].vgFreeSpace > 0L) {
                respVolGroupArray[0].vgFreeSpace += this.volGroups[n2].vgFreeSpace;
            }
            if (this.volGroups[n2].vgDisks > 0) {
                respVolGroupArray[0].vgDisks += this.volGroups[n2].vgDisks;
            }
            if (this.volGroups[n2].vgVolumes > 0) {
                respVolGroupArray[0].vgVolumes += this.volGroups[n2].vgVolumes;
            }
            respVolGroupArray[n2 + 1] = this.volGroups[n2];
            ++n2;
        }
        this.volGroups = respVolGroupArray;
        ++this.frozenRows;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        int n = 0;
        while (n < this.volGroups.length) {
            RespVolGroup respVolGroup = this.volGroups[n];
            int n2 = respVolGroup.vgID;
            HistChartProcessor.addLegend(this.grr, respVolGroup.rvgComputerName, respVolGroup.vgName, n2);
            ++n;
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.volGroups.length];
        int n = 0;
        while (n < this.volGroups.length) {
            int n2;
            RespVolGroup respVolGroup = this.volGroups[n];
            nArray[n] = n2 = respVolGroup.vgID;
            ++n;
        }
        return nArray;
    }
}

