/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SubsystemArrayGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList fabricSelections;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private String fabricRootLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode sourceClusterLabel;
    private TreeSelectorNode sourceFabricLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean groupExpanding = false;
    private boolean fabricExpanding = false;
    private static final int ROOT_ID = -5;
    private static final int GROUP_ID = -4;
    private static final int MEMBER_ID = -3;
    private static final int FABRIC_ID = -2;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;

    public SubsystemArrayGroupSelector(short s, NameList nameList, NameList nameList2, NameList nameList3, boolean bl) {
        this.memberType = s;
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.fabricSelections = nameList3;
        this.allMembersSelected = bl;
        this.groupType = (short)77;
        this.memberRootLabel = "STG4191L";
        this.groupRootLabel = "STG5500L";
        this.allMembersLabel = "STG5501L";
        this.fabricRootLabel = "FabricAlert_FabricTabTitle";
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList nameList = null;
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList[] nameListArray = new NameList[3];
        this.allMembersSelected = false;
        NameList nameList4 = this.selector.getNameList();
        while (nameList4 != null) {
            NameList nameList5 = (NameList)nameList4.clone();
            nameList5.nlNext = null;
            if (nameList5.nlInfo == this.groupType) {
                if (nameList2 == null) {
                    nameListArray[1] = nameList5;
                } else {
                    nameList2.nlNext = nameList5;
                }
                nameList2 = nameList5;
            } else if (nameList5.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (nameList5.nlInfo == 114) {
                if (nameList3 == null) {
                    nameListArray[2] = nameList5;
                } else {
                    nameList3.nlNext = nameList5;
                }
                nameList3 = nameList5;
            } else {
                if (nameList == null) {
                    nameListArray[0] = nameList5;
                } else {
                    nameList.nlNext = nameList5;
                }
                nameList = nameList5;
            }
            nameList4 = nameList4.nlNext;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        this.sourceGroupLabel = this.addGroupLabel(treeSelectorNode);
        this.sourceFabricLabel = this.addFabricLabel(treeSelectorNode);
        this.addMemberLabel(treeSelectorNode);
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = this.newRoot();
        NameList nameList = this.fabricSelections;
        while (nameList != null) {
            if (treeSelectorNode4 == null) {
                treeSelectorNode4 = this.addFabricLabel(treeSelectorNode5);
            }
            treeSelectorNode4.add(new TreeSelectorNode(nameList, true, false, true, true, null, false, false));
            nameList = nameList.nlNext;
        }
        nameList = this.groupSelections;
        while (nameList != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addGroupLabel(treeSelectorNode5);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList, true, false, true, true, null, false, false));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            treeSelectorNode2 = this.addMemberLabel(treeSelectorNode5);
            if (this.allMembersSelected) {
                this.addAllMembersNode(treeSelectorNode2, true);
            }
            this.addTreeSet(treeSelectorNode2, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            treeSelectorNode3 = TreeSelector.makeExcludeRoot();
            treeSelectorNode5.add(treeSelectorNode3);
            this.addTreeSet(treeSelectorNode3, this.excludeSet);
        }
        return treeSelectorNode5;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, NameList nameList3, boolean bl) {
        this.memberSelections = nameList;
        this.groupSelections = nameList2;
        this.fabricSelections = nameList3;
        this.allMembersSelected = bl;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, boolean bl, boolean bl2) {
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl3;
            boolean bl4;
            TreeSet treeSet;
            if ((nameList.nlState & 1) != 0) {
                treeSet = this.excludeSet;
                bl4 = false;
                bl3 = true;
            } else {
                treeSet = this.memberSet;
                bl4 = bl;
                bl3 = bl2;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl4, bl3, false, false, null, false, false);
            if (this.groupExpanding) {
                treeSelectorNode.setButtonFlag(false);
            }
            treeSet.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList2, true, false, true, true, null);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, this.sourceGroupLabel, treeSelectorNode);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        this.fabricExpanding = false;
        this.groupExpanding = false;
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -4) {
                this.sendRequest(this.groupType, -1);
            } else if (nameList.nlID == -3) {
                this.sendRequest(this.memberType, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest((short)114, -1);
            }
        } else if (nameList.nlInfo == this.groupType) {
            this.sendRequest(this.memberType, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 114) {
            this.fabricExpanding = true;
            this.sendRequest(nameList.nlInfo, nameList.nlID);
        } else if (nameList.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeListRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10000 + s;
        guiListReq.groupID = n;
        guiListReq.excludeNAS = false;
        guiListReq.excludeVS = false;
        guiListReq.getVersions = false;
        guiListReq.excludeVS = false;
        return guiListReq;
    }

    protected GroupDefinition makeGroupRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendRequest(short s, int n) {
        Request request;
        if (s == 99) {
            GroupDefinition groupDefinition = this.makeGroupRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        } else {
            GuiListReq guiListReq = this.makeListRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        Cloneable cloneable;
        if (s > 4) {
            return;
        }
        Serializable serializable = response.responseData;
        NameList nameList = null;
        if (serializable instanceof GroupDefinition) {
            cloneable = (GroupDefinition)response.responseData;
            nameList = cloneable.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == this.groupType) {
            while (nameList != null) {
                cloneable = new TreeSelectorNode(nameList, true, false, false, true, null, false, false);
                this.expansionNode.add((MutableTreeNode)((Object)cloneable));
                nameList = nameList.nlNext;
            }
        } else {
            boolean bl;
            boolean bl2 = this.expansionTree == this.sourceTree;
            boolean bl3 = bl = !bl2;
            if (bl2) {
                this.addAllMembersNode(this.expansionNode, false);
            }
            this.memberSet.clear();
            this.fillSets(nameList, bl2, bl);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.groupRootLabel, -4, treeSelectorNode);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.memberRootLabel, -3, treeSelectorNode);
    }

    private TreeSelectorNode addFabricLabel(TreeSelectorNode treeSelectorNode) {
        return this.addLabelNode(this.fabricRootLabel, -2, treeSelectorNode);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        String string2 = Util.getString(string);
        NameList nameList = this.newNameList(string2, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(TreeSelectorNode treeSelectorNode, boolean bl) {
        String string = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList nameList = this.newNameList(string, Integer.MAX_VALUE, 13);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private void addAllMembersNode(TreeSelectorNode treeSelectorNode, boolean bl, boolean bl2) {
        String string = Util.getString(this.allMembersLabel);
        NameList nameList = this.newNameList(string, Integer.MAX_VALUE, 13);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }
}

