/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.gui.TTextField;

public abstract class MultipleEditor
implements ValueEditor,
ListElementEditor,
ActionListener {
    protected ColumnFilter filter;
    private EditableList list;
    private FreeForm smartTextField;
    protected ValueEditorDialog dialog;

    protected abstract FreeForm makeTextField(ColumnFilter var1);

    protected abstract Object toDisplayable(ColumnFilterValue var1);

    protected abstract ColumnFilterValue toStored(Object var1);

    public MultipleEditor(ColumnFilter columnFilter, ValueEditorDialog valueEditorDialog) {
        this.filter = columnFilter;
        this.dialog = valueEditorDialog;
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        if (columnFilterValue == null) {
            this.dialog.setOKEnabled(false);
        }
        this.filter.clfValueList = null;
        this.smartTextField = this.makeTextField(this.filter);
        TTextField tTextField = (TTextField)this.smartTextField.textField;
        tTextField.removeActionListener(tTextField);
        tTextField.addActionListener(this);
        this.list = new EditableList("", this, null, 15);
        while (columnFilterValue != null) {
            this.list.addObject(this.toDisplayable(columnFilterValue));
            columnFilterValue = columnFilterValue.fvNext;
        }
        this.list.setAddEnabled(true);
    }

    public Component getWholeComponent() {
        return this.list;
    }

    public void getData() {
        Object[] objectArray = this.list.getElements();
        ColumnFilterValue columnFilterValue = null;
        this.filter.clfValueList = null;
        int n = 0;
        while (n < objectArray.length) {
            ColumnFilterValue columnFilterValue2 = this.toStored(objectArray[n]);
            if (columnFilterValue != null) {
                columnFilterValue.fvNext = columnFilterValue2;
            } else {
                this.filter.clfValueList = columnFilterValue2;
            }
            columnFilterValue = columnFilterValue2;
            ++n;
        }
    }

    public void setFocus() {
        this.smartTextField.textField.requestFocus();
    }

    public Component getComponent() {
        return this.smartTextField.getComponent();
    }

    public void setObject(Object object) {
        ColumnFilterValue columnFilterValue;
        this.filter.clfValueList = columnFilterValue = this.toStored(object);
        this.smartTextField.refresh();
    }

    public void setEnabled(boolean bl) {
    }

    public Object getObject() {
        try {
            this.smartTextField.getData();
        }
        catch (GeneralException generalException) {
            Toolkit.getDefaultToolkit().beep();
            GuiUtil.displayException(generalException);
            return null;
        }
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        this.filter.clfValueList = null;
        this.smartTextField.refresh();
        this.dialog.setOKEnabled(true);
        return this.toDisplayable(columnFilterValue);
    }

    public void objectRemoved(Object object) {
        if (this.list.editList.getModel().getSize() <= 0) {
            this.dialog.setOKEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this.list.addButton, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
        this.list.actionPerformed(actionEvent2);
    }
}

