/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.aperi.xmsg.MessageLog;

public class Constants {
    public static final int RUN_ON_SERVER_TOO = -999999999;
    public static final int RUN_ON_SERVER_FABRIC = -999999998;
    public static final int RUN_ON_SERVER_TAPE = -999999997;
    public static final int FAILED = 8;
    public static final int WARNING = 4;
    public static final int SUCCESSFUL = 0;
    public static final long NULL_DATE = 86400000L;
    public static final Date NULL_DATE_DATE = new Date(86400000L);
    public static final int NO_COMPUTER_ID = -1;
    public static final int ALL_COMPUTERS = -2;
    public static final int COMPUTER_GUID = -3;
    public static final short UNKNOWN = 0;
    public static final short LINUX = 1;
    public static final short AIX = 2;
    public static final short HPUX = 3;
    public static final short WIN_NT = 4;
    public static final short WIN_2000 = 5;
    public static final short SOLARIS = 6;
    public static final short HPUX10 = 7;
    public static final short NETWARE = 8;
    public static final short NAS = 9;
    public static final short NET_APP = 10;
    public static final short SYMMETRIX = 11;
    public static final short ESS = 12;
    public static final short COMPAQ_HS = 13;
    public static final short HITACHI_OPEN = 14;
    public static final short IBM_FASTT = 15;
    public static final short LSI_METASTOR = 16;
    public static final short SUN_T3 = 17;
    public static final short HP_SW = 18;
    public static final short STORAGETEK = 19;
    public static final short MSCS_VS = 20;
    public static final short IBM_SANVC_CLUSTER = 21;
    public static final short MSCS_CLUSTER = 22;
    public static final short IBM_SANFS_CLUSTER = 23;
    public static final short RDBMS_HOST = 24;
    public static final short DS8000 = 25;
    public static final short OTHER_SMIS10_DARRAY = 26;
    public static final short DS6000 = 27;
    public static final int MAX_OSTYPE = 28;
    public static final short CPU_POWER = 1;
    public static final short CPU_IA32 = 2;
    public static final short CPU_IX86 = 2;
    public static final short CPU_SPARC = 3;
    public static final short CPU_PA_RISC = 4;
    public static final short CPU_S390 = 5;
    public static final short N_CPU_ARCH = 6;
    public static final String[] OSTYPES = new String[]{"STG7500L", "STG7501L", "STG7502L", "STG7503L", "STG7504L", "STG7505L", "STG7506L", "STG7507L", "STG7508L", "STG7509L", "STG7510L", "STG7511L", "STG7512L", "STG7513L", "STG7514L", "STG7515L", "STG7516L", "STG7517L", "STG7518L", "STG7519L", "STG7520L", "STG7521L", "STG7522L", "STG7527L", "DBG0366L", "STG7564L", "STG7565L", "STG7566L"};
    public static final String[] INTERNAL_OSTYPES = new String[]{"unknown", "linux", "aix", "hpux", "windows", "windows", "solaris", "hpux10", "netware", "nas", "netapp", "symmetrix", "ess", "compaqhs", "hitachiopen", "ibmfastt", "lsimetastor", "sunttt", "hpstgwrks", "storagetek", "vs_mscs", "ibm_sanvc_cluster", "cluster", "ibm_sanfs", "rdbms_host", "ds8000", "other_array", "ds6000"};
    public static String[] cpuArchDisplayNames;
    private static final String[] cpuArchInternalNames;
    public static final String IBM = "IBM";
    public static final String NOVELL = "NOVELL";
    public static final String DECOMM = "DECOMM-";
    public static final String[][] REPORT_NAMES;
    public static final String[][] REPORT_DESC;
    public static String INITIAL_DB_REMOVED_TIME;
    public static final byte OS_GENERIC_SUBPRODUCT = 0;
    public static final byte DISK_ARRAY_SUBPRODUCT = 1;
    public static final byte QUEUE_ACTIVE = 0;
    public static final byte SHUTDOWN_NORMAL = 1;
    public static final byte SHUTDOWN_IMMEDIATE = 2;
    public static final byte SHUTDOWN_ABORT = 3;
    public static final byte STARTUP = 4;
    public static final byte SHUTDOWN_DUMP = 5;
    public static final String[] shutdownType;
    public static final byte AGENT_DOWN = 0;
    public static final byte AGENT_UP = 1;
    public static final byte AGENT_DEFECTED = 2;
    public static final byte AGENT_UPGRADING = 3;
    public static final byte AGENT_UNREACHABLE = 4;
    public static final byte AGENT_UPGRADE_NEEDED = 5;
    public static final byte AGENT_DELETED = 77;
    public static final byte DEVICE_SERVER_DOWN = 0;
    public static final byte DEVICE_SERVER_UP = 1;
    public static final byte STORAGE_ALERT_ES = 9;
    public static final byte COMMON = 0;
    public static final byte STORAGE_ALERT_OS = 1;
    public static final byte STORAGE_ALERT_NAS = 4;
    public static final byte STORAGE_ALERT_ES_SYM = 9;
    public static final byte MAX_PRODUCT_CODE = 9;
    public static final byte COMMON_VERSION = 5;
    public static final byte COMMON_RELEASE = 0;
    public static final byte COMMON_MODIFICATION = 0;
    public static final byte COMMON_SUBMODIFICATION = 0;
    public static final int FILESYSTEM_SUMMARY_ID = -1;
    public static final int NETWORK_WIDE_ID = -3;
    public static final int MONITORED_TABLE_ID = -5;
    public static final byte DAILY_HIST = 0;
    public static final byte WEEKLY_HIST = 1;
    public static final byte MONTHLY_HIST = 2;
    public static final byte WEEKLY_ACCUM = 3;
    public static final byte MONTHLY_ACCUM = 4;
    public static final int FEATURE_UNDER_ENDPOINT = 1;
    public static final int[] OS_SYSTEM_REPORTS;
    public static final String USER = "Default";
    public static final String FABRIC_USER = "FabricDefault";
    public static final String DISK_USER = "DiskDefault";
    public static final String TAPE_USER = "TapeDefault";
    public static final int DA_USERID = 1;
    public static final int FA_USERID = 2;
    public static final int DK_USERID = 3;
    public static final int TA_USERID = 4;
    public static final int FAILED_ALERT_LIMIT = 10;

    static {
        String[] stringArray = new String[6];
        stringArray[1] = "power";
        stringArray[2] = "i386";
        stringArray[3] = "sparc";
        stringArray[4] = "pa-risc";
        stringArray[5] = "s390";
        cpuArchInternalNames = stringArray;
        REPORT_NAMES = new String[][]{{"Storage Availability", "TREE_OSREPORT_STORAGE_AVAILABILITY"}, {"Storage Capacity", "TREE_OSREPORT_STORAGE_CAPACITY"}, {"Total Freespace", "TREE_OSREPORT_TOTAL_FREESPACE"}, {"Disk Defects", "TREE_OSREPORT_DISK_DEFECTS"}, {"Disk Capacity Summary", "NEWPORT_VALUE_REPORT_CAPACITY_NAME"}, {"SAN Assets (All)", "FabricSAN_ASSETS_ALL"}, {"SAN Assets (Switches)", "FabricSAN_ASSETS_SWITCHES"}, {"SAN Assets (Connected Devices)", "FabricSAN_ASSETS_CONNECTED_DEVICES"}, {"Port Connections", "FabricPORT_CONNECTIONS"}};
        REPORT_DESC = new String[][]{{"Ping by computer", "DESC_OSREPORT_STORAGE_AVAILABILITY"}, {"Disk capacity by computer", "DESC_OSREPORT_STORAGE_CAPACITY"}, {"Total freespace network wide", "DESC_OSREPORT_TOTAL_FREESPACE"}, {"Disks by primary defects", "DESC_OSREPORT_DISK_DEFECTS"}, {"Disk Capacity Summary", "NEWPORT_VALUE_REPORT_CAPACITY_DESC"}, {"SAN Assets (All)", "FabricFOR_SAN_ASSETS_ALL"}, {"SAN Assets (Switches)", "FabricFOR_SAN_ASSETS_SWITCHES"}, {"SAN Assets (Connected Devices)", "FabricFOR_SAN_ASSETS_CONNECTED_DEVICES"}, {"Port Connections", "FabricFOR_PORT_CONNECTIONS"}};
        INITIAL_DB_REMOVED_TIME = "'1969-12-31-16.00.00.000000'";
        String[] stringArray2 = new String[6];
        stringArray2[1] = MessageLog.getMessageNoID("ADG0007L");
        stringArray2[2] = MessageLog.getMessageNoID("ADG0009L");
        stringArray2[3] = MessageLog.getMessageNoID("ADG0011L");
        stringArray2[5] = MessageLog.getMessageNoID("ADG0023E");
        shutdownType = stringArray2;
        OS_SYSTEM_REPORTS = new int[]{200, 201, 202, 203, 204, 205, 230};
        cpuArchDisplayNames = new String[6];
        Constants.cpuArchDisplayNames[0] = MessageLog.getMessageNoID("GEN0183T");
        Constants.cpuArchDisplayNames[1] = "POWER";
        Constants.cpuArchDisplayNames[2] = "IA32";
        Constants.cpuArchDisplayNames[3] = "SPARC";
        Constants.cpuArchDisplayNames[4] = "PA-RISC";
        Constants.cpuArchDisplayNames[5] = "S390";
    }

    public static String getCPUArchDisplayName(int n) {
        String string = cpuArchDisplayNames[0];
        try {
            string = cpuArchDisplayNames[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return string;
    }

    public static String getCPUArchInternalName(int n) {
        String string = null;
        try {
            string = cpuArchInternalNames[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return string;
    }

    public static boolean isWindows(short s) {
        return s == 4 || s == 5;
    }

    public static boolean isNasBox(short s) {
        boolean bl = false;
        switch (s) {
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean licensedAsNAS(short s) {
        return Constants.isNasBox(s) && s != 8;
    }

    public static boolean supportsFullProbe(short s) {
        return s == 8 || s == 10 || s == 20;
    }

    public static boolean isUnmanagedOS(short s) {
        return s == 24;
    }

    public static boolean isDiskArray(short s) {
        boolean bl = false;
        switch (s) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isCimomManaged(short s) {
        boolean bl = false;
        switch (s) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasClusterSupport(short s) {
        boolean bl = false;
        switch (s) {
            case 4: 
            case 5: 
            case 20: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasDiskInfo(short s) {
        boolean bl = false;
        switch (s) {
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasDiskGroupInfo(short s) {
        boolean bl = false;
        switch (s) {
            case 12: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasArraySiteInfo(short s) {
        boolean bl = false;
        switch (s) {
            case 25: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasRankInfo(short s) {
        boolean bl = false;
        switch (s) {
            case 25: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasStoragePoolInfo(short s) {
        boolean bl = false;
        switch (s) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasSSDiskSerialNumber(short s) {
        boolean bl = false;
        switch (s) {
            case 25: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean hasLunWWN(short s) {
        boolean bl = false;
        switch (s) {
            case 15: 
            case 25: 
            case 27: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean supportsCIMOMDiscovery(short s) {
        return s == 2 || Constants.isWindows(s) || s == 1;
    }

    public static boolean isVirtualServer(int n) {
        return n == 20;
    }

    public static boolean isSANFSClient(int n) {
        return n == 23;
    }

    public static String getCPUArchString(short s) {
        return Constants.getCPUArchString(s, (short)0);
    }

    public static String getCPUArchString(short s, short s2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = null;
            string = s == 4 || s == 5 ? "win32" : (s == 3 ? "hp-ux" : INTERNAL_OSTYPES[s]);
            stringBuffer.append(string);
            if (s2 != 0) {
                stringBuffer.append("_");
                stringBuffer.append(cpuArchInternalNames[s2]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static boolean isFSLVDetectable(long l, long l2) {
        Timestamp timestamp = new Timestamp(0L);
        return l >= 0L && l2 - timestamp.getTime() <= 10800000L;
    }
}

