/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.sblim.wbem.cim.CIMProperty;

public class DeviceStatus {
    public static final DeviceStatus INVALID = new DeviceStatus(new int[]{-1});
    public static final int UNKNOWN = -1;
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final int[] OKS = new int[]{2};
    private static final int[] WARNINGS = new int[]{3, 4, 8, 9, 11};
    private static final int[] ERRORS = new int[]{5, 6, 7, 10, 12, 13, 14, 15, 16, 17, 18};
    private int[] cStatus = null;

    public DeviceStatus(int[] nArray) {
        this.cStatus = nArray;
    }

    public DeviceStatus(CIMProperty cIMProperty) {
        if (!cIMProperty.getName().equalsIgnoreCase("OperationalStatus")) {
            throw new IllegalArgumentException();
        }
        Vector vector = (Vector)cIMProperty.getValue().getValue();
        this.cStatus = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.cStatus[n] = ((Number)vector.get(n)).intValue();
            ++n;
        }
    }

    public DeviceStatus(List list) {
        this.cStatus = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            this.cStatus[n] = Integer.parseInt(list.get(n).toString());
            ++n;
        }
    }

    public int getStatusValue(int n) {
        return this.cStatus[n];
    }

    public String getStatusString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.cStatus.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Integer.toString(this.cStatus[n]));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getStatusCount() {
        return this.cStatus.length;
    }

    public boolean isInvalid() {
        return this.equals(INVALID);
    }

    public boolean isOK() {
        return this.contains(OKS) && !this.contains(WARNINGS) && !this.contains(ERRORS);
    }

    public boolean isWarning() {
        return !this.contains(ERRORS) && this.contains(WARNINGS);
    }

    public boolean isError() {
        return this.contains(ERRORS);
    }

    public int getConsolidatedState() {
        return this.isOK() ? 0 : (this.isError() ? 2 : (this.isWarning() ? 1 : -1));
    }

    public boolean isDisconnected() {
        return this.isInvalid() || Arrays.binarySearch(this.cStatus, 12) >= 0 || Arrays.binarySearch(this.cStatus, 13) >= 0;
    }

    private boolean contains(int[] nArray) {
        int n = 0;
        while (n < this.cStatus.length) {
            if (Arrays.binarySearch(nArray, this.cStatus[n]) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        if (this.isInvalid()) {
            return "INVALID";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{values=[");
        int n = 0;
        while (n < this.cStatus.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Integer.toString(this.cStatus[n]));
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.append(",c=" + String.valueOf(this.getConsolidatedState()));
        stringBuffer.append(this.isOK() ? ", green" : "");
        stringBuffer.append(this.isWarning() ? ", yellow" : "");
        stringBuffer.append(this.isError() ? ", red" : "");
        stringBuffer.append(this.isDisconnected() ? ", disconnected}" : "}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        DeviceStatus deviceStatus = new DeviceStatus(new int[]{2});
        System.out.println("test 1: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{2, 3});
        System.out.println("test 2: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{3});
        System.out.println("test 3: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{2, 3, 6});
        System.out.println("test 4: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{2, 3, 13});
        System.out.println("test 5: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{13});
        System.out.println("test 6: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[1]);
        System.out.println("test 7: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{1});
        System.out.println("test 7: " + deviceStatus.toString());
        deviceStatus = new DeviceStatus(new int[]{2, 1});
        System.out.println("test 7: " + deviceStatus.toString());
    }
}

