/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.common.api.Distinguishable;

public class SRMMessage
implements Cloneable,
Comparable,
Serializable,
Distinguishable {
    public static final short TYPE_UNKNOWN = 0;
    public static final short TYPE_INFO = 1;
    public static final short TYPE_WARN = 2;
    public static final short TYPE_ERR = 3;
    private static final String DEFAULT_MSG1 = "Message resource {0} is missing from {1}.";
    private static final String DEFAULT_MSG2 = "Unable to load {0} for message resource {1}.";
    private static Hashtable htBundles = new Hashtable(8);
    private static Hashtable htBundleNames = new Hashtable(4);
    private String strMsgId;
    private String[] astrInserts;
    static final long serialVersionUID = 2096267658782765626L;

    static {
        htBundleNames.put("HWN", "org.eclipse.aperi.disk.resources.APIMessages");
        htBundleNames.put("BTAFM", "org.eclipse.aperi.fabric.api.resources.FabricManagerMsgs");
        htBundleNames.put("HWNPM", "org.eclipse.aperi.perf.api.resources.PerfManagerMsgs");
        htBundleNames.put("HWNTM", "org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }

    public SRMMessage(String string, String[] stringArray) throws IllegalArgumentException {
        this.strMsgId = this.validate(string);
        this.astrInserts = stringArray;
    }

    public SRMMessage(SRMMessage sRMMessage) {
        this.strMsgId = sRMMessage.strMsgId;
        this.astrInserts = new String[sRMMessage.astrInserts.length];
        int n = this.astrInserts.length - 1;
        while (n >= 0) {
            this.astrInserts[n] = sRMMessage.astrInserts[n];
            --n;
        }
    }

    public final String getMsgId() {
        return this.strMsgId;
    }

    public final String getMsgPrefix() {
        return this.strMsgId.substring(0, 3);
    }

    public final String getMsgCompId() {
        if (Character.isDigit(this.strMsgId.charAt(3)) && Character.isDigit(this.strMsgId.charAt(4))) {
            return "";
        }
        return this.strMsgId.substring(3, 5);
    }

    public final int getMsgNum() {
        int n = -1;
        try {
            n = this.getMsgCompId() == null ? Integer.parseInt(this.strMsgId.substring(3, 9)) : Integer.parseInt(this.strMsgId.substring(5, 9));
        }
        catch (Exception exception) {}
        return n;
    }

    public final short getMsgType() {
        short s;
        switch (this.strMsgId.charAt(9)) {
            case 'I': {
                s = 1;
                break;
            }
            case 'W': {
                s = 2;
                break;
            }
            case 'E': {
                s = 3;
                break;
            }
            default: {
                s = 0;
            }
        }
        return s;
    }

    public final String[] getMsgInserts() {
        return this.astrInserts;
    }

    public String getMessage() {
        return this.getText(true);
    }

    public String getLocalizedMessage() {
        return this.getText(false);
    }

    public void setMsgId(String string) {
        this.strMsgId = this.validate(string);
    }

    public void setMsgInserts(String[] stringArray) {
        this.astrInserts = stringArray;
    }

    public boolean equals(Object object) {
        if (object instanceof SRMMessage) {
            return this.strMsgId.equals(((SRMMessage)object).strMsgId);
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.strMsgId.compareTo(((SRMMessage)object).strMsgId);
    }

    public boolean isIdentical(Object object) {
        boolean bl = false;
        if (object instanceof SRMMessage && ((SRMMessage)object).strMsgId.equals(this.strMsgId) && ((SRMMessage)object).astrInserts.length == this.astrInserts.length) {
            bl = true;
            int n = this.astrInserts.length - 1;
            while (n >= 0) {
                if (!((SRMMessage)object).astrInserts[n].equals(this.astrInserts[n])) {
                    bl = false;
                    break;
                }
                --n;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getMessage();
    }

    public Object clone() {
        SRMMessage sRMMessage = null;
        try {
            sRMMessage = (SRMMessage)super.clone();
            sRMMessage.astrInserts = new String[this.astrInserts.length];
            int n = this.astrInserts.length - 1;
            while (n >= 0) {
                sRMMessage.astrInserts[n] = this.astrInserts[n];
                --n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return sRMMessage;
    }

    protected String validate(String string) {
        int n = -1;
        try {
            if (string.length() == 10) {
                n = Character.isDigit(string.charAt(3)) && Character.isDigit(string.charAt(4)) ? Integer.parseInt(string.substring(3, 9)) : Integer.parseInt(string.substring(5, 9));
            }
        }
        catch (Exception exception) {}
        if (string.length() != 10 || n < 0) {
            throw new IllegalArgumentException("The message ID is invalid: " + string);
        }
        return string;
    }

    protected String getText(boolean bl) {
        ResourceBundle resourceBundle = null;
        String string = bl ? "E_" : "L_";
        String string2 = this.getBundleName();
        String string3 = null;
        resourceBundle = (ResourceBundle)htBundles.get(String.valueOf(string) + string2);
        if (resourceBundle == null && string2 != null) {
            resourceBundle = bl ? ResourceBundle.getBundle(string2, Locale.US) : ResourceBundle.getBundle(string2, Locale.getDefault());
            htBundles.put(String.valueOf(string) + string2, resourceBundle);
        }
        if (resourceBundle != null) {
            try {
                string3 = resourceBundle.getString(this.strMsgId);
            }
            catch (Exception exception) {}
        }
        string3 = string3 != null ? MessageFormat.format(string3, this.astrInserts) : (resourceBundle != null ? MessageFormat.format(DEFAULT_MSG1, this.strMsgId, string2) : MessageFormat.format(DEFAULT_MSG2, string2, this.strMsgId));
        return string3;
    }

    protected String getBundleName() {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = this.getMsgPrefix();
        string2 = this.getMsgCompId();
        string3 = (String)htBundleNames.get(String.valueOf(string) + string2);
        return string3;
    }
}

