/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeFrameTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;

public class CIMOMSelectorDbHelper {
    private static final short NOT_DETECTABLE = 0;
    private static final short DETECTABLE = 1;

    public static CIMOM getCimom(int n) {
        CIMOM cIMOM = CIMOMManager.getCIMOMManager().getCIMMOMByDBKey(n);
        return cIMOM;
    }

    public static short getCreationClassNameId(String string) throws SQLException {
        short s;
        block2: {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                s = Normalizer.CreationClassNameGetID(dBConnection, string);
                Object var2_3 = null;
                if (dBConnection == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var2_4 = null;
                    if (dBConnection == null) break block3;
                    dBConnection.close();
                }
                throw throwable;
            }
            dBConnection.close();
        }
        return s;
    }

    public static CapabilityData getCapabilityData(int n) throws SQLException {
        CapabilityData capabilityData;
        block2: {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                CapabilityData capabilityData2 = new CapabilityData();
                capabilityData2.setCapabilityDataId(n);
                capabilityData = capabilityData2.retrieve(dBConnection) ? capabilityData2 : null;
                Object var3_4 = null;
                if (dBConnection == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (dBConnection == null) break block3;
                    dBConnection.close();
                }
                throw throwable;
            }
            dBConnection.close();
        }
        return capabilityData;
    }

    public static class CIMOMInformation
    implements Comparable {
        private int cId;
        private String cNamespace;
        private int cNamespaceId;
        private short cPriority;

        public CIMOMInformation(int n, int n2, String string, short s) {
            this.cId = n;
            this.cNamespace = string;
            this.cNamespaceId = n2;
            this.cPriority = s;
        }

        public int getId() {
            return this.cId;
        }

        public String getNamespace() {
            return this.cNamespace;
        }

        public int getNamespaceId() {
            return this.cNamespaceId;
        }

        public short getPriority() {
            return this.cPriority;
        }

        public int compareTo(Object object) {
            return this.cPriority - ((CIMOMInformation)object).cPriority;
        }

        public String toString() {
            return "{CimomInfo id=" + Integer.toString(this.cId) + ",ns=" + this.cNamespace + ",ns_id=" + Integer.toString(this.cNamespaceId) + ",prio=" + Short.toString(this.cPriority) + "}";
        }
    }

    public static class Subsystem {
        public static CIMOMInformation[] getCimomInformation(int n) throws SQLException {
            CIMOMInformation[] cIMOMInformationArray;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                    String string = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySubsystemTable.getTablename() + " AS CKS, " + TResRegisteredCimomTable.getTablename() + " AS REGCIM WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SUBSYSTEM_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL" + " AND (" + "C2N." + "CIMOM_ID" + " = REGCIM." + "REG_CIMOM_ID" + " AND REGCIM." + "STATUS" + " != " + CIMOMConnectionStatus.PENDING_DELETION.toID() + "))";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                    ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                    while (dBResultSet.next()) {
                        CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                        arrayList.add(cIMOMInformation);
                    }
                    dBResultSet.closeAll();
                    cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cIMOMInformationArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, int n2) throws SQLException {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper$Subsystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                short s = Subsystem.getLowestPriority(n2);
                if (s == Short.MAX_VALUE) {
                    s = Subsystem.resetPriorities(n2);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Subsystem.setCimomPriority(n, n2, s);
            }
        }

        private static short resetPriorities(int n) throws SQLException {
            Object[] objectArray = Subsystem.getCimomInformation(n);
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = ((CIMOMInformation)objectArray[n2]).getNamespaceId();
                short s = (short)(n2 + 1);
                n2 = s;
                Subsystem.setCimomPriority(n3, n, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, int n2, short s) throws SQLException {
            boolean bl;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySubsystemTable.getColumnInfo("ACTIVE"), Short.toString(s));
                    hashtable.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                    hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n2));
                    String string = "UPDATE " + TResCimkeySubsystemTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                    int n3 = ComplexQuery.sqlUpdate(dBConnection, string, hashtable);
                    if (!dBConnection.getAutoCommit()) {
                        dBConnection.commit();
                    }
                    bl = n3 == 1;
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return bl;
        }

        private static short getLowestPriority(int n) throws SQLException {
            short s;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                    String string = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "SUBSYSTEM_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                    short s2 = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                    dBResultSet.closeAll();
                    s = s2;
                    Object var6_7 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var6_8 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return s;
        }

        public static CimkeySubsystem getCimNamespaceMapping(int n, int n2) throws SQLException {
            CimkeySubsystem cimkeySubsystem;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    CimkeySubsystem cimkeySubsystem2 = new CimkeySubsystem();
                    cimkeySubsystem2.setSubsystemId(n);
                    cimkeySubsystem2.setCimNamespaceId(n2);
                    cimkeySubsystem = cimkeySubsystem2.retrieve(dBConnection) ? cimkeySubsystem2 : null;
                    Object var4_5 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var4_6 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cimkeySubsystem;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static int getCorrespondingCapabilityDataId(int n, int n2) throws SQLException {
            int n3;
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n2));
                hashtable.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                String string = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SUBSYSTEM_ID" + "=(?))";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                try {
                    if (!dBResultSet.next() || dBResultSet.getInt(1) == 0) throw new IllegalArgumentException("No record existing in " + TResCimkeySubsystemTable.getTablename() + " for this namespace-subsystem combination.");
                    n3 = dBResultSet.getInt(1);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    dBResultSet.closeAll();
                    throw throwable;
                }
                dBResultSet.closeAll();
                Object var9_9 = null;
                if (dBConnection == null) return n3;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            dBConnection.close();
            return n3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static StorageSubsystem getSubsystem(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block5: {
                    StorageSubsystemWrapper storageSubsystemWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResStorageSubsystemTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block5;
                        StorageSubsystemWrapper storageSubsystemWrapper2 = new StorageSubsystemWrapper();
                        storageSubsystemWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        storageSubsystemWrapper = storageSubsystemWrapper2;
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    Object var8_9 = null;
                    if (dBConnection == null) return storageSubsystemWrapper;
                    dBConnection.close();
                    return storageSubsystemWrapper;
                }
                Object var5_7 = null;
                dBResultSet.closeAll();
                Object var8_10 = null;
                if (dBConnection == null) return null;
                dBConnection.close();
                return null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
        }

        public static void setMissing(int n) throws SQLException {
            StorageSubsystem storageSubsystem = Subsystem.getSubsystem(n);
            if (storageSubsystem.getDetectable() != 0) {
                Subsystem.updateDetectable(storageSubsystem.getName(), storageSubsystem.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int n) throws SQLException {
            StorageSubsystem storageSubsystem = Subsystem.getSubsystem(n);
            if (storageSubsystem.getDetectable() != 1) {
                Subsystem.updateDetectable(storageSubsystem.getName(), storageSubsystem.getNameFormat(), (short)1);
            }
        }

        /*
         * Exception decompiling
         */
        private static void updateDetectable(String var0, short var1_1, short var2_2) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 89->93)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class Switch {
        public static CIMOMInformation[] getCimomInformation(String string) throws SQLException {
            CIMOMInformation[] cIMOMInformationArray;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                    String string2 = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeySwitchTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "SWITCH_WWN" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
                    ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                    while (dBResultSet.next()) {
                        CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                        arrayList.add(cIMOMInformation);
                    }
                    dBResultSet.closeAll();
                    cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cIMOMInformationArray;
        }

        public static CimkeySwitch getCimNamespaceMapping(String string, int n) throws SQLException {
            CimkeySwitch cimkeySwitch;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    CimkeySwitch cimkeySwitch2 = new CimkeySwitch();
                    cimkeySwitch2.setSwitchWwn(string);
                    cimkeySwitch2.setCimNamespaceId(n);
                    cimkeySwitch = cimkeySwitch2.retrieve(dBConnection) ? cimkeySwitch2 : null;
                    Object var4_5 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var4_6 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cimkeySwitch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, String string) throws SQLException {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper$Switch");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                short s = Switch.getLowestPriority(string);
                if (s == Short.MAX_VALUE) {
                    s = Switch.resetPriorities(string);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Switch.setCimomPriority(n, string, s);
            }
        }

        private static short resetPriorities(String string) throws SQLException {
            Object[] objectArray = Switch.getCimomInformation(string);
            Arrays.sort(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                int n2 = ((CIMOMInformation)objectArray[n]).getNamespaceId();
                short s = (short)(n + 1);
                n = s;
                Switch.setCimomPriority(n2, string, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, String string, short s) throws SQLException {
            boolean bl;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySwitchTable.getColumnInfo("ACTIVE"), Short.toString(s));
                    hashtable.put(TResCimkeySwitchTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                    hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                    String string2 = "UPDATE " + TResCimkeySwitchTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "SWITCH_WWN" + "=(?))";
                    int n2 = ComplexQuery.sqlUpdate(dBConnection, string2, hashtable);
                    if (!dBConnection.getAutoCommit()) {
                        dBConnection.commit();
                    }
                    bl = n2 == 1;
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return bl;
        }

        private static short getLowestPriority(String string) throws SQLException {
            short s;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
                    String string2 = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE (" + "SWITCH_WWN" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
                    short s2 = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                    dBResultSet.closeAll();
                    s = s2;
                    Object var6_7 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var6_8 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return s;
        }

        public static org.eclipse.aperi.infrastructure.database.objects.Switch getSwitch(String string) throws SQLException {
            org.eclipse.aperi.infrastructure.database.objects.Switch switch_;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    org.eclipse.aperi.infrastructure.database.objects.Switch switch_2 = new org.eclipse.aperi.infrastructure.database.objects.Switch();
                    switch_2.setSwitchWwn(string);
                    switch_ = switch_2.retrieve(dBConnection) ? switch_2 : null;
                    Object var3_4 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var3_5 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return switch_;
        }

        private static LinkedList getMissingSwitches(DBConnection dBConnection, String string) throws SQLException {
            String string2 = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " , " + TResCimkeySwitchTable.getTablename() + " WHERE " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + " AND " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + " = (?) " + ")";
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
            DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string2, hashtable);
            if (dBResultSet.next()) {
                dBResultSet.close();
                return new LinkedList();
            }
            String string3 = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " , " + TResCimkeySwitchTable.getTablename() + " WHERE " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + " AND " + TResCimkeySwitchTable.getTablename() + "." + "SWITCH_WWN" + " = (?) " + ")";
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            hashtable2.put(TResCimkeySwitchTable.getColumnInfo("SWITCH_WWN"), string);
            DBResultSet dBResultSet2 = ComplexQuery.sqlQuery(dBConnection, string3, hashtable2);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (dBResultSet2.next()) {
                linkedList.add(dBResultSet2.getString(1));
            }
            dBResultSet2.close();
            return linkedList;
        }

        private static String convertLinkedListToCommaSeparatedString(LinkedList linkedList) {
            String string = "";
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                string = String.valueOf(string) + (String)iterator.next();
                string = String.valueOf(string) + ",";
            }
            if (string.indexOf(",") >= 0) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        /*
         * Exception decompiling
         */
        public static void setMissing(String var0) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 281->285)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public static void setVisible(String var0) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 56->60)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class Tape {
        public static CIMOMInformation[] getCimomInformation(int n) throws SQLException {
            CIMOMInformation[] cIMOMInformationArray;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    String string = "SELECT C2N.CIMOM_ID, C2N.NAMESPACE, CKS.CIM_NAMESPACE_ID, CKS.ACTIVE FROM " + TResCimom2namespaceTable.getTablename() + " AS C2N, " + TResCimkeyTapeLibraryTable.getTablename() + " AS CKS WHERE (C2N." + "CIM_NAMESPACE_ID" + "=CKS." + "CIM_NAMESPACE_ID" + " AND CKS." + "TAPE_LIBRARY_ID" + "=(?) AND CKS." + "ACTIVE" + " IS NOT NULL)";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                    ArrayList<CIMOMInformation> arrayList = new ArrayList<CIMOMInformation>();
                    while (dBResultSet.next()) {
                        CIMOMInformation cIMOMInformation = new CIMOMInformation(dBResultSet.getInt(1), dBResultSet.getInt(3), dBResultSet.getString(2), dBResultSet.getShort(4));
                        arrayList.add(cIMOMInformation);
                    }
                    dBResultSet.closeAll();
                    cIMOMInformationArray = arrayList.toArray(new CIMOMInformation[arrayList.size()]);
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cIMOMInformationArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean degradeCimomPriority(int n, int n2) throws SQLException {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper$Tape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                short s = Tape.getLowestPriority(n2);
                if (s == Short.MAX_VALUE) {
                    s = Tape.resetPriorities(n2);
                }
                s = (short)(s + 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Tape.setCimomPriority(n, n2, s);
            }
        }

        private static short resetPriorities(int n) throws SQLException {
            Object[] objectArray = Tape.getCimomInformation(n);
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = ((CIMOMInformation)objectArray[n2]).getNamespaceId();
                short s = (short)(n2 + 1);
                n2 = s;
                Tape.setCimomPriority(n3, n, s);
            }
            return (short)objectArray.length;
        }

        private static boolean setCimomPriority(int n, int n2, short s) throws SQLException {
            boolean bl;
            block3: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("ACTIVE"), Short.toString(s));
                    hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                    hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n2));
                    String string = "UPDATE " + TResCimkeyTapeLibraryTable.getTablename() + " SET " + "ACTIVE" + "=(?) WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                    int n3 = ComplexQuery.sqlUpdate(dBConnection, string, hashtable);
                    if (!dBConnection.getAutoCommit()) {
                        dBConnection.commit();
                    }
                    bl = n3 == 1;
                    Object var7_8 = null;
                    if (dBConnection == null) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var7_9 = null;
                        if (dBConnection == null) break block4;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return bl;
        }

        private static short getLowestPriority(int n) throws SQLException {
            short s;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    String string = "SELECT COUNT(*), MAX(ACTIVE) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "TAPE_LIBRARY_ID" + "=(?) AND " + "ACTIVE" + " IS NOT NULL)";
                    DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                    short s2 = dBResultSet.next() && dBResultSet.getInt(1) > 0 ? dBResultSet.getShort(2) : (short)0;
                    dBResultSet.closeAll();
                    s = s2;
                    Object var6_7 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var6_8 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return s;
        }

        public static CimkeyTapeLibrary getCimNamespaceMapping(int n, int n2) throws SQLException {
            CimkeyTapeLibrary cimkeyTapeLibrary;
            block2: {
                DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                try {
                    CimkeyTapeLibrary cimkeyTapeLibrary2 = new CimkeyTapeLibrary();
                    cimkeyTapeLibrary2.setTapeLibraryId(n);
                    cimkeyTapeLibrary2.setCimNamespaceId(n2);
                    cimkeyTapeLibrary = cimkeyTapeLibrary2.retrieve(dBConnection) ? cimkeyTapeLibrary2 : null;
                    Object var4_5 = null;
                    if (dBConnection == null) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var4_6 = null;
                        if (dBConnection == null) break block3;
                        dBConnection.close();
                    }
                    throw throwable;
                }
                dBConnection.close();
            }
            return cimkeyTapeLibrary;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static int getCorrespondingCapabilityDataId(int n, int n2) throws SQLException {
            int n3;
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n2));
                hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), Integer.toString(n));
                String string = "SELECT CAPABILITY_DATA_ID FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE (" + "CIM_NAMESPACE_ID" + "=(?) AND " + "TAPE_LIBRARY_ID" + "=(?))";
                DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, hashtable);
                try {
                    if (!dBResultSet.next() || dBResultSet.getInt(1) == 0) throw new IllegalArgumentException("No record existing in " + TResCimkeyTapeLibraryTable.getTablename() + " for this namespace-subsystem combination.");
                    n3 = dBResultSet.getInt(1);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    dBResultSet.closeAll();
                    throw throwable;
                }
                dBResultSet.closeAll();
                Object var9_9 = null;
                if (dBConnection == null) return n3;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            dBConnection.close();
            return n3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static TapeLibrary getTapeLibrary(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block5: {
                    TapeLibraryWrapper tapeLibraryWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResTapeLibraryTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block5;
                        TapeLibraryWrapper tapeLibraryWrapper2 = new TapeLibraryWrapper();
                        tapeLibraryWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        tapeLibraryWrapper = tapeLibraryWrapper2;
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    Object var8_9 = null;
                    if (dBConnection == null) return tapeLibraryWrapper;
                    dBConnection.close();
                    return tapeLibraryWrapper;
                }
                Object var5_7 = null;
                dBResultSet.closeAll();
                Object var8_10 = null;
                if (dBConnection == null) return null;
                dBConnection.close();
                return null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static TapeFrame getTapeFrame(int n) throws SQLException {
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                DBResultSet dBResultSet;
                block5: {
                    TapeFrameWrapper tapeFrameWrapper;
                    Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                    hashtable.put(TResTapeFrameTable.getColumnInfo("TAPE_LIBRARY_ID"), Integer.toString(n));
                    dBResultSet = DBQueryAssistant.performRetrieve(TResTapeFrameTable.getTablename(), dBConnection, hashtable, null);
                    try {
                        if (!dBResultSet.next()) break block5;
                        TapeFrameWrapper tapeFrameWrapper2 = new TapeFrameWrapper();
                        tapeFrameWrapper2.setFieldsFromDbRow(dBConnection, dBResultSet);
                        tapeFrameWrapper = tapeFrameWrapper2;
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        dBResultSet.closeAll();
                        throw throwable;
                    }
                    dBResultSet.closeAll();
                    Object var8_9 = null;
                    if (dBConnection == null) return tapeFrameWrapper;
                    dBConnection.close();
                    return tapeFrameWrapper;
                }
                Object var5_7 = null;
                dBResultSet.closeAll();
                Object var8_10 = null;
                if (dBConnection == null) return null;
                dBConnection.close();
                return null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
        }

        public static void setMissing(int n) throws SQLException {
            TapeLibrary tapeLibrary = Tape.getTapeLibrary(n);
            if (tapeLibrary.getDetectable() != 0) {
                Tape.updateDetectable(tapeLibrary.getName(), tapeLibrary.getNameFormat(), (short)0);
            }
        }

        public static void setVisible(int n) throws SQLException {
            TapeLibrary tapeLibrary = Tape.getTapeLibrary(n);
            if (tapeLibrary.getDetectable() != 1) {
                Tape.updateDetectable(tapeLibrary.getName(), tapeLibrary.getNameFormat(), (short)1);
            }
        }

        /*
         * Exception decompiling
         */
        private static void updateDetectable(String var0, short var1_1, short var2_2) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 89->93)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class StorageSubsystemWrapper
    extends StorageSubsystem {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }

    public static class TapeLibraryWrapper
    extends TapeLibrary {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }

    public static class TapeFrameWrapper
    extends TapeFrame {
        public void setFieldsFromDbRow(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
            this.setFields(dBConnection, dBResultSet);
        }
    }
}

