/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.InstancePool;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;

public final class DiskThreadPool
extends InstancePool {
    public DiskThreadPool() {
        super(DiskManagerConfigSvc.getIntConfigValue("DiskThread.PoolSize", 50));
    }

    public DiskMgrThread getThread(DiskThreadManager diskThreadManager) {
        DiskMgrThread diskMgrThread;
        LogTraceHelper logTraceHelper;
        block3: {
            logTraceHelper = LogTraceHelper.entry(this, "getThread", new Object[]{diskThreadManager});
            diskMgrThread = null;
            try {
                diskMgrThread = (DiskMgrThread)this.getClearInstance();
                if (diskMgrThread == null) break block3;
                logTraceHelper.traceHigh("Returning thread from pool.");
                DiskMgrThread diskMgrThread2 = diskMgrThread;
                Object var4_6 = null;
                logTraceHelper.exit(diskMgrThread);
                return diskMgrThread2;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                logTraceHelper.exit(diskMgrThread);
                throw throwable;
            }
        }
        diskMgrThread = new DiskMgrThread(diskThreadManager);
        diskMgrThread.start();
        logTraceHelper.traceHigh("Returning new thread.");
        DiskMgrThread diskMgrThread3 = diskMgrThread;
        Object var4_7 = null;
        logTraceHelper.exit(diskMgrThread);
        return diskMgrThread3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void returnThread(DiskMgrThread diskMgrThread) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "returnThread", new Object[]{diskMgrThread});
        try {
            if (!diskMgrThread.cIsExecutionComplete()) {
                logTraceHelper.traceWarning("Thread execution of " + diskMgrThread.getName() + " is not yet complete. Thread will be taken out of the thread management");
                diskMgrThread.releaseThread();
                diskMgrThread.interrupt();
                this.removeInst(diskMgrThread);
                Object var3_3 = null;
                logTraceHelper.exit("void");
                return;
            }
            if (!this.returnInst(diskMgrThread)) {
                logTraceHelper.traceHigh("Thread " + diskMgrThread.getName() + " returned to pool");
                diskMgrThread.releaseThread();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit("void");
            throw throwable;
        }
        {
            Object var3_5 = null;
            logTraceHelper.exit("void");
            return;
        }
    }
}

