/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.aperi.TStorm.common.PrintHistoryChart;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.ExportFileChooser;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.tables.MegaTable;

public class ExportTableData {
    public static void export(Container container, String string, String string2) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof MegaTable) {
                    MegaTable megaTable = (MegaTable)componentArray[n];
                    ExportTableData.exportTable(megaTable, string, string2);
                    break;
                }
                ++n;
            }
        }
    }

    public static void exportTable(MegaTable megaTable, String string, String string2) {
        ExportFileChooser exportFileChooser = new ExportFileChooser(false);
        PrintWriter printWriter = ExportTableData.getPrintWriter(exportFileChooser, string, string2);
        if (printWriter != null) {
            BaseTableModel baseTableModel = (BaseTableModel)megaTable.getDataSource();
            int[] nArray = null;
            nArray = baseTableModel.getAdjuster().fixColumnArray(nArray);
            int[] nArray2 = megaTable.getViewToModelIndices();
            int n = exportFileChooser.getType();
            if (n == 4) {
                new PrintHtmlTable().printHtml(baseTableModel.getAdjuster(), printWriter, nArray, GuiUtil.getUserName(), string2, nArray2);
            } else {
                WriteReports writeReports = new WriteReports();
                if (n == 2) {
                    writeReports.writeCSV(baseTableModel.getAdjuster(), printWriter, nArray, exportFileChooser.getHeaders(), exportFileChooser.getTotals(), nArray2);
                } else {
                    writeReports.writeFormatted(baseTableModel.getAdjuster(), printWriter, nArray, nArray2);
                }
            }
            printWriter.close();
        }
    }

    public static void exportHistory(int n, Object[] objectArray, String string, String string2, String string3) {
        ExportFileChooser exportFileChooser = new ExportFileChooser(true);
        PrintWriter printWriter = ExportTableData.getPrintWriter(exportFileChooser, string, string2);
        if (printWriter != null) {
            if (!exportFileChooser.getHeaders()) {
                string3 = null;
            }
            new PrintHistoryChart().print(n, objectArray, printWriter, string3);
            printWriter.close();
        }
    }

    private static PrintWriter getPrintWriter(ExportFileChooser exportFileChooser, String string, String string2) {
        PrintWriter printWriter = null;
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        String string3 = iGuiMain.getUserPrefs().exportPath;
        if (string3 == null || string3.charAt(0) == ' ') {
            string3 = System.getProperty("user.dir", " ");
        }
        string3 = String.valueOf(string3) + File.separatorChar;
        if (string2 == null) {
            string2 = "report.csv";
        } else {
            string2 = String.valueOf(string2) + ".csv";
            string2 = WriteReports.adjustFileName(string2);
        }
        String string4 = exportFileChooser.getName(string3, string2);
        if (string4 != null) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                outputStreamWriter = exportFileChooser.getType() == 4 || System.getProperty("os.name", " ").regionMatches(true, 0, "win", 0, 3) ? new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8") : new OutputStreamWriter(fileOutputStream);
            }
            catch (IOException iOException) {
                GuiUtil.displayErrorMessage(iOException.getMessage());
                outputStreamWriter = null;
            }
            if (outputStreamWriter != null) {
                printWriter = new PrintWriter((Writer)outputStreamWriter, true);
            }
        }
        return printWriter;
    }
}

