/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Selector;

public class TUpDownListSelector
extends Selector
implements ActionListener,
ListSelectionListener {
    protected JList srcList;
    protected JList selList;
    protected String srcTitle;
    protected String selTitle;
    protected boolean upDown;

    public TUpDownListSelector(JList jList, JList jList2, String string, String string2, boolean bl) {
        super(jList, jList2, false, bl);
        this.upDown = bl;
        this.srcList = jList;
        this.selList = jList2;
        this.srcList.addListSelectionListener(this);
        this.selList.addListSelectionListener(this);
        this.srcTitle = string;
        this.selTitle = string2;
        this.leftTitle.setText(this.srcTitle);
        this.rightTitle.setText(this.selTitle);
        GuiUtil.setAccessible(this.leftTitle, this.leftTitle.getText(), this.leftTitle.getText());
        GuiUtil.setAccessible(this.rightTitle, this.rightTitle.getText(), this.rightTitle.getText());
    }

    public TUpDownListSelector(ArrayList arrayList, ArrayList arrayList2, String string, String string2, boolean bl) {
        super(arrayList, arrayList2, false, bl);
        this.upDown = bl;
        this.srcList = this.sourceJList;
        this.selList = this.selectedJList;
        this.srcList.addListSelectionListener(this);
        this.selList.addListSelectionListener(this);
        this.srcTitle = string;
        this.selTitle = string2;
        this.leftTitle.setText(this.srcTitle);
        this.rightTitle.setText(this.selTitle);
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.srcList.clearSelection();
            this.selList.clearSelection();
        }
        this.srcList.setEnabled(bl);
        this.srcList.setEnabled(bl);
        this.setEnabledPane(this.rightPane, bl);
        this.setEnabledPane(this.leftPane, bl);
        this.setEnabledPane(this.middlePane, bl);
        if (this.upDown) {
            this.setEnabledPane(this.upDownPane, bl);
        }
    }

    private void setEnabledPane(JPanel jPanel, boolean bl) {
        Component[] componentArray = jPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    public ArrayList getSelList() {
        return this.getTheList(this.selList);
    }

    public ArrayList getSrcList() {
        return this.getTheList(this.srcList);
    }

    private ArrayList getTheList(JList jList) {
        ArrayList arrayList = null;
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        if (defaultListModel.getSize() != 0) {
            arrayList = new ArrayList(defaultListModel.getSize());
            int n = 0;
            while (n < defaultListModel.getSize()) {
                Object e = defaultListModel.getElementAt(n);
                arrayList.add(e);
                ++n;
            }
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.addButton) {
                this.addPressed();
                this.addButton.setEnabled(false);
                this.srcList.clearSelection();
                this.srcList.requestFocus();
            } else if (jButton == this.delButton) {
                this.removePressed();
                this.delButton.setEnabled(false);
                this.selList.clearSelection();
                this.selList.requestFocus();
            } else if (jButton == this.upButton) {
                this.upPressed();
            } else if (jButton == this.downButton) {
                this.downPressed();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        boolean bl = this.srcList.getSelectedIndices().length != 0;
        boolean bl2 = this.selList.getSelectedIndices().length != 0;
        this.addButton.setEnabled(bl);
        this.delButton.setEnabled(bl2);
        if (jList == this.srcList) {
            if (this.upDown) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
            if (bl2 && bl) {
                this.selList.clearSelection();
            }
        } else {
            if (this.upDown) {
                boolean bl3;
                ListSelectionModel listSelectionModel = this.selList.getSelectionModel();
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = bl3 = !listSelectionModel.isSelectionEmpty();
                if (bl3) {
                    if (listSelectionModel.isSelectedIndex(0)) {
                        bl4 = true;
                    }
                    if (listSelectionModel.isSelectedIndex(this.selList.getModel().getSize() - 1)) {
                        bl5 = true;
                    }
                }
                this.upButton.setEnabled(bl3 && !bl4);
                this.downButton.setEnabled(bl3 && !bl5);
            }
            if (bl2 && bl) {
                this.srcList.clearSelection();
            }
        }
    }

    protected void addPressed() {
        DefaultListModel defaultListModel = (DefaultListModel)this.selList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.srcList.getModel();
        List list = TUpDownListSelector.enumSelectedIndices(this.srcList);
        this.srcList.clearSelection();
        int n = defaultListModel.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            Object e = defaultListModel2.remove(n2);
            defaultListModel.add(n, e);
        }
        this.srcList.validate();
        this.selList.validate();
    }

    private void removePressed() {
        DefaultListModel defaultListModel = (DefaultListModel)this.selList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.srcList.getModel();
        List list = TUpDownListSelector.enumSelectedIndices(this.selList);
        this.selList.clearSelection();
        defaultListModel.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            Object e = defaultListModel.remove(n);
            int n2 = defaultListModel2.size();
            boolean bl = true;
            int n3 = 0;
            while (bl && n3 < n2) {
                Object e2 = defaultListModel2.get(n3);
                String string = e2.toString();
                if (string.compareTo(e.toString()) < 0) {
                    ++n3;
                    continue;
                }
                bl = false;
            }
            defaultListModel2.add(n3, e);
        }
        this.srcList.validate();
        this.selList.validate();
    }

    private void downPressed() {
        this.selList.getSelectionModel();
        DefaultListModel defaultListModel = (DefaultListModel)this.selList.getModel();
        List list = TUpDownListSelector.enumSelectedRanges(this.selList);
        this.selList.clearSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            Object e = defaultListModel.remove(range.last + 1);
            defaultListModel.add(range.first, e);
        }
        TUpDownListSelector.reselect(this.selList, list, 1);
    }

    private void upPressed() {
        this.selList.getSelectionModel();
        DefaultListModel defaultListModel = (DefaultListModel)this.selList.getModel();
        List list = TUpDownListSelector.enumSelectedRanges(this.selList);
        this.selList.clearSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            Object e = defaultListModel.remove(range.first - 1);
            defaultListModel.add(range.last, e);
        }
        TUpDownListSelector.reselect(this.selList, list, -1);
    }

    private static List enumSelectedRanges(JList jList) {
        Range range = null;
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        LinkedList<Range> linkedList = new LinkedList<Range>();
        int n = jList.getModel().getSize();
        int n2 = 0;
        while (n2 < n) {
            if (listSelectionModel.isSelectedIndex(n2)) {
                if (range != null) {
                    range.last = n2;
                } else {
                    range = new Range(n2);
                }
            } else if (range != null) {
                linkedList.add(range);
                range = null;
            }
            ++n2;
        }
        if (range != null) {
            linkedList.add(range);
        }
        return linkedList;
    }

    protected static List enumSelectedIndices(JList jList) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = jList.getModel().getSize();
        while (n > 0) {
            if (!listSelectionModel.isSelectedIndex(--n)) continue;
            linkedList.add(new Integer(n));
        }
        return linkedList;
    }

    private static void reselect(JList jList, List list, int n) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            listSelectionModel.addSelectionInterval(range.first + n, range.last + n);
        }
    }

    public void setMnemonicForTitles(String string, String string2) {
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic(string));
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic(string2));
    }

    private static class Range {
        public int first;
        public int last;

        public Range(int n) {
            this.first = n;
            this.last = n;
        }
    }
}

