/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

class WrappingHeaderRenderer
extends JPanel
implements TableCellRenderer {
    String text = null;
    Font font;
    int alignment = 0;

    public WrappingHeaderRenderer() {
        super(false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.removeAll();
    }

    public void setHorizontalAlignment(int n) {
        this.alignment = n;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.text == null) {
            this.text = object.toString();
        }
        this.font = jTable.getFont().deriveFont(1);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\r\n");
        int n3 = stringTokenizer.countTokens();
        if (n3 == 1) {
            this.setLayout(new BorderLayout());
        } else {
            this.setLayout(new GridLayout(n3, 1));
        }
        while (stringTokenizer.hasMoreElements()) {
            JLabel jLabel = new JLabel(stringTokenizer.nextToken(), this.alignment);
            jLabel.setOpaque(false);
            jLabel.setForeground(Color.black);
            jLabel.setBackground(Color.white);
            jLabel.setFont(this.font);
            LookAndFeel.installColorsAndFont(jLabel, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
            this.add(jLabel);
        }
        this.setBorder(new LineBorder(Color.black, 1));
        return this;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, this.getMaximumSize().width, this.getMaximumSize().height);
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            if (componentArray[n3] instanceof JLabel) {
                JLabel jLabel = (JLabel)componentArray[n3];
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(jLabel.getText(), graphics);
                int n4 = (int)rectangle2D.getWidth();
                int n5 = this.getWidth();
                n = (n5 - n4) / 2;
                int n6 = 0;
                int n7 = this.getHeight();
                int n8 = componentArray.length;
                if (n8 == 1) {
                    n2 = (n7 - (int)rectangle2D.getHeight()) / 2;
                    n2 += (int)rectangle2D.getHeight() - fontMetrics.getDescent();
                } else {
                    int n9 = n7 / (n8 + 1);
                    n2 = (n9 - (int)rectangle2D.getHeight()) / 2;
                    n2 += n9 * (n3 + 0);
                    n2 += (int)rectangle2D.getHeight();
                    n2 += fontMetrics.getDescent() * n3;
                }
                graphics.drawString(jLabel.getText(), n, n2 += n6);
            }
            ++n3;
        }
        this.paintBorder(graphics);
    }
}

