/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeSet;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.PluginSettings;

public class AperiEclipseChart
extends AperiChartAdapter
implements IUpdateNotifier {
    private static final long serialVersionUID = 1L;
    private IDeviceRenderer idr = null;
    private GeneratedChartState gcs = null;
    private Chart cm = null;
    private boolean needsRebuild = true;
    private ColorDefinition backgroundColor;
    private String yUnits = null;
    private double yScale = 1.0;
    protected static final String DECIMAL_FMT = "###,###.00";
    protected static final String NUMBER_FMT = "###,###";
    protected static final String BYTE_LABEL = "b";
    protected static final String KBYTE_LABEL = "KB";
    protected static final String MBYTE_LABEL = "MB";
    protected static final String GBYTE_LABEL = "GB";
    protected static final String TBYTE_LABEL = "TB";
    protected static final String PBYTE_LABEL = "PB";
    protected static final long BYTE_THRESHOLD = 1L;
    protected static final long KBYTE_THRESHOLD = 1024L;
    protected static final long MBYTE_THRESHOLD = 0x100000L;
    protected static final long GBYTE_THRESHOLD = 0x40000000L;
    protected static final long TBYTE_THRESHOLD = 0x10000000000L;
    protected static final long PBYTE_THRESHOLD = 0x4000000000000L;
    private static Date date;
    Double[][] doubleTrendSeries;
    Double[][] doubleYSeries;
    Double[] doubleXSeries;
    Calendar[] typedXSeries;
    private double max = 0.0;

    static {
        System.setProperty("STANDALONE", "true");
        System.setProperty("RUN_UNDER_ECLIPSE", "false");
        date = new Date();
    }

    public void setChartOrientation(int n) {
        super.setChartOrientation(n);
        this.repaintIfNeeded();
    }

    public void setChartType(int n) {
        super.setChartType(n);
        this.repaintIfNeeded();
    }

    public void setLegendAnchor(int n) {
        super.setLegendAnchor(n);
        this.repaintIfNeeded();
    }

    public void setLegendOrientation(int n) {
        super.setLegendOrientation(n);
        this.repaintIfNeeded();
    }

    public void setLegendVisible(boolean bl) {
        super.setLegendVisible(bl);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleText(String string) {
        super.setXAxisTitleText(string);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleVisible(boolean bl) {
        super.setXAxisTitleVisible(bl);
        this.repaintIfNeeded();
    }

    public void setXCategories(String[] stringArray) {
        super.setXCategories(stringArray);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleText(String string) {
        super.setYAxisTitleText(string);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleVisible(boolean bl) {
        super.setYAxisTitleVisible(bl);
        this.repaintIfNeeded();
    }

    public void setYAxisScaling(int n) {
        super.setYAxisScaling(n);
        this.repaintIfNeeded();
    }

    public void setYSeries(Number[][] numberArray) {
        int n;
        boolean bl = false;
        int n2 = 0;
        while (n2 < numberArray.length) {
            if (numberArray[n2] != null) {
                n = 0;
                while (n < numberArray[n2].length) {
                    if (numberArray[n2][n] != null && !(numberArray[n2][n] instanceof Double)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        if (bl) {
            Number[][] numberArray2 = new Double[numberArray.length][];
            n2 = 0;
            while (n2 < numberArray2.length) {
                if (numberArray[n2] != null) {
                    numberArray2[n2] = new Double[numberArray[n2].length];
                    n = 0;
                    while (n < numberArray[n2].length) {
                        numberArray2[n2][n] = numberArray[n2][n] != null && !(numberArray[n2][n] instanceof Double) ? new Double(numberArray[n2][n].doubleValue()) : (Double)numberArray[n2][n];
                        ++n;
                    }
                }
                ++n2;
            }
            super.setYSeries(numberArray2);
        } else {
            super.setYSeries(numberArray);
        }
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public void setYSeriesNames(String[] stringArray) {
        super.setYSeriesNames(stringArray);
        this.repaintIfNeeded();
    }

    public void setChartTitle(String string) {
        super.setChartTitle(string);
        this.repaintIfNeeded();
    }

    public void setYAxisTitleOrientation(int n) {
        super.setYAxisTitleOrientation(n);
        this.repaintIfNeeded();
    }

    public void setChartTitleVisible(boolean bl) {
        super.setChartTitleVisible(bl);
        this.repaintIfNeeded();
    }

    public void setXAxisTitleOrientation(int n) {
        super.setXAxisTitleOrientation(n);
        this.repaintIfNeeded();
    }

    public void setYValueLabelsVisible(boolean bl) {
        super.setYValueLabelsVisible(bl);
        this.repaintIfNeeded();
    }

    public void setYValueLabelsOrientation(int n) {
        super.setYValueLabelsOrientation(n);
        this.repaintIfNeeded();
    }

    public void setYValuePointsVisible(boolean bl) {
        super.setYValuePointsVisible(bl);
        this.repaintIfNeeded();
    }

    public void setYValueFormat(int n) {
        super.setYValueFormat(n);
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public AperiEclipseChart() {
        PluginSettings pluginSettings = PluginSettings.instance();
        try {
            this.idr = pluginSettings.getDevice("dv.SWING");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(this.getMinimumSize());
    }

    private void repaintIfNeeded() {
        this.setNeedsRebuild(true);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.backgroundColor = ColorDefinitionImpl.TRANSPARENT();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.idr.setProperty("device.output.context", (Object)graphics2D);
        this.idr.setProperty("device.component", (Object)this);
        Dimension dimension = this.getSize();
        Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)dimension.width, (double)dimension.height);
        bounds.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        Generator generator = Generator.instance();
        if (this.isNeedsRebuild()) {
            this.cm = this.buildChart();
            this.setNeedsRebuild(false);
        }
        try {
            this.gcs = generator.build(this.idr.getDisplayServer(), this.cm, bounds, null, null, null);
            generator.render(this.idr, this.gcs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Chart buildChart() {
        switch (this.getChartType()) {
            case 0: {
                return this.createHistoryChart();
            }
            case 1: {
                return this.createPieChart();
            }
            case 2: 
            case 3: {
                return this.createBarChart();
            }
        }
        throw new RuntimeException("Bad Chart Type " + this.getChartType());
    }

    public Chart createBarChart() {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.setSeriesThickness(1.0);
        chartWithAxes.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chartWithAxes.getBlock().setBackground((Fill)this.backgroundColor);
        chartWithAxes.getBlock().getOutline().setVisible(false);
        chartWithAxes.setTransposed(this.getChartOrientation() == 0);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground(null);
        plot.getOutline().setVisible(false);
        chartWithAxes.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        chartWithAxes.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        chartWithAxes.getTitle().setVisible(this.isChartTitleVisible());
        Legend legend = chartWithAxes.getLegend();
        legend.setVisible(this.isLegendVisible());
        legend.setPosition(this.mapPosition(this.getLegendAnchor()));
        legend.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        legend.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        legend.getText().getFont().setSize(8.0f);
        legend.setBackground(null);
        legend.getOutline().setVisible(false);
        legend.setItemType(LegendItemType.SERIES_LITERAL);
        Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
        this.setChartAxisLabelFormatter(axis, this.getXValueFormat());
        axis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        axis.getTitle().getCaption().setValue(this.getXAxisTitleText());
        axis.getTitle().setVisible(this.isXAxisTitleVisible());
        Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
        axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.setChartYAxisScaling(axis2);
        if (this.getYAxisScaling() != 1) {
            this.setChartAxisLabelFormatter(axis2, this.getYValueFormat());
        }
        axis2.getTitle().setVisible(this.isYAxisTitleVisible());
        axis2.getTitle().getCaption().setValue(this.getYAxisTitleText());
        if (chartWithAxes.isTransposed()) {
            axis2.getTitle().getCaption().getFont().setRotation(this.mapRotation(this.getYAxisTitleOrientation()) - 90.0);
        } else {
            axis2.getTitle().getCaption().getFont().setRotation(this.mapRotation(this.getYAxisTitleOrientation()));
        }
        axis2.getTitle().getCaption().getFont().setSize(8.0f);
        axis2.getLabel().setVisible(this.isYValueLabelsVisible());
        axis2.getLabel().getCaption().getFont().setSize(8.0f);
        if (this.getChartOrientation() == 0) {
            axis2.getLabel().getCaption().getFont().setRotation(90.0);
            axis.getLabel().getCaption().getFont().setRotation(-90.0);
        }
        if (this.getChartSubtype() == 0) {
            Series series = SeriesImpl.create();
            series.setDataSet((DataSet)TextDataSetImpl.create((Object)this.getXCategories()));
            SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
            axis.getSeriesDefinitions().add((Object)seriesDefinition);
            seriesDefinition.getSeries().add((Object)series);
            SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
            seriesDefinition2.getSeriesPalette().update(0);
            axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
            double d = 0.0;
            int n = this.getSeriesOffset();
            while (n < Math.min(this.getYSeries().length, this.getSeriesOffset() + this.getSeriesPerChart())) {
                BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
                barSeries.setSeriesIdentifier((Object)this.getYSeriesNames()[n]);
                if ((Double)this.getYSeries()[n][0] > d) {
                    d = (Double)this.getYSeries()[n][0];
                }
                barSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)new Double[]{(Double)this.getYSeries()[n][0]}));
                barSeries.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)barSeries);
                if (this.getChartType() == 3) {
                    barSeries.setStacked(true);
                }
                seriesDefinition2.getSeries().add((Object)barSeries);
                ++n;
            }
            if (n < this.getYSeries().length) {
                double d2 = 0.0;
                int n2 = n;
                while (n2 < this.getYSeries().length) {
                    d2 += this.getYSeries()[n2][0].doubleValue();
                    ++n2;
                }
                BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
                barSeries.setSeriesIdentifier((Object)"Other");
                barSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)new double[]{d2}));
                barSeries.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)barSeries);
                if (this.getChartType() == 3) {
                    barSeries.setStacked(true);
                }
                seriesDefinition2.getSeries().add((Object)barSeries);
                if (d2 > d) {
                    d = d2;
                }
            }
            if (this.getYValueFormat() != 8 && this.getYAxisScaling() != 1) {
                axis2.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
                if (d == 0.0) {
                    d = 10.0;
                }
                double d3 = Math.round(d / 10.0);
                axis2.getScale().setMax((DataElement)NumberDataElementImpl.create((double)Math.round(d + d3)));
                axis2.getScale().setStep(d3);
                axis2.getScale().setMinorGridsPerUnit(1);
            }
        } else {
            Series series = SeriesImpl.create();
            series.setDataSet((DataSet)this.extractCategoryNamesSubset());
            SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
            axis.getSeriesDefinitions().add((Object)seriesDefinition);
            seriesDefinition.getSeries().add((Object)series);
            SeriesDefinition seriesDefinition3 = SeriesDefinitionImpl.create();
            seriesDefinition3.getSeriesPalette().update(0);
            axis2.getSeriesDefinitions().add((Object)seriesDefinition3);
            int n = 0;
            while (n < this.getYSeries().length) {
                BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
                barSeries.setSeriesIdentifier((Object)this.getYSeriesNames()[n]);
                barSeries.setDataSet((DataSet)this.extractSeriesDataSubset(this.getYSeries()[n]));
                barSeries.getLabel().setVisible(this.isYValuePointsVisible());
                this.configureDataPoint((Series)barSeries);
                if (this.getChartType() == 3) {
                    barSeries.setStacked(true);
                }
                this.configureDataPoint((Series)barSeries);
                seriesDefinition3.getSeries().add((Object)barSeries);
                ++n;
            }
        }
        return chartWithAxes;
    }

    private TextDataSet extractCategoryNamesSubset() {
        String[] stringArray = (String[])this.getXCategories();
        String[] stringArray2 = new String[Math.min(this.getChartsPerView(), stringArray.length - this.getCategoryOffset())];
        int n = 0;
        int n2 = this.getCategoryOffset();
        while (n2 < Math.min(stringArray.length, this.getCategoryOffset() + this.getChartsPerView())) {
            stringArray2[n] = stringArray[n2];
            ++n2;
            ++n;
        }
        return TextDataSetImpl.create((Object)stringArray2);
    }

    private void setChartAxisLabelFormatter(Axis axis, int n) {
        axis.setFormatSpecifier(this.getYValueFormatSpecifier(n));
        axis.getScale().unsetStep();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                axis.setType(AxisType.LINEAR_LITERAL);
                break;
            }
            case 5: {
                axis.setType(AxisType.DATE_TIME_LITERAL);
                break;
            }
            case 7: {
                axis.setType(AxisType.TEXT_LITERAL);
                break;
            }
            case 8: {
                axis.setType(AxisType.LINEAR_LITERAL);
                axis.getScale().setStep(10.0);
                axis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)100.0));
                break;
            }
            default: {
                axis.setType(AxisType.LINEAR_LITERAL);
            }
        }
    }

    private void setChartYAxisScaling(Axis axis) {
        if (this.getYAxisScaling() == 1) {
            axis.setPercent(true);
            axis.setType(AxisType.LINEAR_LITERAL);
            axis.setFormatSpecifier((FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0'%'"));
            axis.getScale().setStep(10.0);
            axis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)100.0));
        } else if (this.getYAxisScaling() == 2) {
            axis.setPercent(false);
            axis.setType(AxisType.LOGARITHMIC_LITERAL);
        } else {
            axis.setPercent(false);
            axis.setType(AxisType.LINEAR_LITERAL);
        }
    }

    private double mapRotation(int n) {
        if (n == 0) {
            return 0.0;
        }
        return 90.0;
    }

    private NumberDataSet extractCategoryData(Number[][] numberArray, int n) {
        Double[] doubleArray;
        if (this.getChartSubtype() != 0) {
            doubleArray = new Double[numberArray.length];
            this.extractCategorySubset(numberArray, n, 0, doubleArray, numberArray.length);
        } else if (this.getSeriesPerChart() < numberArray.length - this.getSeriesOffset()) {
            int n2 = this.getSeriesPerChart() + 1;
            doubleArray = new Double[n2];
            this.extractCategorySubset(numberArray, n, this.getSeriesOffset(), doubleArray, n2 - 1);
            double d = 0.0;
            int n3 = this.getSeriesOffset() + 1;
            while (n3 < numberArray.length) {
                d += ((Double)numberArray[n3][n]).doubleValue();
                ++n3;
            }
            doubleArray[n2 - 1] = new Double(d);
        } else {
            int n4 = numberArray.length - this.getSeriesOffset();
            doubleArray = new Double[n4];
            this.extractCategorySubset(numberArray, n, this.getSeriesOffset(), doubleArray, n4);
        }
        return NumberDataSetImpl.create((Object)doubleArray);
    }

    private TextDataSet extractYSeriesNamesSubset() {
        String[] stringArray;
        String[] stringArray2 = this.getYSeriesNames();
        if (this.getChartSubtype() != 0) {
            stringArray = stringArray2;
        } else if (this.getSeriesPerChart() < stringArray2.length - this.getSeriesOffset()) {
            stringArray = new String[this.getSeriesPerChart() + 1];
            int n = 0;
            while (n < stringArray.length - 1) {
                stringArray[n] = stringArray2[this.getSeriesOffset() + n];
                ++n;
            }
            stringArray[stringArray.length - 1] = "Other";
        } else {
            stringArray = new String[stringArray2.length - this.getSeriesOffset()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray2[this.getSeriesOffset() + n];
                ++n;
            }
        }
        return TextDataSetImpl.create((Object)stringArray);
    }

    private void extractCategorySubset(Number[][] numberArray, int n, int n2, Double[] doubleArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            try {
                doubleArray[n4] = (Double)numberArray[n4 + n2][n];
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            ++n4;
        }
    }

    private NumberDataSet extractSeriesDataSubset(Number[] numberArray) {
        Double[] doubleArray = new Double[Math.min(this.getChartsPerView(), numberArray.length - this.getCategoryOffset())];
        int n = 0;
        int n2 = this.getCategoryOffset();
        while (n2 < Math.min(numberArray.length, this.getCategoryOffset() + this.getChartsPerView())) {
            doubleArray[n] = (Double)numberArray[n2];
            ++n2;
            ++n;
        }
        return NumberDataSetImpl.create((Object)doubleArray);
    }

    public Chart createHistoryChart() {
        this.convertSeries();
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.setSeriesThickness(1.0);
        chartWithAxes.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chartWithAxes.getBlock().setBackground((Fill)this.backgroundColor);
        chartWithAxes.getBlock().getOutline().setVisible(false);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground(null);
        plot.getOutline().setVisible(false);
        chartWithAxes.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        chartWithAxes.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        chartWithAxes.getTitle().setVisible(this.isChartTitleVisible());
        Legend legend = chartWithAxes.getLegend();
        legend.setVisible(this.isLegendVisible());
        legend.setPosition(this.mapPosition(this.getLegendAnchor()));
        legend.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        legend.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        legend.getText().getFont().setSize(8.0f);
        legend.setBackground(null);
        legend.getOutline().setVisible(false);
        legend.setItemType(LegendItemType.SERIES_LITERAL);
        Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
        this.setChartAxisLabelFormatter(axis, this.getXValueFormat());
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        axis.getTitle().getCaption().setValue(this.getXAxisTitleText());
        axis.getTitle().setVisible(this.isXAxisTitleVisible());
        axis.getLabel().getCaption().getFont().setSize(8.0f);
        axis.getLabel().getCaption().getFont().setRotation(90.0);
        Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
        axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        Series series = SeriesImpl.create();
        series.setDataSet((DataSet)DateTimeDataSetImpl.create((Object)this.typedXSeries));
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        seriesDefinition.getSeries().add((Object)series);
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().update(-2);
        axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
        this.setChartYAxisScaling(axis2);
        if (this.getYAxisScaling() != 1) {
            this.setChartAxisLabelFormatter(axis2, this.getYValueFormat());
        }
        axis2.getTitle().setVisible(this.isYAxisTitleVisible());
        axis2.getTitle().getCaption().setValue(this.getYAxisTitleText());
        axis2.getTitle().getCaption().getFont().setSize(8.0f);
        axis2.getLabel().setVisible(this.isYValueLabelsVisible());
        axis2.getLabel().getCaption().getFont().setSize(8.0f);
        if (this.getYValueFormat() != 8 && this.getYAxisScaling() != 1) {
            axis2.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            if (this.max == 0.0) {
                this.max = 10.0;
            }
            double d = Math.round(this.max / 10.0);
            axis2.getScale().setMax((DataElement)NumberDataElementImpl.create((double)Math.round(this.max + d)));
            axis2.getScale().setStep(d);
            axis2.getScale().setMinorGridsPerUnit(1);
        }
        int n = this.getSeriesOffset();
        while (n < Math.min(this.getYSeriesNames().length, this.getSeriesOffset() + this.getSeriesPerChart())) {
            ScatterSeries scatterSeries = (ScatterSeries)ScatterSeriesImpl.create();
            scatterSeries.setSeriesIdentifier((Object)this.getYSeriesNames()[n]);
            scatterSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.doubleYSeries[n]));
            scatterSeries.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
            scatterSeries.getLineAttributes().setStyle(LineStyle.SOLID_LITERAL);
            scatterSeries.getLineAttributes().setVisible(true);
            scatterSeries.getMarker().setType(MarkerType.BOX_LITERAL);
            scatterSeries.getLabel().setVisible(this.isYValuePointsVisible());
            this.configureDataPoint((Series)scatterSeries);
            seriesDefinition2.getSeries().add((Object)scatterSeries);
            if (this.isTrendLineVisible() && this.doubleTrendSeries[n] != null) {
                ScatterSeries scatterSeries2 = (ScatterSeries)ScatterSeriesImpl.create();
                scatterSeries2.setSeriesIdentifier((Object)"");
                scatterSeries2.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.doubleTrendSeries[n]));
                scatterSeries2.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
                scatterSeries2.getLineAttributes().setStyle(LineStyle.DASHED_LITERAL);
                scatterSeries2.getLineAttributes().setVisible(true);
                scatterSeries2.getMarker().setType(MarkerType.CROSSHAIR_LITERAL);
                scatterSeries2.getLabel().setVisible(false);
                this.configureDataPoint((Series)scatterSeries2);
                seriesDefinition2.getSeries().add((Object)scatterSeries2);
            }
            ++n;
        }
        return chartWithAxes;
    }

    private void convertSeries() {
        boolean bl = true;
        this.createTrendValues();
        this.buildXSeries();
        this.buildYSeries();
        this.buildTrendSeries();
        this.typeXaxis();
    }

    private void typeXaxis() {
        this.typedXSeries = new Calendar[this.doubleXSeries.length];
        int n = 0;
        while (n < this.doubleXSeries.length) {
            date.setTime((long)this.doubleXSeries[n].doubleValue());
            this.typedXSeries[n] = new CDateTime(date);
            ++n;
        }
    }

    private void buildTrendSeries() {
        this.doubleTrendSeries = new Double[this.getYValues().length][];
        int n = 0;
        while (n < this.doubleTrendSeries.length) {
            if (this.xTrend[n][0] == Double.MIN_VALUE || this.yTrend[n][0] == Double.MIN_VALUE) {
                this.doubleTrendSeries[n] = null;
            } else {
                this.doubleTrendSeries[n] = new Double[this.doubleXSeries.length];
                Arrays.fill(this.doubleTrendSeries[n], null);
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.doubleXSeries.length && n2 < this.xTrend[n].length) {
                    if (this.xTrend[n][n2] == this.doubleXSeries[n3]) {
                        this.doubleTrendSeries[n][n3] = new Double(this.yTrend[n][n2]);
                        if (this.doubleTrendSeries[n][n3] > this.max) {
                            this.max = this.doubleTrendSeries[n][n3];
                        }
                        ++n2;
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private void buildYSeries() {
        this.doubleYSeries = new Double[this.getYValues().length][this.doubleXSeries.length];
        int n = 0;
        while (n < this.getYValues().length) {
            Arrays.fill(this.doubleYSeries[n], null);
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.doubleXSeries.length && n2 < this.getXValues()[n].length) {
                if (this.getXValues()[n][n2] == this.doubleXSeries[n3]) {
                    this.doubleYSeries[n][n3] = new Double(this.getYValues()[n][n2]);
                    if (this.doubleYSeries[n][n3] > this.max) {
                        this.max = this.doubleYSeries[n][n3];
                    }
                    ++n2;
                }
                ++n3;
            }
            ++n;
        }
    }

    private void buildXSeries() {
        int n;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        int n2 = 0;
        while (n2 < this.getXValues().length) {
            n = 0;
            while (n < this.getXValues()[n2].length) {
                treeSet.add(new Double(this.getXValues()[n2][n]));
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.xTrend.length) {
            n = 0;
            while (n < this.xTrend[n2].length) {
                treeSet.add(new Double(this.xTrend[n2][n]));
                ++n;
            }
            ++n2;
        }
        this.doubleXSeries = treeSet.toArray(new Double[treeSet.size()]);
    }

    public Chart createPieChart() {
        ChartWithoutAxes chartWithoutAxes = ChartWithoutAxesImpl.create();
        chartWithoutAxes.setSeriesThickness(20.0);
        chartWithoutAxes.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chartWithoutAxes.getBlock().setBackground((Fill)this.backgroundColor);
        Plot plot = chartWithoutAxes.getPlot();
        plot.getClientArea().setBackground(null);
        plot.getOutline().setVisible(false);
        chartWithoutAxes.getTitle().getLabel().getCaption().setValue(this.getChartTitle());
        chartWithoutAxes.getTitle().getLabel().getCaption().getFont().setSize(8.0f);
        chartWithoutAxes.getTitle().setVisible(this.isChartTitleVisible());
        Legend legend = chartWithoutAxes.getLegend();
        legend.setVisible(this.isLegendVisible());
        legend.setPosition(this.mapPosition(this.getLegendAnchor()));
        legend.setAnchor(this.mapAnchor(this.getLegendAnchor()));
        legend.setOrientation(this.mapOrientation(this.getLegendOrientation()));
        legend.getText().getFont().setSize(8.0f);
        legend.setBackground(null);
        legend.getOutline().setVisible(false);
        if (this.getXCategories() == null || this.getXCategories().length == 1) {
            chartWithoutAxes.setGridColumnCount(1);
        } else {
            chartWithoutAxes.setGridColumnCount((int)Math.round(Math.sqrt(this.getChartsPerView())));
        }
        Series series = SeriesImpl.create();
        series.setDataSet((DataSet)this.extractYSeriesNamesSubset());
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        chartWithoutAxes.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeriesPalette().update(0);
        seriesDefinition.getSeries().add((Object)series);
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition.getSeriesDefinitions().add((Object)seriesDefinition2);
        Number[][] numberArray = this.getYSeries();
        int n = this.getCategoryOffset();
        while (n < Math.min(this.getXCategories().length, this.getCategoryOffset() + this.getChartsPerView())) {
            PieSeries pieSeries = (PieSeries)PieSeriesImpl.create();
            pieSeries.setRatio(0.0);
            pieSeries.setExplosion(0);
            pieSeries.setSeriesIdentifier(this.getXCategories()[n]);
            pieSeries.setDataSet((DataSet)this.extractCategoryData(numberArray, n));
            pieSeries.setTitlePosition(Position.BELOW_LITERAL);
            pieSeries.getTitle().getCaption().getFont().setSize(8.0f);
            this.configureDataPoint((Series)pieSeries);
            seriesDefinition2.getSeries().add((Object)pieSeries);
            ++n;
        }
        return chartWithoutAxes;
    }

    private void configureDataPoint(Series series) {
        series.getLabel().setVisible(this.isYValuePointsVisible());
        if (this.getChartType() == 0) {
            series.setLabelPosition(Position.ABOVE_LITERAL);
        } else {
            series.setLabelPosition(Position.INSIDE_LITERAL);
        }
        DataPoint dataPoint = series.getDataPoint();
        dataPoint.getComponents().clear();
        dataPoint.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)this.getYValueFormatSpecifier(this.getYValueFormat())));
        dataPoint.setSeparator(" ");
        if (this.getChartType() == 1) {
            dataPoint.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, null));
        } else {
            dataPoint.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.SERIES_VALUE_LITERAL, null));
        }
        if (!this.isYValuePointsVisible()) {
            series.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)1, null))));
        }
    }

    private FormatSpecifier getYValueFormatSpecifier(int n) {
        JavaDateFormatSpecifier javaDateFormatSpecifier = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                javaDateFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)(String.valueOf(this.getYJavaNumberFormat()) + " " + this.getYUnits()));
                ((JavaNumberFormatSpecifier)javaDateFormatSpecifier).setMultiplier(1.0 / this.getYScale());
                break;
            }
            case 5: {
                javaDateFormatSpecifier = JavaDateFormatSpecifierImpl.create((String)"dd-MMM-yy:HH:mm:ss");
                break;
            }
            case 8: {
                javaDateFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)"0'%'");
                break;
            }
            default: {
                javaDateFormatSpecifier = null;
            }
        }
        return javaDateFormatSpecifier;
    }

    private Anchor mapAnchor(int n) {
        return Anchor.get((int)n);
    }

    private Position mapPosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 7: {
                return Position.ABOVE_LITERAL;
            }
            case 3: 
            case 4: 
            case 5: {
                return Position.BELOW_LITERAL;
            }
            case 2: {
                return Position.RIGHT_LITERAL;
            }
            case 6: {
                return Position.LEFT_LITERAL;
            }
        }
        return Position.OUTSIDE_LITERAL;
    }

    private Orientation mapOrientation(int n) {
        if (n == 1) {
            return Orientation.VERTICAL_LITERAL;
        }
        return Orientation.HORIZONTAL_LITERAL;
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.gcs.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.repaint();
    }

    public void repaintChart() {
        this.repaint();
    }

    public boolean isNeedsRebuild() {
        return this.needsRebuild;
    }

    public void setNeedsRebuild(boolean bl) {
        this.needsRebuild = bl;
    }

    protected String getYUnits() {
        return this.yUnits;
    }

    private void calcYUnitsAndScaling() {
        switch (this.getYValueFormat()) {
            case 1: {
                this.calcByteUnitsAndScaling();
                break;
            }
            case 3: {
                this.setYUnits("msecs");
                this.setYScale(1.0);
                break;
            }
            case 4: {
                this.setYUnits("days");
                this.setYScale(86400.0);
                break;
            }
            default: {
                this.setYUnits("");
                this.setYScale(1.0);
            }
        }
    }

    private void calcByteUnitsAndScaling() {
        block6: {
            block5: {
                if (this.getChartType() == 0) break block5;
                Number[][] numberArray = this.getYSeries();
                if (numberArray == null) break block6;
                this.setYUnits(BYTE_LABEL);
                this.setYScale(1.0);
                int n = 0;
                while (n < numberArray.length) {
                    int n2 = 0;
                    while (n2 < numberArray[n].length) {
                        this.setByteUnitsAndScaling(numberArray[n][n2].doubleValue());
                        ++n2;
                    }
                    ++n;
                }
                break block6;
            }
            double[][] dArray = this.getYValues();
            if (dArray != null) {
                this.setYUnits(BYTE_LABEL);
                this.setYScale(1.0);
                int n = 0;
                while (n < dArray.length) {
                    int n3 = 0;
                    while (n3 < dArray[n].length) {
                        this.setByteUnitsAndScaling(dArray[n][n3]);
                        ++n3;
                    }
                    ++n;
                }
            }
        }
    }

    private void setByteUnitsAndScaling(double d) {
        if (d > 1.125899906842624E15) {
            this.setYUnits(PBYTE_LABEL);
            this.setYScale(1.125899906842624E15);
        } else if (d > 1.099511627776E12) {
            this.setYUnits(TBYTE_LABEL);
            this.setYScale(1.099511627776E12);
        } else if (d > 1.073741824E9) {
            this.setYUnits(GBYTE_LABEL);
            this.setYScale(1.073741824E9);
        } else if (d > 1048576.0) {
            this.setYUnits(MBYTE_LABEL);
            this.setYScale(1048576.0);
        } else if (d > 1024.0) {
            this.setYUnits(KBYTE_LABEL);
            this.setYScale(1024.0);
        }
    }

    protected String getYJavaNumberFormat() {
        switch (this.getYValueFormat()) {
            case 1: 
            case 2: {
                return DECIMAL_FMT;
            }
        }
        return NUMBER_FMT;
    }

    private double getYScale() {
        return this.yScale;
    }

    private void setYScale(double d) {
        this.yScale = d;
    }

    private void setYUnits(String string) {
        this.yUnits = string;
    }

    public void setXCategories(Object[] objectArray) {
        super.setXCategories(objectArray);
        this.repaintIfNeeded();
    }

    public void setXValueFormat(int n) {
        super.setXValueFormat(n);
        this.repaintIfNeeded();
    }

    public void setXYValues(double[][] dArray, double[][] dArray2) {
        super.setXYValues(dArray, dArray2);
        this.calcYUnitsAndScaling();
        this.repaintIfNeeded();
    }

    public void setTrendLineVisible(boolean bl) {
        super.setTrendLineVisible(bl);
        this.repaintIfNeeded();
    }

    public void setChartsPerView(int n, int n2) {
        super.setChartsPerView(n, n2);
        this.repaintIfNeeded();
    }

    public void setSeriesPerChart(int n, int n2) {
        super.setSeriesPerChart(n, n2);
        this.repaintIfNeeded();
    }

    public void setChartSubtype(int n) {
        super.setChartSubtype(n);
        this.repaintIfNeeded();
    }
}

