/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;

public class GuiConfig {
    private static final String windowsUserConfigDir = "Application Data" + File.separator + "Aperi" + File.separator + "config";
    private static final String unixUserConfigDir = ".Aperi" + File.separator + "config";

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
    }

    public static void loadProperties(String string, Properties properties) throws IOException {
        File file = new File(GuiConfig.getUserConfigDir().append(File.separator).append(string).toString());
        BufferedInputStream bufferedInputStream = null;
        if (file.canRead()) {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    public static void storeProperties(String string, Properties properties) throws IOException, FileNotFoundException {
        StringBuffer stringBuffer = GuiConfig.getUserConfigDir();
        GuiConfig.mkDirectory(stringBuffer.toString());
        File file = new File(stringBuffer.append(File.separator).append(string).toString());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        properties.store(bufferedOutputStream, null);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static boolean mkDirectory(String string) {
        File file = new File(string);
        return file.isDirectory() && file.canWrite() || file.mkdirs();
    }

    public static StringBuffer getUserConfigDir() {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("user.home", ""));
        stringBuffer.append(File.separator);
        if (GuiConfig.isWindows()) {
            stringBuffer.append(windowsUserConfigDir);
        } else {
            stringBuffer.append(unixUserConfigDir);
        }
        return stringBuffer;
    }

    public static FileInputStream getFileInputStream(String string) throws FileNotFoundException {
        StringBuffer stringBuffer = GuiConfig.getUserConfigDir();
        File file = new File(stringBuffer.append(File.separator).append(string).toString());
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static FileOutputStream getFileOutputStream(String string) throws FileNotFoundException {
        StringBuffer stringBuffer = GuiConfig.getUserConfigDir();
        GuiConfig.mkDirectory(stringBuffer.toString());
        File file = new File(stringBuffer.append(File.separator).append(string).toString());
        return new FileOutputStream(file);
    }
}

