/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.config.common.ConfigSection;

public class ConfigSectionContainer
extends JPanel
implements ActionListener {
    private static ImageIcon exIcon = GuiUtil.createImageIcon("expand.gif");
    private static ImageIcon clIcon = GuiUtil.createImageIcon("collapse.gif");
    private JButton ctrlBtn = null;
    private JLabel title = null;
    private ConfigSection contentpane = null;
    private JLabel spacer = null;

    public ConfigSectionContainer(ConfigSection configSection) {
        this.contentpane = configSection;
        configSection.setContainer(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ctrlBtn = new JButton(configSection.isExpanded() ? clIcon : exIcon);
        this.ctrlBtn.setSize(12, 12);
        this.ctrlBtn.setBorderPainted(false);
        this.ctrlBtn.setContentAreaFilled(false);
        this.ctrlBtn.setFocusPainted(false);
        this.ctrlBtn.addActionListener(this);
        jPanel.add((Component)this.ctrlBtn, "Before");
        this.title = new JLabel(configSection.getSectionTitle());
        Font font = this.title.getFont().deriveFont(1);
        this.title.setFont(font);
        jPanel.add((Component)this.title, "Center");
        this.add((Component)jPanel, "First");
        this.spacer = new JLabel();
        this.spacer.setPreferredSize(new Dimension(50, 30));
        this.add((Component)this.spacer, "Before");
        this.add((Component)configSection, "Center");
        this.add((Component)new JSeparator(0), "Last");
        this.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ctrlBtn) {
            this.contentpane.setExpanded(!this.contentpane.isExpanded());
            this.update();
        }
    }

    public void update() {
        this.ctrlBtn.setIcon(this.contentpane.isExpanded() ? clIcon : exIcon);
        this.title.setText(this.contentpane.getSectionTitle());
        this.spacer.setVisible(this.contentpane.isExpanded());
        this.contentpane.setVisible(this.contentpane.isExpanded());
    }

    public void updateSectionTitle() {
        this.title.setText(this.contentpane.getSectionTitle());
    }
}

