/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneConfigurationTree
extends JTree {
    ZoneCNS zoneCNS;
    DefaultMutableTreeNode topNode;
    DefaultMutableTreeNode allZoneSetsNode;
    DefaultMutableTreeNode allZonesNode;
    DefaultMutableTreeNode allAliasesNode;
    private boolean active = true;
    private static final String ZONES_LABEL = FabricGuiUtil.getString("FabricDeleteMissingDialog_Zones");
    private static final String ZONESETS_LABEL = FabricGuiUtil.getString("FabricDeleteMissingDialog_ZoneSets");
    private static final String ALIASES_LABEL = FabricGuiUtil.getString("FabricZonePanel_ZoneAliases");

    public ZoneConfigurationTree(ZoneCNS zoneCNS, boolean bl) {
        this.zoneCNS = zoneCNS;
        this.active = bl;
        this.populateTree();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.topNode);
        this.setModel(defaultTreeModel);
        this.setTreeOptions();
    }

    public void populateTree() {
        this.topNode = new DefaultMutableTreeNode();
        this.allZoneSetsNode = new DefaultMutableTreeNode(ZONESETS_LABEL);
        this.allZonesNode = new DefaultMutableTreeNode(ZONES_LABEL);
        this.allAliasesNode = new DefaultMutableTreeNode(ALIASES_LABEL);
        ZoneDefinition zoneDefinition = this.zoneCNS.getZoneDefinition(this.active);
        ZoneSet[] zoneSetArray = zoneDefinition.getZoneSets();
        int n = 0;
        while (n < zoneSetArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ZoneTreeNode(zoneSetArray[n].getName(), 0));
            Zone[] zoneArray = zoneDefinition.getZones(zoneSetArray[n]);
            this.updateZonesTreeNode(zoneDefinition, zoneArray, this.active, defaultMutableTreeNode);
            if (this.active) {
                this.topNode.add(defaultMutableTreeNode);
            } else {
                this.allZoneSetsNode.add(defaultMutableTreeNode);
            }
            ++n;
        }
        if (!this.active) {
            this.updateZonesTreeNode(zoneDefinition, null, true, this.allZonesNode);
            this.updateAliasesTreeNode(zoneDefinition, null, this.allAliasesNode);
            this.topNode.add(this.allZoneSetsNode);
            this.topNode.add(this.allZonesNode);
            this.topNode.add(this.allAliasesNode);
        }
    }

    private void updateZonesTreeNode(ZoneDefinition zoneDefinition, Zone[] zoneArray, boolean bl, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (zoneArray == null) {
            zoneArray = zoneDefinition.getZones();
        }
        int n = 0;
        while (n < zoneArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ZoneTreeNode(zoneArray[n].getName(), 1));
            if (bl) {
                ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zoneArray[n]);
                int n2 = 0;
                while (n2 < zoneMemberArray.length) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ZoneTreeNode(zoneMemberArray[n2].getName(), 2));
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    ++n2;
                }
                ZoneAlias[] zoneAliasArray = zoneDefinition.getAliases(zoneArray[n]);
                this.updateAliasesTreeNode(zoneDefinition, zoneAliasArray, defaultMutableTreeNode2);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    private void updateAliasesTreeNode(ZoneDefinition zoneDefinition, ZoneAlias[] zoneAliasArray, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (zoneAliasArray == null) {
            zoneAliasArray = zoneDefinition.getAliases();
        }
        int n = 0;
        while (n < zoneAliasArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ZoneTreeNode(zoneAliasArray[n].getName(), 3));
            ZoneMember[] zoneMemberArray = zoneDefinition.getMembers(zoneAliasArray[n]);
            int n2 = 0;
            while (n2 < zoneMemberArray.length) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ZoneTreeNode(zoneMemberArray[n2].getName(), 2));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                ++n2;
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    public void rePopulateTree() {
    }

    private void setTreeOptions() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setSelectionRow(0);
    }

    class ZoneTreeNode {
        protected String name;
        protected int type = 0;

        public ZoneTreeNode(String string, int n) {
            this.name = string;
            this.type = n;
        }

        public String toString() {
            return this.name;
        }
    }
}

