/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.AssignZoneMembersStep;
import org.eclipse.aperi.gui.fabric.zone.AssignZoneSetsStep;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneNameDescriptionStep;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneWizard
extends Wizard {
    private ZoneCNS zoneCNS;
    private AssignZoneSetsStep assignZoneSetsStep = null;
    private ZoneNameDescriptionStep nameDescStep = null;
    private AssignZoneMembersStep zoneMemStep = null;
    private int NO_BACK_WIZARD_FLAGS = 26;
    private int BACK_NEXT_WIZARD_FLAGS = 27;
    private int NO_NEXT_WIZARD_FLAGS = 29;
    private Zone zone = null;
    private Zone origZone = null;
    private ZoneSet[] zsInZone = null;
    private ZoneMember[] memInZone = null;
    private boolean duplicate = false;
    private boolean isEditZone = false;
    private boolean isNewZone = true;

    public ZoneWizard(Zone zone, ZoneCNS zoneCNS, boolean bl, boolean bl2) {
        this.zoneCNS = zoneCNS;
        this.zone = zone;
        this.duplicate = bl;
        this.origZone = zone;
        this.isEditZone = bl2;
        if (this.isEditZone || this.duplicate) {
            this.isNewZone = false;
            this.memInZone = this.zoneCNS.getZoneMembers(this.origZone);
        }
        if (this.duplicate) {
            String string = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_ZoneNameCopy"), new Object[]{zone.getName()});
            this.zone = new Zone(string.trim());
            this.zone.setDescription(zone.getDescription());
        }
        this.zsInZone = this.zoneCNS.getZoneSets(zone);
        this.addWizardListener(this);
        this.nameDescStep = new ZoneNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zone.getName(), this.zone.getDescription());
        this.add(this.nameDescStep);
        this.zoneMemStep = new AssignZoneMembersStep(this.BACK_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.isNewZone, this.memInZone);
        this.add(this.zoneMemStep);
        this.assignZoneSetsStep = new AssignZoneSetsStep(this.NO_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.zsInZone);
        this.add(this.assignZoneSetsStep);
    }

    public ZoneWizard(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.zone = new Zone("");
        this.addWizardListener(this);
        this.nameDescStep = new ZoneNameDescriptionStep(this.NO_BACK_WIZARD_FLAGS, false, this.zone.getName(), this.zone.getDescription());
        this.add(this.nameDescStep);
        this.zoneMemStep = new AssignZoneMembersStep(this.BACK_NEXT_WIZARD_FLAGS, this.zone, zoneCNS, this.isNewZone, this.memInZone);
        this.add(this.zoneMemStep);
        this.assignZoneSetsStep = new AssignZoneSetsStep(this.NO_NEXT_WIZARD_FLAGS, this.zone, this.zoneCNS, this.zsInZone);
        this.add(this.assignZoneSetsStep);
    }

    public boolean supportsEmptyZone() {
        return this.zoneCNS.getZoneCapabilities().isSupportsEmptyZones();
    }

    public int maxZoneMembers() {
        return this.zoneCNS.getZoneCapabilities().getMaxMembersInZone();
    }

    public boolean isSupportsSameZoneSetAndZoneName() {
        return this.zoneCNS.getZoneCapabilities().isSupportsSameZoneSetAndZoneName();
    }

    public boolean hasZoneSet(String string) {
        return this.zoneCNS.containsZoneSet(string);
    }

    public boolean hasZone(String string) {
        return this.zoneCNS.getZone(string) != null;
    }

    public String checkZoneNameString(String string) {
        String string2 = null;
        if (string.indexOf(32) != -1) {
            return Util.getString("FMSG_FabricZoneFrame_BadCharZoneNameErrorMsg");
        }
        if (!this.zoneCNS.getZoneCapabilities().isAllowsNumericNameStart() && this.zoneCNS.isNum(string.charAt(0))) {
            string2 = Util.getString("FabricZoneFrame_NumericalZoneNameErrorMsg");
            return string2;
        }
        if (!this.zoneCNS.getZoneCapabilities().isSupportsSpecialCharacters() && this.zoneCNS.isUnsupportedChar(string)) {
            string2 = Util.getString("FMSG_FabricZoneFrame_BadCharZoneNameErrorMsg");
            return string2;
        }
        if (this.zoneCNS.containsZone(string) && !this.isEditZone) {
            string2 = Util.getString("FabricZoneFrame_DuplicateZoneNameErrorMsg");
        }
        return string2;
    }

    public void setZoneNameDesc(String string, String string2) {
        this.zone = new Zone(string);
        this.zone.setDescription(string2);
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void nextBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.nameDescStep) {
            wizardEvent.setNewPage(this.zoneMemStep);
        } else if ((WizardPage)wizardEvent.getCurrentPage() == this.zoneMemStep) {
            wizardEvent.setNewPage(this.assignZoneSetsStep);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finished(WizardEvent wizardEvent) {
        Object object;
        super.finished(wizardEvent);
        if ((WizardPage)wizardEvent.getCurrentPage() != this.assignZoneSetsStep) return;
        ArrayList arrayList = this.assignZoneSetsStep.getSelectedList();
        if ((arrayList == null || arrayList.isEmpty()) && !this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones()) {
            int n = JOptionPane.showConfirmDialog(this, Util.getString("FabricZoneSetFrame_ZoneNotAssignedWarningMsg"), Util.getString("FabricZoneFrame_ZoneConfigurationErrorTitle"), 0);
            if (n != 0) return;
            this.zoneCNS.addZoneConfigError(this.zone.getName());
            this.zoneCNS.addZone(this.zone);
        } else if (arrayList != null && !arrayList.isEmpty()) {
            ZoneSet zoneSet;
            Object object2;
            Integer n = new Integer(this.zoneCNS.getZoneCapabilities().getMaxZonesInSet());
            object = new Integer(arrayList.size());
            if (!n.equals(new Integer(-1)) && (Integer)object > n) {
                JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
                return;
            }
            Iterator iterator = arrayList.iterator();
            ZoneSet[] zoneSetArray = new ZoneSet[arrayList.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                object2 = (ZoneSet[])iterator.next();
                zoneSetArray[n2] = zoneSet = this.zoneCNS.getZoneSet((String)object2);
                ++n2;
            }
            if (this.isEditZone && ((ZoneSet[])(object2 = this.zoneCNS.deleteZones(this.origZone))).length != 0) {
                int n3 = 0;
                while (n3 < ((ZoneSet[])object2).length) {
                    this.zoneCNS.addZoneSet((ZoneSet)object2[n3]);
                    this.zoneCNS.addZoneSetConfigError(((ZoneSet)object2[n3]).getName());
                    ++n3;
                }
            }
            this.zoneCNS.addZone(this.zone);
            this.zoneCNS.removeZoneConfigError(this.zone.getName());
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                zoneSet = this.zoneCNS.getZoneSet((String)object2.next());
                if (zoneSet == null) continue;
                this.zoneCNS.addZone(this.zone, zoneSet);
                this.zoneCNS.removeZoneSetConfigError(zoneSet.getName());
            }
        } else {
            ZoneSet[] zoneSetArray;
            if (this.isEditZone && (zoneSetArray = this.zoneCNS.deleteZones(this.origZone)).length != 0) {
                int n = 0;
                while (n < zoneSetArray.length) {
                    this.zoneCNS.addZoneSet(zoneSetArray[n]);
                    this.zoneCNS.addZoneSetConfigError(zoneSetArray[n].getName());
                    ++n;
                }
            }
            this.zoneCNS.addZone(this.zone);
            if (!this.zoneCNS.getZoneCapabilities().isSupportsOrphanZones()) {
                this.zoneCNS.addZoneConfigError(this.zone.getName());
            }
        }
        Vector vector = this.zoneMemStep.getZoneMembers();
        object = vector.elements();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (e instanceof ZoneMember) {
                this.zoneCNS.addZoneMember((ZoneMember)e, this.zone);
                continue;
            }
            if (!(e instanceof ZoneAlias)) continue;
            this.zoneCNS.addZoneAlias((ZoneAlias)e, this.zone);
        }
        this.zoneCNS.refreshDefinitionPanel();
        this.closeWizard();
    }

    public void canceled(WizardEvent wizardEvent) {
        super.canceled(wizardEvent);
        this.closeWizard();
    }

    private void closeWizard() {
        JDialog jDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        jDialog.dispose();
    }
}

