/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesDDI;
import org.eclipse.aperi.gui.tape.common.TapeGuiTable;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.TapeDataAccessor;
import org.eclipse.aperi.gui.tape.drives.DrivesDDI;
import org.eclipse.aperi.gui.tape.frames.FramesDDI;
import org.eclipse.aperi.gui.tape.ioports.IOPortsDDI;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.tape.library.LibraryPanel;
import org.eclipse.aperi.gui.tape.library.LibraryTableModel;
import org.eclipse.aperi.gui.tape.mediachangers.MediaChangersDDI;
import org.eclipse.aperi.request.Response;

public class LibraryListPanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    private static final String ACTION_VIEW_DETAILS = "TAPE_VIEW_DETAILS_LABEL";
    private LibraryDDI theDDI;
    public FramesDDI fDDI;
    public LibraryPanel mainPanel;
    private TapeGuiTable table = new TapeGuiTable();
    private LibraryTableModel tableModel;
    private JButton launchButton = null;
    private JButton drivesButton = null;
    private JButton mediaChangersButton = null;
    private JButton ioPortsButton = null;
    private JButton framesButton = null;
    private JButton cartridgesButton = null;
    private JButton removeButton = null;
    private JPanel p = new JPanel();
    private JPanel pb = new JPanel();
    private JPanel pbNorth = new JPanel();
    private JPanel pbSouth = new JPanel();
    private JPanel tablePanel = GuiUtil.getPanel();
    private boolean dblClick = false;
    private GUILibrary oLibrary;
    private static DefaultTableCellRenderer drillDownRenderer = new DrillDownRenderer();
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object object) {
            return ((GUILibrary)object).getId();
        }

        public String extractDefaultElementManager(Object object) {
            return ((GUILibrary)object).getElementManager();
        }

        public String extractDisplayName(Object object) {
            return ((GUILibrary)object).getName();
        }
    };

    public LibraryListPanel(LibraryDDI libraryDDI) {
        this.theDDI = libraryDDI;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        this.launchButton = new JButton(Util.getString("TAPE_LAUNCH_ELEMENT_MGR_LABEL"));
        this.launchButton.setEnabled(false);
        this.launchButton.addActionListener(this);
        GuiUtil.setAccessible(this.launchButton, this.launchButton.getText(), this.launchButton.getText());
        this.drivesButton = new JButton(Util.getString("TAPE_DRIVES_LABEL"));
        this.drivesButton.setEnabled(false);
        this.drivesButton.addActionListener(this);
        GuiUtil.setAccessible(this.drivesButton, this.drivesButton.getText(), this.drivesButton.getText());
        this.mediaChangersButton = new JButton(Util.getString("TAPE_MEDIA_CHANGERS_LABEL"));
        this.mediaChangersButton.setEnabled(false);
        this.mediaChangersButton.addActionListener(this);
        GuiUtil.setAccessible(this.mediaChangersButton, this.mediaChangersButton.getText(), this.mediaChangersButton.getText());
        this.ioPortsButton = new JButton(Util.getString("TAPE_IOPORTS_LABEL"));
        this.ioPortsButton.setEnabled(false);
        this.ioPortsButton.addActionListener(this);
        GuiUtil.setAccessible(this.ioPortsButton, this.ioPortsButton.getText(), this.ioPortsButton.getText());
        this.cartridgesButton = new JButton(Util.getString("TAPE_CARTRIDGES_LABEL"));
        this.cartridgesButton.setEnabled(false);
        this.cartridgesButton.addActionListener(this);
        GuiUtil.setAccessible(this.cartridgesButton, this.cartridgesButton.getText(), this.cartridgesButton.getText());
        this.removeButton = new JButton(Util.getString("TAPE_REMOVE_LABEL"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        GuiUtil.setAccessible(this.removeButton, this.removeButton.getText(), this.removeButton.getText());
        this.p.setLayout(new BorderLayout());
        this.pbNorth.setLayout(new FlowLayout(0));
        this.pbNorth.add(this.launchButton);
        this.pbNorth.add(this.drivesButton);
        this.pbNorth.add(this.mediaChangersButton);
        this.pbSouth.setLayout(new FlowLayout(0));
        this.pbSouth.add(this.ioPortsButton);
        this.pbSouth.add(this.cartridgesButton);
        this.pbSouth.add(this.removeButton);
        this.pb.setLayout(new BorderLayout());
        this.pb.add((Component)this.pbNorth, "North");
        this.pb.add((Component)this.pbSouth, "South");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("TAPE_LIBRARIES_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buildtable();
        this.tablePanel.add((Component)this.table, gridBagConstraints);
        this.add((Component)this.p, "Center");
        this.p.add((Component)this.pb, "North");
        this.p.add((Component)this.tablePanel, "Center");
        this.showAndAddListeners();
        return this;
    }

    private void showAndAddListeners() {
        this.guiMain.setSaveActionEnabled(false, false);
        this.guiMain.addSaveActionListener(this);
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int n5 = this.table.getPointedRow(n4);
        this.table.setSelectedRows(n5, n5);
        this.selectionChanged(true);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(Util.getString(ACTION_VIEW_DETAILS));
        jMenuItem.setActionCommand(ACTION_VIEW_DETAILS);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        jPopupMenu.show(component, n3, n4);
        jPopupMenu.requestFocus();
    }

    public void selectionChanged(boolean bl) {
        boolean bl2 = this.capabilities.isTapeAdmin();
        if (this.tableModel.getNumRows() != 0) {
            try {
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length > 0) {
                    GUILibrary gUILibrary = (GUILibrary)this.theDDI.getLibrary().elementAt(nArray[0]);
                    if (gUILibrary.getType() == 1) {
                        this.launchButton.setEnabled(bl);
                        if (bl2) {
                            this.removeButton.setEnabled(bl);
                        }
                        if (gUILibrary.getCatridges() == 0) {
                            this.cartridgesButton.setEnabled(false);
                        } else {
                            this.cartridgesButton.setEnabled(true);
                        }
                        if (gUILibrary.getDrives() == 0) {
                            this.drivesButton.setEnabled(false);
                        } else {
                            this.drivesButton.setEnabled(true);
                        }
                        if (gUILibrary.getIoPorts() == 0) {
                            this.ioPortsButton.setEnabled(false);
                        } else {
                            this.ioPortsButton.setEnabled(true);
                        }
                        if (gUILibrary.getMediaChangers() == 0) {
                            this.mediaChangersButton.setEnabled(false);
                        } else {
                            this.mediaChangersButton.setEnabled(true);
                        }
                    } else if (gUILibrary.getType() == 0) {
                        this.disableAllButtons();
                    }
                } else {
                    this.disableAllButtons();
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.disableAllButtons();
                return;
            }
        }
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
        this.theDDI.showDetails(n);
    }

    public void showDefaultChart(int n) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.drivesButton || object == this.mediaChangersButton || object == this.removeButton || object == this.launchButton || object == this.ioPortsButton || object == this.cartridgesButton || string.equals(ACTION_VIEW_DETAILS)) {
            int[] nArray;
            int[] nArray2 = this.table.getSelectedRows();
            GUILibrary[] gUILibraryArray = new GUILibrary[nArray2.length];
            int n = 0;
            while (n < gUILibraryArray.length) {
                gUILibraryArray[n] = (GUILibrary)this.theDDI.getLibrary().elementAt(nArray2[n]);
                ++n;
            }
            if (object == this.drivesButton) {
                DrivesDDI drivesDDI = new DrivesDDI(gUILibraryArray[0]);
                ((DataDisplayInfo)drivesDDI).reDisplay();
            } else if (object == this.mediaChangersButton) {
                MediaChangersDDI mediaChangersDDI = new MediaChangersDDI(gUILibraryArray[0]);
                ((DataDisplayInfo)mediaChangersDDI).reDisplay();
            } else if (object == this.removeButton) {
                this.openLibDelete(gUILibraryArray[0]);
            } else if (object == this.launchButton) {
                this.openElementManager(gUILibraryArray[0]);
            } else if (object == this.ioPortsButton) {
                IOPortsDDI iOPortsDDI = new IOPortsDDI(gUILibraryArray[0]);
                ((DataDisplayInfo)iOPortsDDI).reDisplay();
            } else if (object == this.cartridgesButton) {
                CartridgesDDI cartridgesDDI = new CartridgesDDI(gUILibraryArray[0]);
                ((DataDisplayInfo)cartridgesDDI).reDisplay();
            } else if (string.equals(ACTION_VIEW_DETAILS) && (nArray = this.table.getSelectedRows()).length > 0) {
                this.theDDI.showDetails(nArray[0]);
            }
        }
    }

    public void openLibDelete(GUILibrary gUILibrary) {
        TapeDataAccessor tapeDataAccessor = TapeDataAccessor.getInstance();
        int n = JOptionPane.showConfirmDialog(this, String.valueOf(Util.getString("TAPE_REALLY_DELETE_LABEL")) + gUILibrary.getDisplayName(), Util.getString("TAPE_DELETE_LABEL"), 1);
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                tapeDataAccessor.deleteTapeLibrary(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        int n;
                        Serializable serializable;
                        if (s == 0 && (serializable = response.responseData) != null && (n = ((Integer)serializable).intValue()) == 0) {
                            LibraryListPanel.this.theDDI.nullOutPanel();
                            LibraryListPanel.this.theDDI.getData();
                        }
                    }
                }, gUILibrary.getId());
            }
        }
    }

    public void openElementManager(GUILibrary gUILibrary) {
        ElementManagerManager.getInstance().launchElementManager(gUILibrary, this.getElementManagerHelper());
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void buildtable() {
        Class<?> clazz;
        Class<?> clazz2;
        this.table.setMouseListener(this);
        this.tableModel = new LibraryTableModel(this.theDDI);
        try {
            clazz2 = Class.forName("javax.swing.JLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz2, drillDownRenderer);
        try {
            clazz = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz, new TableCellRenderers.DecimalRenderer(2, ""));
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.table.setSelectionPolicy(0);
        this.table.updateUI();
    }

    public void disableAllButtons() {
        this.launchButton.setEnabled(false);
        this.drivesButton.setEnabled(false);
        this.mediaChangersButton.setEnabled(false);
        this.ioPortsButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.cartridgesButton.setEnabled(false);
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object object) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)object).getIcon();
            this.setIcon(icon);
        }
    }
}

