/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.test;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL0;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL1;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL0;
import org.eclipse.aperi.gui.topo.model.GraphModelFabricL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL0;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.GraphModelOverview;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelStorageL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL2;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL1;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL2;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL1;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2DatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2HBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2LogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk2DiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2PoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Pool;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2SwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2TapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZone2ZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2Zone;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneFabric2ZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneMember;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet;
import org.eclipse.aperi.gui.topo.model.bean.GraphZoneSet2Zone;
import org.eclipse.aperi.gui.topo.test.SampleGraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.JTopoApp;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class SampleTopoDataManager
implements ITopoBackend {
    private ControllerApp controllerApp;
    private BackendData data;
    private LinkedList queue = new LinkedList();
    private Vector mgrV;

    public SampleTopoDataManager() {
        this.data = new BackendData();
        this.mgrV = new Vector();
        int n = 0;
        while (n < 3) {
            BackendMgr backendMgr = new BackendMgr(n);
            this.mgrV.add(backendMgr);
            backendMgr.start();
            ++n;
        }
        TopoSetting topoSetting = new TopoSetting();
        this.controllerApp = new ControllerApp();
        this.controllerApp.setSessionModel(this, topoSetting);
    }

    public ControllerApp getTopoControllerApp() {
        return this.controllerApp;
    }

    public JTopoApp getTopoViewer() {
        return this.controllerApp.getTopoApp();
    }

    private void simulateDataChange_SubsystemStatus() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_SubsystemStatus' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_SubsystemStatus' wake up!");
                    String[] stringArray = new String[]{"subsystem0"};
                    SampleTopoDataManager.this.data.simulateDataChange_SubsystemStatus(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_ComputerStatus() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_ComputerStatus' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_ComputerStatus' wake up!");
                    String[] stringArray = new String[]{"computer0"};
                    SampleTopoDataManager.this.data.simulateDataChange_ComputerStatus(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidFabric() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidFabric' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidFabric' wake up!");
                    String[] stringArray = new String[]{"fabric0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidFabric(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidSwitch() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidSwitch' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidSwitch' wake up!");
                    String[] stringArray = new String[]{"sw0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidSwitch(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidComputer() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidComputer' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidComputer' wake up!");
                    String[] stringArray = new String[]{"computer0", "computer4"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidComputer(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidSubsystem() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidSubsystem' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidSubsystem' wake up!");
                    String[] stringArray = new String[]{"subsystem0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidSubsystem(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidTapeLibrary() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidTapeLibrary' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidTapeLibrary' wake up!");
                    String[] stringArray = new String[]{"tape0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidTapeLibrary(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void simulateDataChange_InvalidOther() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Thread 'simulateDataChange_InvalidOther' sleep!");
                    Thread.sleep(10000L);
                    System.out.println("Thread 'simulateDataChange_InvalidOther' wake up!");
                    String[] stringArray = new String[]{"other0"};
                    SampleTopoDataManager.this.data.simulateDataChange_InvalidOther(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void refreshView(GraphModel.ID iD) {
        GraphDebug.info("SampleTopoDataManager, refreshView, modelID=" + iD);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("cmd", "refresh");
        hashtable.put("modelID", iD);
        this.addJob(hashtable);
    }

    public void refreshAllViews() {
        GraphDebug.info("SampleTopoDataManager, refreshAllViews");
        Vector vector = this.controllerApp.getOpenedViews();
        int n = 0;
        while (n < vector.size()) {
            GraphModel.ID iD = (GraphModel.ID)vector.elementAt(n);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("cmd", "refresh");
            hashtable.put("modelID", iD);
            this.addJob(hashtable);
            ++n;
        }
    }

    public void closeView(GraphModel.ID iD) {
        GraphDebug.info("SampleTopoDataManager, closeView, modelID=" + iD);
    }

    public void removeEntity(Vector vector) {
        GraphDebug.info("SampleTopoDataManager, removeEntity, v=" + vector);
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof GraphEntity.ID) {
                System.out.println("WARNING:, removeEntity is a GraphNode.ID, =" + vector.elementAt(n));
            }
            ++n;
        }
    }

    public void launchElementManager(GraphEntity graphEntity) {
        GraphDebug.info("SampleTopoDataManager, launchElementManager, node=" + graphEntity);
    }

    public void launchDetailsPanel(GraphEntity.ID iD) {
        GraphDebug.info("SampleTopoDataManager, launchDetailsPanel, nodeID=" + iD);
    }

    public void setTimeout(int n) {
        GraphDebug.info("SampleTopoDataManager, setTimeout, new timeout=" + n);
    }

    public void refreshPinList(GraphModel.ID iD) {
        GraphDebug.info("SampleTopoDataManager, refreshPinList");
    }

    public synchronized void addJob(Object object) {
        this.queue.addLast(object);
        this.notifyAll();
    }

    public synchronized Object getJob() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        return this.queue.removeFirst();
    }

    public void persistTopoSettings(TopoSetting topoSetting) {
    }

    private class BackendMgr
    extends Thread {
        private int id;

        public BackendMgr(int n) {
            this.id = n;
            this.setName("BackendMgr-" + n);
        }

        public void run() {
            while (true) {
                Hashtable hashtable = (Hashtable)SampleTopoDataManager.this.getJob();
                this.requestHandler(hashtable);
            }
        }

        private void requestHandler(Hashtable hashtable) {
            String string = (String)hashtable.get("cmd");
            if (string.equals("refresh")) {
                GraphModel.ID iD = (GraphModel.ID)hashtable.get("modelID");
                String string2 = iD.getFocusLevel();
                SampleTopoDataManager.this.controllerApp.startRefreshView(iD);
                int n = 0;
                GraphModel graphModel = null;
                if (string2.equals("Overview")) {
                    graphModel = SampleTopoDataManager.this.data.generateOverview((GraphModelOverview.ID)iD);
                } else if (string2.equals("FabricL0")) {
                    graphModel = SampleTopoDataManager.this.data.generateFabricL0((GraphModelFabricL0.ID)iD);
                } else if (string2.equals("FabricL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateFabricL2((GraphModelFabricL2.ID)iD);
                } else if (string2.equals("ComputerL0")) {
                    graphModel = SampleTopoDataManager.this.data.generateComputerL0((GraphModelComputerL0.ID)iD);
                } else if (string2.equals("ComputerL1")) {
                    graphModel = SampleTopoDataManager.this.data.generateComputerL1((GraphModelComputerL1.ID)iD);
                } else if (string2.equals("ComputerL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateComputerL2((GraphModelComputerL2.ID)iD);
                } else if (string2.equals("SwitchL0")) {
                    graphModel = SampleTopoDataManager.this.data.generateSwitchL0((GraphModelSwitchL0.ID)iD);
                } else if (string2.equals("SwitchL1")) {
                    graphModel = SampleTopoDataManager.this.data.generateSwitchL1((GraphModelSwitchL1.ID)iD);
                } else if (string2.equals("SwitchL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateSwitchL2((GraphModelSwitchL2.ID)iD);
                } else if (string2.equals("StorageL0")) {
                    graphModel = SampleTopoDataManager.this.data.generateStorageL0((GraphModelStorageL0.ID)iD);
                } else if (string2.equals("SubsystemL1")) {
                    graphModel = SampleTopoDataManager.this.data.generateSubsystemL1((GraphModelSubsystemL1.ID)iD);
                } else if (string2.equals("SubsystemL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateSubsystemL2((GraphModelSubsystemL2.ID)iD);
                } else if (string2.equals("TapeLibraryL1")) {
                    graphModel = SampleTopoDataManager.this.data.generateTapeLibraryL1((GraphModelTapeLibraryL1.ID)iD);
                } else if (string2.equals("TapeLibraryL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateTapeLibraryL2((GraphModelTapeLibraryL2.ID)iD);
                } else if (string2.equals("OtherL0")) {
                    graphModel = SampleTopoDataManager.this.data.generateOtherL0((GraphModelOtherL0.ID)iD);
                } else if (string2.equals("OtherL1")) {
                    graphModel = SampleTopoDataManager.this.data.generateOtherL1((GraphModelOtherL1.ID)iD);
                } else if (string2.equals("OtherL2")) {
                    graphModel = SampleTopoDataManager.this.data.generateOtherL2((GraphModelOtherL2.ID)iD);
                } else if (string2.equals("PinList")) {
                    graphModel = SampleTopoDataManager.this.data.generatePinList((GraphModelPinList.ID)iD);
                } else {
                    GraphDebug.error("Warning: SampleTopoDataManager, requestHandler(), invalid modelID=" + iD);
                }
                SampleTopoDataManager.this.controllerApp.updateView(n, graphModel);
                SampleTopoDataManager.this.controllerApp.finishRefreshView(iD);
            } else {
                GraphDebug.error("SampleDataManager, requestHandler, cmd is invalid, cmd=" + string);
            }
        }
    }

    private static class BackendData {
        private SampleGraphModel model = new SampleGraphModel();
        private Vector pinListV = new Vector();

        private int getAbnormalSize(Vector vector) {
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphEntity graphEntity = (GraphEntity)vector.elementAt(n2);
                if (GraphModelUtilities.isAbnormal(graphEntity)) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        private GraphModelOverview generateOverview(GraphModelOverview.ID iD) {
            GraphEntity graphEntity;
            GraphModelOverview graphModelOverview = new GraphModelOverview(iD);
            Vector<Serializable> vector = new Vector<Serializable>();
            Object object = new Vector<GraphEntity>();
            Serializable serializable = this.model.enumerate(GraphFabric.TYPE);
            while (serializable.hasMoreElements()) {
                graphEntity = (GraphFabric)serializable.nextElement();
                vector.add(graphEntity);
                if (((GraphFabric)graphEntity).getIsPhysical().booleanValue()) continue;
                ((Vector)object).add(graphEntity);
            }
            graphEntity = new GraphFabricSummary("FabricSummary");
            graphEntity.setDisplayName("Fabrics");
            ((GraphFabricSummary)graphEntity).setNumOfFabrics(new Integer(vector.size()));
            ((GraphFabricSummary)graphEntity).setNumOfAbnormalFabrics(new Integer(this.getAbnormalSize(vector)));
            ((GraphFabricSummary)graphEntity).setNumOfVirtualFabrics(new Integer(((Vector)object).size()));
            ((GraphFabricSummary)graphEntity).setNumOfAbnormalVirtualFabrics(new Integer(this.getAbnormalSize((Vector)object)));
            graphEntity.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphModelOverview.put(graphEntity);
            vector = new Vector();
            object = this.model.enumerate(GraphComputer.TYPE);
            while (object.hasMoreElements()) {
                serializable = (GraphComputer)object.nextElement();
                vector.add(serializable);
            }
            serializable = new GraphComputerSummary("ComputerSummary");
            ((GraphEntity)serializable).setDisplayName("Computers");
            ((GraphComputerSummary)serializable).setNumOfComputers(new Integer(vector.size()));
            ((GraphComputerSummary)serializable).setNumOfAbnormalComputers(new Integer(this.getAbnormalSize(vector)));
            ((GraphEntity)serializable).setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphModelOverview.put((GraphEntity)serializable);
            vector = new Vector();
            object = this.model.enumerate(GraphSwitch.TYPE);
            while (object.hasMoreElements()) {
                serializable = (GraphSwitch)object.nextElement();
                vector.add(serializable);
            }
            serializable = new GraphSwitchSummary("SwitchSummary");
            ((GraphEntity)serializable).setDisplayName("Switches");
            ((GraphSwitchSummary)serializable).setNumOfSwitches(new Integer(vector.size()));
            ((GraphSwitchSummary)serializable).setNumOfAbnormalSwitches(new Integer(this.getAbnormalSize(vector)));
            ((GraphEntity)serializable).setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphModelOverview.put((GraphEntity)serializable);
            vector = new Vector();
            object = this.model.enumerate(GraphSubsystem.TYPE);
            while (object.hasMoreElements()) {
                serializable = (GraphSubsystem)object.nextElement();
                vector.add(serializable);
            }
            serializable = new Vector();
            object = this.model.enumerate(GraphTapeLibrary.TYPE);
            while (object.hasMoreElements()) {
                graphEntity = (GraphTapeLibrary)object.nextElement();
                ((Vector)serializable).add(graphEntity);
            }
            graphEntity = new GraphStorageSummary("StorageSummary");
            graphEntity.setDisplayName("Storage");
            ((GraphStorageSummary)graphEntity).setNumOfSubsystems(new Integer(vector.size()));
            ((GraphStorageSummary)graphEntity).setNumOfAbnormalSubsystems(new Integer(this.getAbnormalSize(vector)));
            ((GraphStorageSummary)graphEntity).setNumOfTapeLibraries(new Integer(((Vector)serializable).size()));
            ((GraphStorageSummary)graphEntity).setNumOfAbnormalTapeLibraries(new Integer(this.getAbnormalSize((Vector)serializable)));
            graphEntity.setHealthStatus(GraphModelUtilities.aggregateStatus(GraphModelUtilities.aggregateHealthStatus(vector), GraphModelUtilities.aggregateHealthStatus((Vector)serializable)));
            graphModelOverview.put(graphEntity);
            vector = new Vector();
            object = this.model.enumerate(GraphOther.TYPE);
            while (object.hasMoreElements()) {
                serializable = (GraphOther)object.nextElement();
                vector.add(serializable);
            }
            serializable = new GraphOtherSummary("Others");
            ((GraphEntity)serializable).setDisplayName("Other");
            ((GraphOtherSummary)serializable).setNumOfOthers(new Integer(vector.size()));
            ((GraphOtherSummary)serializable).setNumOfAbnormalOthers(new Integer(this.getAbnormalSize(vector)));
            ((GraphEntity)serializable).setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphModelOverview.put((GraphEntity)serializable);
            return graphModelOverview;
        }

        private GraphModelFabricL0 generateFabricL0(GraphModelFabricL0.ID iD) {
            GraphEntity graphEntity;
            GraphModelFabricL0 graphModelFabricL0 = new GraphModelFabricL0(iD);
            Enumeration enumeration = this.model.enumerate(GraphFabric.TYPE);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphFabric)enumeration.nextElement();
                graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                graphModelFabricL0.put(graphEntity);
            }
            enumeration = this.model.enumerate(GraphFabric2VirtualFabric.TYPE);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphFabric2VirtualFabric)enumeration.nextElement();
                graphEntity = (GraphFabric2VirtualFabric)((GraphFabric2VirtualFabric)graphEntity).clone();
                graphModelFabricL0.put(graphEntity);
            }
            return graphModelFabricL0;
        }

        private GraphModelFabricL2 generateFabricL2(GraphModelFabricL2.ID iD) {
            Comparable comparable;
            Object object;
            HashSet<GraphOther.ID> hashSet;
            HashSet<GraphTapeLibrary.ID> hashSet2;
            HashSet<GraphSubsystem.ID> hashSet3;
            HashSet<GraphSwitch.ID> hashSet4;
            GraphEntity.ID iD2 = iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            GraphModelFabricL2 graphModelFabricL2 = new GraphModelFabricL2(iD);
            graphModelFabricL2.setWithZoneData(bl);
            Serializable serializable = (GraphFabric)this.model.get(iD2);
            if (serializable == null) {
                return graphModelFabricL2;
            }
            serializable = (GraphFabric)((GraphFabric)serializable).clone();
            graphModelFabricL2.put((GraphEntity)serializable);
            if (bl) {
                hashSet4 = (GraphFabric.ID)((GraphEntity)serializable).getEntityID();
                this.addZones_L1Fabric(this.model, graphModelFabricL2, (GraphFabric.ID)((Object)hashSet4));
            }
            serializable = new HashSet();
            hashSet4 = this.model.reference(GraphFabric2Switch.TYPE, iD2);
            while (hashSet4.hasMoreElements()) {
                hashSet3 = (GraphFabric2Switch)hashSet4.nextElement();
                hashSet3 = (GraphFabric2Switch)((GraphFabric2Switch)((Object)hashSet3)).clone();
                graphModelFabricL2.put((GraphEntity)((Object)hashSet3));
            }
            hashSet3 = this.model.associator(GraphFabric2Switch.TYPE, iD2);
            while (hashSet3.hasMoreElements()) {
                hashSet2 = (GraphSwitch)hashSet3.nextElement();
                hashSet2 = (GraphSwitch)((GraphSwitch)((Object)hashSet2)).clone();
                hashSet = (GraphSwitch.ID)((GraphEntity)((Object)hashSet2)).getEntityID();
                graphModelFabricL2.put((GraphEntity)((Object)hashSet2));
                ((HashSet)serializable).add(hashSet);
            }
            hashSet4 = new HashSet<GraphSwitch.ID>();
            hashSet3 = this.model.associator(GraphFabric2Computer.TYPE, iD2);
            while (hashSet3.hasMoreElements()) {
                hashSet2 = (GraphComputer)hashSet3.nextElement();
                hashSet2 = (GraphComputer)((GraphComputer)((Object)hashSet2)).clone();
                hashSet = (GraphComputer.ID)((GraphEntity)((Object)hashSet2)).getEntityID();
                graphModelFabricL2.put((GraphEntity)((Object)hashSet2));
                hashSet4.add((GraphSwitch.ID)((Object)hashSet));
            }
            hashSet3 = new HashSet<GraphSubsystem.ID>();
            hashSet2 = this.model.associator(GraphFabric2Subsystem.TYPE, iD2);
            while (hashSet2.hasMoreElements()) {
                hashSet = (GraphSubsystem)hashSet2.nextElement();
                hashSet = (GraphSubsystem)((GraphSubsystem)((Object)hashSet)).clone();
                object = (GraphSubsystem.ID)((GraphEntity)((Object)hashSet)).getEntityID();
                graphModelFabricL2.put((GraphEntity)((Object)hashSet));
                hashSet3.add((GraphSubsystem.ID)object);
            }
            hashSet2 = new HashSet<GraphTapeLibrary.ID>();
            hashSet = this.model.associator(GraphFabric2TapeLibrary.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                object = (GraphTapeLibrary)hashSet.nextElement();
                object = (GraphTapeLibrary)((GraphTapeLibrary)object).clone();
                comparable = (GraphTapeLibrary.ID)((GraphEntity)object).getEntityID();
                graphModelFabricL2.put((GraphEntity)object);
                hashSet2.add((GraphTapeLibrary.ID)comparable);
            }
            hashSet = new HashSet<GraphOther.ID>();
            object = this.model.associator(GraphFabric2Other.TYPE, iD2);
            while (object.hasMoreElements()) {
                comparable = (GraphOther)object.nextElement();
                comparable = (GraphOther)((GraphOther)comparable).clone();
                GraphOther.ID iD3 = (GraphOther.ID)((GraphEntity)comparable).getEntityID();
                graphModelFabricL2.put((GraphEntity)comparable);
                hashSet.add(iD3);
            }
            object = this.model.enumerate(GraphSwitch2Switch.TYPE);
            while (object.hasMoreElements()) {
                comparable = (GraphSwitch2Switch)object.nextElement();
                if (!((HashSet)serializable).contains(((GraphSwitch2Switch)(comparable = (GraphSwitch2Switch)((GraphSwitch2Switch)comparable).clone())).getSwitch1ID()) || !((HashSet)serializable).contains(((GraphSwitch2Switch)comparable).getSwitch2ID())) continue;
                graphModelFabricL2.put((GraphEntity)comparable);
            }
            object = this.model.enumerate(GraphSwitch2Computer.TYPE);
            while (object.hasMoreElements()) {
                comparable = (GraphSwitch2Computer)object.nextElement();
                if (!((HashSet)serializable).contains(((GraphSwitch2Computer)(comparable = (GraphSwitch2Computer)((GraphSwitch2Computer)comparable).clone())).getSwitchID()) || !hashSet4.contains(((GraphSwitch2Computer)comparable).getComputerID())) continue;
                graphModelFabricL2.put((GraphEntity)comparable);
            }
            object = this.model.enumerate(GraphSwitch2Subsystem.TYPE);
            while (object.hasMoreElements()) {
                comparable = (GraphSwitch2Subsystem)object.nextElement();
                if (!((HashSet)serializable).contains(((GraphSwitch2Subsystem)(comparable = (GraphSwitch2Subsystem)((GraphSwitch2Subsystem)comparable).clone())).getSwitchID()) || !hashSet3.contains(((GraphSwitch2Subsystem)comparable).getSubsystemID())) continue;
                graphModelFabricL2.put((GraphEntity)comparable);
            }
            object = this.model.enumerate(GraphSwitch2TapeLibrary.TYPE);
            while (object.hasMoreElements()) {
                comparable = (GraphSwitch2TapeLibrary)object.nextElement();
                if (!((HashSet)serializable).contains(((GraphSwitch2TapeLibrary)(comparable = (GraphSwitch2TapeLibrary)((GraphSwitch2TapeLibrary)comparable).clone())).getSwitchID()) || !hashSet2.contains(((GraphSwitch2TapeLibrary)comparable).getTapeLibraryID())) continue;
                graphModelFabricL2.put((GraphEntity)comparable);
            }
            object = this.model.enumerate(GraphSwitch2Other.TYPE);
            while (object.hasMoreElements()) {
                comparable = (GraphSwitch2Other)object.nextElement();
                if (!((HashSet)serializable).contains(((GraphSwitch2Other)(comparable = (GraphSwitch2Other)((GraphSwitch2Other)comparable).clone())).getSwitchID()) || !hashSet.contains(((GraphSwitch2Other)comparable).getOtherID())) continue;
                graphModelFabricL2.put((GraphEntity)comparable);
            }
            return graphModelFabricL2;
        }

        private GraphModelComputerL0 generateComputerL0(GraphModelComputerL0.ID iD) {
            GraphModelComputerL0 graphModelComputerL0 = new GraphModelComputerL0(iD);
            Enumeration enumeration = this.model.enumerate(GraphComputer.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphComputer graphComputer = (GraphComputer)enumeration.nextElement();
                graphComputer = (GraphComputer)graphComputer.clone();
                GraphComputer.ID cfr_ignored_0 = (GraphComputer.ID)graphComputer.getEntityID();
                graphModelComputerL0.put(graphComputer);
            }
            return graphModelComputerL0;
        }

        private GraphModelComputerL1 generateComputerL1(GraphModelComputerL1.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            Vector vector = iD.getChildFocusEntityIDs();
            GraphModelComputerL1 graphModelComputerL1 = new GraphModelComputerL1(iD);
            Vector<GraphComputer.ID> vector2 = new Vector<GraphComputer.ID>();
            int n = 0;
            while (n < vector.size()) {
                object2 = (GraphComputer.ID)vector.elementAt(n);
                object = (GraphComputer)this.model.get((GraphEntity.ID)object2);
                if (object != null) {
                    object = (GraphComputer)((GraphComputer)object).clone();
                    graphModelComputerL1.put((GraphEntity)object);
                    vector2.add((GraphComputer.ID)object2);
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return graphModelComputerL1;
            }
            if (bl) {
                this.addZones_L1(this.model, graphModelComputerL1, vector2);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphComputer.ID iD2 = (GraphComputer.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2Computer.TYPE, iD2);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Computer)object2.nextElement();
                    object = (GraphSwitch2Computer)((GraphSwitch2Computer)object).clone();
                    graphModelComputerL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Computer.TYPE, iD2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    graphEntity = (GraphSwitch)((GraphSwitch)graphEntity).clone();
                    GraphSwitch.ID cfr_ignored_0 = (GraphSwitch.ID)graphEntity.getEntityID();
                    graphModelComputerL1.put(graphEntity);
                }
                ++n2;
            }
            Enumeration enumeration = graphModelComputerL1.enumerateID(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphSwitch.ID iD3 = (GraphSwitch.ID)enumeration.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, iD3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelComputerL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelComputerL1.put(graphEntity);
                }
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                GraphComputer.ID iD4 = (GraphComputer.ID)vector.elementAt(n3);
                object2 = this.model.reference(GraphComputer2Volume.TYPE, iD4);
                while (object2.hasMoreElements()) {
                    object = (GraphComputer2Volume)object2.nextElement();
                    object = (GraphComputer2Volume)((GraphComputer2Volume)object).clone();
                    graphModelComputerL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphComputer2Volume.TYPE, iD4);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphVolume)object.nextElement();
                    graphEntity = (GraphVolume)((GraphVolume)graphEntity).clone();
                    graphModelComputerL1.put(graphEntity);
                }
                ++n3;
            }
            Enumeration enumeration2 = graphModelComputerL1.enumerateID(GraphVolume.TYPE);
            while (enumeration2.hasMoreElements()) {
                GraphVolume.ID iD5 = (GraphVolume.ID)enumeration2.nextElement();
                object2 = this.model.reference(GraphSubsystem2Volume.TYPE, iD5);
                while (object2.hasMoreElements()) {
                    object = (GraphSubsystem2Volume)object2.nextElement();
                    object = (GraphSubsystem2Volume)((GraphSubsystem2Volume)object).clone();
                    graphModelComputerL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSubsystem2Volume.TYPE, iD5);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSubsystem)object.nextElement();
                    graphEntity = (GraphSubsystem)((GraphSubsystem)graphEntity).clone();
                    graphModelComputerL1.put(graphEntity);
                }
            }
            graphModelComputerL1.setWithZoneData(bl);
            return graphModelComputerL1;
        }

        private GraphModelComputerL2 generateComputerL2(GraphModelComputerL2.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            Comparable comparable;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            HashSet<Comparable> hashSet;
            GraphEntity.ID iD2 = iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            GraphModelComputerL2 graphModelComputerL2 = new GraphModelComputerL2(iD);
            graphModelComputerL2.setWithZoneData(bl);
            HashSet<GraphFCPort> hashSet2 = (GraphComputer)this.model.get(iD2);
            if (hashSet2 == null) {
                return graphModelComputerL2;
            }
            hashSet2 = (GraphComputer)((GraphComputer)((Object)hashSet2)).clone();
            graphModelComputerL2.put((GraphEntity)((Object)hashSet2));
            if (bl) {
                hashSet = (GraphComputer.ID)((GraphEntity)((Object)hashSet2)).getEntityID();
                this.addZones_L2(this.model, graphModelComputerL2, (GraphEntity.ID)((Object)hashSet));
            }
            hashSet2 = this.model.reference(GraphComputer2FCPort.TYPE, iD2);
            while (hashSet2.hasMoreElements()) {
                hashSet = (GraphComputer2FCPort)hashSet2.nextElement();
                hashSet = (GraphComputer2FCPort)((GraphComputer2FCPort)((Object)hashSet)).clone();
                graphModelComputerL2.put((GraphEntity)((Object)hashSet));
            }
            hashSet = this.model.associator(GraphComputer2FCPort.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                object8 = (GraphFCPort)hashSet.nextElement();
                GraphFCPort.ID cfr_ignored_0 = (GraphFCPort.ID)((GraphEntity)object8).getEntityID();
                object8 = (GraphFCPort)((GraphFCPort)object8).clone();
                graphModelComputerL2.put((GraphEntity)object8);
            }
            hashSet2 = this.model.reference(GraphComputer2HBA.TYPE, iD2);
            while (hashSet2.hasMoreElements()) {
                hashSet = (GraphComputer2HBA)hashSet2.nextElement();
                hashSet = (GraphComputer2HBA)((GraphComputer2HBA)((Object)hashSet)).clone();
                graphModelComputerL2.put((GraphEntity)((Object)hashSet));
            }
            hashSet = this.model.associator(GraphComputer2HBA.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                object8 = (GraphHBA)hashSet.nextElement();
                object7 = (GraphHBA.ID)((GraphEntity)object8).getEntityID();
                object8 = (GraphHBA)((GraphHBA)object8).clone();
                graphModelComputerL2.put((GraphEntity)object8);
                object6 = this.model.reference(GraphHBA2FCPort.TYPE, (GraphEntity.ID)object7);
                while (object6.hasMoreElements()) {
                    object5 = (GraphHBA2FCPort)object6.nextElement();
                    object5 = (GraphHBA2FCPort)((GraphHBA2FCPort)object5).clone();
                    graphModelComputerL2.put((GraphEntity)object5);
                }
            }
            hashSet2 = new HashSet<GraphFCPort>();
            hashSet = new HashSet<Comparable>();
            object8 = graphModelComputerL2.enumerateID(GraphFCPort.TYPE);
            while (object8.hasMoreElements()) {
                object7 = (GraphFCPort.ID)object8.nextElement();
                object6 = this.model.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object7);
                while (object6.hasMoreElements()) {
                    object5 = (GraphFCPort2FCPort)object6.nextElement();
                    object5 = (GraphFCPort2FCPort)((GraphFCPort2FCPort)object5).clone();
                    graphModelComputerL2.put((GraphEntity)object5);
                }
                object5 = this.model.associator(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object7);
                while (object5.hasMoreElements()) {
                    object4 = (GraphFCPort)object5.nextElement();
                    object4 = (GraphFCPort)((GraphFCPort)object4).clone();
                    hashSet2.add((GraphFCPort)object4);
                }
            }
            object7 = hashSet2.iterator();
            while (object7.hasNext()) {
                object6 = (GraphFCPort)object7.next();
                graphModelComputerL2.put((GraphEntity)object6);
                object5 = (GraphFCPort.ID)((GraphEntity)object6).getEntityID();
                hashSet.add((Comparable)object5);
            }
            object8 = this.model.associator(GraphSwitch2Computer.TYPE, iD2);
            while (object8.hasMoreElements()) {
                object7 = (GraphSwitch)object8.nextElement();
                object7 = (GraphSwitch)((GraphSwitch)object7).clone();
                object6 = (GraphSwitch.ID)((GraphEntity)object7).getEntityID();
                graphModelComputerL2.put((GraphEntity)object7);
                object5 = this.model.reference(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object6);
                while (object5.hasMoreElements()) {
                    object4 = (GraphSwitch2FCPort)object5.nextElement();
                    object3 = ((GraphSwitch2FCPort)(object4 = (GraphSwitch2FCPort)((GraphSwitch2FCPort)object4).clone())).getFCPortID();
                    if (!hashSet.contains(object3)) continue;
                    graphModelComputerL2.put((GraphEntity)object4);
                }
            }
            object8 = graphModelComputerL2.enumerateID(GraphSwitch.TYPE);
            while (object8.hasMoreElements()) {
                object7 = (GraphSwitch.ID)object8.nextElement();
                object6 = this.model.reference(GraphFabric2Switch.TYPE, (GraphEntity.ID)object7);
                while (object6.hasMoreElements()) {
                    object5 = (GraphFabric2Switch)object6.nextElement();
                    object5 = (GraphFabric2Switch)((GraphFabric2Switch)object5).clone();
                    graphModelComputerL2.put((GraphEntity)object5);
                }
                object5 = this.model.associator(GraphFabric2Switch.TYPE, (GraphEntity.ID)object7);
                while (object5.hasMoreElements()) {
                    object4 = (GraphFabric)object5.nextElement();
                    object4 = (GraphFabric)((GraphFabric)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
            }
            object8 = this.model.reference(GraphComputer2Lun.TYPE, iD2);
            while (object8.hasMoreElements()) {
                object7 = (GraphComputer2Lun)object8.nextElement();
                object7 = (GraphComputer2Lun)((GraphComputer2Lun)object7).clone();
                graphModelComputerL2.put((GraphEntity)object7);
            }
            object7 = this.model.associator(GraphComputer2Lun.TYPE, iD2);
            while (object7.hasMoreElements()) {
                object6 = (GraphLun)object7.nextElement();
                object6 = (GraphLun)((GraphLun)object6).clone();
                graphModelComputerL2.put((GraphEntity)object6);
            }
            object8 = graphModelComputerL2.enumerateID(GraphLun.TYPE);
            while (object8.hasMoreElements()) {
                object7 = (GraphLun.ID)object8.nextElement();
                object6 = this.model.reference(GraphVolume2Lun.TYPE, (GraphEntity.ID)object7);
                while (object6.hasMoreElements()) {
                    object5 = (GraphVolume2Lun)object6.nextElement();
                    object5 = (GraphVolume2Lun)((GraphVolume2Lun)object5).clone();
                    graphModelComputerL2.put((GraphEntity)object5);
                }
                object5 = this.model.associator(GraphVolume2Lun.TYPE, (GraphEntity.ID)object7);
                while (object5.hasMoreElements()) {
                    object4 = (GraphVolume)object5.nextElement();
                    object4 = (GraphVolume)((GraphVolume)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
            }
            object8 = graphModelComputerL2.enumerateID(GraphVolume.TYPE);
            while (object8.hasMoreElements()) {
                object7 = (GraphVolume.ID)object8.nextElement();
                object6 = this.model.reference(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object7);
                while (object6.hasMoreElements()) {
                    object5 = (GraphSubsystem2Volume)object6.nextElement();
                    object5 = (GraphSubsystem2Volume)((GraphSubsystem2Volume)object5).clone();
                    graphModelComputerL2.put((GraphEntity)object5);
                }
                object5 = this.model.associator(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object7);
                while (object5.hasMoreElements()) {
                    object4 = (GraphSubsystem)object5.nextElement();
                    object4 = (GraphSubsystem)((GraphSubsystem)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
            }
            object8 = this.model.associator(GraphComputer2LogicalVolumeManager.TYPE, iD2);
            while (object8.hasMoreElements()) {
                object7 = (GraphLogicalVolumeManager)object8.nextElement();
                object6 = (GraphLogicalVolumeManager.ID)((GraphEntity)object7).getEntityID();
                object7 = (GraphLogicalVolumeManager)((GraphLogicalVolumeManager)object7).clone();
                graphModelComputerL2.put((GraphEntity)object7);
                object5 = this.model.reference(GraphLogicalVolumeManager2Lun.TYPE, (GraphEntity.ID)object6);
                while (object5.hasMoreElements()) {
                    object4 = (GraphLogicalVolumeManager2Lun)object5.nextElement();
                    object4 = (GraphLogicalVolumeManager2Lun)((GraphLogicalVolumeManager2Lun)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
                object4 = this.model.reference(GraphLogicalVolumeManager2LogicalVolume.TYPE, (GraphEntity.ID)object6);
                while (object4.hasMoreElements()) {
                    object3 = (GraphLogicalVolumeManager2LogicalVolume)object4.nextElement();
                    object3 = (GraphLogicalVolumeManager2LogicalVolume)((GraphLogicalVolumeManager2LogicalVolume)object3).clone();
                    graphModelComputerL2.put((GraphEntity)object3);
                }
                object3 = this.model.associator(GraphLogicalVolumeManager2LogicalVolume.TYPE, (GraphEntity.ID)object6);
                while (object3.hasMoreElements()) {
                    comparable = (GraphLogicalVolume)object3.nextElement();
                    object2 = (GraphLogicalVolume.ID)comparable.getEntityID();
                    comparable = (GraphLogicalVolume)comparable.clone();
                    graphModelComputerL2.put((GraphEntity)comparable);
                    object = this.model.reference(GraphLogicalVolume2Lun.TYPE, (GraphEntity.ID)object2);
                    while (object.hasMoreElements()) {
                        graphEntity = (GraphLogicalVolume2Lun)object.nextElement();
                        graphEntity = (GraphLogicalVolume2Lun)((GraphLogicalVolume2Lun)graphEntity).clone();
                        graphModelComputerL2.put(graphEntity);
                    }
                }
            }
            object8 = this.model.associator(GraphComputer2Filesystem.TYPE, iD2);
            while (object8.hasMoreElements()) {
                object7 = (GraphFilesystem)object8.nextElement();
                object6 = (GraphFilesystem.ID)((GraphEntity)object7).getEntityID();
                object7 = (GraphFilesystem)((GraphFilesystem)object7).clone();
                graphModelComputerL2.put((GraphEntity)object7);
                object5 = this.model.reference(GraphFilesystem2Lun.TYPE, (GraphEntity.ID)object6);
                while (object5.hasMoreElements()) {
                    object4 = (GraphFilesystem2Lun)object5.nextElement();
                    object4 = (GraphFilesystem2Lun)((GraphFilesystem2Lun)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
                object4 = this.model.reference(GraphFilesystem2LogicalVolume.TYPE, (GraphEntity.ID)object6);
                while (object4.hasMoreElements()) {
                    object3 = (GraphFilesystem2LogicalVolume)object4.nextElement();
                    object3 = (GraphFilesystem2LogicalVolume)((GraphFilesystem2LogicalVolume)object3).clone();
                    graphModelComputerL2.put((GraphEntity)object3);
                }
            }
            object8 = this.model.associator(GraphComputer2DatabaseGroup.TYPE, iD2);
            while (object8.hasMoreElements()) {
                object7 = (GraphDatabaseGroup)object8.nextElement();
                object6 = (GraphDatabaseGroup.ID)((GraphEntity)object7).getEntityID();
                object7 = (GraphDatabaseGroup)((GraphDatabaseGroup)object7).clone();
                graphModelComputerL2.put((GraphEntity)object7);
                object5 = this.model.reference(GraphDatabaseGroup2Database.TYPE, (GraphEntity.ID)object6);
                while (object5.hasMoreElements()) {
                    object4 = (GraphDatabaseGroup2Database)object5.nextElement();
                    object4 = (GraphDatabaseGroup2Database)((GraphDatabaseGroup2Database)object4).clone();
                    graphModelComputerL2.put((GraphEntity)object4);
                }
                object4 = this.model.associator(GraphDatabaseGroup2Database.TYPE, (GraphEntity.ID)object6);
                while (object4.hasMoreElements()) {
                    object3 = (GraphDatabase)object4.nextElement();
                    comparable = (GraphDatabase.ID)((GraphEntity)object3).getEntityID();
                    object3 = (GraphDatabase)((GraphDatabase)object3).clone();
                    graphModelComputerL2.put((GraphEntity)object3);
                    object2 = this.model.reference(GraphDatabase2TableSpace.TYPE, (GraphEntity.ID)comparable);
                    while (object2.hasMoreElements()) {
                        object = (GraphDatabase2TableSpace)object2.nextElement();
                        object = (GraphDatabase2TableSpace)((GraphDatabase2TableSpace)object).clone();
                        graphModelComputerL2.put((GraphEntity)object);
                    }
                    object = this.model.associator(GraphDatabase2TableSpace.TYPE, (GraphEntity.ID)comparable);
                    while (object.hasMoreElements()) {
                        Object object9;
                        Object object10;
                        graphEntity = (GraphTableSpace)object.nextElement();
                        GraphTableSpace.ID iD3 = (GraphTableSpace.ID)graphEntity.getEntityID();
                        graphEntity = (GraphTableSpace)((GraphTableSpace)graphEntity).clone();
                        graphModelComputerL2.put(graphEntity);
                        Enumeration enumeration = this.model.reference(GraphTableSpace2Filesystem.TYPE, iD3);
                        while (enumeration.hasMoreElements()) {
                            object10 = (GraphTableSpace2Filesystem)enumeration.nextElement();
                            object10 = (GraphTableSpace2Filesystem)((GraphTableSpace2Filesystem)object10).clone();
                            graphModelComputerL2.put((GraphEntity)object10);
                        }
                        object10 = this.model.reference(GraphTableSpace2LogicalVolume.TYPE, iD3);
                        while (object10.hasMoreElements()) {
                            object9 = (GraphTableSpace2LogicalVolume)object10.nextElement();
                            object9 = (GraphTableSpace2LogicalVolume)((GraphTableSpace2LogicalVolume)object9).clone();
                            graphModelComputerL2.put((GraphEntity)object9);
                        }
                        object9 = this.model.reference(GraphTableSpace2Lun.TYPE, iD3);
                        while (object9.hasMoreElements()) {
                            GraphTableSpace2Lun graphTableSpace2Lun = (GraphTableSpace2Lun)object9.nextElement();
                            graphTableSpace2Lun = (GraphTableSpace2Lun)graphTableSpace2Lun.clone();
                            graphModelComputerL2.put(graphTableSpace2Lun);
                        }
                    }
                }
            }
            return graphModelComputerL2;
        }

        private GraphModelSwitchL0 generateSwitchL0(GraphModelSwitchL0.ID iD) {
            GraphModelSwitchL0 graphModelSwitchL0 = new GraphModelSwitchL0(iD);
            Enumeration enumeration = this.model.enumerate(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                Object object;
                GraphSwitch graphSwitch = (GraphSwitch)enumeration.nextElement();
                graphSwitch = (GraphSwitch)graphSwitch.clone();
                GraphSwitch.ID iD2 = (GraphSwitch.ID)graphSwitch.getEntityID();
                graphModelSwitchL0.put(graphSwitch);
                Enumeration enumeration2 = this.model.reference(GraphFabric2Switch.TYPE, iD2);
                while (enumeration2.hasMoreElements()) {
                    object = (GraphFabric2Switch)enumeration2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelSwitchL0.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD2);
                while (object.hasMoreElements()) {
                    GraphFabric graphFabric = (GraphFabric)object.nextElement();
                    graphFabric = (GraphFabric)graphFabric.clone();
                    graphModelSwitchL0.put(graphFabric);
                }
            }
            return graphModelSwitchL0;
        }

        private GraphModelSwitchL1 generateSwitchL1(GraphModelSwitchL1.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            Vector vector = iD.getChildFocusEntityIDs();
            GraphModelSwitchL1 graphModelSwitchL1 = new GraphModelSwitchL1(iD);
            Vector<GraphSwitch.ID> vector2 = new Vector<GraphSwitch.ID>();
            int n = 0;
            while (n < vector.size()) {
                object2 = (GraphSwitch.ID)vector.elementAt(n);
                object = (GraphSwitch)this.model.get((GraphEntity.ID)object2);
                if (object != null) {
                    object = (GraphSwitch)((GraphSwitch)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                    vector2.add((GraphSwitch.ID)object2);
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return graphModelSwitchL1;
            }
            if (bl) {
                this.addZones_L1(this.model, graphModelSwitchL1, vector2);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphSwitch.ID iD2 = (GraphSwitch.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2Computer.TYPE, iD2);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Computer)object2.nextElement();
                    object = (GraphSwitch2Computer)((GraphSwitch2Computer)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Computer.TYPE, iD2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphComputer)object.nextElement();
                    graphEntity = (GraphComputer)((GraphComputer)graphEntity).clone();
                    GraphComputer.ID cfr_ignored_0 = (GraphComputer.ID)graphEntity.getEntityID();
                    graphModelSwitchL1.put(graphEntity);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < vector.size()) {
                GraphSwitch.ID iD3 = (GraphSwitch.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2Switch.TYPE, iD3);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Switch)object2.nextElement();
                    object = (GraphSwitch2Switch)((GraphSwitch2Switch)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Switch.TYPE, iD3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    graphEntity = (GraphSwitch)((GraphSwitch)graphEntity).clone();
                    GraphSwitch.ID cfr_ignored_1 = (GraphSwitch.ID)graphEntity.getEntityID();
                    graphModelSwitchL1.put(graphEntity);
                }
                ++n2;
            }
            Enumeration enumeration = graphModelSwitchL1.enumerateID(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphSwitch.ID iD4 = (GraphSwitch.ID)enumeration.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, iD4);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD4);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelSwitchL1.put(graphEntity);
                }
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                GraphSwitch.ID iD5 = (GraphSwitch.ID)vector.elementAt(n3);
                object2 = this.model.reference(GraphSwitch2Subsystem.TYPE, iD5);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Subsystem)object2.nextElement();
                    object = (GraphSwitch2Subsystem)((GraphSwitch2Subsystem)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Subsystem.TYPE, iD5);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSubsystem)object.nextElement();
                    graphEntity = (GraphSubsystem)((GraphSubsystem)graphEntity).clone();
                    GraphSubsystem.ID cfr_ignored_2 = (GraphSubsystem.ID)graphEntity.getEntityID();
                    graphModelSwitchL1.put(graphEntity);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < vector.size()) {
                GraphSwitch.ID iD6 = (GraphSwitch.ID)vector.elementAt(n3);
                object2 = this.model.reference(GraphSwitch2TapeLibrary.TYPE, iD6);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2TapeLibrary)object2.nextElement();
                    object = (GraphSwitch2TapeLibrary)((GraphSwitch2TapeLibrary)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2TapeLibrary.TYPE, iD6);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphTapeLibrary)object.nextElement();
                    graphEntity = (GraphTapeLibrary)((GraphTapeLibrary)graphEntity).clone();
                    GraphTapeLibrary.ID cfr_ignored_3 = (GraphTapeLibrary.ID)graphEntity.getEntityID();
                    graphModelSwitchL1.put(graphEntity);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < vector.size()) {
                GraphSwitch.ID iD7 = (GraphSwitch.ID)vector.elementAt(n3);
                object2 = this.model.reference(GraphSwitch2Other.TYPE, iD7);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Other)object2.nextElement();
                    object = (GraphSwitch2Other)((GraphSwitch2Other)object).clone();
                    graphModelSwitchL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Other.TYPE, iD7);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphOther)object.nextElement();
                    graphEntity = (GraphOther)((GraphOther)graphEntity).clone();
                    GraphOther.ID cfr_ignored_4 = (GraphOther.ID)graphEntity.getEntityID();
                    graphModelSwitchL1.put(graphEntity);
                }
                ++n3;
            }
            graphModelSwitchL1.setWithZoneData(bl);
            return graphModelSwitchL1;
        }

        private GraphModelSwitchL2 generateSwitchL2(GraphModelSwitchL2.ID iD) {
            GraphFCPort.ID iD2;
            GraphEntity graphEntity;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            GraphEntity.ID iD3 = iD.getFocusEntityID();
            boolean bl = iD.isNeedPerfData();
            boolean bl2 = iD.isNeedZoneData();
            GraphModelSwitchL2 graphModelSwitchL2 = new GraphModelSwitchL2(iD);
            graphModelSwitchL2.setWithZoneData(bl2);
            HashSet<GraphFCPort> hashSet = (GraphSwitch)this.model.get(iD3);
            if (hashSet == null) {
                return graphModelSwitchL2;
            }
            hashSet = (GraphSwitch)((GraphSwitch)((Object)hashSet)).clone();
            graphModelSwitchL2.put((GraphEntity)((Object)hashSet));
            if (bl2) {
                serializable = (GraphSwitch.ID)((GraphEntity)((Object)hashSet)).getEntityID();
                this.addZones_L2(this.model, graphModelSwitchL2, (GraphEntity.ID)serializable);
            }
            if (bl) {
                hashSet = this.model.reference(GraphSwitch2SwitchPerf.TYPE, iD3);
                while (hashSet.hasMoreElements()) {
                    serializable = (GraphSwitch2SwitchPerf)hashSet.nextElement();
                    serializable = (GraphSwitch2SwitchPerf)((GraphSwitch2SwitchPerf)serializable).clone();
                    graphModelSwitchL2.put((GraphEntity)serializable);
                }
                serializable = this.model.associator(GraphSwitch2SwitchPerf.TYPE, iD3);
                while (serializable.hasMoreElements()) {
                    object4 = (GraphSwitchPerf)serializable.nextElement();
                    object4 = (GraphSwitchPerf)((GraphSwitchPerf)object4).clone();
                    graphModelSwitchL2.put((GraphEntity)object4);
                }
            }
            hashSet = this.model.reference(GraphSwitch2FCPort.TYPE, iD3);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphSwitch2FCPort)hashSet.nextElement();
                serializable = (GraphSwitch2FCPort)((GraphSwitch2FCPort)serializable).clone();
                graphModelSwitchL2.put((GraphEntity)serializable);
            }
            serializable = this.model.associator(GraphSwitch2FCPort.TYPE, iD3);
            while (serializable.hasMoreElements()) {
                object4 = (GraphFCPort)serializable.nextElement();
                object4 = (GraphFCPort)((GraphFCPort)object4).clone();
                GraphFCPort.ID cfr_ignored_0 = (GraphFCPort.ID)((GraphEntity)object4).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object4);
            }
            if (bl) {
                hashSet = graphModelSwitchL2.enumerateID(GraphFCPort.TYPE);
                while (hashSet.hasMoreElements()) {
                    serializable = (GraphFCPort.ID)hashSet.nextElement();
                    object4 = this.model.reference(GraphFCPort2SwitchFCPortPerf.TYPE, (GraphEntity.ID)serializable);
                    while (object4.hasMoreElements()) {
                        object3 = (GraphFCPort2SwitchFCPortPerf)object4.nextElement();
                        object3 = (GraphFCPort2SwitchFCPortPerf)((GraphFCPort2SwitchFCPortPerf)object3).clone();
                        graphModelSwitchL2.put((GraphEntity)object3);
                    }
                    object3 = this.model.associator(GraphFCPort2SwitchFCPortPerf.TYPE, (GraphEntity.ID)serializable);
                    while (object3.hasMoreElements()) {
                        object2 = (GraphSwitchFCPortPerf)object3.nextElement();
                        object2 = (GraphSwitchFCPortPerf)((GraphSwitchFCPortPerf)object2).clone();
                        graphModelSwitchL2.put((GraphEntity)object2);
                    }
                }
            }
            hashSet = new HashSet<GraphFCPort>();
            serializable = new HashSet();
            object4 = graphModelSwitchL2.enumerateID(GraphFCPort.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphFCPort.ID)object4.nextElement();
                object2 = this.model.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFCPort2FCPort)object2.nextElement();
                    object = (GraphFCPort2FCPort)((GraphFCPort2FCPort)object).clone();
                    graphModelSwitchL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFCPort)object.nextElement();
                    graphEntity = (GraphFCPort)((GraphFCPort)graphEntity).clone();
                    hashSet.add((GraphFCPort)graphEntity);
                }
            }
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (GraphFCPort)object3.next();
                graphModelSwitchL2.put((GraphEntity)object2);
                object = (GraphFCPort.ID)((GraphEntity)object2).getEntityID();
                ((HashSet)serializable).add(object);
            }
            object4 = this.model.associator(GraphSwitch2Computer.TYPE, iD3);
            while (object4.hasMoreElements()) {
                object3 = (GraphComputer)object4.nextElement();
                object3 = (GraphComputer)((GraphComputer)object3).clone();
                object2 = (GraphComputer.ID)((GraphEntity)object3).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object3);
                object = this.model.reference(GraphComputer2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphComputer2FCPort)object.nextElement();
                    iD2 = ((GraphComputer2FCPort)(graphEntity = (GraphComputer2FCPort)((GraphComputer2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD2)) continue;
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            object4 = this.model.associator(GraphSwitch2Switch.TYPE, iD3);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch)object4.nextElement();
                object3 = (GraphSwitch)((GraphSwitch)object3).clone();
                object2 = (GraphSwitch.ID)((GraphEntity)object3).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object3);
                object = this.model.reference(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch2FCPort)object.nextElement();
                    iD2 = ((GraphSwitch2FCPort)(graphEntity = (GraphSwitch2FCPort)((GraphSwitch2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD2)) continue;
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            object4 = graphModelSwitchL2.enumerateID(GraphSwitch.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch.ID)object4.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelSwitchL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            object4 = this.model.associator(GraphSwitch2Subsystem.TYPE, iD3);
            while (object4.hasMoreElements()) {
                object3 = (GraphSubsystem)object4.nextElement();
                object3 = (GraphSubsystem)((GraphSubsystem)object3).clone();
                object2 = (GraphSubsystem.ID)((GraphEntity)object3).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object3);
                object = this.model.reference(GraphSubsystem2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSubsystem2FCPort)object.nextElement();
                    iD2 = ((GraphSubsystem2FCPort)(graphEntity = (GraphSubsystem2FCPort)((GraphSubsystem2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD2)) continue;
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            object4 = this.model.associator(GraphSwitch2TapeLibrary.TYPE, iD3);
            while (object4.hasMoreElements()) {
                object3 = (GraphTapeLibrary)object4.nextElement();
                object3 = (GraphTapeLibrary)((GraphTapeLibrary)object3).clone();
                object2 = (GraphTapeLibrary.ID)((GraphEntity)object3).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object3);
                object = this.model.reference(GraphTapeLibrary2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphTapeLibrary2FCPort)object.nextElement();
                    iD2 = ((GraphTapeLibrary2FCPort)(graphEntity = (GraphTapeLibrary2FCPort)((GraphTapeLibrary2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD2)) continue;
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            object4 = this.model.associator(GraphSwitch2Other.TYPE, iD3);
            while (object4.hasMoreElements()) {
                object3 = (GraphOther)object4.nextElement();
                object3 = (GraphOther)((GraphOther)object3).clone();
                object2 = (GraphOther.ID)((GraphEntity)object3).getEntityID();
                graphModelSwitchL2.put((GraphEntity)object3);
                object = this.model.reference(GraphOther2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphOther2FCPort)object.nextElement();
                    iD2 = ((GraphOther2FCPort)(graphEntity = (GraphOther2FCPort)((GraphOther2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD2)) continue;
                    graphModelSwitchL2.put(graphEntity);
                }
            }
            graphModelSwitchL2.setWithPerfData(bl);
            return graphModelSwitchL2;
        }

        private GraphModelStorageL0 generateStorageL0(GraphModelStorageL0.ID iD) {
            GraphEntity graphEntity;
            GraphModelStorageL0 graphModelStorageL0 = new GraphModelStorageL0(iD);
            Enumeration enumeration = this.model.enumerate(GraphSubsystem.TYPE);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphSubsystem)enumeration.nextElement();
                graphEntity = (GraphSubsystem)((GraphSubsystem)graphEntity).clone();
                GraphSubsystem.ID cfr_ignored_0 = (GraphSubsystem.ID)graphEntity.getEntityID();
                graphModelStorageL0.put(graphEntity);
            }
            enumeration = this.model.enumerate(GraphTapeLibrary.TYPE);
            while (enumeration.hasMoreElements()) {
                graphEntity = (GraphTapeLibrary)enumeration.nextElement();
                graphEntity = (GraphTapeLibrary)((GraphTapeLibrary)graphEntity).clone();
                GraphTapeLibrary.ID cfr_ignored_1 = (GraphTapeLibrary.ID)graphEntity.getEntityID();
                graphModelStorageL0.put(graphEntity);
            }
            return graphModelStorageL0;
        }

        private GraphModelSubsystemL1 generateSubsystemL1(GraphModelSubsystemL1.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            boolean bl = iD.isNeedZoneData();
            Vector vector = iD.getChildFocusEntityIDs();
            GraphModelSubsystemL1 graphModelSubsystemL1 = new GraphModelSubsystemL1(iD);
            Vector<GraphSubsystem.ID> vector2 = new Vector<GraphSubsystem.ID>();
            int n = 0;
            while (n < vector.size()) {
                object2 = (GraphSubsystem.ID)vector.elementAt(n);
                object = (GraphSubsystem)this.model.get((GraphEntity.ID)object2);
                if (object != null) {
                    object = (GraphSubsystem)((GraphSubsystem)object).clone();
                    graphModelSubsystemL1.put((GraphEntity)object);
                    vector2.add((GraphSubsystem.ID)object2);
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return graphModelSubsystemL1;
            }
            if (bl) {
                this.addZones_L1(this.model, graphModelSubsystemL1, vector2);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphSubsystem.ID iD2 = (GraphSubsystem.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2Subsystem.TYPE, iD2);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Subsystem)object2.nextElement();
                    object = (GraphSwitch2Subsystem)((GraphSwitch2Subsystem)object).clone();
                    graphModelSubsystemL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Subsystem.TYPE, iD2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    graphEntity = (GraphSwitch)((GraphSwitch)graphEntity).clone();
                    GraphSwitch.ID cfr_ignored_0 = (GraphSwitch.ID)graphEntity.getEntityID();
                    graphModelSubsystemL1.put(graphEntity);
                }
                ++n2;
            }
            Enumeration enumeration = graphModelSubsystemL1.enumerateID(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphSwitch.ID iD3 = (GraphSwitch.ID)enumeration.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, iD3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelSubsystemL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelSubsystemL1.put(graphEntity);
                }
            }
            graphModelSubsystemL1.setWithZoneData(bl);
            return graphModelSubsystemL1;
        }

        private GraphModelSubsystemL2 generateSubsystemL2(GraphModelSubsystemL2.ID iD) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Serializable serializable;
            GraphEntity.ID iD2 = iD.getFocusEntityID();
            boolean bl = iD.isNeedPerfData();
            boolean bl2 = iD.isNeedZoneData();
            GraphModelSubsystemL2 graphModelSubsystemL2 = new GraphModelSubsystemL2(iD);
            graphModelSubsystemL2.setWithPerfData(bl);
            graphModelSubsystemL2.setWithZoneData(bl2);
            HashSet<GraphFCPort> hashSet = (GraphSubsystem)this.model.get(iD2);
            if (hashSet == null) {
                return graphModelSubsystemL2;
            }
            hashSet = (GraphSubsystem)((GraphSubsystem)((Object)hashSet)).clone();
            graphModelSubsystemL2.put((GraphEntity)((Object)hashSet));
            if (bl2) {
                serializable = (GraphSubsystem.ID)((GraphEntity)((Object)hashSet)).getEntityID();
                this.addZones_L2(this.model, graphModelSubsystemL2, (GraphEntity.ID)serializable);
            }
            if (bl) {
                hashSet = this.model.reference(GraphSubsystem2SubsystemPerf.TYPE, iD2);
                while (hashSet.hasMoreElements()) {
                    serializable = (GraphSubsystem2SubsystemPerf)hashSet.nextElement();
                    serializable = (GraphSubsystem2SubsystemPerf)((GraphSubsystem2SubsystemPerf)serializable).clone();
                    graphModelSubsystemL2.put((GraphEntity)serializable);
                }
                serializable = this.model.associator(GraphSubsystem2SubsystemPerf.TYPE, iD2);
                while (serializable.hasMoreElements()) {
                    object10 = (GraphSubsystemPerf)serializable.nextElement();
                    object10 = (GraphSubsystemPerf)((GraphSubsystemPerf)object10).clone();
                    graphModelSubsystemL2.put((GraphEntity)object10);
                }
            }
            hashSet = this.model.reference(GraphSubsystem2FCPort.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphSubsystem2FCPort)hashSet.nextElement();
                serializable = (GraphSubsystem2FCPort)((GraphSubsystem2FCPort)serializable).clone();
                graphModelSubsystemL2.put((GraphEntity)serializable);
            }
            serializable = this.model.associator(GraphSubsystem2FCPort.TYPE, iD2);
            while (serializable.hasMoreElements()) {
                object10 = (GraphFCPort)serializable.nextElement();
                object10 = (GraphFCPort)((GraphFCPort)object10).clone();
                GraphFCPort.ID cfr_ignored_0 = (GraphFCPort.ID)((GraphEntity)object10).getEntityID();
                graphModelSubsystemL2.put((GraphEntity)object10);
            }
            if (bl) {
                hashSet = graphModelSubsystemL2.enumerateID(GraphFCPort.TYPE);
                while (hashSet.hasMoreElements()) {
                    serializable = (GraphFCPort.ID)hashSet.nextElement();
                    object10 = this.model.reference(GraphFCPort2SubsystemFCPortPerf.TYPE, (GraphEntity.ID)serializable);
                    while (object10.hasMoreElements()) {
                        object9 = (GraphFCPort2SubsystemFCPortPerf)object10.nextElement();
                        object9 = (GraphFCPort2SubsystemFCPortPerf)((GraphFCPort2SubsystemFCPortPerf)object9).clone();
                        graphModelSubsystemL2.put((GraphEntity)object9);
                    }
                    object9 = this.model.associator(GraphFCPort2SubsystemFCPortPerf.TYPE, (GraphEntity.ID)serializable);
                    while (object9.hasMoreElements()) {
                        object8 = (GraphSubsystemFCPortPerf)object9.nextElement();
                        object8 = (GraphSubsystemFCPortPerf)((GraphSubsystemFCPortPerf)object8).clone();
                        graphModelSubsystemL2.put((GraphEntity)object8);
                    }
                }
            }
            hashSet = new HashSet<GraphFCPort>();
            serializable = new HashSet();
            object10 = graphModelSubsystemL2.enumerateID(GraphFCPort.TYPE);
            while (object10.hasMoreElements()) {
                object9 = (GraphFCPort.ID)object10.nextElement();
                object8 = this.model.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object9);
                while (object8.hasMoreElements()) {
                    object7 = (GraphFCPort2FCPort)object8.nextElement();
                    object7 = (GraphFCPort2FCPort)((GraphFCPort2FCPort)object7).clone();
                    graphModelSubsystemL2.put((GraphEntity)object7);
                }
                object7 = this.model.associator(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object9);
                while (object7.hasMoreElements()) {
                    object6 = (GraphFCPort)object7.nextElement();
                    object6 = (GraphFCPort)((GraphFCPort)object6).clone();
                    hashSet.add((GraphFCPort)object6);
                }
            }
            object9 = hashSet.iterator();
            while (object9.hasNext()) {
                object8 = (GraphFCPort)object9.next();
                graphModelSubsystemL2.put((GraphEntity)object8);
                object7 = (GraphFCPort.ID)((GraphEntity)object8).getEntityID();
                ((HashSet)serializable).add(object7);
            }
            object10 = this.model.associator(GraphSwitch2Subsystem.TYPE, iD2);
            while (object10.hasMoreElements()) {
                object9 = (GraphSwitch)object10.nextElement();
                object9 = (GraphSwitch)((GraphSwitch)object9).clone();
                object8 = (GraphSwitch.ID)((GraphEntity)object9).getEntityID();
                graphModelSubsystemL2.put((GraphEntity)object9);
                object7 = this.model.reference(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object8);
                while (object7.hasMoreElements()) {
                    object6 = (GraphSwitch2FCPort)object7.nextElement();
                    object5 = ((GraphSwitch2FCPort)(object6 = (GraphSwitch2FCPort)((GraphSwitch2FCPort)object6).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(object5)) continue;
                    graphModelSubsystemL2.put((GraphEntity)object6);
                }
            }
            object10 = graphModelSubsystemL2.enumerateID(GraphSwitch.TYPE);
            while (object10.hasMoreElements()) {
                object9 = (GraphSwitch.ID)object10.nextElement();
                object8 = this.model.reference(GraphFabric2Switch.TYPE, (GraphEntity.ID)object9);
                while (object8.hasMoreElements()) {
                    object7 = (GraphFabric2Switch)object8.nextElement();
                    object7 = (GraphFabric2Switch)((GraphFabric2Switch)object7).clone();
                    graphModelSubsystemL2.put((GraphEntity)object7);
                }
                object7 = this.model.associator(GraphFabric2Switch.TYPE, (GraphEntity.ID)object9);
                while (object7.hasMoreElements()) {
                    object6 = (GraphFabric)object7.nextElement();
                    object6 = (GraphFabric)((GraphFabric)object6).clone();
                    graphModelSubsystemL2.put((GraphEntity)object6);
                }
            }
            object10 = this.model.associator(GraphSubsystem2Disk.TYPE, iD2);
            while (object10.hasMoreElements()) {
                object9 = (GraphDisk)object10.nextElement();
                object9 = (GraphDisk)((GraphDisk)object9).clone();
                object8 = (GraphDisk.ID)((GraphEntity)object9).getEntityID();
                graphModelSubsystemL2.put((GraphEntity)object9);
                if (bl) {
                    object7 = this.model.reference(GraphDisk2DiskPerf.TYPE, (GraphEntity.ID)object8);
                    while (object7.hasMoreElements()) {
                        object6 = (GraphDisk2DiskPerf)object7.nextElement();
                        object6 = (GraphDisk2DiskPerf)((GraphDisk2DiskPerf)object6).clone();
                        graphModelSubsystemL2.put((GraphEntity)object6);
                    }
                    object6 = this.model.associator(GraphDisk2DiskPerf.TYPE, (GraphEntity.ID)object8);
                    while (object6.hasMoreElements()) {
                        object5 = (GraphDiskPerf)object6.nextElement();
                        object5 = (GraphDiskPerf)((GraphDiskPerf)object5).clone();
                        graphModelSubsystemL2.put((GraphEntity)object5);
                    }
                }
                object7 = this.model.reference(GraphVolume2Disk.TYPE, (GraphEntity.ID)object8);
                while (object7.hasMoreElements()) {
                    object6 = (GraphVolume2Disk)object7.nextElement();
                    object6 = (GraphVolume2Disk)((GraphVolume2Disk)object6).clone();
                    graphModelSubsystemL2.put((GraphEntity)object6);
                }
                object6 = this.model.associator(GraphVolume2Disk.TYPE, (GraphEntity.ID)object8);
                while (object6.hasMoreElements()) {
                    object5 = (GraphVolume)object6.nextElement();
                    object4 = (GraphVolume.ID)((GraphEntity)object5).getEntityID();
                    object5 = (GraphVolume)((GraphVolume)object5).clone();
                    graphModelSubsystemL2.put((GraphEntity)object5);
                    object3 = this.model.reference(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object4);
                    while (object3.hasMoreElements()) {
                        object2 = (GraphSubsystem2Volume)object3.nextElement();
                        object2 = (GraphSubsystem2Volume)((GraphSubsystem2Volume)object2).clone();
                        graphModelSubsystemL2.put((GraphEntity)object2);
                    }
                    object2 = this.model.associator(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object4);
                    while (object2.hasMoreElements()) {
                        object = (GraphSubsystem)object2.nextElement();
                        object = (GraphSubsystem)((GraphSubsystem)object).clone();
                        graphModelSubsystemL2.put((GraphEntity)object);
                    }
                }
            }
            object10 = this.model.associator(GraphSubsystem2Pool.TYPE, iD2);
            while (object10.hasMoreElements()) {
                object9 = (GraphPool)object10.nextElement();
                object9 = (GraphPool)((GraphPool)object9).clone();
                object8 = (GraphPool.ID)((GraphEntity)object9).getEntityID();
                graphModelSubsystemL2.put((GraphEntity)object9);
                object7 = this.model.reference(GraphPool2Disk.TYPE, (GraphEntity.ID)object8);
                while (object7.hasMoreElements()) {
                    object6 = (GraphPool2Disk)object7.nextElement();
                    object6 = (GraphPool2Disk)((GraphPool2Disk)object6).clone();
                    graphModelSubsystemL2.put((GraphEntity)object6);
                }
                object6 = this.model.reference(GraphPool2Volume.TYPE, (GraphEntity.ID)object8);
                while (object6.hasMoreElements()) {
                    object5 = (GraphPool2Volume)object6.nextElement();
                    object5 = (GraphPool2Volume)((GraphPool2Volume)object5).clone();
                    graphModelSubsystemL2.put((GraphEntity)object5);
                }
                if (!bl) continue;
                object5 = this.model.reference(GraphPool2PoolPerf.TYPE, (GraphEntity.ID)object8);
                while (object5.hasMoreElements()) {
                    object4 = (GraphPool2PoolPerf)object5.nextElement();
                    object4 = (GraphPool2PoolPerf)((GraphPool2PoolPerf)object4).clone();
                    graphModelSubsystemL2.put((GraphEntity)object4);
                }
                object4 = this.model.associator(GraphPool2PoolPerf.TYPE, (GraphEntity.ID)object8);
                while (object4.hasMoreElements()) {
                    object3 = (GraphPoolPerf)object4.nextElement();
                    object3 = (GraphPoolPerf)((GraphPoolPerf)object3).clone();
                    graphModelSubsystemL2.put((GraphEntity)object3);
                }
            }
            object10 = this.model.associator(GraphSubsystem2Volume.TYPE, iD2);
            while (object10.hasMoreElements()) {
                Object object11;
                object9 = (GraphVolume)object10.nextElement();
                object9 = (GraphVolume)((GraphVolume)object9).clone();
                object8 = (GraphVolume.ID)((GraphEntity)object9).getEntityID();
                graphModelSubsystemL2.put((GraphEntity)object9);
                if (bl) {
                    object7 = this.model.reference(GraphVolume2VolumePerf.TYPE, (GraphEntity.ID)object8);
                    while (object7.hasMoreElements()) {
                        object6 = (GraphVolume2VolumePerf)object7.nextElement();
                        object6 = (GraphVolume2VolumePerf)((GraphVolume2VolumePerf)object6).clone();
                        graphModelSubsystemL2.put((GraphEntity)object6);
                    }
                    object6 = this.model.associator(GraphVolume2VolumePerf.TYPE, (GraphEntity.ID)object8);
                    while (object6.hasMoreElements()) {
                        object5 = (GraphVolumePerf)object6.nextElement();
                        object5 = (GraphVolumePerf)((GraphVolumePerf)object5).clone();
                        graphModelSubsystemL2.put((GraphEntity)object5);
                    }
                }
                object7 = this.model.reference(GraphVolume2Volume.TYPE, (GraphEntity.ID)object8);
                while (object7.hasMoreElements()) {
                    object6 = (GraphVolume2Volume)object7.nextElement();
                    object6 = (GraphVolume2Volume)((GraphVolume2Volume)object6).clone();
                    graphModelSubsystemL2.put((GraphEntity)object6);
                }
                object6 = this.model.reference(GraphVolume2Disk.TYPE, (GraphEntity.ID)object8);
                while (object6.hasMoreElements()) {
                    object5 = (GraphVolume2Disk)object6.nextElement();
                    object5 = (GraphVolume2Disk)((GraphVolume2Disk)object5).clone();
                    graphModelSubsystemL2.put((GraphEntity)object5);
                }
                object5 = this.model.associator(GraphVolume2Disk.TYPE, (GraphEntity.ID)object8);
                while (object5.hasMoreElements()) {
                    object4 = (GraphDisk)object5.nextElement();
                    object3 = (GraphDisk.ID)((GraphEntity)object4).getEntityID();
                    object4 = (GraphDisk)((GraphDisk)object4).clone();
                    graphModelSubsystemL2.put((GraphEntity)object4);
                    object2 = this.model.reference(GraphSubsystem2Disk.TYPE, (GraphEntity.ID)object3);
                    while (object2.hasMoreElements()) {
                        object = (GraphSubsystem2Disk)object2.nextElement();
                        object = (GraphSubsystem2Disk)((GraphSubsystem2Disk)object).clone();
                        graphModelSubsystemL2.put((GraphEntity)object);
                    }
                    object = this.model.associator(GraphSubsystem2Disk.TYPE, (GraphEntity.ID)object3);
                    while (object.hasMoreElements()) {
                        object11 = (GraphSubsystem)object.nextElement();
                        object11 = (GraphSubsystem)((GraphSubsystem)object11).clone();
                        graphModelSubsystemL2.put((GraphEntity)object11);
                    }
                }
                object4 = this.model.reference(GraphVolume2Lun.TYPE, (GraphEntity.ID)object8);
                while (object4.hasMoreElements()) {
                    object3 = (GraphVolume2Lun)object4.nextElement();
                    object3 = (GraphVolume2Lun)((GraphVolume2Lun)object3).clone();
                    graphModelSubsystemL2.put((GraphEntity)object3);
                }
                object3 = this.model.associator(GraphVolume2Lun.TYPE, (GraphEntity.ID)object8);
                while (object3.hasMoreElements()) {
                    Object object12;
                    Object object13;
                    Object object14;
                    object2 = (GraphLun)object3.nextElement();
                    object2 = (GraphLun)((GraphLun)object2).clone();
                    object = (GraphLun.ID)((GraphEntity)object2).getEntityID();
                    graphModelSubsystemL2.put((GraphEntity)object2);
                    object11 = this.model.reference(GraphComputer2Lun.TYPE, (GraphEntity.ID)object);
                    while (object11.hasMoreElements()) {
                        object14 = (GraphComputer2Lun)object11.nextElement();
                        object14 = (GraphComputer2Lun)((GraphComputer2Lun)object14).clone();
                        graphModelSubsystemL2.put((GraphEntity)object14);
                    }
                    object14 = this.model.associator(GraphComputer2Lun.TYPE, (GraphEntity.ID)object);
                    while (object14.hasMoreElements()) {
                        object13 = (GraphComputer)object14.nextElement();
                        object13 = (GraphComputer)((GraphComputer)object13).clone();
                        GraphComputer.ID cfr_ignored_1 = (GraphComputer.ID)((GraphEntity)object13).getEntityID();
                        graphModelSubsystemL2.put((GraphEntity)object13);
                    }
                    object13 = this.model.reference(GraphOther2Lun.TYPE, (GraphEntity.ID)object);
                    while (object13.hasMoreElements()) {
                        object12 = (GraphOther2Lun)object13.nextElement();
                        object12 = (GraphOther2Lun)((GraphOther2Lun)object12).clone();
                        graphModelSubsystemL2.put((GraphEntity)object12);
                    }
                    object12 = this.model.associator(GraphOther2Lun.TYPE, (GraphEntity.ID)object);
                    while (object12.hasMoreElements()) {
                        GraphOther graphOther = (GraphOther)object12.nextElement();
                        graphOther = (GraphOther)graphOther.clone();
                        GraphOther.ID cfr_ignored_2 = (GraphOther.ID)graphOther.getEntityID();
                        graphModelSubsystemL2.put(graphOther);
                    }
                }
            }
            return graphModelSubsystemL2;
        }

        private GraphModelTapeLibraryL1 generateTapeLibraryL1(GraphModelTapeLibraryL1.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            boolean bl = iD.isNeedZoneData();
            Vector vector = iD.getChildFocusEntityIDs();
            GraphModelTapeLibraryL1 graphModelTapeLibraryL1 = new GraphModelTapeLibraryL1(iD);
            Vector<GraphTapeLibrary.ID> vector2 = new Vector<GraphTapeLibrary.ID>();
            int n = 0;
            while (n < vector.size()) {
                object2 = (GraphTapeLibrary.ID)vector.elementAt(n);
                object = (GraphTapeLibrary)this.model.get((GraphEntity.ID)object2);
                if (object != null) {
                    object = (GraphTapeLibrary)((GraphTapeLibrary)object).clone();
                    graphModelTapeLibraryL1.put((GraphEntity)object);
                    vector2.add((GraphTapeLibrary.ID)object2);
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return graphModelTapeLibraryL1;
            }
            if (bl) {
                this.addZones_L1(this.model, graphModelTapeLibraryL1, vector2);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphTapeLibrary.ID iD2 = (GraphTapeLibrary.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2TapeLibrary.TYPE, iD2);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2TapeLibrary)object2.nextElement();
                    object = (GraphSwitch2TapeLibrary)((GraphSwitch2TapeLibrary)object).clone();
                    graphModelTapeLibraryL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2TapeLibrary.TYPE, iD2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    graphEntity = (GraphSwitch)((GraphSwitch)graphEntity).clone();
                    GraphSwitch.ID cfr_ignored_0 = (GraphSwitch.ID)graphEntity.getEntityID();
                    graphModelTapeLibraryL1.put(graphEntity);
                }
                ++n2;
            }
            Enumeration enumeration = graphModelTapeLibraryL1.enumerateID(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphSwitch.ID iD3 = (GraphSwitch.ID)enumeration.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, iD3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelTapeLibraryL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelTapeLibraryL1.put(graphEntity);
                }
            }
            graphModelTapeLibraryL1.setWithZoneData(bl);
            return graphModelTapeLibraryL1;
        }

        private GraphModelTapeLibraryL2 generateTapeLibraryL2(GraphModelTapeLibraryL2.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            GraphEntity.ID iD2 = iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            GraphModelTapeLibraryL2 graphModelTapeLibraryL2 = new GraphModelTapeLibraryL2(iD);
            graphModelTapeLibraryL2.setWithZoneData(bl);
            HashSet<GraphFCPort> hashSet = (GraphTapeLibrary)this.model.get(iD2);
            if (hashSet == null) {
                return graphModelTapeLibraryL2;
            }
            hashSet = (GraphTapeLibrary)((GraphTapeLibrary)((Object)hashSet)).clone();
            graphModelTapeLibraryL2.put((GraphEntity)((Object)hashSet));
            if (bl) {
                serializable = (GraphTapeLibrary.ID)((GraphEntity)((Object)hashSet)).getEntityID();
                this.addZones_L2(this.model, graphModelTapeLibraryL2, (GraphEntity.ID)serializable);
            }
            hashSet = this.model.reference(GraphTapeLibrary2FCPort.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphTapeLibrary2FCPort)hashSet.nextElement();
                serializable = (GraphTapeLibrary2FCPort)((GraphTapeLibrary2FCPort)serializable).clone();
                graphModelTapeLibraryL2.put((GraphEntity)serializable);
            }
            serializable = this.model.associator(GraphTapeLibrary2FCPort.TYPE, iD2);
            while (serializable.hasMoreElements()) {
                object4 = (GraphFCPort)serializable.nextElement();
                GraphFCPort.ID cfr_ignored_0 = (GraphFCPort.ID)((GraphEntity)object4).getEntityID();
                object4 = (GraphFCPort)((GraphFCPort)object4).clone();
                graphModelTapeLibraryL2.put((GraphEntity)object4);
            }
            hashSet = this.model.reference(GraphTapeLibrary2TapeDrive.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphTapeLibrary2TapeDrive)hashSet.nextElement();
                serializable = (GraphTapeLibrary2TapeDrive)((GraphTapeLibrary2TapeDrive)serializable).clone();
                graphModelTapeLibraryL2.put((GraphEntity)serializable);
            }
            serializable = this.model.associator(GraphTapeLibrary2TapeDrive.TYPE, iD2);
            while (serializable.hasMoreElements()) {
                object4 = (GraphTapeDrive)serializable.nextElement();
                object4 = (GraphTapeDrive)((GraphTapeDrive)object4).clone();
                graphModelTapeLibraryL2.put((GraphEntity)object4);
            }
            hashSet = graphModelTapeLibraryL2.enumerateID(GraphTapeDrive.TYPE);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphTapeDrive.ID)hashSet.nextElement();
                object4 = this.model.reference(GraphTapeDrive2FCPort.TYPE, (GraphEntity.ID)serializable);
                while (object4.hasMoreElements()) {
                    object3 = (GraphTapeDrive2FCPort)object4.nextElement();
                    object3 = (GraphTapeDrive2FCPort)((GraphTapeDrive2FCPort)object3).clone();
                    graphModelTapeLibraryL2.put((GraphEntity)object3);
                }
                object3 = this.model.associator(GraphTapeDrive2FCPort.TYPE, (GraphEntity.ID)serializable);
                while (object3.hasMoreElements()) {
                    object2 = (GraphFCPort)object3.nextElement();
                    object2 = (GraphFCPort)((GraphFCPort)object2).clone();
                    GraphFCPort.ID cfr_ignored_1 = (GraphFCPort.ID)((GraphEntity)object2).getEntityID();
                    graphModelTapeLibraryL2.put((GraphEntity)object2);
                }
            }
            hashSet = this.model.reference(GraphTapeLibrary2FCPort.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                serializable = (GraphTapeLibrary2FCPort)hashSet.nextElement();
                serializable = (GraphTapeLibrary2FCPort)((GraphTapeLibrary2FCPort)serializable).clone();
                graphModelTapeLibraryL2.put((GraphEntity)serializable);
            }
            hashSet = new HashSet<GraphFCPort>();
            serializable = new HashSet();
            object4 = graphModelTapeLibraryL2.enumerateID(GraphFCPort.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphFCPort.ID)object4.nextElement();
                object2 = this.model.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFCPort2FCPort)object2.nextElement();
                    object = (GraphFCPort2FCPort)((GraphFCPort2FCPort)object).clone();
                    graphModelTapeLibraryL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFCPort)object.nextElement();
                    graphEntity = (GraphFCPort)((GraphFCPort)graphEntity).clone();
                    hashSet.add((GraphFCPort)graphEntity);
                }
            }
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (GraphFCPort)object3.next();
                graphModelTapeLibraryL2.put((GraphEntity)object2);
                object = (GraphFCPort.ID)((GraphEntity)object2).getEntityID();
                ((HashSet)serializable).add(object);
            }
            object4 = this.model.associator(GraphSwitch2TapeLibrary.TYPE, iD2);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch)object4.nextElement();
                object3 = (GraphSwitch)((GraphSwitch)object3).clone();
                object2 = (GraphSwitch.ID)((GraphEntity)object3).getEntityID();
                graphModelTapeLibraryL2.put((GraphEntity)object3);
                object = this.model.reference(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch2FCPort)object.nextElement();
                    GraphFCPort.ID iD3 = ((GraphSwitch2FCPort)(graphEntity = (GraphSwitch2FCPort)((GraphSwitch2FCPort)graphEntity).clone())).getFCPortID();
                    if (!((HashSet)serializable).contains(iD3)) continue;
                    graphModelTapeLibraryL2.put(graphEntity);
                }
            }
            object4 = graphModelTapeLibraryL2.enumerateID(GraphSwitch.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch.ID)object4.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelTapeLibraryL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelTapeLibraryL2.put(graphEntity);
                }
            }
            object4 = this.model.reference(GraphTapeLibrary2MediaChanger.TYPE, iD2);
            while (object4.hasMoreElements()) {
                object3 = (GraphTapeLibrary2MediaChanger)object4.nextElement();
                object3 = (GraphTapeLibrary2MediaChanger)((GraphTapeLibrary2MediaChanger)object3).clone();
                graphModelTapeLibraryL2.put((GraphEntity)object3);
            }
            object3 = this.model.associator(GraphTapeLibrary2MediaChanger.TYPE, iD2);
            while (object3.hasMoreElements()) {
                object2 = (GraphMediaChanger)object3.nextElement();
                object2 = (GraphMediaChanger)((GraphMediaChanger)object2).clone();
                graphModelTapeLibraryL2.put((GraphEntity)object2);
            }
            return graphModelTapeLibraryL2;
        }

        private GraphModelOtherL0 generateOtherL0(GraphModelOtherL0.ID iD) {
            GraphModelOtherL0 graphModelOtherL0 = new GraphModelOtherL0(iD);
            Enumeration enumeration = this.model.enumerate(GraphOther.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphOther graphOther = (GraphOther)enumeration.nextElement();
                graphOther = (GraphOther)graphOther.clone();
                GraphOther.ID cfr_ignored_0 = (GraphOther.ID)graphOther.getEntityID();
                graphModelOtherL0.put(graphOther);
            }
            return graphModelOtherL0;
        }

        private GraphModelOtherL1 generateOtherL1(GraphModelOtherL1.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            boolean bl = iD.isNeedZoneData();
            Vector vector = iD.getChildFocusEntityIDs();
            GraphModelOtherL1 graphModelOtherL1 = new GraphModelOtherL1(iD);
            Vector<GraphOther.ID> vector2 = new Vector<GraphOther.ID>();
            int n = 0;
            while (n < vector.size()) {
                object2 = (GraphOther.ID)vector.elementAt(n);
                object = (GraphOther)this.model.get((GraphEntity.ID)object2);
                if (object != null) {
                    object = (GraphOther)((GraphOther)object).clone();
                    graphModelOtherL1.put((GraphEntity)object);
                    vector2.add((GraphOther.ID)object2);
                }
                ++n;
            }
            if (vector2.size() == 0) {
                return graphModelOtherL1;
            }
            if (bl) {
                this.addZones_L1(this.model, graphModelOtherL1, vector2);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                GraphOther.ID iD2 = (GraphOther.ID)vector.elementAt(n2);
                object2 = this.model.reference(GraphSwitch2Other.TYPE, iD2);
                while (object2.hasMoreElements()) {
                    object = (GraphSwitch2Other)object2.nextElement();
                    object = (GraphSwitch2Other)((GraphSwitch2Other)object).clone();
                    graphModelOtherL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSwitch2Other.TYPE, iD2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch)object.nextElement();
                    graphEntity = (GraphSwitch)((GraphSwitch)graphEntity).clone();
                    GraphSwitch.ID cfr_ignored_0 = (GraphSwitch.ID)graphEntity.getEntityID();
                    graphModelOtherL1.put(graphEntity);
                }
                ++n2;
            }
            Enumeration enumeration = graphModelOtherL1.enumerateID(GraphSwitch.TYPE);
            while (enumeration.hasMoreElements()) {
                GraphSwitch.ID iD3 = (GraphSwitch.ID)enumeration.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, iD3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelOtherL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, iD3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelOtherL1.put(graphEntity);
                }
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                GraphOther.ID iD4 = (GraphOther.ID)vector.elementAt(n3);
                object2 = this.model.reference(GraphOther2Volume.TYPE, iD4);
                while (object2.hasMoreElements()) {
                    object = (GraphOther2Volume)object2.nextElement();
                    object = (GraphOther2Volume)((GraphOther2Volume)object).clone();
                    graphModelOtherL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphOther2Volume.TYPE, iD4);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphVolume)object.nextElement();
                    graphEntity = (GraphVolume)((GraphVolume)graphEntity).clone();
                    graphModelOtherL1.put(graphEntity);
                }
                ++n3;
            }
            Enumeration enumeration2 = graphModelOtherL1.enumerateID(GraphVolume.TYPE);
            while (enumeration2.hasMoreElements()) {
                GraphVolume.ID iD5 = (GraphVolume.ID)enumeration2.nextElement();
                object2 = this.model.reference(GraphSubsystem2Volume.TYPE, iD5);
                while (object2.hasMoreElements()) {
                    object = (GraphSubsystem2Volume)object2.nextElement();
                    object = (GraphSubsystem2Volume)((GraphSubsystem2Volume)object).clone();
                    graphModelOtherL1.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSubsystem2Volume.TYPE, iD5);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSubsystem)object.nextElement();
                    graphEntity = (GraphSubsystem)((GraphSubsystem)graphEntity).clone();
                    graphModelOtherL1.put(graphEntity);
                }
            }
            graphModelOtherL1.setWithZoneData(bl);
            return graphModelOtherL1;
        }

        private GraphModelOtherL2 generateOtherL2(GraphModelOtherL2.ID iD) {
            GraphEntity graphEntity;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashSet<Comparable> hashSet;
            GraphEntity.ID iD2 = iD.getFocusEntityID();
            boolean bl = iD.isNeedZoneData();
            GraphModelOtherL2 graphModelOtherL2 = new GraphModelOtherL2(iD);
            graphModelOtherL2.setWithZoneData(bl);
            HashSet<GraphFCPort> hashSet2 = (GraphOther)this.model.get(iD2);
            if (hashSet2 == null) {
                return graphModelOtherL2;
            }
            hashSet2 = (GraphOther)((GraphOther)((Object)hashSet2)).clone();
            graphModelOtherL2.put((GraphEntity)((Object)hashSet2));
            if (bl) {
                hashSet = (GraphOther.ID)((GraphEntity)((Object)hashSet2)).getEntityID();
                this.addZones_L2(this.model, graphModelOtherL2, (GraphEntity.ID)((Object)hashSet));
            }
            hashSet2 = this.model.reference(GraphOther2FCPort.TYPE, iD2);
            while (hashSet2.hasMoreElements()) {
                hashSet = (GraphOther2FCPort)hashSet2.nextElement();
                hashSet = (GraphOther2FCPort)((GraphOther2FCPort)((Object)hashSet)).clone();
                graphModelOtherL2.put((GraphEntity)((Object)hashSet));
            }
            hashSet = this.model.associator(GraphOther2FCPort.TYPE, iD2);
            while (hashSet.hasMoreElements()) {
                object4 = (GraphFCPort)hashSet.nextElement();
                object4 = (GraphFCPort)((GraphFCPort)object4).clone();
                GraphFCPort.ID cfr_ignored_0 = (GraphFCPort.ID)((GraphEntity)object4).getEntityID();
                graphModelOtherL2.put((GraphEntity)object4);
            }
            hashSet2 = new HashSet<GraphFCPort>();
            hashSet = new HashSet<Comparable>();
            object4 = graphModelOtherL2.enumerateID(GraphFCPort.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphFCPort.ID)object4.nextElement();
                object2 = this.model.reference(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFCPort2FCPort)object2.nextElement();
                    object = (GraphFCPort2FCPort)((GraphFCPort2FCPort)object).clone();
                    graphModelOtherL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFCPort2FCPort.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFCPort)object.nextElement();
                    graphEntity = (GraphFCPort)((GraphFCPort)graphEntity).clone();
                    hashSet2.add((GraphFCPort)graphEntity);
                }
            }
            object3 = hashSet2.iterator();
            while (object3.hasNext()) {
                object2 = (GraphFCPort)object3.next();
                graphModelOtherL2.put((GraphEntity)object2);
                object = (GraphFCPort.ID)((GraphEntity)object2).getEntityID();
                hashSet.add((Comparable)object);
            }
            object4 = this.model.associator(GraphSwitch2Other.TYPE, iD2);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch)object4.nextElement();
                object3 = (GraphSwitch)((GraphSwitch)object3).clone();
                object2 = (GraphSwitch.ID)((GraphEntity)object3).getEntityID();
                graphModelOtherL2.put((GraphEntity)object3);
                object = this.model.reference(GraphSwitch2FCPort.TYPE, (GraphEntity.ID)object2);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSwitch2FCPort)object.nextElement();
                    GraphFCPort.ID iD3 = ((GraphSwitch2FCPort)(graphEntity = (GraphSwitch2FCPort)((GraphSwitch2FCPort)graphEntity).clone())).getFCPortID();
                    if (!hashSet.contains(iD3)) continue;
                    graphModelOtherL2.put(graphEntity);
                }
            }
            object4 = graphModelOtherL2.enumerateID(GraphSwitch.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphSwitch.ID)object4.nextElement();
                object2 = this.model.reference(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphFabric2Switch)object2.nextElement();
                    object = (GraphFabric2Switch)((GraphFabric2Switch)object).clone();
                    graphModelOtherL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphFabric2Switch.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphFabric)object.nextElement();
                    graphEntity = (GraphFabric)((GraphFabric)graphEntity).clone();
                    graphModelOtherL2.put(graphEntity);
                }
            }
            object4 = this.model.reference(GraphOther2Lun.TYPE, iD2);
            while (object4.hasMoreElements()) {
                object3 = (GraphOther2Lun)object4.nextElement();
                object3 = (GraphOther2Lun)((GraphOther2Lun)object3).clone();
                graphModelOtherL2.put((GraphEntity)object3);
            }
            object3 = this.model.associator(GraphOther2Lun.TYPE, iD2);
            while (object3.hasMoreElements()) {
                object2 = (GraphLun)object3.nextElement();
                object2 = (GraphLun)((GraphLun)object2).clone();
                graphModelOtherL2.put((GraphEntity)object2);
            }
            object4 = graphModelOtherL2.enumerateID(GraphLun.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphLun.ID)object4.nextElement();
                object2 = this.model.reference(GraphVolume2Lun.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphVolume2Lun)object2.nextElement();
                    object = (GraphVolume2Lun)((GraphVolume2Lun)object).clone();
                    graphModelOtherL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphVolume2Lun.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphVolume)object.nextElement();
                    graphEntity = (GraphVolume)((GraphVolume)graphEntity).clone();
                    graphModelOtherL2.put(graphEntity);
                }
            }
            object4 = graphModelOtherL2.enumerateID(GraphVolume.TYPE);
            while (object4.hasMoreElements()) {
                object3 = (GraphVolume.ID)object4.nextElement();
                object2 = this.model.reference(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object3);
                while (object2.hasMoreElements()) {
                    object = (GraphSubsystem2Volume)object2.nextElement();
                    object = (GraphSubsystem2Volume)((GraphSubsystem2Volume)object).clone();
                    graphModelOtherL2.put((GraphEntity)object);
                }
                object = this.model.associator(GraphSubsystem2Volume.TYPE, (GraphEntity.ID)object3);
                while (object.hasMoreElements()) {
                    graphEntity = (GraphSubsystem)object.nextElement();
                    graphEntity = (GraphSubsystem)((GraphSubsystem)graphEntity).clone();
                    graphModelOtherL2.put(graphEntity);
                }
            }
            return graphModelOtherL2;
        }

        private void addZones_L2(GraphModel graphModel, GraphModel graphModel2, GraphEntity.ID iD) {
            Comparable comparable;
            Comparable comparable2;
            Object object;
            Enumeration enumeration;
            GraphEntity.ID iD2;
            Object object2;
            Enumeration enumeration2 = graphModel.enumerate(GraphZoneMember.TYPE);
            while (enumeration2.hasMoreElements()) {
                object2 = (GraphZoneMember)enumeration2.nextElement();
                if (!((GraphZoneMember)object2).getParentID().equals(iD)) continue;
                iD2 = (GraphZoneMember.ID)((GraphEntity)object2).getEntityID();
                enumeration = graphModel.associator(GraphZone2ZoneMember.TYPE, iD2);
                while (enumeration.hasMoreElements()) {
                    object = (GraphZone)enumeration.nextElement();
                    object = (GraphZone)((GraphZone)object).clone();
                    graphModel2.put((GraphEntity)object);
                }
            }
            object2 = graphModel2.enumerateID(GraphZone.TYPE);
            while (object2.hasMoreElements()) {
                iD2 = (GraphZone.ID)object2.nextElement();
                enumeration = graphModel.reference(GraphZoneFabric2Zone.TYPE, iD2);
                while (enumeration.hasMoreElements()) {
                    object = (GraphZoneFabric2Zone)enumeration.nextElement();
                    object = (GraphZoneFabric2Zone)((GraphZoneFabric2Zone)object).clone();
                    graphModel2.put((GraphEntity)object);
                    comparable2 = ((GraphZoneFabric2Zone)object).getZoneFabricID();
                    comparable = (GraphZoneFabric)graphModel.get((GraphEntity.ID)comparable2);
                    comparable = (GraphZoneFabric)((GraphZoneFabric)comparable).clone();
                    graphModel2.put((GraphEntity)comparable);
                }
                object = graphModel.reference(GraphZoneSet2Zone.TYPE, iD2);
                while (object.hasMoreElements()) {
                    comparable2 = (GraphZoneSet2Zone)object.nextElement();
                    comparable2 = (GraphZoneSet2Zone)comparable2.clone();
                    graphModel2.put((GraphEntity)comparable2);
                    comparable = comparable2.getZoneSetID();
                    GraphZoneSet graphZoneSet = (GraphZoneSet)graphModel.get((GraphEntity.ID)comparable);
                    graphZoneSet = (GraphZoneSet)graphZoneSet.clone();
                    graphModel2.put(graphZoneSet);
                    Enumeration enumeration3 = graphModel.reference(GraphZoneFabric2ZoneSet.TYPE, (GraphEntity.ID)comparable);
                    while (enumeration3.hasMoreElements()) {
                        GraphZoneFabric2ZoneSet graphZoneFabric2ZoneSet = (GraphZoneFabric2ZoneSet)enumeration3.nextElement();
                        graphZoneFabric2ZoneSet = (GraphZoneFabric2ZoneSet)graphZoneFabric2ZoneSet.clone();
                        graphModel2.put(graphZoneFabric2ZoneSet);
                        GraphZoneFabric.ID iD3 = graphZoneFabric2ZoneSet.getZoneFabricID();
                        GraphZoneFabric graphZoneFabric = (GraphZoneFabric)graphModel.get(iD3);
                        graphZoneFabric = (GraphZoneFabric)graphZoneFabric.clone();
                        graphModel2.put(graphZoneFabric);
                    }
                }
            }
            object2 = graphModel2.enumerateID(GraphZone.TYPE);
            while (object2.hasMoreElements()) {
                iD2 = (GraphZone.ID)object2.nextElement();
                enumeration = graphModel.reference(GraphZone2ZoneMember.TYPE, iD2);
                while (enumeration.hasMoreElements()) {
                    object = (GraphZone2ZoneMember)enumeration.nextElement();
                    object = (GraphZone2ZoneMember)((GraphZone2ZoneMember)object).clone();
                    graphModel2.put((GraphEntity)object);
                    comparable2 = ((GraphZone2ZoneMember)object).getZoneMemberID();
                    comparable = (GraphZoneMember)graphModel.get((GraphEntity.ID)comparable2);
                    comparable = (GraphZoneMember)((GraphZoneMember)comparable).clone();
                    graphModel2.put((GraphEntity)comparable);
                }
            }
        }

        private void addZones_L1(GraphModel graphModel, GraphModel graphModel2, Vector vector) {
            Comparable comparable;
            Comparable comparable2;
            Object object;
            Object object2;
            Comparable comparable3;
            Comparable comparable4;
            Object object3;
            HashSet<Comparable> hashSet;
            GraphEntity.ID iD;
            Object object4;
            Enumeration enumeration = graphModel.enumerate(GraphZoneMember.TYPE);
            while (enumeration.hasMoreElements()) {
                object4 = (GraphZoneMember)enumeration.nextElement();
                iD = ((GraphZoneMember)object4).getParentID();
                if (!vector.contains(iD)) continue;
                hashSet = (GraphZoneMember.ID)((GraphEntity)object4).getEntityID();
                object3 = graphModel.associator(GraphZone2ZoneMember.TYPE, (GraphEntity.ID)((Object)hashSet));
                while (object3.hasMoreElements()) {
                    comparable4 = (GraphZone)object3.nextElement();
                    comparable4 = (GraphZone)((GraphZone)comparable4).clone();
                    graphModel2.put((GraphEntity)comparable4);
                }
            }
            object4 = graphModel2.enumerateID(GraphZone.TYPE);
            while (object4.hasMoreElements()) {
                iD = (GraphZone.ID)object4.nextElement();
                hashSet = graphModel.reference(GraphZoneFabric2Zone.TYPE, iD);
                while (hashSet.hasMoreElements()) {
                    object3 = (GraphZoneFabric2Zone)hashSet.nextElement();
                    object3 = (GraphZoneFabric2Zone)((GraphZoneFabric2Zone)object3).clone();
                    graphModel2.put((GraphEntity)object3);
                    comparable4 = ((GraphZoneFabric2Zone)object3).getZoneFabricID();
                    comparable3 = (GraphZoneFabric)graphModel.get((GraphEntity.ID)comparable4);
                    comparable3 = (GraphZoneFabric)((GraphZoneFabric)comparable3).clone();
                    graphModel2.put((GraphEntity)comparable3);
                }
                object3 = graphModel.reference(GraphZoneSet2Zone.TYPE, iD);
                while (object3.hasMoreElements()) {
                    comparable4 = (GraphZoneSet2Zone)object3.nextElement();
                    comparable4 = (GraphZoneSet2Zone)((GraphZoneSet2Zone)comparable4).clone();
                    graphModel2.put((GraphEntity)comparable4);
                    comparable3 = ((GraphZoneSet2Zone)comparable4).getZoneSetID();
                    object2 = (GraphZoneSet)graphModel.get((GraphEntity.ID)comparable3);
                    object2 = (GraphZoneSet)((GraphZoneSet)object2).clone();
                    graphModel2.put((GraphEntity)object2);
                    object = graphModel.reference(GraphZoneFabric2ZoneSet.TYPE, (GraphEntity.ID)comparable3);
                    while (object.hasMoreElements()) {
                        comparable2 = (GraphZoneFabric2ZoneSet)object.nextElement();
                        comparable2 = (GraphZoneFabric2ZoneSet)((GraphZoneFabric2ZoneSet)comparable2).clone();
                        graphModel2.put((GraphEntity)comparable2);
                        comparable = ((GraphZoneFabric2ZoneSet)comparable2).getZoneFabricID();
                        GraphZoneFabric graphZoneFabric = (GraphZoneFabric)graphModel.get((GraphEntity.ID)comparable);
                        graphZoneFabric = (GraphZoneFabric)graphZoneFabric.clone();
                        graphModel2.put(graphZoneFabric);
                    }
                }
            }
            object4 = graphModel2.enumerateID(GraphZone.TYPE);
            while (object4.hasMoreElements()) {
                iD = (GraphZone.ID)object4.nextElement();
                hashSet = new HashSet<Comparable>();
                enumeration = graphModel.associator(GraphZone2ZoneMember.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    object3 = (GraphZoneMember)enumeration.nextElement();
                    comparable4 = ((GraphZoneMember)object3).getParentID();
                    hashSet.add(comparable4);
                }
                object3 = hashSet.iterator();
                while (object3.hasNext()) {
                    comparable4 = (GraphEntity.ID)object3.next();
                    comparable3 = graphModel.get((GraphEntity.ID)comparable4);
                    object2 = ((GraphEntity)comparable3).getDisplayName();
                    object = new GraphZoneMember(((GraphEntity.ID)comparable4).getID().toString());
                    comparable2 = (GraphZoneMember.ID)((GraphEntity)object).getEntityID();
                    ((GraphZoneMember)object).setParentID((GraphEntity.ID)comparable4);
                    ((GraphZoneMember)object).setParentLabel((String)object2);
                    graphModel2.put((GraphEntity)object);
                    comparable = new GraphZone2ZoneMember(iD.getID() + "+" + ((GraphEntity.ID)comparable2).getID());
                    ((GraphZone2ZoneMember)comparable).setZoneID((GraphZone.ID)iD);
                    ((GraphZone2ZoneMember)comparable).setZoneMemberID((GraphZoneMember.ID)comparable2);
                    graphModel2.put((GraphEntity)comparable);
                }
            }
        }

        private void addZones_L1Fabric(GraphModel graphModel, GraphModel graphModel2, GraphFabric.ID iD) {
            GraphEntity graphEntity;
            Object object;
            GraphEntity graphEntity2;
            Comparable comparable;
            Object object2;
            Object object3;
            Object object4;
            GraphEntity.ID iD2;
            Object object5;
            Enumeration enumeration = graphModel.enumerate(GraphZoneFabric.TYPE);
            while (enumeration.hasMoreElements()) {
                object5 = (GraphZoneFabric)enumeration.nextElement();
                if (!((GraphZoneFabric)object5).getFabricID().equals(iD)) continue;
                iD2 = (GraphZoneFabric.ID)((GraphEntity)object5).getEntityID();
                object5 = (GraphZoneFabric)((GraphZoneFabric)object5).clone();
                graphModel2.put((GraphEntity)object5);
                object4 = graphModel.reference(GraphZoneFabric2Zone.TYPE, iD2);
                while (object4.hasMoreElements()) {
                    object3 = (GraphZoneFabric2Zone)object4.nextElement();
                    object3 = (GraphZoneFabric2Zone)((GraphZoneFabric2Zone)object3).clone();
                    graphModel2.put((GraphEntity)object3);
                    object2 = ((GraphZoneFabric2Zone)object3).getZoneID();
                    comparable = (GraphZone)graphModel.get((GraphEntity.ID)object2);
                    comparable = (GraphZone)((GraphZone)comparable).clone();
                    graphModel2.put((GraphEntity)comparable);
                }
                object3 = graphModel.reference(GraphZoneFabric2ZoneSet.TYPE, iD2);
                while (object3.hasMoreElements()) {
                    object2 = (GraphZoneFabric2ZoneSet)object3.nextElement();
                    object2 = (GraphZoneFabric2ZoneSet)((GraphZoneFabric2ZoneSet)object2).clone();
                    graphModel2.put((GraphEntity)object2);
                    comparable = ((GraphZoneFabric2ZoneSet)object2).getZoneSetID();
                    graphEntity2 = (GraphZoneSet)graphModel.get((GraphEntity.ID)comparable);
                    graphEntity2 = (GraphZoneSet)((GraphZoneSet)graphEntity2).clone();
                    graphModel2.put(graphEntity2);
                    object = graphModel.reference(GraphZoneSet2Zone.TYPE, (GraphEntity.ID)comparable);
                    while (object.hasMoreElements()) {
                        graphEntity = (GraphZoneSet2Zone)object.nextElement();
                        graphEntity = (GraphZoneSet2Zone)((GraphZoneSet2Zone)graphEntity).clone();
                        graphModel2.put(graphEntity);
                    }
                }
            }
            object5 = graphModel2.enumerateID(GraphZone.TYPE);
            while (object5.hasMoreElements()) {
                iD2 = (GraphZone.ID)object5.nextElement();
                object4 = new HashSet();
                object3 = graphModel.associator(GraphZone2ZoneMember.TYPE, iD2);
                while (object3.hasMoreElements()) {
                    object2 = (GraphZoneMember)object3.nextElement();
                    comparable = ((GraphZoneMember)object2).getParentID();
                    ((HashSet)object4).add(comparable);
                }
                object2 = ((HashSet)object4).iterator();
                while (object2.hasNext()) {
                    comparable = (GraphEntity.ID)object2.next();
                    graphEntity2 = graphModel.get((GraphEntity.ID)comparable);
                    object = graphEntity2.getDisplayName();
                    graphEntity = new GraphZoneMember(((GraphEntity.ID)comparable).getID().toString());
                    GraphZoneMember.ID iD3 = (GraphZoneMember.ID)graphEntity.getEntityID();
                    ((GraphZoneMember)graphEntity).setParentID((GraphEntity.ID)comparable);
                    ((GraphZoneMember)graphEntity).setParentLabel((String)object);
                    graphModel2.put(graphEntity);
                    GraphZone2ZoneMember graphZone2ZoneMember = new GraphZone2ZoneMember(iD2.getID() + "+" + iD3.getID());
                    graphZone2ZoneMember.setZoneID((GraphZone.ID)iD2);
                    graphZone2ZoneMember.setZoneMemberID(iD3);
                    graphModel2.put(graphZone2ZoneMember);
                }
            }
        }

        private GraphModelPinList generatePinList(GraphModelPinList.ID iD) {
            GraphModelPinList graphModelPinList = new GraphModelPinList(iD);
            Vector vector = iD.getChildFocusEntityIDs();
            int n = 0;
            while (n < vector.size()) {
                GraphEntity graphEntity;
                Enumeration enumeration;
                GraphEntity graphEntity2;
                GraphEntity.ID iD2 = (GraphEntity.ID)vector.elementAt(n);
                if (iD2 instanceof GraphComputer.ID) {
                    graphEntity2 = (GraphComputer)this.model.get(iD2);
                    if (graphEntity2 != null) {
                        graphEntity2 = (GraphComputer)((GraphComputer)graphEntity2).clone();
                        graphModelPinList.put(graphEntity2);
                        enumeration = this.model.reference(GraphFabric2Computer.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric2Computer)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.associator(GraphFabric2Computer.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                    }
                } else if (iD2 instanceof GraphSwitch.ID) {
                    graphEntity2 = (GraphSwitch)this.model.get(iD2);
                    if (graphEntity2 != null) {
                        graphEntity2 = (GraphSwitch)((GraphSwitch)graphEntity2).clone();
                        graphModelPinList.put(graphEntity2);
                        enumeration = this.model.reference(GraphFabric2Switch.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric2Switch)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.associator(GraphFabric2Switch.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.reference(GraphSwitch2SwitchPerf.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphSwitch2SwitchPerf)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.associator(GraphSwitch2SwitchPerf.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphSwitchPerf)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                    }
                } else if (iD2 instanceof GraphSubsystem.ID) {
                    graphEntity2 = (GraphSubsystem)this.model.get(iD2);
                    if (graphEntity2 != null) {
                        graphEntity2 = (GraphSubsystem)((GraphSubsystem)graphEntity2).clone();
                        graphModelPinList.put(graphEntity2);
                        enumeration = this.model.reference(GraphFabric2Subsystem.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric2Subsystem)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.associator(GraphFabric2Subsystem.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                    }
                } else if (iD2 instanceof GraphTapeLibrary.ID) {
                    graphEntity2 = (GraphTapeLibrary)this.model.get(iD2);
                    if (graphEntity2 != null) {
                        graphEntity2 = (GraphTapeLibrary)((GraphTapeLibrary)graphEntity2).clone();
                        graphModelPinList.put(graphEntity2);
                        enumeration = this.model.reference(GraphFabric2TapeLibrary.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric2TapeLibrary)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                        enumeration = this.model.associator(GraphFabric2TapeLibrary.TYPE, iD2);
                        while (enumeration.hasMoreElements()) {
                            graphEntity = (GraphFabric)enumeration.nextElement();
                            graphModelPinList.put(graphEntity);
                        }
                    }
                } else if (iD2 instanceof GraphOther.ID && (graphEntity2 = (GraphOther)this.model.get(iD2)) != null) {
                    graphEntity2 = (GraphOther)((GraphOther)graphEntity2).clone();
                    graphModelPinList.put(graphEntity2);
                    enumeration = this.model.reference(GraphFabric2Other.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        graphEntity = (GraphFabric2Other)enumeration.nextElement();
                        graphModelPinList.put(graphEntity);
                    }
                    enumeration = this.model.associator(GraphFabric2Other.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        graphEntity = (GraphFabric)enumeration.nextElement();
                        graphModelPinList.put(graphEntity);
                    }
                }
                ++n;
            }
            return graphModelPinList;
        }

        public void simulateDataChange_SubsystemStatus(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                GraphSubsystem.ID iD = new GraphSubsystem.ID(string);
                GraphSubsystem graphSubsystem = (GraphSubsystem)this.model.get(iD);
                graphSubsystem.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                ++n;
            }
        }

        public void simulateDataChange_ComputerStatus(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                GraphComputer.ID iD = new GraphComputer.ID(string);
                GraphComputer graphComputer = (GraphComputer)this.model.get(iD);
                graphComputer.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                ++n;
            }
        }

        public void simulateDataChange_InvalidFabric(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                Comparable comparable;
                String string = stringArray[n];
                GraphFabric.ID iD = new GraphFabric.ID(string);
                this.model.remove(iD);
                Enumeration enumeration = this.model.reference(GraphFabric2Switch.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    Comparable comparable2;
                    comparable = (GraphFabric2Switch)enumeration.nextElement();
                    GraphFabric2Switch.ID iD2 = (GraphFabric2Switch.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD2);
                    GraphSwitch.ID iD3 = ((GraphFabric2Switch)comparable).getSwitchID();
                    Enumeration enumeration2 = this.model.referenceID(GraphSwitch2Switch.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2Switch.ID)enumeration2.nextElement();
                        this.model.remove((GraphEntity.ID)comparable2);
                    }
                    enumeration2 = this.model.referenceID(GraphSwitch2Computer.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2Computer.ID)enumeration2.nextElement();
                        this.model.remove((GraphEntity.ID)comparable2);
                    }
                    enumeration2 = this.model.referenceID(GraphSwitch2Subsystem.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2Subsystem.ID)enumeration2.nextElement();
                        this.model.remove((GraphEntity.ID)comparable2);
                    }
                    enumeration2 = this.model.referenceID(GraphSwitch2TapeLibrary.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2TapeLibrary.ID)enumeration2.nextElement();
                        this.model.remove((GraphEntity.ID)comparable2);
                    }
                    enumeration2 = this.model.referenceID(GraphSwitch2Other.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2Other.ID)enumeration2.nextElement();
                        this.model.remove((GraphEntity.ID)comparable2);
                    }
                    enumeration2 = this.model.reference(GraphSwitch2FCPort.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        comparable2 = (GraphSwitch2FCPort)enumeration2.nextElement();
                        GraphSwitch2FCPort.ID iD4 = (GraphSwitch2FCPort.ID)((GraphEntity)comparable2).getEntityID();
                        this.model.remove(iD4);
                        GraphFCPort.ID iD5 = ((GraphSwitch2FCPort)comparable2).getFCPortID();
                        this.model.remove(iD5);
                        Enumeration enumeration3 = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD5);
                        while (enumeration3.hasMoreElements()) {
                            GraphFCPort2FCPort.ID iD6 = (GraphFCPort2FCPort.ID)enumeration3.nextElement();
                            this.model.remove(iD6);
                        }
                    }
                }
                enumeration = this.model.referenceID(GraphFabric2Computer.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphFabric2Computer.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration = this.model.referenceID(GraphFabric2Subsystem.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphFabric2Subsystem.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphFabric2TapeLibrary.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration = this.model.referenceID(GraphFabric2Other.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphFabric2Other.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidSwitch(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                GraphEntity.ID iD;
                Object object;
                Enumeration enumeration;
                GraphEntity.ID iD2;
                GraphEntity.ID iD3;
                Comparable comparable;
                String string = stringArray[n];
                GraphSwitch.ID iD4 = new GraphSwitch.ID(string);
                this.model.remove(iD4);
                HashSet hashSet = new HashSet();
                Enumeration enumeration2 = this.model.reference(GraphFabric2Switch.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphFabric2Switch)enumeration2.nextElement();
                    iD3 = (GraphFabric2Switch.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphFabric2Switch)comparable).getFabricID();
                    enumeration = this.model.associatorID(GraphFabric2Switch.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        hashSet.add(enumeration.nextElement());
                    }
                }
                enumeration2 = this.model.referenceID(GraphSwitch2Switch.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Switch.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.reference(GraphSwitch2Computer.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Computer)enumeration2.nextElement();
                    iD3 = (GraphSwitch2Computer.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSwitch2Computer)comparable).getComputerID();
                    boolean bl = false;
                    object = this.model.associatorID(GraphSwitch2Computer.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphSwitch.ID)object.nextElement();
                        if (!hashSet.contains(iD)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    object = this.model.referenceID(GraphFabric2Computer.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphFabric2Computer.ID)object.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSwitch2Subsystem.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Subsystem)enumeration2.nextElement();
                    iD3 = (GraphSwitch2Subsystem.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSwitch2Subsystem)comparable).getSubsystemID();
                    boolean bl = false;
                    object = this.model.associatorID(GraphSwitch2Subsystem.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphSwitch.ID)object.nextElement();
                        if (!hashSet.contains(iD)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    object = this.model.referenceID(GraphFabric2Subsystem.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphFabric2Subsystem.ID)object.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSwitch2TapeLibrary.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2TapeLibrary)enumeration2.nextElement();
                    iD3 = (GraphSwitch2TapeLibrary.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSwitch2TapeLibrary)comparable).getTapeLibraryID();
                    boolean bl = false;
                    object = this.model.associatorID(GraphSwitch2TapeLibrary.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphSwitch.ID)object.nextElement();
                        if (!hashSet.contains(iD)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    object = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphFabric2TapeLibrary.ID)object.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSwitch2Other.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Other)enumeration2.nextElement();
                    iD3 = (GraphSwitch2Other.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSwitch2Other)comparable).getOtherID();
                    boolean bl = false;
                    object = this.model.associatorID(GraphSwitch2Other.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphSwitch.ID)object.nextElement();
                        if (!hashSet.contains(iD)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    object = this.model.referenceID(GraphFabric2Other.TYPE, iD2);
                    while (object.hasMoreElements()) {
                        iD = (GraphFabric2Other.ID)object.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSwitch2FCPort.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2FCPort)enumeration2.nextElement();
                    iD3 = (GraphSwitch2FCPort.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSwitch2FCPort)comparable).getFCPortID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        object = (GraphFCPort2FCPort.ID)enumeration.nextElement();
                        this.model.remove((GraphEntity.ID)object);
                    }
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidComputer(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                GraphEntity.ID iD;
                Enumeration enumeration;
                GraphEntity.ID iD2;
                GraphEntity.ID iD3;
                Comparable comparable;
                String string = stringArray[n];
                GraphComputer.ID iD4 = new GraphComputer.ID(string);
                this.model.remove(iD4);
                Enumeration enumeration2 = this.model.referenceID(GraphFabric2Computer.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphFabric2Computer.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.referenceID(GraphSwitch2Computer.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Computer.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.reference(GraphComputer2FCPort.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphComputer2FCPort)enumeration2.nextElement();
                    iD3 = (GraphComputer2FCPort.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphComputer2FCPort)comparable).getFCPortID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphFCPort2FCPort.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphComputer2HBA.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphComputer2HBA)enumeration2.nextElement();
                    iD3 = (GraphComputer2HBA.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphComputer2HBA)comparable).getHBAID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphHBA2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphHBA2FCPort.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphComputer2Lun.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphComputer2Lun)enumeration2.nextElement();
                    iD3 = (GraphComputer2Lun.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphComputer2Lun)comparable).getLunID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphVolume2Lun.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphVolume2Lun.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidSubsystem(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                GraphEntity.ID iD;
                Enumeration enumeration;
                GraphEntity.ID iD2;
                GraphEntity.ID iD3;
                Comparable comparable;
                String string = stringArray[n];
                GraphSubsystem.ID iD4 = new GraphSubsystem.ID(string);
                this.model.remove(iD4);
                Enumeration enumeration2 = this.model.referenceID(GraphFabric2Subsystem.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphFabric2Subsystem.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.referenceID(GraphSwitch2Subsystem.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2Subsystem.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.reference(GraphSubsystem2FCPort.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSubsystem2FCPort)enumeration2.nextElement();
                    iD3 = (GraphSubsystem2FCPort.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSubsystem2FCPort)comparable).getFCPortID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphFCPort2FCPort.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSubsystem2Disk.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSubsystem2Disk)enumeration2.nextElement();
                    iD3 = (GraphSubsystem2Disk.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSubsystem2Disk)comparable).getDiskID();
                    this.model.remove(iD2);
                }
                enumeration2 = this.model.reference(GraphSubsystem2Pool.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSubsystem2Pool)enumeration2.nextElement();
                    iD3 = (GraphSubsystem2Pool.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSubsystem2Pool)comparable).getPoolID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphPool2Disk.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphPool2Disk.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                    enumeration = this.model.referenceID(GraphPool2Volume.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphPool2Volume.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphSubsystem2Volume.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSubsystem2Volume)enumeration2.nextElement();
                    iD3 = (GraphSubsystem2Volume.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphSubsystem2Volume)comparable).getVolumeID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphVolume2Lun.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphVolume2Lun.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidTapeLibrary(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                GraphEntity.ID iD;
                Enumeration enumeration;
                GraphEntity.ID iD2;
                GraphEntity.ID iD3;
                Comparable comparable;
                String string = stringArray[n];
                GraphTapeLibrary.ID iD4 = new GraphTapeLibrary.ID(string);
                this.model.remove(iD4);
                Enumeration enumeration2 = this.model.referenceID(GraphFabric2TapeLibrary.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphFabric2TapeLibrary.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.referenceID(GraphSwitch2TapeLibrary.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphSwitch2TapeLibrary.ID)enumeration2.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration2 = this.model.reference(GraphTapeLibrary2FCPort.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphTapeLibrary2FCPort)enumeration2.nextElement();
                    iD3 = (GraphTapeLibrary2FCPort.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphTapeLibrary2FCPort)comparable).getFCPortID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphFCPort2FCPort.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphTapeLibrary2TapeDrive.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphTapeLibrary2TapeDrive)enumeration2.nextElement();
                    iD3 = (GraphTapeLibrary2TapeDrive.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphTapeLibrary2TapeDrive)comparable).getTapeDriveID();
                    this.model.remove(iD2);
                    enumeration = this.model.referenceID(GraphTapeDrive2FCPort.TYPE, iD2);
                    while (enumeration.hasMoreElements()) {
                        iD = (GraphTapeDrive2FCPort.ID)enumeration.nextElement();
                        this.model.remove(iD);
                    }
                }
                enumeration2 = this.model.reference(GraphTapeLibrary2MediaChanger.TYPE, iD4);
                while (enumeration2.hasMoreElements()) {
                    comparable = (GraphTapeLibrary2MediaChanger)enumeration2.nextElement();
                    iD3 = (GraphTapeLibrary2MediaChanger.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD3);
                    iD2 = ((GraphTapeLibrary2MediaChanger)comparable).getMediaChangerID();
                    this.model.remove(iD2);
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }

        public void simulateDataChange_InvalidOther(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                Comparable comparable;
                String string = stringArray[n];
                GraphOther.ID iD = new GraphOther.ID(string);
                this.model.remove(iD);
                Enumeration enumeration = this.model.referenceID(GraphFabric2Other.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphFabric2Other.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration = this.model.referenceID(GraphSwitch2Other.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphSwitch2Other.ID)enumeration.nextElement();
                    this.model.remove((GraphEntity.ID)comparable);
                }
                enumeration = this.model.reference(GraphOther2FCPort.TYPE, iD);
                while (enumeration.hasMoreElements()) {
                    comparable = (GraphOther2FCPort)enumeration.nextElement();
                    GraphOther2FCPort.ID iD2 = (GraphOther2FCPort.ID)((GraphEntity)comparable).getEntityID();
                    this.model.remove(iD2);
                    GraphFCPort.ID iD3 = ((GraphOther2FCPort)comparable).getFCPortID();
                    this.model.remove(iD3);
                    Enumeration enumeration2 = this.model.referenceID(GraphFCPort2FCPort.TYPE, iD3);
                    while (enumeration2.hasMoreElements()) {
                        GraphFCPort2FCPort.ID iD4 = (GraphFCPort2FCPort.ID)enumeration2.nextElement();
                        this.model.remove(iD4);
                    }
                }
                ++n;
            }
            this.model.calculateFabricMeta();
        }
    }
}

