/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummary;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoSummaryWithTitle
extends AbstractJTopoNode {
    protected TitlePanel titlePanel;
    protected SummaryPanel summaryPanel;

    protected AbstractJTopoSummaryWithTitle() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoSummaryWithTitle(ITopoGroupModel iTopoGroupModel, boolean bl) {
        super(iTopoGroupModel, bl);
        iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        this.titlePanel = new TitlePanel(iTopoGroupModel);
        this.summaryPanel = new SummaryPanel(iTopoGroupModel);
        this.initState();
    }

    private void initState() {
        this.titlePanel.setLogicalParent(this);
        this.summaryPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.summaryPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.summaryPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas abstractJTopoCanvas, String string) {
        super.setSessionModel(abstractJTopoCanvas, string);
        this.titlePanel.setSessionModel(abstractJTopoCanvas, string);
        this.summaryPanel.setSessionModel(abstractJTopoCanvas, string);
    }

    public void setDataModel(GraphEntity graphEntity) {
        super.setDataModel(graphEntity);
        this.titlePanel.setDataModel(graphEntity);
        this.summaryPanel.setDataModel(graphEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public SummaryPanel getSummaryPanel() {
        return this.summaryPanel;
    }

    protected Object createWidgetModel() {
        return new DefaultTopoGroupModel();
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.summaryPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.summaryPanel.selectionChanged();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.summaryPanel.highlightChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder compoundBorder = null;
        compoundBorder = iTopoEntityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(compoundBorder);
    }

    public Vector getSummaries() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        return iTopoGroupModel.getSummaries();
    }

    public void setSummaries(Vector vector) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.setSummaries(vector);
    }

    public void addSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.addSummary(summary);
    }

    public void removeSummary(ITopoGroupModel.Summary summary) {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.removeSummary(summary);
    }

    public void removeAllSummaries() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        iTopoGroupModel.removeAllSummaries();
    }

    protected Point getConnectingPoint() {
        Point point = this.titlePanel.getConnectingPoint();
        Point point2 = new Point(this.getX() + point.x, this.getY() + point.y);
        return point2;
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.titlePanel.setOverlayHealthEnabled(bl);
        this.summaryPanel.setOverlayHealthEnabled(bl);
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.titlePanel.setOverlayPerfEnabled(bl);
        this.summaryPanel.setOverlayPerfEnabled(bl);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
        this.titlePanel.setArrange(arrangeRecord);
        this.summaryPanel.setArrange(arrangeRecord);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel iTopoNodeModel) {
            super(iTopoNodeModel, false);
            this.setStrCounterEnabled(false);
        }

        protected void reattach() {
        }

        protected void modelChanged_setCounter() {
        }
    }

    protected class SummaryPanel
    extends AbstractJTopoSummary {
        public SummaryPanel(ITopoGroupModel iTopoGroupModel) {
            super(iTopoGroupModel, false);
        }

        protected void reattach() {
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            int n = 0;
            int n2 = 0;
            Dimension dimension2 = AbstractJTopoSummaryWithTitle.this.titlePanel.getPreferredSize();
            n2 += dimension2.height;
            dimension2 = AbstractJTopoSummaryWithTitle.this.summaryPanel.getPreferredSize();
            n = dimension2.width > (n += dimension2.width) ? dimension2.width : n;
            dimension.width += n;
            dimension.height += (n2 += dimension2.height);
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            Dimension dimension = AbstractJTopoSummaryWithTitle.this.titlePanel.getPreferredSize();
            Rectangle rectangle = new Rectangle();
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = container.getWidth() - insets.left - insets.right;
            rectangle.height = dimension.height;
            AbstractJTopoSummaryWithTitle.this.titlePanel.setBounds(rectangle);
            dimension = AbstractJTopoSummaryWithTitle.this.summaryPanel.getPreferredSize();
            rectangle = new Rectangle();
            rectangle.x = n;
            rectangle.y = n2 += AbstractJTopoSummaryWithTitle.this.titlePanel.getHeight();
            rectangle.width = AbstractJTopoSummaryWithTitle.this.titlePanel.getWidth();
            rectangle.height = dimension.height;
            AbstractJTopoSummaryWithTitle.this.summaryPanel.setBounds(rectangle);
        }
    }
}

