/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchFCPortPerf;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoIcon;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoIconSwitchFCPort
extends AbstractJTopoIcon {
    public JTopoIconSwitchFCPort() {
        this.maxLabelWidth_compact = 40;
        this.maxLabelWidth_relax = 120;
    }

    protected void reattach() {
        if (this.focusEntity == null) {
            return;
        }
        GraphFCPort graphFCPort = (GraphFCPort)this.focusEntity;
        ITopoNodeModel iTopoNodeModel = (ITopoNodeModel)this.widgetModel;
        iTopoNodeModel.setType(GuiUtil.getString("TOPO_LABEL_ENTITY_FCPORT"));
        String string = graphFCPort.getPortNumber();
        String string2 = graphFCPort.getDisplayName();
        if (string != null) {
            iTopoNodeModel.setLabel(string);
        } else {
            iTopoNodeModel.setLabel(string2);
        }
        iTopoNodeModel.setHealth(graphFCPort.getHealthStatus());
        boolean bl = false;
        Enumeration enumeration = this.canvas.getDataModel().associator(GraphFCPort2FCPort.TYPE, this.focusEntityID);
        if (enumeration.hasMoreElements()) {
            bl = true;
        }
        if (bl) {
            iTopoNodeModel.setIconSelected(TopoResource.ICON_FCPORT_USED_SELECTED);
            iTopoNodeModel.setIconUnselected(TopoResource.ICON_FCPORT_USED_UNSELECTED);
            iTopoNodeModel.setIconMissing(TopoResource.ICON_FCPORT_USED_MISSING);
        } else {
            iTopoNodeModel.setIconSelected(TopoResource.ICON_FCPORT_EMPTY_SELECTED);
            iTopoNodeModel.setIconUnselected(TopoResource.ICON_FCPORT_EMPTY_UNSELECTED);
            iTopoNodeModel.setIconMissing(TopoResource.ICON_FCPORT_EMPTY_MISSING);
        }
        iTopoNodeModel.setPerf(graphFCPort.getPerfStatus());
        String string3 = null;
        enumeration = this.canvas.getDataModel().associator(GraphFCPort2SwitchFCPortPerf.TYPE, this.focusEntityID);
        if (enumeration.hasMoreElements()) {
            GraphSwitchFCPortPerf graphSwitchFCPortPerf = (GraphSwitchFCPortPerf)enumeration.nextElement();
            String string4 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getPacketRateRx());
            String string5 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getPacketRateTx());
            String string6 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getDataRateRx());
            String string7 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getDataRateTx());
            String string8 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getErrorFrameRate());
            String string9 = GraphModelUtilities.formatDouble(graphSwitchFCPortPerf.getLinkFailureRate());
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.common.meta.MdRbMetrics");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<HTML>");
            stringBuffer.append(GraphModelUtilities.getTooltipPerf(graphFCPort.getPerfStatus()));
            stringBuffer.append("<HR width=120 align=left>");
            stringBuffer.append("<TABLE>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_PORT_SEND_PKT_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string5 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_PORT_RECV_PKT_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string4 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_PORT_SEND_DATA_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string7 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_PORT_RECV_DATA_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string6 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_ERR_FRAME_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string8 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("<TR>");
            stringBuffer.append("<TD>" + resourceBundle.getString("MET_LNK_FAIL_RATE_NAME") + ":" + "</TD>");
            stringBuffer.append("<TD>" + string9 + "</TD>");
            stringBuffer.append("</TR>");
            stringBuffer.append("</TABLE>");
            stringBuffer.append("</HTML>");
            string3 = stringBuffer.toString();
        }
        iTopoNodeModel.setPerfTooltip(string3);
        iTopoNodeModel.fireModelChanged();
    }
}

