/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.aperi.common.api.DeviceStatus;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCapabilityDataTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResNodeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRedundancyTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaChangerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public final class DBConstants {
    private static ILogger dblogger = null;
    private static Map cAutoIdMap;
    public static final int INVALID_INT_VALUE = Integer.MIN_VALUE;
    public static final short INVALID_SHORT_VALUE = Short.MIN_VALUE;
    public static final double INVALID_DOUBLE_VALUE = Double.MIN_VALUE;
    public static final float INVALID_FLOAT_VALUE = Float.MIN_VALUE;
    public static final long INVALID_LONG_VALUE = Long.MIN_VALUE;
    public static final String INVALID_STRING_VALUE;
    public static final Timestamp INVALID_TIMESTAMP_VALUE;
    public static final byte[] INVALID_BYTE_ARRAY_VALUE;
    public static final Date INVALID_DATE_VALUE;
    public static final Time INVALID_TIME_VALUE;
    public static final Clob INVALID_CLOB_VALUE;
    public static final BigDecimal INVALID_BIGDECIMAL_VALUE;
    public static final String NULL_STRING_VALUE = "__NULL__";
    public static final int NULL_INT_VALUE = 0;
    public static final short NULL_SHORT_VALUE = 0;
    public static final double NULL_DOUBLE_VALUE = 0.0;
    public static final float NULL_FLOAT_VALUE = 0.0f;
    public static final long NULL_LONG_VALUE = 0L;
    public static final Timestamp NULL_TIMESTAMP_VALUE;
    public static final byte[] NULL_BYTE_ARRAY_VALUE;
    public static final Date NULL_DATE_VALUE;
    public static final Time NULL_TIME_VALUE;
    public static final Clob NULL_CLOB_VALUE;
    public static final BigDecimal NULL_BIGDECIMAL_VALUE;
    public static final String ESS = "ESS";
    public static final String DS6000 = "DS6000";
    public static final String DS8000 = "DS8000";
    public static final String SVC = "SVC";
    public static final String FASTT = "FAStT";
    public static final String HDS = "HDS";
    public static final String EMC = "EMC";
    public static final String HP = "HP";
    public static final String HP_XP128 = "XP128";
    public static final String FUJITSU = "FUJITSU";
    public static final String SUN = "SUN";
    public static final String SMIS_102_ARRAY = "SMI-S 1.0.2 Array";
    public static final String SMIS_102_INBAND = "SMI-S 1.0.2 Inband";
    public static final String SMIS_103_ARRAY = "SMI-S 1.0.3 Array";
    public static final String SMIS_103_INBAND = "SMI-S 1.0.3 Inband";
    public static final String SMIS_11_ARRAY = "SMI-S 1.1 Array";
    public static final String SMIS_11_INBAND = "SMI-S 1.1 Inband";
    public static final String UNKNOWN = "Unknown";
    public static final short FALSE_SHORT = 0;
    public static final short TRUE_SHORT = 1;
    public static final int STATEMENT_RETURNS_GENERATED_KEYS = 1;
    public static boolean useLogging;
    public static final String NAMEFORMAT_LOOKUP = "Name_Format";
    private static Hashtable Name_Format;
    private static Hashtable Name_Format_Reverse;
    public static final String SMISNAMEFORMAT_LOOKUP = "SMISName_Format";
    private static Hashtable SMISName_Format;
    private static Hashtable SMISName_Format_Reverse;
    public static final String PORTTYPES_LOOKUP = "Port_Types";
    private static Hashtable Port_Types;
    private static Hashtable Port_Types_Reverse;
    public static final String BOOLEAN_LOOKUP = "Boolean";
    private static Hashtable Boolean;
    private static Hashtable Boolean_Reverse;
    public static final String OPERATIONALSTATUS_LOOKUP = "Operational_Status";
    private static Hashtable Operational_Status;
    private static Hashtable Operational_Status_Reverse;
    public static final String ZONETYPE_LOOKUP = "Zone_Type";
    private static Hashtable Zone_Type;
    private static Hashtable Zone_Type_Reverse;
    public static final String ZONEVENDORTYPE_LOOKUP = "Zone_Vendor_Type";
    private static Hashtable Zone_Vendor_Type;
    private static Hashtable Zone_Vendor_Type_Reverse;
    public static final String ZONEVENDORSUBTYPE_LOOKUP = "Zone_Vendor_Sub_Type";
    private static Hashtable Zone_Vendor_Sub_Type;
    private static Hashtable Zone_Vendor_Sub_Type_Reverse;
    public static final String ZONEMEMBERTYPE_LOOKUP = "Zone_Member_Type";
    private static Hashtable Zone_Member_Type;
    private static Hashtable Zone_Member_Type_Reverse;
    public static final String ZONEMEMBERVENDORYTYPE_LOOKUP = "Zone_Member_Vendor_Type";
    private static Hashtable Zone_Member_Vendor_Type;
    private static Hashtable Zone_Member_Vendor_Type_Reverse;
    public static final String SANZONECAPABILITIES_LOOKUP = "SAN_Zone_Capabilities";
    private static Hashtable SAN_Zone_Capabilities;
    private static Hashtable SAN_Zone_Capabilities_Reverse;
    public static final String BLADESTATUS_LOOKUP = "Blade_Status";
    private static Hashtable Blade_Status;
    private static Hashtable Blate_Status_Reverse;
    public static final String BLADESTATUSOP2CONSTATUS_LOOKUP = "Blade_Consolidated_Status";
    private static Hashtable Blade_Consolidated_Status;
    private static Hashtable Blade_Consolidated_Status_Reverse;
    public static final String PESCSITYPE_LOOKUP = "PE_SCSI_Type";
    private static Hashtable PE_SCSI_Type;
    private static Hashtable PE_SCSI_Type_Reverse;
    public static final String OSTYPE_LOOKUP = "OS_Type";
    private static Hashtable OS_Type;
    private static Hashtable OS_Type_Reverse;
    public static final String OSNAMETYPE_LOOKUP = "OS_Name_Type";
    private static Hashtable OS_Name_Type;
    private static Hashtable OS_Name_Type_Reverse;
    public static final String NODETYPE_LOOKUP = "Node_Type";
    private static Hashtable Node_Type;
    private static Hashtable Node_Type_Reverse;
    public static final String NODESCSISUPPORT_LOOKUP = "Node_SCSI_Support";
    private static Hashtable Node_SCSI_Support;
    private static Hashtable Node_SCSI_Support_Reverse;
    public static final String IPADDRESSTYPE_LOOKUP = "IP_Address_Type";
    private static Hashtable IP_Address_Type;
    private static Hashtable IP_Address_Type_Reverse;
    public static final String OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP = "Operational2ConsolidatedStatus";
    private static Hashtable Operational2ConsolidatedStatus;
    private static Hashtable Operational2ConsolidatedStatus_Reverse;
    public static final String VDISKTYPE_LOOKUP = "Vdisk_Type";
    private static Hashtable Vdisk_Type;
    private static Hashtable Vdisk_Type_Reverse;
    public static final String ESSFORMAT_LOOKUP = "ESS_Format";
    private static Hashtable ESS_Format;
    private static Hashtable ESS_Format_Reverse;
    public static final String EXTENTTYPE_LOOKUP = "ESS_Format";
    public static final String DSRAIDLEVELFORMAT_LOOKUP = "DSRAIDLEVEL_Format";
    private static Hashtable DSRAIDLEVEL_Format;
    private static Hashtable DSRAIDLEVEL_Format_Reverse;
    public static final String DSRAIDLEVELNUMBERFORMAT_LOOKUP = "DSRAIDLEVELNUMBER_Format";
    private static Hashtable DSRAIDLEVELNUMBER_Format;
    private static Hashtable DSRAIDLEVELNUMBER_Format_Reverse;
    public static final String DSFORMAT_LOOKUP = "DS_Format";
    private static Hashtable DS_Format;
    private static Hashtable DS_Format_Reverse;
    public static final String FABRICSTATUS_LOOKUP = "Fabric_Status";
    private static Hashtable Fabric_Status;
    private static Hashtable Fabric_Status_Reverse;
    public static final String CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP = "CIM_ELE_OP2CON_Status";
    private static Hashtable CIM_ELE_OP2CON_Status;
    private static Hashtable CIM_ELE_OP2CON_Status_Reverse;
    public static final String TAPEMEDIATYPESUPPORTED_LOOKUP = "TAPE_MEDIA_TYPE_SUPPORTED";
    private static Hashtable TAPE_MEDIA_TYPE_SUPPORTED;
    private static Hashtable TAPE_MEDIA_TYPE_SUPPORTED_Reverse;

    static {
        INVALID_STRING_VALUE = null;
        INVALID_TIMESTAMP_VALUE = null;
        INVALID_BYTE_ARRAY_VALUE = null;
        INVALID_DATE_VALUE = null;
        INVALID_TIME_VALUE = null;
        INVALID_CLOB_VALUE = null;
        INVALID_BIGDECIMAL_VALUE = new BigDecimal(Double.MIN_VALUE);
        NULL_TIMESTAMP_VALUE = new Timestamp(0L);
        NULL_BYTE_ARRAY_VALUE = NULL_STRING_VALUE.getBytes();
        NULL_DATE_VALUE = new Date(0L);
        NULL_TIME_VALUE = new Time(0L);
        NULL_CLOB_VALUE = null;
        NULL_BIGDECIMAL_VALUE = new BigDecimal(0);
        useLogging = true;
        Name_Format = new Hashtable();
        Name_Format_Reverse = new Hashtable();
        SMISName_Format = new Hashtable();
        SMISName_Format_Reverse = new Hashtable();
        Port_Types = new Hashtable();
        Port_Types_Reverse = new Hashtable();
        Boolean = new Hashtable();
        Boolean_Reverse = new Hashtable();
        Operational_Status = new Hashtable();
        Operational_Status_Reverse = new Hashtable();
        Zone_Type = new Hashtable();
        Zone_Type_Reverse = new Hashtable();
        Zone_Vendor_Type = new Hashtable();
        Zone_Vendor_Type_Reverse = new Hashtable();
        Zone_Vendor_Sub_Type = new Hashtable();
        Zone_Vendor_Sub_Type_Reverse = new Hashtable();
        Zone_Member_Type = new Hashtable();
        Zone_Member_Type_Reverse = new Hashtable();
        Zone_Member_Vendor_Type = new Hashtable();
        Zone_Member_Vendor_Type_Reverse = new Hashtable();
        SAN_Zone_Capabilities = new Hashtable();
        SAN_Zone_Capabilities_Reverse = new Hashtable();
        Blade_Status = new Hashtable();
        Blate_Status_Reverse = new Hashtable();
        Blade_Consolidated_Status = new Hashtable();
        Blade_Consolidated_Status_Reverse = new Hashtable();
        PE_SCSI_Type = new Hashtable();
        PE_SCSI_Type_Reverse = new Hashtable();
        OS_Type = new Hashtable();
        OS_Type_Reverse = new Hashtable();
        OS_Name_Type = new Hashtable();
        OS_Name_Type_Reverse = new Hashtable();
        Node_Type = new Hashtable();
        Node_Type_Reverse = new Hashtable();
        Node_SCSI_Support = new Hashtable();
        Node_SCSI_Support_Reverse = new Hashtable();
        IP_Address_Type = new Hashtable();
        IP_Address_Type_Reverse = new Hashtable();
        Operational2ConsolidatedStatus = new Hashtable();
        Operational2ConsolidatedStatus_Reverse = new Hashtable();
        Vdisk_Type = new Hashtable();
        Vdisk_Type_Reverse = new Hashtable();
        ESS_Format = new Hashtable();
        ESS_Format_Reverse = new Hashtable();
        DSRAIDLEVEL_Format = new Hashtable();
        DSRAIDLEVEL_Format_Reverse = new Hashtable();
        DSRAIDLEVELNUMBER_Format = new Hashtable();
        DSRAIDLEVELNUMBER_Format_Reverse = new Hashtable();
        DS_Format = new Hashtable();
        DS_Format_Reverse = new Hashtable();
        Fabric_Status = new Hashtable();
        Fabric_Status_Reverse = new Hashtable();
        CIM_ELE_OP2CON_Status = new Hashtable();
        CIM_ELE_OP2CON_Status_Reverse = new Hashtable();
        TAPE_MEDIA_TYPE_SUPPORTED = new Hashtable();
        TAPE_MEDIA_TYPE_SUPPORTED_Reverse = new Hashtable();
        DBConstants.insertPair(NAMEFORMAT_LOOKUP, "FC_WWN", "1");
        DBConstants.insertPair(NAMEFORMAT_LOOKUP, "iSCSI", "2");
        DBConstants.insertPair(NAMEFORMAT_LOOKUP, "SMIS", "3");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "other", "0");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "ip", "1");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "dial", "2");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "hid", "3");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "nwa", "4");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "hwa", "5");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "x25", "6");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "isdn", "7");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "ipx", "8");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "dcc", "9");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "icd", "10");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "e.164", "11");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "sna", "12");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "oid/osi", "13");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "wwn", "14");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "naa", "15");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "Vendor Name Product Serial Number", "16");
        DBConstants.insertPair(SMISNAMEFORMAT_LOOKUP, "vnpsn", "16");
        DBConstants.insertPair(PORTTYPES_LOOKUP, UNKNOWN, "0");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "UNDEFINED", "0");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "not_present", "0");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "Other", "1");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "N_PORT", "10");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "NL_PORT", "11");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "F/NL_PORT", "12");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "Nx_PORT", "13");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "E_PORT", "14");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "F_PORT", "15");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "FL_PORT", "16");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "B_PORT", "17");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "G_PORT", "18");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "LT_PORT", "18000");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "TE_PORT", "18001");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "FV_PORT", "18006");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "NV_PORT", "18007");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "Auto", "17001");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "FX_PORT", "6");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "SD_PORT", "17002");
        DBConstants.insertPair(PORTTYPES_LOOKUP, "TL_PORT", "17016");
        DBConstants.insertPair(BOOLEAN_LOOKUP, "True", "1");
        DBConstants.insertPair(BOOLEAN_LOOKUP, "False", "0");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "unknown", "0");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "other", "1");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "ok", "2");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "operational", "2");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "degraded", "3");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "stressed", "4");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "predictive failure", "5");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "error", "6");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "non-recoverable error", "7");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "starting", "8");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "stopping", "9");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "stopped", "10");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "in service", "11");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "no contact", "12");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "lost communication", "13");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "aborted", "14");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "dormant", "15");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "supporting entity in error", "16");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "completed", "17");
        DBConstants.insertPair(OPERATIONALSTATUS_LOOKUP, "power mode", "18");
        DBConstants.insertPair(ZONETYPE_LOOKUP, "soft zone", "1");
        DBConstants.insertPair(ZONETYPE_LOOKUP, "hard zone", "2");
        DBConstants.insertPair(ZONETYPE_LOOKUP, "none", "3");
        DBConstants.insertPair(ZONEVENDORTYPE_LOOKUP, "ZONETYPE_UKNOWN", "0");
        DBConstants.insertPair(ZONEVENDORTYPE_LOOKUP, "ZONETYPE_STD", "1");
        DBConstants.insertPair(ZONEVENDORTYPE_LOOKUP, "ZONETYPE_QL", "2");
        DBConstants.insertPair(ZONEVENDORTYPE_LOOKUP, "ZONETYPE_FA", "3");
        DBConstants.insertPair(ZONEVENDORTYPE_LOOKUP, "ZONETYPE_PRO", "4");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, UNKNOWN, "0");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, "ZONE_PROTOCOL_MIN", "1");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, "ZONE_PROTOCOL_IP", "2");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, "ZONE_PROTOCOL_FCP", "3");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, "ZONE_PROTOCOL_VI", "4");
        DBConstants.insertPair(ZONEVENDORSUBTYPE_LOOKUP, "ZONE_PROTOCOL_MAX", "5");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "unknown", "10");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "portwwn", "11");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "domainport", "12");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "fcid", "13");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "nodewwn", "14");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "quickloop", "15");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "fabricwwn", "16");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "ip", "17");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "interfaceswitchwwn", "18");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "interfacedomainid", "19");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "wwnlun", "20");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "fcidlun", "21");
        DBConstants.insertPair(ZONEMEMBERTYPE_LOOKUP, "symbolicnodename", "23");
        DBConstants.insertPair(ZONEMEMBERVENDORYTYPE_LOOKUP, UNKNOWN, "10");
        DBConstants.insertPair(ZONEMEMBERVENDORYTYPE_LOOKUP, "ZONE_MEMBER_NONE", "11");
        DBConstants.insertPair(ZONEMEMBERVENDORYTYPE_LOOKUP, "ZONE_MEMBER_LUN", "12");
        DBConstants.insertPair(ZONEMEMBERVENDORYTYPE_LOOKUP, "ZONE_MEMBER_ALPA", "13");
        DBConstants.insertPair(ZONEMEMBERVENDORYTYPE_LOOKUP, "ZONE_MEMBER_FAHOST", "14");
        DBConstants.insertPair(SANZONECAPABILITIES_LOOKUP, "unknown", "0");
        DBConstants.insertPair(SANZONECAPABILITIES_LOOKUP, "hard only", "1");
        DBConstants.insertPair(SANZONECAPABILITIES_LOOKUP, "soft only", "2");
        DBConstants.insertPair(SANZONECAPABILITIES_LOOKUP, "hard and soft", "3");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7500L", "0");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7501L", "1");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7502L", "2");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7503L", "3");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7504L", "4");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7505L", "5");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7506L", "6");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7507L", "7");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7508L", "8");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7509L", "9");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7510L", "10");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7511L", "11");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7512L", "12");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7513L", "13");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7514L", "14");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7515L", "15");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7516L", "16");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7517L", "17");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7518L", "18");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7519L", "19");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7520L", "20");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7521L", "21");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7522L", "22");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7527L", "23");
        DBConstants.insertPair(OSTYPE_LOOKUP, "DBG0366L", "24");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7564L", "25");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7565L", "26");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG7566L", "27");
        DBConstants.insertPair(OSTYPE_LOOKUP, "STG1046L", "28");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7500L", UNKNOWN);
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7501L", "Linux");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7502L", "AIX");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7503L", "HP-UX");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7504L", "Windows NT");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7505L", "Windows");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7506L", "Solaris");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7507L", "HP-UX 10.x");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7508L", "NetWare");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7509L", "Other NAS");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7510L", "NetApp Data ONTAP");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7511L", "EMC Symmetrix");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7512L", "IBM ESS");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7513L", "COMPAQ HS");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7514L", "HITACHI Open");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7515L", "IBM FASt-T");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7516L", "LSI MetaStor");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7517L", "SUN T3");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7518L", "HP StorageWorks");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7519L", "StorageTek");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7520L", "MSCS Virtual Server");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7521L", "IBM SAN Volume Controller Cluster");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7522L", "Cluster");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7527L", "IBM SAN.FS Cluster");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "DBG0366L", "RDBMS Host");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7564L", "IBM DS8000");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7565L", "Other Subsystem");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG7566L", "IBM DS6000");
        DBConstants.insertPair(OSNAMETYPE_LOOKUP, "STG1046L", "VMWare ESX");
        DBConstants.insertPair(NODETYPE_LOOKUP, UNKNOWN, "1");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Undefined", "1");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Other", "2");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Gateway", "3");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Converter", "4");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Hub", "5");
        DBConstants.insertPair(NODETYPE_LOOKUP, "HBA", "6");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Switch", "7");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Storage Device", "8");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Host", "9");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Storage Subsystem", "10");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Module", "11");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Storage Driver", "12");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Storage Acess Device", "13");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Software Proxy Agent", "14");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Reserved", "15");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Shark", "16");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Lodestone", "17");
        DBConstants.insertPair(NODETYPE_LOOKUP, DS6000, "18");
        DBConstants.insertPair(NODETYPE_LOOKUP, DS8000, "19");
        DBConstants.insertPair(NODETYPE_LOOKUP, "NAS Server", "20");
        DBConstants.insertPair(NODETYPE_LOOKUP, "Bridge", "21");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "Disk", "31");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "Tape", "32");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "Printer", "33");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "ExternalController", "34");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "WORM", "35");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "CDROM", "36");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "Scanner", "37");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "Optical", "38");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "MediumChanger", "39");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "OtherEntity", "40");
        DBConstants.insertPair(PESCSITYPE_LOOKUP, "SmartEnclosure", "41");
        DBConstants.insertPair(NODESCSISUPPORT_LOOKUP, UNKNOWN, "1");
        DBConstants.insertPair(NODESCSISUPPORT_LOOKUP, "Initiator", "2");
        DBConstants.insertPair(NODESCSISUPPORT_LOOKUP, "Target", "3");
        DBConstants.insertPair(NODESCSISUPPORT_LOOKUP, "Intiator/Target", "4");
        DBConstants.insertPair(NODESCSISUPPORT_LOOKUP, "None", "5");
        DBConstants.insertPair(IPADDRESSTYPE_LOOKUP, "SNMP TRAP IP", "0");
        DBConstants.insertPair(IPADDRESSTYPE_LOOKUP, "SLP Directory agent IP", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "0", "-1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "1", "-1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "2", "0");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "3", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "4", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "5", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "6", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "7", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "8", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "9", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "10", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "11", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "12", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "13", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "14", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "15", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "16", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "17", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "18", "2");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "ok", "0");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "warning", "1");
        DBConstants.insertPair(OPERATIONAL2CONSOLIDATEDSTATUS_LOOKUP, "failure", "2");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "0", "raid0");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "1", "raid0");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "2", "raid0");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "3", "raid0");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "4", "raid5");
        DBConstants.insertPair(DSRAIDLEVELFORMAT_LOOKUP, "5", "raid10");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "0", "0");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "1", "0");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "2", "0");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "3", "0");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "4", "5");
        DBConstants.insertPair(DSRAIDLEVELNUMBERFORMAT_LOOKUP, "5", "10");
        DBConstants.insertPair(VDISKTYPE_LOOKUP, "Sequential", "0");
        DBConstants.insertPair(VDISKTYPE_LOOKUP, "Stripped", "1");
        DBConstants.insertPair(VDISKTYPE_LOOKUP, "Router", "2");
        DBConstants.insertPair(VDISKTYPE_LOOKUP, "Image", "3");
        DBConstants.insertPair("ESS_Format", "FB", "1");
        DBConstants.insertPair("ESS_Format", "Block512", "2");
        DBConstants.insertPair("ESS_Format", "Block520Protected", "3");
        DBConstants.insertPair("ESS_Format", "Block520Unprotected", "4");
        DBConstants.insertPair("ESS_Format", "3380", "5");
        DBConstants.insertPair("ESS_Format", "3390", "6");
        DBConstants.insertPair("ESS_Format", "3390Extended", "7");
        DBConstants.insertPair("ESS_Format", "CKD", "8");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "0", "0");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "1", "0");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "2", "0");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "3", "1");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "4", "8");
        DBConstants.insertPair(DSFORMAT_LOOKUP, "5", "5");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "0", "1");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "1", "1");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "2", "0");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "3", "2");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "4", "2");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "5", "1");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "6", "2");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "7", "1");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "8", "1");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "9", "2");
        DBConstants.insertPair(CIMENABLEDLOGICALELEMENTOP2CON_LOOKUP, "10", "1");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "0", UNKNOWN);
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "1", "Other");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "2", "Tape Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "3", "QIC Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "4", "AIT Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "5", "DTF Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "6", "DAT Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "7", "8mm Tape Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "8", "19mm Tape Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "9", "DLT Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "10", "Half-Inch Magnetic Tape Cartridge");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "11", "Cartridge Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "12", "JAZ Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "13", "ZIP Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "14", "SyQuest Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "15", "Winchester Removable Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "16", "CD-ROM");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "17", "CD-ROM/XA");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "18", "CD-I");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "19", "CD Recordable");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "20", "WORM");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "21", "Magneto-Optical");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "22", "DVD");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "23", "DVD-RW+");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "24", "DVD-RAM");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "25", "DVD-ROM");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "26", "DVD-Video");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "27", "Divx");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "28", "Floppy/Diskette");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "29", "Hard Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "30", "Memory Card");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "31", "Hard Copy");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "32", "Clik Disk");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "33", "CD-RW");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "34", "CD-DA");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "35", "CD+");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "36", "DVD Recordable");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "37", "DVD-RW");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "38", "DVD-Audio");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "39", "DVD-5");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "40", "DVD-9");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "41", "DVD-10");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "42", "DVD-18");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "43", "Magneto-Optical Rewriteable");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "44", "Magneto-Optical Write Once");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "45", "Magneto-Optical Rewriteable (LIMDOW)");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "46", "Phase Change Write Once");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "47", "Phase Change Rewriteable");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "48", "Phase Change Dual Rewriteable");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "49", "Ablative Write Once");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "50", "Near Field Recording");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "51", "MiniQic");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "52", "Travan");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "53", "8mm Metal Particle");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "54", "8mm Advanced Metal Evaporate");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "55", "NCTP");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "56", "LTO Ultrium");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "57", "LTO Accelis");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "58", "9 Track Tape");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "59", "18 Track Tape");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "60", "36 Track Tape");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "61", "Magstar 3590");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "62", "Magstar MP");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "63", "D2 Tape");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "64", "Tape - DST Small");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "65", "Tape - DST Medium");
        DBConstants.insertPair(TAPEMEDIATYPESUPPORTED_LOOKUP, "66", "Tape - DST Large");
    }

    private DBConstants() {
    }

    public static ILogger getLogger() {
        if (dblogger == null && useLogging) {
            dblogger = LogManagerFactory.getTraceLogger("aperi.logger.trace.DB");
        }
        return dblogger;
    }

    public static String getValueFromKey(String string, String string2) {
        String string3 = null;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Hashtable hashtable = (Hashtable)clazz2.getDeclaredField(string).get(clazz);
            string3 = (String)hashtable.get(string2);
        }
        catch (Exception exception) {}
        return string3;
    }

    public static String getKeyFromValue(String string, String string2) {
        String string3 = null;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Hashtable hashtable = (Hashtable)clazz2.getDeclaredField(String.valueOf(string) + "_Reverse").get(clazz);
            string3 = (String)hashtable.get(string2);
        }
        catch (Exception exception) {}
        return string3;
    }

    public static Hashtable getNormalizationHashtable(String string) {
        Hashtable hashtable = null;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            hashtable = (Hashtable)clazz2.getDeclaredField(string).get(clazz);
        }
        catch (Exception exception) {}
        return (Hashtable)hashtable.clone();
    }

    public static Hashtable getReverseNormalizationHashtable(String string) {
        Hashtable hashtable = null;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            hashtable = (Hashtable)clazz2.getDeclaredField(String.valueOf(string) + "_Reverse").get(clazz);
        }
        catch (Exception exception) {}
        return (Hashtable)hashtable.clone();
    }

    private static void insertPair(String string, String string2, String string3) {
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz3 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Hashtable hashtable = (Hashtable)clazz4.getDeclaredField(string).get(clazz3);
            String string4 = string2.toLowerCase();
            hashtable.put(string4, string3);
            hashtable.put(string2, string3);
            try {
                clazz2 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.DBConstants");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            hashtable = (Hashtable)clazz2.getDeclaredField(String.valueOf(string) + "_Reverse").get(clazz);
            hashtable.put(string3, string2);
        }
        catch (Exception exception) {}
    }

    public static String convertOperationalstatusArrayToBitValue(Vector vector) {
        try {
            int n = 19;
            BitSet bitSet = new BitSet(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                int n3 = Integer.parseInt((String)vector.elementAt(n2));
                if (n3 >= 0 && n3 < n) {
                    bitSet.set(n3);
                }
                ++n2;
            }
            double d = 0.0;
            int n4 = 0;
            while (n4 < n) {
                if (bitSet.get(n4)) {
                    d += Math.pow(2.0, n4);
                }
                ++n4;
            }
            String string = String.valueOf(d);
            return string.substring(0, string.indexOf("."));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector convertOperationalstatusBitValueToArray(int n) {
        try {
            int n2 = 19;
            Vector<String> vector = new Vector<String>();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                double d = Math.pow(2.0, n3);
                double d2 = (double)n / d;
                if (d2 >= 1.0) {
                    vector.addElement(String.valueOf(n3));
                    n = (int)((double)n - d);
                }
                --n3;
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertOperationalstatusArrayToConsolidatedValue(List list) {
        try {
            DeviceStatus deviceStatus = new DeviceStatus(list);
            return String.valueOf(deviceStatus.getConsolidatedState());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized ColumnInfo getAutoIdColumn(String string) {
        if (cAutoIdMap == null) {
            DBConstants.initializeAutoIdMap();
        }
        ColumnInfo columnInfo = (ColumnInfo)cAutoIdMap.get(string);
        return columnInfo;
    }

    private static void initializeAutoIdMap() {
        cAutoIdMap = new HashMap();
        cAutoIdMap.put(TResMaskingInfoTable.getTablename(), TResMaskingInfoTable.getColumnInfo("MASKING_INFO_ID"));
        cAutoIdMap.put(TResStorageVolumeTable.getTablename(), TResStorageVolumeTable.getColumnInfo("SVID"));
        cAutoIdMap.put(TResStoragePoolTable.getTablename(), TResStoragePoolTable.getColumnInfo("POOL_ID"));
        cAutoIdMap.put(TResStorageExtentTable.getTablename(), TResStorageExtentTable.getColumnInfo("STORAGE_EXTENT_ID"));
        cAutoIdMap.put(TResStorageSubsystemTable.getTablename(), TResStorageSubsystemTable.getColumnInfo("SUBSYSTEM_ID"));
        cAutoIdMap.put(TResCimkeySubsystemTable.getTablename(), TResCimkeySubsystemTable.getColumnInfo("CIMKEY_SUBSYSTEM_ID"));
        cAutoIdMap.put(TResTapeLibraryTable.getTablename(), TResTapeLibraryTable.getColumnInfo("TAPE_LIBRARY_ID"));
        cAutoIdMap.put(TResCimkeyTapeLibraryTable.getTablename(), TResCimkeyTapeLibraryTable.getColumnInfo("CIMKEY_TAPE_LIBRARY_ID"));
        cAutoIdMap.put(TResRedundancyTable.getTablename(), TResRedundancyTable.getColumnInfo("REDUNDANCY_ID"));
        cAutoIdMap.put(TResIoGroupTable.getTablename(), TResIoGroupTable.getColumnInfo("IO_GROUP_ID"));
        cAutoIdMap.put(TResPhysicalVolumeTable.getTablename(), TResPhysicalVolumeTable.getColumnInfo("PHYSICAL_VOLUME_ID"));
        cAutoIdMap.put(TResDiskGroupTable.getTablename(), TResDiskGroupTable.getColumnInfo("DISK_GROUP_ID"));
        cAutoIdMap.put(TResPortTable.getTablename(), TResPortTable.getColumnInfo("PORT_ID"));
        cAutoIdMap.put(TResCimkeyPortTable.getTablename(), TResCimkeyPortTable.getColumnInfo("CIMKEY_PORT_ID"));
        cAutoIdMap.put(TResNodeTable.getTablename(), TResNodeTable.getColumnInfo("NODE_ID"));
        cAutoIdMap.put(TResCapabilityDataTable.getTablename(), TResCapabilityDataTable.getColumnInfo("CAPABILITY_DATA_ID"));
        cAutoIdMap.put(TResBackendControllerTable.getTablename(), TResBackendControllerTable.getColumnInfo("BACKEND_CONTROLLER_ID"));
        cAutoIdMap.put(TResCimom2namespaceTable.getTablename(), TResCimom2namespaceTable.getColumnInfo("CIM_NAMESPACE_ID"));
        cAutoIdMap.put(TResRegisteredCimomTable.getTablename(), TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"));
        cAutoIdMap.put(TResTapeDriveTable.getTablename(), TResTapeDriveTable.getColumnInfo("TAPE_DRIVE_ID"));
        cAutoIdMap.put(TResTapeMediaChangerTable.getTablename(), TResTapeMediaChangerTable.getColumnInfo("TAPE_MEDIA_CHANGER_ID"));
        cAutoIdMap.put(TResTapeMediaLocationTable.getTablename(), TResTapeMediaLocationTable.getColumnInfo("LOCATION_ID"));
    }
}

