/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.detectability;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.ElementProbeStatus;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyPortPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlCimkeyVolumeVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlElementProbeStatus;
import org.eclipse.aperi.infrastructure.database.sql.SqlNode;
import org.eclipse.aperi.infrastructure.database.sql.SqlNodePort;
import org.eclipse.aperi.infrastructure.database.sql.SqlPhysicalVolumePhysicalVolume2Extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlPhysicalvolume2extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlPort;
import org.eclipse.aperi.infrastructure.database.sql.SqlScantype2table;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageExtentVolume2Extent;
import org.eclipse.aperi.infrastructure.database.sql.SqlSwitch2port;
import org.eclipse.aperi.infrastructure.database.sql.SqlSwitchSwitch2Port;
import org.eclipse.aperi.infrastructure.database.sql.SqlVolume2extent;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResScantype2tableTable;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcTableInfo;
import org.eclipse.aperi.infrastructure.history.detectability.DetSvcUtils;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityResult;
import org.eclipse.aperi.infrastructure.history.detectability.InFlightScan;
import org.eclipse.aperi.infrastructure.history.detectability.interfaces.DetectabilityConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DetectabilityService
implements DetectabilityConstants {
    private static Hashtable inFlight;
    private static ILogger traceLogger;
    private static String className;
    private static boolean TRACE;
    private static IEventMonitorService eventMonitor;
    public static HashMap scannerIdToClassMappings;
    private static Random randGen;

    static {
        Class<?> clazz;
        inFlight = new Hashtable();
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        TRACE = false;
        eventMonitor = null;
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        eventMonitor = DetectabilityService.getEventMonitorProxy();
        scannerIdToClassMappings = new HashMap();
        scannerIdToClassMappings.put("DS2", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PS1", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PS2", "StorageSubsystemScanType");
        scannerIdToClassMappings.put("PO2", "FabricScanType");
        scannerIdToClassMappings.put("PO4", "FabricScanType");
        scannerIdToClassMappings.put("PI1", "FabricScanType");
        scannerIdToClassMappings.put("PI2", "FabricScanType");
        scannerIdToClassMappings.put("PT1", "TapeScanType");
        scannerIdToClassMappings.put("DF1", "SwitchScanType");
        randGen = new Random();
    }

    public static int cancelDiscovery(String string) {
        return DetectabilityService.cancelDiscovery(string, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int startDiscovery(String string, int n, int n2, String string2) throws SQLException {
        InFlightScan inFlightScan = null;
        String string3 = "startDiscovery (" + string + ", " + n2 + ", " + n + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        if (string == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string3, String.valueOf(string3) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, 1);
            }
            return 1;
        }
        inFlightScan = DetectabilityService.getCurrScanner(string, n2, n, true);
        if (inFlightScan == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string3, String.valueOf(string3) + " had null scanner");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, 1);
            }
            return 1;
        }
        if (!inFlightScan.isNew()) {
            DetectabilityService.cancelDiscovery(string, inFlightScan);
        }
        if (string2 != null) {
            inFlightScan.setProcessID(string2);
        } else if (TRACE) {
            traceLogger.text(IRecordType.TYPE_WARN, className, string3, "Null processId received as input; using default " + inFlightScan.getProcessID());
        }
        int n3 = 0;
        String string4 = DetectabilityService.getClassFromScanId(string);
        n3 = DetSvcTableInfo.getMetaScannerClass(string4);
        inFlightScan.setScannerClass(n3);
        String string5 = DetectabilityService.getTypeFromScanId(string);
        inFlightScan.setScanType(string5);
        try {
            inFlightScan.setScanTime();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inFlightScan.resetLock();
            throw throwable;
        }
        {
            Object var9_11 = null;
            inFlightScan.resetLock();
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, 0);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DetectabilityResult stopDiscovery(String var0) throws SQLException, Exception {
        block46: {
            block45: {
                block43: {
                    block44: {
                        var1_1 = "stopDiscovery (" + var0 + ")";
                        var2_2 = new DetectabilityResult(0, null);
                        if (DetectabilityService.TRACE) {
                            DetectabilityService.traceLogger.entry(IRecordType.TYPE_ENTRY, DetectabilityService.className, var1_1);
                        }
                        if (var0 == null) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, String.valueOf(var1_1) + " had null parm");
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, 1);
                            }
                            var2_2.result = 1;
                            return var2_2;
                        }
                        var3_3 = null;
                        var4_4 = false;
                        var5_5 = false;
                        var6_6 = false;
                        var7_7 = false;
                        var8_8 = false;
                        var9_9 = false;
                        var3_3 = DetectabilityService.getCurrScanner(var0);
                        if (var3_3 == null) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, String.valueOf(var1_1) + " had null scanner");
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, 1);
                            }
                            var2_2.result = 1;
                            return var2_2;
                        }
                        DetectabilityService.resolveTablesToScan(var3_3);
                        var10_10 = DBConnPoolDataSource.getInstance();
                        var11_11 = null;
                        try {
                            var11_11 = (DBConnection)var10_10.getPooledConnection();
                        }
                        catch (SQLException var12_12) {
                            DetectabilityService.endScannerFlight(var3_3.getScanId());
                            var3_3.resetLock();
                            throw var12_12;
                        }
                        var12_13 = null;
                        var13_14 = null;
                        var14_15 = null;
                        var15_16 = null;
                        var16_17 = null;
                        var17_18 = null;
                        var18_19 = null;
                        var19_20 = null;
                        var20_21 = null;
                        var21_22 = null;
                        var22_23 = -1;
                        var23_24 = var3_3.getList();
                        var24_25 = var23_24.iterator();
                        var25_26 = null;
                        var26_27 = 0;
                        var27_28 = 0L;
                        var29_29 = false;
                        var30_30 = new HashMap<K, V>();
                        try {
                            while (var24_25.hasNext()) {
                                var25_26 = (String)var24_25.next();
                                var4_4 = false;
                                var5_5 = false;
                                var6_6 = false;
                                var7_7 = false;
                                var8_8 = false;
                                var13_14 = null;
                                var12_13 = null;
                                var14_15 = null;
                                var15_16 = null;
                                var16_17 = null;
                                var17_18 = null;
                                var18_19 = null;
                                var19_20 = null;
                                var20_21 = null;
                                var21_22 = null;
                                var22_23 = -1;
                                var9_9 = false;
                                if (!DetectabilityService.TRACE) {
                                    System.out.println("stopDiscovery: table=" + var25_26);
                                }
                                while (true) {
                                    try {
                                        var5_5 = DetSvcTableInfo.isDetectableTracked(var25_26);
                                        DetSvcTableInfo.isSubsysCIMOMScanned(var25_26);
                                        var6_6 = DetSvcTableInfo.isSubsysCIMOMAuth(var25_26);
                                        DetSvcTableInfo.isFabricAgentScanned(var25_26);
                                        var7_7 = DetSvcTableInfo.isFabricAgentAuth(var25_26);
                                        DetSvcTableInfo.isSwitchCIMOMScanned(var25_26);
                                        var8_8 = DetSvcTableInfo.isSwitchCIMOMAuth(var25_26);
                                        var4_4 = DetSvcTableInfo.isHybrid(var25_26);
                                        var9_9 = DetSvcTableInfo.isEventGen(var25_26);
                                        var13_14 = DetSvcUtils.getHelper(var25_26);
                                        var12_13 = DetSvcUtils.getHelperSuper(var25_26);
                                        var14_15 = var12_13.getDeclaredMethod("getColumns", new Class[0]);
                                        var15_16 = (Hashtable)var14_15.invoke((Object)var12_13, new Object[0]);
                                        var17_18 = (ColumnInfo)var15_16.get("UPDATE_TIMESTAMP");
                                        if (var17_18 != null) {
                                            var17_18 = var17_18.addOperator("<");
                                        }
                                        var16_17 = (ColumnInfo)var15_16.get("DETECTABLE");
                                        var20_21 = DetSvcTableInfo.getFKeyName(var25_26);
                                        if (var20_21 != null) {
                                            var18_19 = (ColumnInfo)var15_16.get(var20_21);
                                        }
                                        if ((var21_22 = DetSvcTableInfo.getAutoIDName(var25_26)) != null) {
                                            var19_20 = (ColumnInfo)var15_16.get(var21_22);
                                        }
                                        if (!(var3_3.getScannerClass() == 100 && var6_6 != false || var3_3.getScannerClass() == 101 && var7_7 != false) && (var3_3.getScannerClass() != 102 || !var8_8)) ** GOTO lbl146
                                        if (var4_4 && (var22_23 = DetectabilityService.deleteProbeStatus(var11_11, var25_26, var3_3, var17_18, var19_20, var18_19)) != 0) {
                                            if (DetectabilityService.TRACE) {
                                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, String.valueOf(var1_1) + " deleteProbeStatus returned " + var22_23);
                                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, var22_23);
                                            }
                                            var2_2.result = var22_23;
                                            var34_33 = var2_2;
                                        }
                                        break;
                                    }
                                    catch (SQLException var31_32) {
                                        if (!SQLExceptionHelper.isDeadlock(var11_11, var31_32)) {
                                            throw var31_32;
                                        }
                                        if (DetectabilityService.TRACE) {
                                            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, "Deadlock occured for table " + var25_26 + "; rolling back relevant changes");
                                        } else {
                                            System.out.println(String.valueOf(DetectabilityService.className) + " " + var1_1 + " Deadlock for table " + var25_26);
                                        }
                                        var11_11.rollback();
                                        if (++var26_27 <= 6) {
                                            if (DetectabilityService.TRACE) {
                                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, "Retry " + var26_27 + " after deadlock");
                                            } else {
                                                System.out.println(String.valueOf(DetectabilityService.className) + " " + var1_1 + " Retry " + var26_27);
                                            }
                                            var29_29 = true;
                                            var27_28 = 15000L * (long)var26_27 + (long)DetectabilityService.randGen.nextInt(15000);
                                            Thread.sleep(var27_28);
                                            continue;
                                        }
                                        if (!DetectabilityService.TRACE) throw var31_32;
                                        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, "Retries complete; aborting with SQLException");
                                        throw var31_32;
                                    }
                                    var32_36 = null;
                                    if (var11_11 == null) break block43;
                                    break block44;
                                    break;
                                }
                                {
                                    var31_31 = DetectabilityService.authScanUpdateDelete(var11_11, var25_26, var13_14, var15_16, var3_3, var17_18, var16_17, var18_19, var5_5, var9_9);
                                    if (var31_31 != null) ** GOTO lbl-1000
                                    if (DetectabilityService.TRACE) {
                                        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, String.valueOf(var1_1) + " authScanUpd returned " + var22_23);
                                        DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, 1);
                                    }
                                    var2_2.result = 1;
                                    var34_34 = var2_2;
                                }
                                break block45;
lbl-1000:
                                // 1 sources

                                {
                                    var30_30.putAll(var31_31);
                                    ** GOTO lbl156
lbl146:
                                    // 1 sources

                                    var31_31 = DetectabilityService.nonAuthScan(var11_11, var25_26, var3_3, var5_5, var9_9, var12_13);
                                    if (var31_31 != null) ** GOTO lbl-1000
                                    if (DetectabilityService.TRACE) {
                                        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, String.valueOf(var1_1) + " nonAuthScan returned " + var22_23);
                                        DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, 1);
                                    }
                                    var2_2.result = 1;
                                    var34_35 = var2_2;
                                }
                                break block46;
lbl-1000:
                                // 1 sources

                                {
                                    var30_30.putAll(var31_31);
lbl156:
                                    // 2 sources

                                    var11_11.commit();
                                    if (DetectabilityService.TRACE) {
                                        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var1_1, "Committed changes relevant to " + var25_26);
                                    } else {
                                        System.out.println(String.valueOf(DetectabilityService.className) + " " + var1_1 + " " + "committed " + var25_26);
                                    }
                                    var26_27 = 0;
                                    var29_29 = false;
                                }
                                if (var29_29) ** continue;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var33_41) {
                            var32_39 = null;
                            if (var11_11 != null && !var11_11.isClosed()) {
                                var11_11.close();
                            }
                            DetectabilityService.endScannerFlight(var3_3.getScanId());
                            var3_3.resetLock();
                            throw var33_41;
                        }
                    }
                    if (!var11_11.isClosed()) {
                        var11_11.close();
                    }
                }
                DetectabilityService.endScannerFlight(var3_3.getScanId());
                var3_3.resetLock();
                return var34_33;
            }
            var32_37 = null;
            if (var11_11 != null && !var11_11.isClosed()) {
                var11_11.close();
            }
            DetectabilityService.endScannerFlight(var3_3.getScanId());
            var3_3.resetLock();
            return var34_34;
        }
        var32_38 = null;
        if (var11_11 != null && !var11_11.isClosed()) {
            var11_11.close();
        }
        DetectabilityService.endScannerFlight(var3_3.getScanId());
        var3_3.resetLock();
        return var34_35;
lbl-1000:
        // 1 sources

        {
            var32_40 = null;
        }
        if (var11_11 != null && !var11_11.isClosed()) {
            var11_11.close();
        }
        DetectabilityService.endScannerFlight(var3_3.getScanId());
        var3_3.resetLock();
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var1_1, 0);
        }
        var2_2.modifiedEntities = var30_30;
        var2_2.result = 0;
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tableUpdated(String var0, String var1_1, Hashtable var2_2) throws SQLException, Exception {
        block41: {
            block40: {
                block38: {
                    block39: {
                        var3_3 = null;
                        var4_4 = "tableUpdated (" + var0 + ", " + var1_1 + ", " + var2_2 + ")";
                        if (DetectabilityService.TRACE) {
                            DetectabilityService.traceLogger.entry(IRecordType.TYPE_ENTRY, DetectabilityService.className, var4_4);
                        }
                        if (var0 == null || var1_1 == null || var2_2 == null) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " had null parm");
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                            }
                            return;
                        }
                        if (!DetSvcTableInfo.isDetSvcTable(var1_1)) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " no-op on table " + var1_1);
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 0);
                            }
                            return;
                        }
                        var3_3 = DetectabilityService.getCurrScanner(var0);
                        if (var3_3 == null) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " had null scanner; table not processed");
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                            }
                            return;
                        }
                        var3_3.addTable(var1_1);
                        if (!DetSvcTableInfo.isProbeStatusUpd(var1_1)) break block41;
                        if (var2_2 == null || var2_2.size() == 0) {
                            if (DetectabilityService.TRACE) {
                                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + "Input hashtable null, cannot process this" + " tuple for table " + var1_1);
                                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                            }
                            var3_3.resetLock();
                            return;
                        }
                        var5_5 = var2_2.values().iterator();
                        var6_6 = (String)var5_5.next();
                        var7_7 = Integer.parseInt(var6_6);
                        var8_8 = DetSvcTableInfo.getElementType(var1_1);
                        if (DetectabilityService.TRACE) {
                            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " " + var1_1 + " autoID = " + var7_7);
                        }
                        var9_9 = TResElementProbeStatusTable.getColumns();
                        var10_10 = var9_9.values().iterator();
                        var11_11 = new Hashtable<ColumnInfo, Object>();
                        var12_12 = null;
                        var13_13 = DBConnPoolDataSource.getInstance();
                        var14_14 = null;
                        try {
                            var14_14 = (DBConnection)var13_13.getPooledConnection();
                        }
                        catch (SQLException var15_15) {
                            var3_3.resetLock();
                            throw var15_15;
                        }
                        while (true) {
                            block42: {
                                if (var10_10.hasNext()) break block42;
                                if (DetectabilityService.TRACE) {
                                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, var2_2.toString());
                                }
                                var15_16 = new ElementProbeStatus();
                                ** try [egrp 2[TRYBLOCK] [5 : 821->1031)] { 
lbl53:
                                // 1 sources

                                ** GOTO lbl-1000
                            }
                            var12_12 = (ColumnInfo)var10_10.next();
                            if (var12_12.getName() == "ELEMENT_ID") {
                                var11_11.put(var12_12, Integer.toString(var7_7));
                                continue;
                            }
                            if (var12_12.getName() == "ELEMENT_TYPE") {
                                var11_11.put(var12_12, Short.toString(var8_8));
                                continue;
                            }
                            if (var12_12.getName() == "SCANNER_ID") {
                                var11_11.put(var12_12, var0);
                                continue;
                            }
                            if (var12_12.getName() == "UPDATE_TIMESTAMP") {
                                var15_16 = null;
                                try {
                                    var15_16 = CurrentTime.getTimestamp(var14_14);
                                }
                                catch (SQLException var16_17) {
                                    if (DetectabilityService.TRACE) {
                                        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " error getting teimestamp, aborting");
                                    }
                                    DetectabilityService.abortDbCon(var14_14);
                                    var3_3.resetLock();
                                    throw var16_17;
                                }
                                var11_11.put(var12_12, var15_16);
                                continue;
                            }
                            if (var12_12.getName() != "PROBE_FOUND") break;
                            var11_11.put(var12_12, Short.toString((short)1));
                        }
                        if (DetectabilityService.TRACE) {
                            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                        }
                        DetectabilityService.abortDbCon(var14_14);
                        var3_3.resetLock();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                if (ElementProbeStatus.retrieve(var14_14, var11_11) != null) {
                                    var16_18 = var15_16.update(var14_14, var11_11);
                                    if (var16_18 != 1) {
                                        if (DetectabilityService.TRACE) {
                                            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " incorrect number of rows updated: " + var16_18);
                                            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                                        }
                                        DetectabilityService.abortDbCon(var14_14);
                                        var3_3.resetLock();
lbl101:
                                        // 2 sources

                                        while (true) {
                                            var17_21 = null;
                                            if (var14_14 == null) break block38;
                                            break block39;
                                            break;
                                        }
                                    }
                                } else {
                                    var16_19 = var15_16.insert(var14_14, var11_11);
                                    if (!var16_19) {
                                        if (DetectabilityService.TRACE) {
                                            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var4_4, String.valueOf(var4_4) + " had false result");
                                            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 1);
                                        }
                                        DetectabilityService.abortDbCon(var14_14);
                                        ** continue;
                                    }
                                }
                                var14_14.commit();
                                break block40;
                            }
                            catch (SQLException var16_20) {
                                var14_14.rollback();
                                throw var16_20;
                            }
                        }
lbl118:
                        // 1 sources

                        catch (Throwable var18_24) {
                            var17_22 = null;
                            if (var14_14 != null && !var14_14.isClosed()) {
                                var14_14.close();
                            }
                            var3_3.resetLock();
                            throw var18_24;
                        }
                    }
                    if (!var14_14.isClosed()) {
                        var14_14.close();
                    }
                }
                var3_3.resetLock();
                return;
            }
            var17_23 = null;
            if (var14_14 != null && !var14_14.isClosed()) {
                var14_14.close();
            }
            var3_3.resetLock();
        }
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var4_4, 0);
        }
    }

    private static void abortDbCon(DBConnection dBConnection) throws SQLException {
        dBConnection.rollback();
        dBConnection.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map authScanUpdateDelete(DBConnection var0, String var1_1, Class var2_2, Hashtable var3_3, InFlightScan var4_4, ColumnInfo var5_5, ColumnInfo var6_6, ColumnInfo var7_7, boolean var8_8, boolean var9_9) throws SQLException, Exception {
        block27: {
            var10_10 = "authScanUpdateDelete (" + var0 + ", " + var1_1 + ", " + var2_2 + "," + var3_3 + ", " + var4_4 + ", " + var5_5 + ", " + var6_6 + ", " + var7_7 + ")";
            var11_11 = new HashMap<String, V>();
            if (DetectabilityService.TRACE) {
                DetectabilityService.traceLogger.entry(IRecordType.TYPE_ENTRY, DetectabilityService.className, var10_10);
            }
            if (var0 == null || var1_1 == null || var2_2 == null || var3_3 == null || var4_4 == null || var5_5 == null) {
                if (DetectabilityService.TRACE == false) return null;
                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, String.valueOf(var10_10) + " had null parm");
                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var10_10, 1);
                return null;
            }
            var11_11.put(var1_1, null);
            var12_12 = -1;
            if (var1_1.equals("T_RES_VOLUME2EXTENT") || var1_1.equals("T_RES_CIMKEY_VOLUME") || var1_1.equals("T_RES_CIMKEY_PORT") || var1_1.equals("T_RES_SWITCH2PORT") || var1_1.equals("T_RES_PHYSICALVOLUME2EXTENT") || 2 == var4_4.getSystemType() && var1_1.equals("T_RES_PORT")) {
                var13_13 = DetectabilityService.authScanSpecialCase(var0, var1_1, var2_2, var3_3, var4_4, var5_5);
                if (var13_13 == null) {
                    if (DetectabilityService.TRACE == false) return null;
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, "authScanSpecialCase returned null");
                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var10_10, 1);
                    return null;
                }
                var11_11.put(var1_1, var13_13.get(var1_1));
                return var11_11;
            }
            var13_14 = null;
            var14_15 = new Hashtable<ColumnInfo, Object>();
            var14_15.put(var5_5, var4_4.getScanTime());
            var14_15.put(var7_7, String.valueOf(var4_4.getScanSystemID()));
            if (var6_6 != null) {
                var15_16 = var6_6.addOperator("<>");
                var14_15.put((ColumnInfo)var15_16, String.valueOf(0));
            }
            var15_16 = DetectabilityService.createAuthParamQuery(var1_1, var8_8 != false ? DetectabilityService.getColsForEventGen(var3_3) : null, var14_15);
            if (DetectabilityService.TRACE) {
                DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, "Query: " + (String)var15_16);
            } else {
                System.out.println(String.valueOf(DetectabilityService.className) + var10_10 + " Query: " + (String)var15_16);
            }
            var16_17 = null;
            try {
                block29: {
                    block28: {
                        var16_17 = ParameterizedSql.sqlQuery(var0, (String)var15_16, new Hashtable<K, V>(), var14_15);
                        if (var16_17 != null || !DetectabilityService.TRACE) break block28;
                        DetectabilityService.traceLogger.text(IRecordType.TYPE_WARN, DetectabilityService.className, var10_10, "sqlQuery returned null; no missing elements found to generate events or to return; continue with update");
                        ** GOTO lbl-1000
                    }
                    if (!var8_8) break block29;
                    var17_18 = new Vector<String>();
                    while (true) {
                        block30: {
                            if (var16_17.next()) break block30;
                            var11_11.put(var1_1, var17_18);
                            ** GOTO lbl-1000
                        }
                        var17_18.add(var16_17.getObject(1).toString());
                    }
                }
                if (var9_9) {
                    DetectabilityService.delEventGen(var4_4.getProcessID(), var1_1, var16_17);
                }
            }
            catch (Throwable var19_19) {
                var18_20 = null;
                if (var16_17 == null) throw var19_19;
                var16_17.close();
                var16_17.getStatement().close();
                var16_17 = null;
                throw var19_19;
            }
lbl-1000:
            // 3 sources

            {
                var18_21 = null;
                if (var16_17 == null) break block27;
            }
            var16_17.close();
            var16_17.getStatement().close();
            var16_17 = null;
        }
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, String.valueOf(var10_10) + " table = " + var1_1);
            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, String.valueOf(var10_10) + " detTracked = " + var8_8);
        }
        if (var8_8) {
            v0 = new Class[3];
            try {
                v1 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConnection");
            }
            catch (ClassNotFoundException v2) {
                throw new NoClassDefFoundError(v2.getMessage());
            }
            v0[0] = v1;
            try {
                v3 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException v4) {
                throw new NoClassDefFoundError(v4.getMessage());
            }
            v0[1] = v3;
            try {
                v5 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException v6) {
                throw new NoClassDefFoundError(v6.getMessage());
            }
            v0[2] = v5;
            var13_14 = var2_2.getDeclaredMethod("update", v0);
            if (var13_14 == null) {
                if (DetectabilityService.TRACE == false) return null;
                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var10_10, 1);
                return null;
            }
            var17_18 = new Hashtable<K, V>();
            var17_18.put(var6_6, String.valueOf(0));
            var17_18.put(var5_5, CurrentTime.getTimestamp(var0));
            var12_12 = (Integer)var13_14.invoke((Object)var2_2, new Object[]{var0, var17_18, var14_15});
        } else {
            v7 = new Class[2];
            try {
                v8 = Class.forName("org.eclipse.aperi.infrastructure.database.DBConnection");
            }
            catch (ClassNotFoundException v9) {
                throw new NoClassDefFoundError(v9.getMessage());
            }
            v7[0] = v8;
            try {
                v10 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException v11) {
                throw new NoClassDefFoundError(v11.getMessage());
            }
            v7[1] = v10;
            var13_14 = var2_2.getDeclaredMethod("deletes", v7);
            if (var13_14 == null) {
                if (DetectabilityService.TRACE == false) return null;
                DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var10_10, 1);
                return null;
            }
            var12_12 = (Integer)var13_14.invoke((Object)var2_2, new Object[]{var0, var14_15});
        }
        if (DetectabilityService.TRACE == false) return var11_11;
        DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var10_10, String.valueOf(var10_10) + " numrowsupdated=" + var12_12);
        return var11_11;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map authScanSpecialCase(DBConnection dBConnection, String string, Class clazz, Hashtable hashtable, InFlightScan inFlightScan, ColumnInfo columnInfo) throws SQLException, Exception {
        HashMap hashMap;
        String string2;
        block46: {
            block52: {
                int n;
                Hashtable<ColumnInfo, Object> hashtable2;
                StringBuffer stringBuffer;
                block44: {
                    Class<?> clazz2;
                    DBResultSet dBResultSet;
                    ColumnInfo columnInfo2;
                    Method method;
                    Class clazz3;
                    block51: {
                        Class<?> clazz4;
                        block50: {
                            Class<?> clazz5;
                            block48: {
                                block43: {
                                    Class<?> clazz6;
                                    block47: {
                                        block45: {
                                            Class<?> clazz7;
                                            string2 = "authScanSpecialCase (" + dBConnection + ", " + string + ", " + clazz + "," + hashtable + ", " + inFlightScan + ", " + columnInfo + ")";
                                            hashMap = new HashMap();
                                            if (TRACE) {
                                                traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
                                            }
                                            if (dBConnection == null || string == null || clazz == null || hashtable == null || inFlightScan == null || columnInfo == null) {
                                                if (TRACE) {
                                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                                                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
                                                }
                                                return null;
                                            }
                                            hashMap.put(string, null);
                                            clazz3 = null;
                                            method = null;
                                            stringBuffer = new StringBuffer();
                                            columnInfo2 = null;
                                            hashtable2 = new Hashtable<ColumnInfo, Object>();
                                            dBResultSet = null;
                                            n = 0;
                                            if (!string.equals("T_RES_VOLUME2EXTENT")) break block45;
                                            clazz3 = DetSvcUtils.getHelperSuper("T_RES_STORAGE_EXTENT");
                                            Class[] classArray = new Class[1];
                                            try {
                                                clazz7 = Class.forName("java.lang.String");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            classArray[0] = clazz7;
                                            method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                                            columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("SUBSYSTEM_ID"));
                                            hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                                            hashtable2.put(columnInfo, inFlightScan.getScanTime());
                                            stringBuffer.append(" where STORAGE_EXTENT_ID in (");
                                            stringBuffer.append(SqlStorageExtentVolume2Extent.getQueryString(SqlStorageExtentVolume2Extent.querySE));
                                            stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                                            if (TRACE) {
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "appended string=" + stringBuffer.toString());
                                            }
                                            n = SqlVolume2extent.sqlUpdate(dBConnection, SqlVolume2extent.delAll, stringBuffer.toString(), hashtable2);
                                            if (TRACE) {
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " deleted rows = " + n);
                                            }
                                            break block46;
                                        }
                                        if (!string.equals("T_RES_CIMKEY_PORT")) break block47;
                                        if (2 == inFlightScan.getSystemType()) {
                                            Class<?> clazz8;
                                            clazz3 = DetSvcUtils.getHelperSuper("T_RES_NODE");
                                            Class[] classArray = new Class[1];
                                            try {
                                                clazz8 = Class.forName("java.lang.String");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            classArray[0] = clazz8;
                                            method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                                            columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("TAPE_LIBRARY_ID"));
                                            hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                                            hashtable2.put(columnInfo, inFlightScan.getScanTime());
                                            stringBuffer.append(" where PORT_ID in (");
                                            stringBuffer.append(SqlNodePort.getQueryString(SqlNodePort.queryPortsInTapeLibrary));
                                            stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                                        } else {
                                            Class<?> clazz9;
                                            clazz3 = DetSvcUtils.getHelperSuper("T_RES_PORT");
                                            Class[] classArray = new Class[1];
                                            try {
                                                clazz9 = Class.forName("java.lang.String");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            classArray[0] = clazz9;
                                            method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                                            columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("SUBSYSTEM_ID"));
                                            hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                                            hashtable2.put(columnInfo, inFlightScan.getScanTime());
                                            stringBuffer.append(" where CIMKEY_PORT_ID in (");
                                            stringBuffer.append(SqlCimkeyPortPort.getQueryString(SqlCimkeyPortPort.queryPort));
                                            stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                                        }
                                        if (TRACE) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "appended string=" + stringBuffer.toString());
                                        }
                                        n = SqlCimkeyPort.sqlUpdate(dBConnection, SqlCimkeyPort.delAll, stringBuffer.toString(), hashtable2);
                                        if (TRACE) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " deleted rows = " + n);
                                        }
                                        break block46;
                                    }
                                    if (!string.equals("T_RES_SWITCH2PORT")) break block48;
                                    clazz3 = DetSvcUtils.getHelperSuper("T_RES_SWITCH");
                                    Class[] classArray = new Class[1];
                                    try {
                                        clazz6 = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    classArray[0] = clazz6;
                                    method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                                    columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("SWITCH_ID"));
                                    hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                                    hashtable2.put(columnInfo, inFlightScan.getScanTime());
                                    try {
                                        dBResultSet = ParameterizedSql.sqlQuery(dBConnection, SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortUpdatedBeforeTime), new Hashtable(), hashtable2);
                                        Vector<String> vector = new Vector<String>();
                                        while (true) {
                                            block49: {
                                                if (dBResultSet.next()) break block49;
                                                hashMap.put(string, vector);
                                                break;
                                            }
                                            vector.add(dBResultSet.getObject(1).toString());
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var16_19 = null;
                                        if (dBResultSet != null) {
                                            dBResultSet.close();
                                            dBResultSet.getStatement().close();
                                            dBResultSet = null;
                                        }
                                        throw throwable;
                                    }
                                    {
                                        Object var16_20 = null;
                                        if (dBResultSet == null) break block43;
                                    }
                                    dBResultSet.close();
                                    dBResultSet.getStatement().close();
                                    dBResultSet = null;
                                }
                                stringBuffer.append(", UPDATE_TIMESTAMP = '");
                                stringBuffer.append(CurrentTime.getTimestamp(dBConnection));
                                stringBuffer.append("' where SWITCH2PORT_ID in (");
                                stringBuffer.append(SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortForSwitch));
                                stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                                if (TRACE) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "appended string=" + stringBuffer.toString());
                                }
                                n = SqlSwitch2port.sqlUpdate(dBConnection, SqlSwitch2port.updateAllDetectable, stringBuffer.toString(), hashtable2);
                                if (TRACE) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " deleted rows = " + n);
                                }
                                break block46;
                            }
                            if (!string.equals("T_RES_PHYSICALVOLUME2EXTENT")) break block50;
                            clazz3 = DetSvcUtils.getHelperSuper("T_RES_PHYSICAL_VOLUME");
                            Class[] classArray = new Class[1];
                            try {
                                clazz5 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            classArray[0] = clazz5;
                            method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                            columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("SUBSYSTEM_ID"));
                            hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                            hashtable2.put(columnInfo, inFlightScan.getScanTime());
                            stringBuffer.append(" where PHYSICAL_VOLUME_ID in (");
                            stringBuffer.append(SqlPhysicalVolumePhysicalVolume2Extent.getQueryString(SqlPhysicalVolumePhysicalVolume2Extent.queryPVForSS));
                            stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                            n = SqlPhysicalvolume2extent.sqlUpdate(dBConnection, SqlPhysicalvolume2extent.delAll, stringBuffer.toString(), hashtable2);
                            if (TRACE) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " deleted rows = " + n);
                            }
                            break block46;
                        }
                        if (!string.equals("T_RES_CIMKEY_VOLUME")) break block51;
                        clazz3 = DetSvcUtils.getHelperSuper("T_RES_STORAGE_VOLUME");
                        Class[] classArray = new Class[1];
                        try {
                            clazz4 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[0] = clazz4;
                        method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                        columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("SUBSYSTEM_ID"));
                        hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                        hashtable2.put(columnInfo, inFlightScan.getScanTime());
                        stringBuffer.append(" where VOLUME_ID in (");
                        stringBuffer.append(SqlCimkeyVolumeVolume.getQueryString(SqlCimkeyVolumeVolume.queryVolume));
                        stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                        if (TRACE) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "appended string=" + stringBuffer.toString());
                        }
                        n = SqlCimkeyVolume.sqlUpdate(dBConnection, 1, stringBuffer.toString(), hashtable2);
                        if (TRACE) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " deleted rows = " + n);
                        }
                        break block46;
                    }
                    if (!string.equals("T_RES_PORT")) break block52;
                    clazz3 = DetSvcUtils.getHelperSuper("T_RES_NODE");
                    Class[] classArray = new Class[1];
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    classArray[0] = clazz2;
                    method = clazz3.getDeclaredMethod("getColumnInfo", classArray);
                    columnInfo2 = (ColumnInfo)method.invoke((Object)clazz3, new String("TAPE_LIBRARY_ID"));
                    hashtable2.put(columnInfo2, String.valueOf(inFlightScan.getScanSystemID()));
                    hashtable2.put(columnInfo, inFlightScan.getScanTime());
                    try {
                        dBResultSet = ParameterizedSql.sqlQuery(dBConnection, SqlNodePort.getQueryString(SqlNodePort.queryPortsInTapeLibraryUpdatedBeforeTime), new Hashtable(), hashtable2);
                        Vector<String> vector = new Vector<String>();
                        while (true) {
                            block53: {
                                if (dBResultSet.next()) break block53;
                                hashMap.put(string, vector);
                                break;
                            }
                            vector.add(dBResultSet.getObject(1).toString());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_21 = null;
                        if (dBResultSet != null) {
                            dBResultSet.close();
                            dBResultSet.getStatement().close();
                            dBResultSet = null;
                        }
                        throw throwable;
                    }
                    {
                        Object var16_22 = null;
                        if (dBResultSet == null) break block44;
                    }
                    dBResultSet.close();
                    dBResultSet.getStatement().close();
                    dBResultSet = null;
                }
                stringBuffer.append(", UPDATE_TIMESTAMP = '");
                stringBuffer.append(CurrentTime.getTimestamp(dBConnection));
                stringBuffer.append("' where NODE_ID in (");
                stringBuffer.append(SqlNode.getQueryString(SqlNode.queryNodeForTapeLib));
                stringBuffer.append(") and UPDATE_TIMESTAMP < ?");
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "appended string=" + stringBuffer.toString());
                }
                n = SqlPort.sqlUpdate(dBConnection, SqlPort.updateAllDetectable, stringBuffer.toString(), hashtable2);
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " updated rows = " + n);
                }
                break block46;
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " tablename invalid " + string);
            }
            return null;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return hashMap;
    }

    private static int deleteProbeStatus(DBConnection dBConnection, String string, InFlightScan inFlightScan, ColumnInfo columnInfo, ColumnInfo columnInfo2, ColumnInfo columnInfo3) throws SQLException, Exception {
        String string2 = "deleteProbeStatus (" + dBConnection + ", " + string + ", " + inFlightScan + ", " + columnInfo + ", " + columnInfo2 + ", " + columnInfo3 + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (dBConnection == null || string == null || inFlightScan == null || columnInfo == null || columnInfo2 == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        Class clazz = null;
        Method method = null;
        String string3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable hashtable2 = null;
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        Vector<Object> vector2 = new Vector<Object>();
        ColumnInfo columnInfo4 = null;
        if (columnInfo2 == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " Returning null as autoID missing for " + string);
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        if (string.equals("T_RES_SWITCH2PORT")) {
            string3 = SqlSwitchSwitch2Port.getQueryString(SqlSwitchSwitch2Port.querySwitch2PortUpdatedBeforeTime);
            try {
                Class<?> clazz2;
                clazz = DetSvcUtils.getHelperSuper("T_RES_SWITCH");
                Class[] classArray = new Class[1];
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[0] = clazz2;
                method = clazz.getDeclaredMethod("getColumnInfo", classArray);
                columnInfo4 = (ColumnInfo)method.invoke((Object)clazz, new String("SWITCH_ID"));
                vector.add(columnInfo4);
                vector2.add(String.valueOf(inFlightScan.getScanSystemID()));
                vector.add(columnInfo);
                vector2.add(inFlightScan.getScanTime());
                hashtable2 = ComplexQuery.generateHashtable(vector, vector2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " DeleteProbeStatus: could " + " not find columninfo for switch_id for table T_RES_SWITCH");
                }
                throw exception;
            }
        }
        if (string.equals("T_RES_CIMKEY_PORT")) {
            string3 = SqlCimkeyPortPort.getQueryString(SqlCimkeyPortPort.queryPortUpdatedBeforeTime);
            try {
                Class<?> clazz3;
                clazz = DetSvcUtils.getHelperSuper("T_RES_PORT");
                Class[] classArray = new Class[1];
                try {
                    clazz3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[0] = clazz3;
                method = clazz.getDeclaredMethod("getColumnInfo", classArray);
                columnInfo4 = (ColumnInfo)method.invoke((Object)clazz, new String("SUBSYSTEM_ID"));
                vector.add(columnInfo4);
                vector2.add(String.valueOf(inFlightScan.getScanSystemID()));
                vector.add(columnInfo);
                vector2.add(inFlightScan.getScanTime());
                hashtable2 = ComplexQuery.generateHashtable(vector, vector2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " DeleteProbeStatus: could " + " not find columninfo for switch_id for table T_RES_SWITCH");
                }
                throw exception;
            }
        }
        if (columnInfo3 == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " FKey is null for hybrid table " + string);
            }
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        string3 = "select T1.<<AUTOID-COL>> from <<TABLENAME>> T1 where T1.<<FKEY-COL>> = ? and T1.UPDATE_TIMESTAMP < ?";
        hashtable.put("<<AUTOID-COL>>", columnInfo2.getName());
        hashtable.put("<<TABLENAME>>", string);
        hashtable.put("<<FKEY-COL>>", columnInfo3.getName());
        vector.add(columnInfo3);
        vector2.add(String.valueOf(inFlightScan.getScanSystemID()));
        vector.add(columnInfo);
        vector2.add(inFlightScan.getScanTime());
        hashtable2 = ComplexQuery.generateHashtable(vector, vector2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from T_RES_ELEMENT_PROBE_STATUS where T_RES_ELEMENT_PROBE_STATUS.ELEMENT_TYPE = ");
        stringBuffer.append(Short.toString(DetSvcTableInfo.getElementType(string)));
        stringBuffer.append(" AND T_RES_ELEMENT_PROBE_STATUS.ELEMENT_ID in (");
        stringBuffer.append(string3);
        stringBuffer.append(")");
        int n = -1;
        n = ParameterizedSql.sqlUpdate(dBConnection, stringBuffer.toString(), hashtable, hashtable2);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " Updated rows = " + n);
        }
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " Result = " + n);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void endScannerFlight(String string) {
        String string2 = "endScannerFlight (" + string + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (string == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return;
        }
        Hashtable hashtable = inFlight;
        synchronized (hashtable) {
            inFlight.remove(string);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
    }

    private static int cancelDiscovery(String string, InFlightScan inFlightScan) {
        InFlightScan inFlightScan2 = null;
        String string2 = "createSnapshot (" + string + " " + inFlightScan2 + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (string == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        inFlightScan2 = inFlightScan == null ? DetectabilityService.getCurrScanner(string) : inFlightScan;
        if (inFlightScan2 != null) {
            inFlightScan2.clearTables();
            if (inFlightScan == null) {
                inFlightScan2.resetLock();
            }
        } else {
            if (TRACE) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return 0;
    }

    private static HashSet dsRSToHSForResolveTab(DBResultSet dBResultSet) throws SQLException {
        String string = "dsRSToHSForResolveTab";
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = "";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        while (dBResultSet.next()) {
            string2 = dBResultSet.getString(2);
            hashSet.add(string2);
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " adding table: " + string2);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, 0);
        }
        return hashSet;
    }

    private static InFlightScan getCurrScanner(String string) {
        String string2 = "getCurrScanner (" + string + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        return DetectabilityService.getCurrScanner(string, -1, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InFlightScan getCurrScanner(String string, int n, int n2, boolean bl) {
        InFlightScan inFlightScan = null;
        String string2 = "getCurrScanner (" + string + ", " + n + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (string == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return null;
        }
        Hashtable hashtable = inFlight;
        synchronized (hashtable) {
            if (inFlight.containsKey(string)) {
                inFlightScan = (InFlightScan)inFlight.get(string);
                inFlightScan.setLock();
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " found scanner on scan " + string);
                }
            } else if (bl) {
                inFlightScan = new InFlightScan(string, n, n2);
                inFlight.put(string, inFlightScan);
                if (TRACE) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " created scanner for scan " + string);
                }
            } else if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "Scanner for scanId =" + string + " should already exist for this function call. \nCannot continue - returning null");
            }
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return inFlightScan;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map nonAuthScan(DBConnection var0, String var1_1, InFlightScan var2_2, boolean var3_3, boolean var4_4, Class var5_5) throws SQLException, Exception {
        block23: {
            var6_6 = "nonAuthScan (" + var0 + ", " + var1_1 + ", " + var2_2 + "," + var3_3 + ", " + var5_5 + ")";
            if (DetectabilityService.TRACE) {
                DetectabilityService.traceLogger.entry(IRecordType.TYPE_ENTRY, DetectabilityService.className, var6_6);
            } else {
                System.out.println(String.valueOf(DetectabilityService.className) + " " + var6_6);
            }
            var7_7 = new HashMap<String, Vector<E>>();
            var7_7.put(var1_1, null);
            var8_8 = DetectabilityService.updateProbeStatus(var2_2, var0, var1_1);
            if (var8_8 != 0) {
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var6_6, var8_8);
                }
                return null;
            }
            var9_9 = DetSvcTableInfo.getAutoIDName(var1_1);
            if (var9_9 == null) {
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var6_6, String.valueOf(var6_6) + " Auto ID not found for table " + var1_1 + "; CONTINUE WITH NEXT TABLE");
                }
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var6_6, 1);
                }
                return null;
            }
            var10_10 = null;
            try {
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var6_6, String.valueOf(var6_6) + " nameAutoID = " + var9_9);
                }
                v0 = new Class[1];
                try {
                    v1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
                v0[0] = v1;
                var10_10 = (ColumnInfo)var5_5.getDeclaredMethod("getColumnInfo", v0).invoke((Object)var5_5, new Object[]{new String(var9_9)});
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var6_6, String.valueOf(var6_6) + " colAutoID = " + var10_10);
                }
            }
            catch (Exception var11_11) {
                if (DetectabilityService.TRACE) {
                    DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var6_6, String.valueOf(var6_6) + " column " + var9_9 + " not found in helper for table " + var1_1);
                }
                throw var11_11;
            }
            var11_12 = new Hashtable<ColumnInfo, String>();
            var12_13 = TResElementProbeStatusTable.getColumnInfo("ELEMENT_TYPE");
            var11_12.put(var12_13, Short.toString(DetSvcTableInfo.getElementType(var1_1)));
            var13_14 = "(" + SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound) + ")";
            var14_15 = new Hashtable<String, String>();
            var14_15.put("<<TABLENAME>>", var1_1);
            var14_15.put("<<AUTOID-COL>>", var9_9);
            var15_16 = null;
            var15_16 = var3_3 != false ? "update <<TABLENAME>> set DETECTABLE = 0, UPDATE_TIMESTAMP = '" + CurrentTime.getTimestamp(var0) + "' where <<AUTOID-COL>> in " : "delete from <<TABLENAME>> where <<AUTOID-COL>> in ";
            var16_17 = null;
            try {
                block24: {
                    if (!var3_3) break block24;
                    var16_17 = ParameterizedSql.sqlQuery(var0, SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound), new Hashtable<K, V>(), var11_12);
                    var17_18 = new Vector<String>();
                    while (true) {
                        block25: {
                            if (var16_17.next()) break block25;
                            var7_7.put(var1_1, var17_18);
                            ** GOTO lbl-1000
                        }
                        var17_18.add(var16_17.getObject(1).toString());
                    }
                }
                if (var4_4) {
                    var16_17 = ParameterizedSql.sqlQuery(var0, SqlElementProbeStatus.getQueryString(SqlElementProbeStatus.queryZeroMaxFound2), var14_15, var11_12);
                    DetectabilityService.delEventGen(var2_2.getProcessID(), var1_1, var16_17);
                }
            }
            catch (Throwable var19_19) {
                var18_20 = null;
                if (var16_17 != null) {
                    var16_17.close();
                    var16_17.getStatement().close();
                    var16_17 = null;
                }
                throw var19_19;
            }
lbl-1000:
            // 2 sources

            {
                var18_21 = null;
                if (var16_17 == null) break block23;
            }
            var16_17.close();
            var16_17.getStatement().close();
            var16_17 = null;
        }
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.text(IRecordType.TYPE_MISC_DATA, DetectabilityService.className, var6_6, String.valueOf(var6_6) + " paramSql = " + var15_16 + "\n" + "concatSql = " + var13_14 + "\n" + "tokenParams = " + var14_15);
        }
        ParameterizedSql.sqlUpdate(var0, var15_16, var14_15, var13_14, var11_12);
        if (!"T_RES_FABRIC".equals(var1_1)) {
            var17_18 = "delete from T_RES_ELEMENT_PROBE_STATUS where ELEMENT_TYPE = <<ELEM_TYPE>> AND ELEMENT_ID in (select T2.ELEMENT_ID from T_RES_ELEMENT_PROBE_STATUS T2 where T2.ELEMENT_TYPE = ? group by T2.ELEMENT_ID having MAX(T2.PROBE_FOUND) = 0)";
            var14_15.clear();
            var14_15.put("<<ELEM_TYPE>>", Short.toString(DetSvcTableInfo.getElementType(var1_1)));
            ParameterizedSql.sqlUpdate(var0, (String)var17_18, var14_15, var11_12);
        }
        if (DetectabilityService.TRACE) {
            DetectabilityService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)DetectabilityService.className, var6_6, 0);
        }
        return var7_7;
    }

    private static int resolveTablesToScan(InFlightScan inFlightScan) throws SQLException {
        String string = "resolveTablesToScan (" + inFlightScan + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        if (inFlightScan == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, 1);
            }
            return 1;
        }
        DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
        DBConnection dBConnection = null;
        dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
        HashSet hashSet = inFlightScan.getList();
        String string2 = inFlightScan.getScanType();
        ColumnInfo columnInfo = TResScantype2tableTable.getColumnInfo("SCAN_TYPE");
        ColumnInfo columnInfo2 = TResScantype2tableTable.getColumnInfo("TABLE_NAME");
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(columnInfo, string2);
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = SqlScantype2table.sqlQuery(dBConnection, SqlScantype2table.queryAllOfScanType, hashtable);
        }
        catch (SQLException sQLException) {
            DetectabilityService.abortDbCon(dBConnection);
            throw sQLException;
        }
        HashSet hashSet2 = DetectabilityService.dsRSToHSForResolveTab(dBResultSet);
        Iterator iterator = hashSet.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (hashSet2.contains(string3)) continue;
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, String.valueOf(string) + " adding table " + string3);
            }
            hashSet2.add(string3);
            hashtable.put(columnInfo2, string3);
            try {
                SqlScantype2table.sqlUpdate(dBConnection, SqlScantype2table.insertRow, hashtable);
            }
            catch (SQLException sQLException) {
                dBResultSet.close();
                DetectabilityService.abortDbCon(dBConnection);
                throw sQLException;
            }
        }
        inFlightScan.replaceList(hashSet2);
        dBResultSet.close();
        dBConnection.commit();
        if (dBConnection != null && !dBConnection.isClosed()) {
            dBConnection.close();
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, 0);
        }
        return 0;
    }

    private static int updateProbeStatus(InFlightScan inFlightScan, DBConnection dBConnection, String string) throws SQLException {
        String string2 = "updateProbeStatus (" + inFlightScan + ", " + dBConnection + ", " + string + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (inFlightScan == null || dBConnection == null || string == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, String.valueOf(string2) + " had null parm");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 1);
            }
            return 1;
        }
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        Hashtable<ColumnInfo, Object> hashtable2 = new Hashtable<ColumnInfo, Object>();
        String string3 = inFlightScan.getScanId();
        Timestamp timestamp = inFlightScan.getScanTime();
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "scannerID = " + string3 + ", " + "scanTS = " + timestamp);
        }
        ColumnInfo columnInfo = TResElementProbeStatusTable.getColumnInfo("PROBE_FOUND");
        ColumnInfo columnInfo2 = TResElementProbeStatusTable.getColumnInfo("SCANNER_ID");
        TResElementProbeStatusTable.getColumnInfo("ELEMENT_ID");
        ColumnInfo columnInfo3 = TResElementProbeStatusTable.getColumnInfo("ELEMENT_TYPE");
        ColumnInfo columnInfo4 = TResElementProbeStatusTable.getColumnInfo("UPDATE_TIMESTAMP");
        columnInfo4 = columnInfo4.addOperator("<");
        hashtable.put(columnInfo, Short.toString((short)0));
        hashtable2.put(columnInfo2, string3);
        hashtable2.put(columnInfo3, Short.toString(DetSvcTableInfo.getElementType(string)));
        hashtable2.put(columnInfo4, timestamp);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "Calling getCursor: \nhtInput = \n\t" + hashtable + "\n" + "Where clause = \n\t" + hashtable2 + "\n");
        }
        int n = ElementProbeStatus.update(dBConnection, hashtable, hashtable2);
        if (TRACE) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string2, "result = " + n);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return 0;
    }

    private static Vector getColsForEventGen(Hashtable hashtable) {
        String string = "getColsForEventGen(" + hashtable + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        Vector<ColumnInfo> vector = new Vector<ColumnInfo>();
        Iterator iterator = hashtable.values().iterator();
        ColumnInfo columnInfo = null;
        Object var5_5 = null;
        while (iterator.hasNext()) {
            var5_5 = iterator.next();
            if (var5_5 instanceof ColumnInfo) {
                columnInfo = var5_5;
                if (!columnInfo.isAutoGenerated()) continue;
                vector.add(columnInfo);
                continue;
            }
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string, "Input hashtable has non-ColumnInfo object; ignoring...");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, 0);
        }
        return vector;
    }

    private static String createAuthParamQuery(String string, Vector vector, Hashtable hashtable) {
        String string2 = "createAuthParamQuery(" + string + "," + vector + "," + hashtable + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        if (vector == null || vector.size() == 0) {
            stringBuffer.append("* ");
        } else {
            int n = 0;
            while (n < vector.size()) {
                stringBuffer.append(((ColumnInfo)vector.elementAt(n)).getName());
                if (n < vector.size() - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        if (hashtable != null && hashtable.size() != 0) {
            stringBuffer.append(" WHERE ");
            String string3 = DetectabilityService.buildWhereClause(hashtable);
            stringBuffer.append(string3);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, 0);
        }
        return stringBuffer.toString();
    }

    private static String buildWhereClause(Hashtable hashtable) {
        String string = "buildWhereClause (" + hashtable + ")";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap treeMap = new TreeMap(hashtable);
        Iterator iterator = treeMap.keySet().iterator();
        ColumnInfo columnInfo = null;
        while (iterator.hasNext()) {
            Class<?> clazz;
            columnInfo = (ColumnInfo)iterator.next();
            stringBuffer.append(columnInfo.getName());
            try {
                clazz = Class.forName("org.eclipse.aperi.infrastructure.database.Null");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (hashtable.get(columnInfo).getClass() != clazz) {
                if (columnInfo.getOperator() != null) {
                    stringBuffer.append(columnInfo.getOperator());
                } else {
                    stringBuffer.append("=");
                }
                stringBuffer.append("?");
            } else {
                stringBuffer.append(" IS NULL");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" AND ");
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, 0);
        }
        return stringBuffer.toString();
    }

    private static void delEventGen(String string, String string2, DBResultSet dBResultSet) throws SQLException {
        String string3 = "delEventGen(" + string + "," + string2 + "," + "DBResultSet with missing entities' autoIDs";
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string3);
        }
        if (string == null || string2 == null || dBResultSet == null) {
            if (TRACE) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string3, "Null input parameter");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, 1);
            }
            return;
        }
        int n = dBResultSet.getMetaData().getColumnCount();
        if (eventMonitor == null) {
            eventMonitor = DetectabilityService.getEventMonitorProxy();
        }
        boolean bl = eventMonitor == null;
        while (dBResultSet.next()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n2 = 1;
            while (n2 <= n) {
                hashMap.put(dBResultSet.getMetaData().getColumnName(n2), dBResultSet.getObject(n2));
                ++n2;
            }
            if (!bl) {
                eventMonitor.handleDeletedDevice(string, string2, hashMap);
                continue;
            }
            if (!TRACE) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string3, "Cannot obtain IEventMonitorService instance; cannot generate events for:" + hashMap.toString());
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3, 0);
        }
    }

    private static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)Activator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static String getTypeFromScanId(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return null;
        }
        return string.substring(0, string.indexOf(":"));
    }

    public static String getClassFromScanId(String string) {
        String string2 = DetectabilityService.getTypeFromScanId(string);
        if (string2 == null) {
            return null;
        }
        return (String)scannerIdToClassMappings.get(string2);
    }
}

