/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import com.ibm.log.Level;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class DataConverter {
    private String classname = "org.eclipse.aperi.infrastructure.mapping.DataConverter.java";
    private ILogger myLogger = null;
    private final boolean useLogger = true;
    Hashtable m_simpleDataConversions = new Hashtable();
    Hashtable m_complexDataConversions = new Hashtable();
    Hashtable m_calculationDataConversions = new Hashtable();

    DataConverter() {
        this.myLogger = DBConstants.getLogger();
    }

    void addCalculationDataConversion(String string, String string2, String string3) {
        this.m_calculationDataConversions.put(string.toLowerCase(), new OperatorAndValue(string2, string3));
    }

    void addSimpleDataConversion(String string, Hashtable hashtable) {
        this.m_simpleDataConversions.put(string.toLowerCase(), hashtable);
    }

    void addSimpleDataConversion(String string, String string2) {
        this.m_simpleDataConversions.put(string.toLowerCase(), string2);
    }

    void addComplexDataConversion(String string, String string2, int n) {
        this.m_complexDataConversions.put(string.toLowerCase(), new RegexAndValue(string2, n));
    }

    void removeSimpleAndComplexDataConversion(String string) {
        String string2 = string.toLowerCase();
        this.m_complexDataConversions.remove(string2);
        this.m_simpleDataConversions.remove(string2);
    }

    void removeCalculationDataConversion(String string) {
        this.m_calculationDataConversions.remove(string.toLowerCase());
    }

    void removeSimpleDataConversion(String string) {
        this.m_simpleDataConversions.remove(string.toLowerCase());
    }

    void removeComplexDataConversion(String string) {
        this.m_complexDataConversions.remove(string.toLowerCase());
    }

    void performDataConversion(Hashtable hashtable) {
        String string = "performDataConversion(Hashtable htValues)";
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            String string2 = (String)iterator.next();
            String string3 = string2.toLowerCase();
            String string4 = (String)hashtable.get(string2);
            if (string4 == null) continue;
            String string5 = null;
            RegexAndValue regexAndValue = (RegexAndValue)this.m_complexDataConversions.get(string3);
            if (regexAndValue != null) {
                string5 = regexAndValue.getNthField(string4);
                if (string5 != null && string5.length() > 0) {
                    this.log(IRecordType.TYPE_INFO, string, "For xmlTag " + string2 + ", converting \"" + string4 + "\" to \"" + string5 + "\"");
                    string4 = string5;
                } else {
                    iterator.remove();
                    this.log(IRecordType.TYPE_WARNING, string, "For xmlTag " + string2 + ", \"" + string4 + "\" did not contain the appropriate token to get desired value.  This mapping will be removed from info to be persisted.");
                }
            }
            if ((v = this.m_simpleDataConversions.get(string3)) != null) {
                if (v instanceof Hashtable) {
                    string5 = (String)((Hashtable)v).get(string4.toLowerCase());
                    this.log(IRecordType.TYPE_INFO, string, "For xmlTag " + string2 + ", converting \"" + string4 + "\" to \"" + string5 + "\"");
                } else {
                    string5 = DBConstants.getValueFromKey((String)v, string4.toLowerCase());
                    this.log(IRecordType.TYPE_INFO, string, "For xmlTag " + string2 + ", converting \"" + string4 + "\" to \"" + string5 + "\"");
                }
                if (string5 == null) {
                    iterator.remove();
                    this.log(IRecordType.TYPE_WARNING, string, "For xmlTag " + string2 + ", \"" + string4.toLowerCase() + "\" was not found in the specified lookup hashtable.  This mapping will be removed from info to be persisted.");
                }
            }
            if (string5 != null) {
                hashtable2.put(string2, string5);
                continue;
            }
            OperatorAndValue operatorAndValue = (OperatorAndValue)this.m_calculationDataConversions.get(string3);
            if (operatorAndValue == null) continue;
            string5 = operatorAndValue.getCalculatedResultValue(string4);
            if (string5 != null && string5.length() > 0) {
                this.log(IRecordType.TYPE_INFO, string, "For xmlTag " + string2 + ", calculated \"" + string4 + "\" to \"" + string5 + "\"");
                hashtable2.put(string2, string5);
                continue;
            }
            iterator.remove();
            this.log(IRecordType.TYPE_WARNING, string, "For xmlTag " + string2 + ", \"" + string4 + "\" did not contain the appropriate token to get desired value.  This mapping will be removed from info to be persisted.");
        }
        hashtable.putAll(hashtable2);
    }

    private void log(Level level, String string, String string2) {
        if (this.myLogger.isLogging()) {
            this.myLogger.text(level, this.classname, string, string2);
        } else {
            System.out.println(String.valueOf(this.classname) + "." + string + ":  " + string2);
        }
    }

    class RegexAndValue {
        int m_nthField;
        String m_regexString;
        boolean m_initialized;

        RegexAndValue(String string, int n) {
            if (string != null) {
                this.m_regexString = new String(string);
                this.m_nthField = n;
                this.m_initialized = true;
            } else {
                this.m_initialized = false;
            }
        }

        String getNthField(String string) {
            if (!this.m_initialized) {
                return null;
            }
            String[] stringArray = string.split(this.m_regexString);
            if (stringArray.length <= this.m_nthField - 1) {
                return null;
            }
            return stringArray[this.m_nthField - 1];
        }
    }

    class OperatorAndValue {
        public long cValue;
        public String cOperator;

        OperatorAndValue(String string, String string2) {
            this.cValue = Long.parseLong(string2);
            this.cOperator = string;
        }

        public String getCalculatedResultValue(String string) {
            long l = Long.parseLong(string);
            if (this.cOperator.equals("+")) {
                return String.valueOf(l + this.cValue);
            }
            if (this.cOperator.equals("-")) {
                return String.valueOf(l - this.cValue);
            }
            if (this.cOperator.equals("*")) {
                return String.valueOf(l * this.cValue);
            }
            if (this.cOperator.equals("/")) {
                return String.valueOf(l / this.cValue);
            }
            return string;
        }
    }
}

