/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISIBMTSDS_DiskExtentToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "IBMTSDS_DiskExtent";
        String string2 = "1.1.0";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISIBMTSDS_DiskExtentToDBMapper() {
        ColumnInfo columnInfo = PhysicalVolume.getColumnInfo("DEVICE_ID");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("deviceid", mapperInfo);
        ColumnInfo columnInfo3 = PhysicalVolume.getColumnInfo("SYSTEM_NAMES_ID");
        columnInfo3.setIsPrimaryKey();
        MapperInfo mapperInfo2 = new MapperInfo(columnInfo3);
        this.m_htAttribToMapperInfo.put("systemname", mapperInfo2);
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_dataConverter.addCalculationDataConversion("capacity", "/", "512");
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        ColumnInfo columnInfo4 = PhysicalVolume.getColumnInfo("SUBSYSTEM_ID");
        MapperInfo mapperInfo3 = new MapperInfo(columnInfo4);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", mapperInfo3);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string2 = (String)hashtable.get("deviceid");
        if (string2 != null) {
            hashtable.put("serialnumber", string2);
        }
        String string3 = (String)hashtable.get("numberofblocks");
        double d = 0.0;
        if (string3 != null) {
            try {
                long l = Long.parseLong((String)hashtable.get("blocksize"));
                long l2 = Long.parseLong((String)hashtable.get("numberofblocks"));
                long l3 = l * l2;
                string3 = Long.toString(l3);
                d = l3 / 1000L / 1000L / 1000L;
                d = Math.abs(d);
                hashtable.put("capacity", string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Wasn't able to calculate PhysicalVolume Capacity");
            }
            catch (Exception exception) {
                this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", exception, "Wasn't able to calculate PhysicalVolume Capacity");
            }
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        String string4 = (String)hashtable.get("ref_tag");
        String string5 = (String)hashtable.get("ref_diskgroup_id");
        if (string4 != null && string5 != null) {
            DiskGroup diskGroup = new DiskGroup();
            diskGroup.setTag(string4);
            if (diskGroup.retrieve(dBConnection)) {
                diskGroup = new DiskGroup();
                diskGroup.setTag(string4);
                diskGroup.setDdmCap(d);
                diskGroup.update(dBConnection);
            }
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
        return mapperResult;
    }
}

