/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.interfaces;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.interfaces.ParameterException;

public class DiscoverRequest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3849478284842903700L;
    public static final String CIMOM = "CIMOM";
    public static final String IPADDRESS = "IPADDRESS";
    public static final String AGENT = "AGENT";
    public static final String SCANNER = "SCANNER";
    public static final String USERID = "USERID";
    public static final String PASSWORD = "PASSWORD";
    public static final String DEVICEID = "DEVICEID";
    public static final String CAPABILITY_DATA = "CAPABILITY";
    public static final String TOP_LEVEL_COMPUTERSYSTEM = "TL_CS";
    public static final String VENDOR = "VENDOR";
    public static final String MODEL = "MODEL";
    public static final String CIMOM_SOFTWARE_LEVEL = "CIMOMSWLVL";
    private String cCommand = null;
    private String cDescription;
    private HashMap cParameterTypes;
    private HashMap cParameterValues;

    private DiscoverRequest() {
        this.cParameterValues = new HashMap();
    }

    public DiscoverRequest(String string, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        this.cDescription = string;
        this.cParameterTypes = new HashMap();
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Number of parameters and corresponding types differ.");
        }
        int n = 0;
        while (n < stringArray.length) {
            this.cParameterTypes.put(stringArray[n], stringArray2[n]);
            ++n;
        }
        this.cParameterValues = new HashMap();
    }

    public void setCommand(String string) {
        this.cCommand = string;
    }

    public String getCommand() {
        return this.cCommand;
    }

    public void setParameters(Map map) throws ParameterException {
        if (this.cParameterTypes.size() != map.size()) {
            throw new ParameterException("Not all parameters are specified.");
        }
        this.cParameterValues.clear();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (!this.cParameterTypes.containsKey(string)) {
                throw new ParameterException("Invalid parameter (" + string + ")");
            }
            String string2 = this.getParameterType(string);
            try {
                if (v == null || !Class.forName(string2).isInstance(v)) {
                    throw new ParameterException("Parameter " + string + "(" + (v == null ? "null" : v.getClass().getName()) + ") is not of type " + this.cParameterTypes.get(string));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParameterException("Class named " + string2 + " is not defined");
            }
            this.cParameterValues.put(string, v);
        }
    }

    public Map getParameters() {
        return this.cParameterValues;
    }

    public Object getParameter(String string) {
        return this.cParameterValues.get(string);
    }

    public String getParameterType(String string) {
        return (String)this.cParameterTypes.get(string);
    }

    public static Object getParameter(Map map, String string, String string2) throws ParameterException {
        Object v = map.get(string);
        if (v == null) {
            throw new ParameterException("Parameter " + string + " is missing.");
        }
        try {
            if (!Class.forName(string2).isInstance(v)) {
                throw new ParameterException("Parameter " + string + "(" + v.getClass().getName() + ") is not of type " + string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParameterException("Class named " + string2 + " is not defined");
        }
        return v;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DiscoverRequest: " + this.cDescription + "\n");
        Set set = this.cParameterTypes.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("     " + entry.getKey() + (this.cParameterValues.get(entry.getKey()) != null ? "=" + this.cParameterValues.get(entry.getKey()).toString() : "") + ", type is " + entry.getValue() + "\n");
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        return this.cDescription;
    }

    public Object clone() throws CloneNotSupportedException {
        DiscoverRequest discoverRequest = new DiscoverRequest();
        discoverRequest.cCommand = this.cCommand;
        discoverRequest.cDescription = this.cDescription;
        discoverRequest.cParameterTypes = (HashMap)this.cParameterTypes.clone();
        return discoverRequest;
    }
}

