/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;
import org.eclipse.aperi.xmsg.NestableException;

public class LimitedWaitOutputStream
extends OutputStream
implements Runnable {
    private static final String THREAD_NAME = "IO Prodder";
    private static IORequest requestHead;
    private static IORequest requestTail;
    private static Thread thread;
    private boolean shutdown = false;
    private static IORequest inProgress;
    private OutputStream real;
    private boolean timedOut;
    private boolean tooLate;
    private boolean awaitingCancel;
    private long timeout;

    static {
        thread = null;
        requestHead = null;
        requestTail = null;
        inProgress = null;
        thread = new TSThread(new LimitedWaitOutputStream(), THREAD_NAME);
        thread.setDaemon(true);
        thread.start();
    }

    private LimitedWaitOutputStream() {
        this.real = null;
    }

    public LimitedWaitOutputStream(OutputStream outputStream, int n) {
        this.real = outputStream;
        if (this.real == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "LimitedWaitOutputStream");
            }
            throw new RuntimeException("LimitedWaitOutputStream(): NULL passed");
        }
        this.timedOut = false;
        this.tooLate = false;
        this.awaitingCancel = true;
        this.timeout = n;
        this.timeout *= 1000L;
    }

    private static synchronized void enqueue(IORequest iORequest) {
        Class<?> clazz;
        if (requestTail == null) {
            requestHead = iORequest;
        } else {
            LimitedWaitOutputStream.requestTail.next = iORequest;
        }
        requestTail = iORequest;
        try {
            clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        clazz.notify();
    }

    private synchronized void notifyWaiter(boolean bl) {
        this.tooLate = bl;
        this.awaitingCancel = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queueCancelAndWait() throws LocalizableException {
        LimitedWaitOutputStream.enqueue(new IORequest(this, -1L));
        LimitedWaitOutputStream limitedWaitOutputStream = this;
        synchronized (limitedWaitOutputStream) {
            while (this.awaitingCancel) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz.getName(), "queueCancelAndWait", interruptedException);
                }
            }
        }
        if (!this.tooLate) {
            return;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "queueCancelAndWait");
        }
        throw new LocalizableException("GEN0556E", null);
    }

    private static void cancel(LimitedWaitOutputStream limitedWaitOutputStream) {
        IORequest iORequest = null;
        IORequest iORequest2 = inProgress;
        while (iORequest2 != null && iORequest2.stream != limitedWaitOutputStream) {
            iORequest = iORequest2;
            iORequest2 = iORequest2.next;
        }
        if (iORequest2 != null) {
            if (iORequest == null) {
                inProgress = iORequest2.next;
            } else {
                iORequest.next = iORequest2.next;
            }
        }
        limitedWaitOutputStream.notifyWaiter(iORequest2 == null);
    }

    private static void insert(IORequest iORequest, long l) {
        iORequest.time += l;
        IORequest iORequest2 = null;
        IORequest iORequest3 = inProgress;
        while (iORequest3 != null && iORequest3.time < iORequest.time) {
            iORequest2 = iORequest3;
            iORequest3 = iORequest3.next;
        }
        if (iORequest2 == null) {
            inProgress = iORequest;
        } else {
            iORequest2.next = iORequest;
        }
        iORequest.next = iORequest3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry(v0.getName(), "run", "");
        }
        if (this.real != null) {
            if (TraceLogger.enableTrace == false) throw new RuntimeException("LimitedWaitOutputStream.run() called illegally!");
            try {
                v2 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            TraceLogger.exit(v2.getName(), "run");
            throw new RuntimeException("LimitedWaitOutputStream.run() called illegally!");
        }
        var1_1 = 0x7FFFFFFFFFFFFFFFL;
        var3_2 = System.currentTimeMillis();
        while (!this.shutdown) {
            var5_3 = null;
            var6_4 = var3_2;
            try {
                v4 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
            var8_5 = v4;
            // MONITORENTER : v4
            while (true) {
                block29: {
                    block30: {
                        if (LimitedWaitOutputStream.requestHead == null && var1_1 > 0L) break block30;
                        var5_3 = LimitedWaitOutputStream.requestHead;
                        LimitedWaitOutputStream.requestHead = null;
                        LimitedWaitOutputStream.requestTail = null;
                        // MONITOREXIT : var8_5
                        if (true) ** GOTO lbl72
                    }
                    try {
                        try {
                            v6 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                        }
                        catch (ClassNotFoundException v7) {
                            throw new NoClassDefFoundError(v7.getMessage());
                        }
                        v6.wait(var1_1);
                        if (this.shutdown) {
                            // MONITOREXIT : var8_5
                            return;
                        }
                    }
                    catch (InterruptedException var9_7) {
                        if (!TraceLogger.enableTrace) break block29;
                        try {
                            v8 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                        }
                        catch (ClassNotFoundException v9) {
                            throw new NoClassDefFoundError(v9.getMessage());
                        }
                        TraceLogger.exception(v8.getName(), "run", var9_7);
                    }
                }
                var3_2 = System.currentTimeMillis();
                var1_1 -= var3_2 - var6_4;
                var6_4 = var3_2;
            }
            do {
                var8_5 = var5_3.next;
                if (var5_3.time < 0L) {
                    LimitedWaitOutputStream.cancel(var5_3.stream);
                } else {
                    LimitedWaitOutputStream.insert((IORequest)var5_3, var3_2);
                }
                var5_3 = var8_5;
lbl72:
                // 2 sources

            } while (var5_3 != null);
            while (LimitedWaitOutputStream.inProgress != null && LimitedWaitOutputStream.inProgress.time <= var3_2) {
                LimitedWaitOutputStream.inProgress.stream.timedOut = true;
                try {
                    LimitedWaitOutputStream.inProgress.stream.real.close();
                }
                catch (IOException var8_6) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v11 = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                        }
                        catch (ClassNotFoundException v12) {
                            throw new NoClassDefFoundError(v12.getMessage());
                        }
                        TraceLogger.exception(v11.getName(), "run", var8_6);
                    }
                    MessageLog.logException("GEN0168E", var8_6);
                }
                LimitedWaitOutputStream.inProgress = LimitedWaitOutputStream.inProgress.next;
            }
            var1_1 = LimitedWaitOutputStream.inProgress == null ? 0x7FFFFFFFFFFFFFFFL : LimitedWaitOutputStream.inProgress.time - var3_2;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws LocalizableException {
        IOException iOException = null;
        try {
            LimitedWaitOutputStream.enqueue(new IORequest(this, this.timeout));
            this.real.write(byArray, n, n2);
        }
        catch (IOException iOException2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "write", iOException2);
            }
            iOException = iOException2;
        }
        if (this.timedOut) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "write");
            }
            throw new LocalizableException("GEN0164E", null);
        }
        this.queueCancelAndWait();
        if (iOException != null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "write");
            }
            throw new NestableException("GEN0166E", null, iOException);
        }
    }

    public void write(byte[] byArray) throws LocalizableException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws LocalizableException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void close() throws LocalizableException {
        try {
            this.real.close();
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "close", iOException);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.request.LimitedWaitOutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "close");
            }
            throw new NestableException("GEN0168E", null, iOException);
        }
    }

    private static class IORequest {
        public IORequest next;
        public long time;
        public LimitedWaitOutputStream stream;

        public IORequest(LimitedWaitOutputStream limitedWaitOutputStream, long l) {
            this.stream = limitedWaitOutputStream;
            this.time = l;
        }
    }
}

