/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.NullUserException;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.sanmgmt.middleware.data.SOAPNotAuthorizedException;
import org.eclipse.aperi.sanmgmt.middleware.data.SOAPNotLicensedException;

public class RPCSecureJavaProvider
extends RPCJavaProvider {
    private static Hashtable roles;
    private static ThreadLocal threadLocal;
    private static ILogger auditLogger;
    private static final String BUNDLE_NAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    private static final String className;

    static {
        Class<?> clazz;
        roles = new Hashtable();
        threadLocal = new ThreadLocal();
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        auditLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.audit");
        auditLogger.setMessageFile(BUNDLE_NAME);
    }

    public static void setRoleMapping(String string, String string2, Integer n) {
        roles.put(String.valueOf(string) + string2, n);
    }

    public void locate(DeploymentDescriptor deploymentDescriptor, Envelope envelope, Call call, String string, String string2, SOAPContext sOAPContext) throws SOAPException {
        super.locate(deploymentDescriptor, envelope, call, string, string2, sOAPContext);
        HttpServletRequest httpServletRequest = (HttpServletRequest)sOAPContext.getProperty(Constants.BAG_HTTPSERVLETREQUEST);
        this.isAuthorized(httpServletRequest, string2, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void isAuthorized(HttpServletRequest httpServletRequest, String string, String string2) throws SOAPNotAuthorizedException, SOAPNotLicensedException, NullUserException {
        if (httpServletRequest.getSession().getValue("isSystemUser") != null) return;
        boolean bl = false;
        if (httpServletRequest.getRemoteUser() == null) {
            if (!"DeviceServiceManager".equals(this.targetObjectURI)) throw new NullUserException(Constants.FAULT_CODE_SERVER, "Service " + string + " Method " + string2);
            if (!"handshake".equals(string2)) throw new NullUserException(Constants.FAULT_CODE_SERVER, "Service " + string + " Method " + string2);
            return;
        }
        bl = this.checkAuthorization(httpServletRequest, string, string2);
        if (bl) return;
        Object[] objectArray = new String[]{(String)this.session.getValue("userName"), this.targetObjectURI, String.valueOf(string) + "." + string2};
        if (auditLogger == null) throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
        if (!auditLogger.isLogging()) throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
        auditLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, this.methodName, "TSNMServiceManager_UnauthorizedRequest", objectArray);
        throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not authorized");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkAuthorization(HttpServletRequest httpServletRequest, String string, String string2) throws SOAPNotAuthorizedException {
        String string3 = "checkAuthorization";
        boolean bl = false;
        if (Roles.getPassthrough()) {
            return true;
        }
        Integer n = (Integer)roles.get(String.valueOf(string) + string2);
        if (n != null) {
            try {
                Roles roles = Roles.getInstance();
                if (roles == null) return bl;
                int n2 = roles.getUserRoles(httpServletRequest.getRemoteUser());
                if (!RoleChecker.isUserInRole(n2, n)) return bl;
                return true;
            }
            catch (SQLException sQLException) {
                this.logRoleAndLicenseError(string, string2, string3, "TSNMServiceManager_UnauthorizedRequest", httpServletRequest.getRemoteUser(), httpServletRequest.getRemoteHost());
                throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Role authorization was unretrivable from the repository");
            }
        }
        this.logRoleAndLicenseError(string, string2, string3, "TSNMServiceManager_UnauthorizedRequest", httpServletRequest.getRemoteUser(), httpServletRequest.getRemoteHost());
        throw new SOAPNotAuthorizedException(Constants.FAULT_CODE_SERVER, "Not registered");
    }

    private void logRoleAndLicenseError(String string, String string2, String string3, String string4, String string5, String string6) {
        ILogger iLogger;
        Object[] objectArray = new String[]{string5, string6, String.valueOf(string) + "." + string2};
        if (auditLogger != null && auditLogger.isLogging()) {
            auditLogger.message(IRecordType.TYPE_ERROR, (Object)className, string3, string4, objectArray);
        }
        if ((iLogger = LogManagerFactory.getTraceLogger("aperi.logger.trace.TSNMServiceManager")) != null && iLogger.isLogging()) {
            iLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, string4, objectArray);
        }
    }

    public void invoke(SOAPContext sOAPContext, SOAPContext sOAPContext2) throws SOAPException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)sOAPContext.getProperty(Constants.BAG_HTTPSERVLETREQUEST);
        if (httpServletRequest.getRemoteUser() != null) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("USER", httpServletRequest.getRemoteUser());
            try {
                hashtable.put("ROLE", new Integer(Roles.getInstance().getUserRoles(httpServletRequest.getRemoteUser())));
            }
            catch (Exception exception) {}
            if (httpServletRequest.getRemoteHost() != null) {
                hashtable.put("HOST", httpServletRequest.getRemoteHost());
            }
            RPCSecureJavaProvider.addUserProperties(hashtable);
        }
        super.invoke(sOAPContext, sOAPContext2);
    }

    public static Map getUserProperties() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)threadLocal.get();
        }
        catch (Throwable throwable) {}
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public static void addUserProperties(Map map) {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)threadLocal.get();
        }
        catch (Throwable throwable) {}
        if (hashtable == null) {
            hashtable = new Hashtable();
            threadLocal.set(hashtable);
        }
        hashtable.putAll(map);
    }
}

