

##########################################################################
# Non dbms specific repository creation script. 
# Processed by TrelliSoft.install.RepositoryInstall
# 
# This file must have the following format:
# 1) The first line of the file must contain a count of the sql stmts
#    included in the line. This info is used to update a progress bar
#    as the sql file is being processed. This line should be in the
#    format:
#        sqlcount = <n>
#    where <n> represents the # of statements contained in the file
#
# 2) Each sql statement must be terminated by a ';' as the first char
#    of a new line. Everything else on the terminator line is ignored.
#
# 3) Comments are denoted by a '#' as the first char of a line. Everything
#    on a comment line is ignored
#
# Parm    Oracle        MSSQL                      DB2
# ----    ------        -----                      ---
# {0}     decimal(10)   integer                    integer
# {1}     decimal(5)    smallint                   smallint
# {2}     raw(20)       varbinary(20)              varchar(20) for bit data
# {3}     date          datetime                   timestamp
# {4}     long          text                       long varchar
# {5}     long raw      image                      long varchar for bit data
# {6}     <empty>       case_mask varbinary(8)     <empty>
#                         default 0x00 not null,
# {7}     <empty>       case_mask varbinary(64)    <empty>
#                         default 0x00 not null,
# {8}     sysdate       current_timestamp          current timestamp
# {9}     '20'          ' '                        ' '
# {10}    <empty>       , case_mask                <empty>
# {11}    <empty>       0x00,                      <empty>
# {12}    float         float                      float
# {13}    raw(60)       varbinary(60)              varchar(60) for bit data
# {14}    <empty>       t_res_stat_dir.            <empty>
# {15}    modify        alter column               alter
# {16}    <empty>       <empty>                    set data type
# {17}    <empty>       not null                   <empty>
# {18}    column        column                     <empty>
# {19}    '4e'          0x4e                       x'4e'
# {20}    partition     partition                  "partition"
# {21}    default null  null                       <empty>
# {22}    <empty>       <empty>                    IN <tablspace>
# {110}   '00'          0x00                       x'00'
# {111}    -            -                          bigint
###########################################################################

# Change Log
# Date/Author/Description
#-------------------------
# Jan 25, 2007/Prasenjit Sarkar/Ported over TPC 3.1.3 changes

ALTER TABLE T_RES_PHYSICAL_VOLUME ADD COLUMN LUNSSID VARCHAR(512)
;

ALTER TABLE T_RES_TOKEN ADD COLUMN USER_ID VARCHAR(32)
;

ALTER TABLE T_RES_TOKEN ADD COLUMN INITIAL_TSTAMP TIMESTAMP DEFAULT {8}
;

CREATE INDEX Node2hbaix1 ON T_RES_NODE2HBA
		(NODE2HBA_ID, 
		 NODE_ID) 
;

 CREATE INDEX stgVolix1 ON T_RES_STORAGE_VOLUME
		(operational_status asc, 
                 consolidated_status asc, 
		 subsystem_id asc,                 
                 svid asc, 
                 unique_id asc ) 
;

 CREATE INDEX statdhistix1 ON T_STAT_DISK_HIST
 (free_space asc, 
  capacity asc, 
  statistic_type asc,   
  disk_id asc )
;
  
 CREATE INDEX statdhistix2 ON T_STAT_DISK_HIST
 (
  statistic_type asc,  
  disk_id asc )
;

 CREATE INDEX devaccessix1 ON T_res_dev_access
 ( device_id asc )
;

 CREATE INDEX portix1 ON T_res_port
 ( subsystem_id , 
  node_id ,
  name,
  port_id )
;

DROP VIEW T_VIEW_ALL_PORTS
;

DROP VIEW T_VIEW_DEAD_END_PORTS
;

DROP VIEW T_VIEW_HOST_SS_PORTS
;

DROP VIEW T_VIEW_HOSTPORT2FABRIC
;

DROP VIEW T_VIEW_HOST2FABRIC
;

DROP VIEW T_VIEW_SWITCH2HOST
;

DROP VIEW T_VIEW_SUBSYSTEM2FABRIC
;

DROP VIEW T_VIEW_SWITCH2SUBSYSTEM
;

DROP VIEW T_VIEW_SWITCH2FABRIC
;

DROP VIEW T_VIEW_PORT2PORT
;

DROP VIEW T_VIEW_SWITCH2PORT
;

DROP VIEW T_VIEW_HOST2PORT
;

DROP VIEW T_VIEW_HOST2PORT_TEMP2
;

DROP VIEW T_VIEW_HOST2PORT_TEMP1
;

DROP VIEW T_VIEW_SUBSYSTEM2PORT
;

create table T_VIEW_SUBSYSTEM2FABRIC (
  SUBSYSTEM_ID                INTEGER,
  FABRIC_ID             INTEGER)
;

create table T_VIEW_SUBSYSTEM2PORT (
  SUBSYSTEM_ID                INTEGER,
  PORT_ID               INTEGER)
;

create table T_VIEW_SWITCH2FABRIC (
  SWITCH_ID             INTEGER,
  FABRIC_ID             INTEGER)
;

create table T_VIEW_SWITCH2HOST (
  HOST_ID               INTEGER,
  HOST_URL              VARCHAR(255),
  HOST_PORT_ID                INTEGER,
  SWITCH_ID             INTEGER,
  PORT2PORT_ID                INTEGER,
  DETECTABLE                  SMALLINT,
  SWITCH_PORT_ID        INTEGER)
;

create table T_VIEW_SWITCH2PORT (
  SWITCH_ID             INTEGER,
  PORT_ID               INTEGER)
;

create table T_VIEW_SWITCH2SUBSYSTEM (
  SUBSYSTEM_ID                INTEGER,
  SUBSYSTEM_PORT_ID           INTEGER,
  SWITCH_PORT_ID        INTEGER,
  SWITCH_ID             INTEGER,
  DETECTABLE                  SMALLINT,
  PORT2PORT_ID                INTEGER)
;

create table T_VIEW_HOST2FABRIC (
  HOST_ID               INTEGER,
  HOST_URL              VARCHAR(255),
  FABRIC_ID             INTEGER)
;

create table T_VIEW_HOST2PORT (
  PORT_ID               INTEGER,
  HOST_ID               INTEGER,
  HOST_URL              VARCHAR(255))
;

create table T_VIEW_HOST2PORT_TEMP1 (
  HOST_ID               INTEGER,
  HOST_URL              VARCHAR(255),
  PORT_ID               INTEGER)
;

create table T_VIEW_HOST2PORT_TEMP2 (
  HOST_ID               INTEGER,
  HOST_URL              VARCHAR(255),
  PORT_ID               INTEGER)
;

create table T_VIEW_HOSTPORT2FABRIC (
  HOST_ID               INTEGER,
  PORT_ID               INTEGER,
  HOST_URL              VARCHAR(255),
  FABRIC_WWN                  CHAR(16))
;

create table T_VIEW_DEAD_END_PORTS (
  PORT_WWN              VARCHAR(255),
  SUBSYSTEM_ID                INTEGER,
  HOST_URL              VARCHAR(255),
  FABRIC_WWN                  CHAR(16),
  SUBSYSTEM_TYPE        VARCHAR(255),
  SUBSYSTEM_DISPLAY_TYPE      VARCHAR(255))
;

create table T_VIEW_HOST_SS_PORTS (
  PORT_WWN              VARCHAR(255),
  SUBSYSTEM_ID                INTEGER,
  HOST_URL              VARCHAR(255),
  FABRIC_WWN                  CHAR(16),
  SUBSYSTEM_TYPE        VARCHAR(255),
  SUBSYSTEM_DISPLAY_TYPE      VARCHAR(255))
;

create table T_VIEW_ALL_PORTS (
  PORT_WWN              VARCHAR(255),
  SUBSYSTEM_ID                INTEGER,
  HOST_URL              VARCHAR(255),
  FABRIC_WWN                  CHAR(16),
  SUBSYSTEM_TYPE        VARCHAR(255),
  SUBSYSTEM_DISPLAY_TYPE      VARCHAR(255))
;

create table T_VIEW_PORT2PORT (
  PORT2PORT_ID                INTEGER,
  PORT_ID1              INTEGER,
  PORT_ID2              INTEGER,
  DETECTABLE                  SMALLINT)
;


CREATE TABLE T_BIRT_DESCR  ( 
		 TITLE			VARCHAR(64) NOT NULL,
		 NAME			VARCHAR(64) NOT NULL,
		 PATH			VARCHAR(256) NOT NULL,
		 ROLES			INTEGER NOT NULL,
		 DESCRIPTION	VARCHAR(256) NOT NULL,
		 CREATOR		VARCHAR(64) NOT NULL, 
		 CREATION_DATE	DECIMAL(13,0) NOT NULL,
		 EDITOR			VARCHAR(64) NOT NULL, 
		 EDIT_DATE		DECIMAL(13,0) NOT NULL)
;

CREATE UNIQUE INDEX T_BIRT_DESCR_IX ON T_BIRT_DESCR
		(PATH ASC,
		 NAME ASC)
;

