/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDataExport;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskCacheResultSet {
    private Map infoMap;
    private int dataCount;
    private DiskDataExport databaseExport;
    private ResultObjectUtil resultObjectUtil;
    private IRowIterator rowIterator;
    static final /* synthetic */ boolean $assertionsDisabled;

    DiskCacheResultSet(Map infoMap) {
        this.infoMap = infoMap;
    }

    public void processStartResultObjects(IResultObject[] resultObjects, Comparator comparator) throws IOException {
        IResultClass rsMetaData = resultObjects[0].getResultClass();
        if (!$assertionsDisabled && rsMetaData == null) {
            throw new AssertionError();
        }
        this.resultObjectUtil = ResultObjectUtil.newInstance(rsMetaData);
        this.databaseExport = DiskDataExport.newInstance(this.infoMap, comparator, rsMetaData, this.resultObjectUtil);
        this.databaseExport.exportStartDataToDisk(resultObjects);
        this.dataCount = resultObjects.length;
    }

    public void processRestResultObjects(IResultObject resultObject, IRowResultSet rs) throws DataException, IOException {
        this.dataCount += this.databaseExport.exportRestDataToDisk(resultObject, rs);
        this.rowIterator = this.databaseExport.getRowIterator();
    }

    public int getCount() {
        return this.dataCount;
    }

    public IResultObject nextRow() throws IOException {
        return this.rowIterator.fetch();
    }

    public void reset() {
        this.rowIterator.reset();
    }

    public void close() {
        if (this.rowIterator != null) {
            this.rowIterator.close();
            this.rowIterator = null;
        }
        if (this.databaseExport != null) {
            this.databaseExport.close();
            this.databaseExport = null;
        }
        this.resultObjectUtil = null;
    }

    static {
        $assertionsDisabled = !DiskCacheResultSet.class.desiredAssertionStatus();
    }
}

