/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MergeSortRowFiles
implements IRowIterator {
    private IRowIterator[] subRowIterators = null;
    private MergeSortUtil mergeSortUtil = null;
    private IResultObject[] rowBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    MergeSortRowFiles(IRowIterator[] subRowIterators, MergeSortUtil mergeSortUtil) {
        if (!$assertionsDisabled && subRowIterators == null) {
            throw new AssertionError();
        }
        this.subRowIterators = subRowIterators;
        this.mergeSortUtil = mergeSortUtil;
    }

    public void reset() {
        for (int i = 0; i < this.subRowIterators.length; ++i) {
            this.subRowIterators[i].reset();
        }
        this.rowBuffer = null;
    }

    public IResultObject fetch() throws IOException {
        int minObjectPos = 0;
        IResultObject resultObject = null;
        if (this.rowBuffer == null) {
            this.prepareFirstFetch();
        }
        if ((minObjectPos = this.mergeSortUtil.getMinResultObject(this.rowBuffer, this.rowBuffer.length)) < 0) {
            return null;
        }
        resultObject = this.rowBuffer[minObjectPos];
        this.rowBuffer[minObjectPos] = this.subRowIterators[minObjectPos].fetch();
        return resultObject;
    }

    private void prepareFirstFetch() throws IOException {
        this.rowBuffer = new IResultObject[this.subRowIterators.length];
        for (int i = 0; i < this.subRowIterators.length; ++i) {
            this.rowBuffer[i] = this.subRowIterators[i].fetch();
        }
    }

    public void close() {
        for (int i = 0; i < this.subRowIterators.length; ++i) {
            this.subRowIterators[i].close();
        }
        this.subRowIterators = null;
    }

    static {
        $assertionsDisabled = !MergeSortRowFiles.class.desiredAssertionStatus();
    }
}

