/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.FilterCalculator;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;

abstract class RowProcessUtil {
    protected ComputedColumnsState iccState;
    protected ComputedColumnHelper computedColumnHelper;
    protected FilterByRow filterByRow;
    protected PassStatusController psController;
    protected ResultSetPopulator populator;
    protected DataEngineSession session;

    protected RowProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, DataEngineSession session) {
        this.iccState = iccState;
        this.computedColumnHelper = computedColumnHelper;
        this.filterByRow = filterByRow;
        this.psController = psController;
        this.populator = populator;
        this.session = session;
    }

    protected List prepareComputedColumns(int model) throws DataException {
        this.initializeICCState(model);
        ArrayList aggCCList = new ArrayList();
        ArrayList simpleCCList = new ArrayList();
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(model);
            List l = this.computedColumnHelper.getComputedColumnList();
            for (int i = 0; i < l.size(); ++i) {
                if (this.populator.getExpressionProcessor().hasAggregation(((ComputedColumn)l.get(i)).getExpression())) {
                    aggCCList.add(l.get(i));
                    continue;
                }
                simpleCCList.add(l.get(i));
            }
            this.computedColumnHelper.getComputedColumnList().clear();
            this.computedColumnHelper.getComputedColumnList().addAll(simpleCCList);
            this.computedColumnHelper.setRePrepare(true);
        }
        return aggCCList;
    }

    private void initializeICCState(int model) throws DataException {
        if (this.iccState != null) {
            this.iccState.setModel(model);
            for (int i = 0; i < this.iccState.getCount(); ++i) {
                if (this.populator.getExpressionProcessor().hasAggregation(this.iccState.getComputedColumn(i).getExpression())) continue;
                this.iccState.setValueAvailable(i);
            }
        }
    }

    protected void applyFilters(int filterType, boolean changeMaxRows) throws DataException {
        if (this.filterByRow != null && this.filterByRow.isFilterSetExist(filterType)) {
            int max = this.populator.getQuery().getMaxRows();
            if (changeMaxRows) {
                this.populator.getQuery().setMaxRows(0);
            }
            this.filterByRow.setWorkingFilterSet(filterType);
            FilterCalculator.applyFilters(this.populator, this.filterByRow, this.session);
            this.populator.getQuery().setMaxRows(max);
        }
        if (this.filterByRow != null) {
            this.filterByRow.setWorkingFilterSet(4);
        }
    }
}

