/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.StringTokenizer;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.PollingInterval;
import org.eclipse.aperi.snmp.TableHandler;
import org.eclipse.aperi.snmp.TablePollingAction;
import org.eclipse.aperi.snmp.TablePollingFilter;
import org.eclipse.aperi.snmp.TablePollingPreFilter;
import org.eclipse.aperi.snmp.data.OID;

public class TablePoller
extends AbstractSnmpPoller {
    protected boolean changed;
    protected OID[] oids;
    protected int[] index;
    protected TableHandler tableRef;
    protected TablePollingAction action;
    protected TablePollingFilter filter;
    protected TablePollingPreFilter prefilter;
    protected boolean keepOldValues;
    protected int useCount;
    protected int maxRows;
    protected static final int MAX_ROWS = Integer.MAX_VALUE;

    public TablePoller(PollingInterval pollingInterval, String[] stringArray, String string, boolean bl, TableHandler tableHandler, TablePollingAction tablePollingAction, TablePollingFilter tablePollingFilter, TablePollingPreFilter tablePollingPreFilter) {
        this(pollingInterval, stringArray, string, bl, tableHandler, tablePollingAction, tablePollingFilter, tablePollingPreFilter, Integer.MAX_VALUE);
    }

    public TablePoller(PollingInterval pollingInterval, String[] stringArray, String string, boolean bl, TableHandler tableHandler, TablePollingAction tablePollingAction, TablePollingFilter tablePollingFilter, TablePollingPreFilter tablePollingPreFilter, int n) {
        super(pollingInterval);
        this.oids = new OID[stringArray.length];
        int n2 = 0;
        while (n2 < this.oids.length) {
            this.oids[n2] = new OID(stringArray[n2]);
            ++n2;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n3 = stringTokenizer.countTokens();
            this.index = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.index[n4] = Integer.parseInt(stringTokenizer.nextToken());
                ++n4;
            }
        }
        this.keepOldValues = bl;
        this.tableRef = tableHandler;
        this.action = tablePollingAction;
        this.filter = tablePollingFilter;
        this.prefilter = tablePollingPreFilter;
        this.useCount = 1;
        this.maxRows = n;
    }

    public PollingInterval getInterval() {
        return this.interval;
    }

    public void setInterval(PollingInterval pollingInterval) {
        this.interval = pollingInterval;
    }

    public TablePollingAction getAction() {
        return this.action;
    }

    public void setAction(TablePollingAction tablePollingAction) {
        this.action = tablePollingAction;
    }

    public TablePollingFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TablePollingFilter tablePollingFilter) {
        this.filter = tablePollingFilter;
    }

    public TablePollingPreFilter getPreFilter() {
        return this.prefilter;
    }

    public void setPreFilter(TablePollingPreFilter tablePollingPreFilter) {
        this.prefilter = tablePollingPreFilter;
    }

    public synchronized void bumpUseCount() {
        ++this.useCount;
    }

    public synchronized int decrUseCount() {
        --this.useCount;
        return this.useCount;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        if (n != this.maxRows) {
            this.changed = true;
        }
        this.maxRows = n;
    }
}

