/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAInputStream;

public class FolderArchiveReader
implements IDocArchiveReader {
    private String folderName;

    public FolderArchiveReader(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder archive name is null or empty string.");
        }
        File fd = new File(folderName);
        if (!fd.isDirectory()) {
            throw new IOException("The specified name is not a folder name. The FolderArchiveReader is expecting a valid folder archive name.");
        }
        this.folderName = fd.getCanonicalPath();
    }

    public String getName() {
        return this.folderName;
    }

    public void open() {
    }

    public void close() {
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File file = new File(path);
        if (file.exists()) {
            RAFolderInputStream in = new RAFolderInputStream(file);
            return in;
        }
        return null;
    }

    public boolean exists(String relativePath) {
        String fullPath = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(fullPath);
        return fd.exists();
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        File[] files;
        ArrayList<String> streamList = new ArrayList<String>();
        String storagePath = ArchiveUtil.generateFullPath(this.folderName, relativeStoragePath);
        File dir = new File(storagePath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String relativePath;
                File file = files[i];
                if (!file.isFile() || ArchiveUtil.needSkip(relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getPath()))) continue;
                streamList.add(relativePath);
            }
        }
        return streamList;
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, stream + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

