/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.io.RandomAccessFile;

class Block {
    static final int BLOCK_SIZE = 4096;
    static final int BLOCK_SHIFT_SIZE = 12;
    static final int TYPE_UNUSED = -1;
    static final int TYPE_HEAD = 0;
    static final int TYPE_ALLOC = 1;
    static final int TYPE_ENTRY = 2;
    int id = -1;
    Block prev = null;
    Block next = null;
    byte[] blockData = new byte[4096];
    private int blockSize = 0;
    private int dirtyStart = 0;
    private int dirtyEnd = 0;

    Block() {
    }

    void reset() {
        this.id = -1;
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
        this.blockSize = 0;
        this.prev = null;
        this.next = null;
    }

    void refresh(RandomAccessFile rf) throws IOException {
        int size;
        this.blockSize = 0;
        rf.seek((long)this.id * 4096L);
        while ((size = rf.read(this.blockData, this.blockSize, 4096 - this.blockSize)) >= 0) {
            this.blockSize += size;
            if (this.blockSize < 4096) continue;
        }
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public void flush(RandomAccessFile file) throws IOException {
        if (this.dirtyEnd != this.dirtyStart) {
            file.seek((long)this.id * 4096L + (long)this.dirtyStart);
            file.write(this.blockData, this.dirtyStart, this.dirtyEnd - this.dirtyStart);
        }
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public byte[] getData() {
        return this.blockData;
    }

    public int write(int tgt, byte[] b, int off, int len) throws IOException {
        int size = 4096 - tgt;
        if (size > len) {
            size = len;
        }
        System.arraycopy(b, off, this.blockData, tgt, size);
        if (this.dirtyStart > tgt) {
            this.dirtyStart = tgt;
        }
        if (this.dirtyEnd < tgt + size) {
            this.dirtyEnd = tgt + size;
        }
        if (this.blockSize < this.dirtyEnd) {
            this.blockSize = this.dirtyEnd;
        }
        return size;
    }

    public int read(int src, byte[] b, int off, int len) throws IOException {
        int size = this.blockSize - src;
        if (size > len) {
            size = len;
        }
        System.arraycopy(this.blockData, src, b, off, size);
        return size;
    }
}

