/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Observable;
import org.eclipse.aperi.snmp.BasicSnmpStats;
import org.eclipse.aperi.snmp.FullSnmpStats;

public class SnmpStatistics
extends Observable {
    private int numSends;
    private int numRecvs;
    private int numRetries;
    private int numTimeouts;
    private int numVbSent;
    private int numVbRecv;
    private int minRspTime = 10000000;
    private int maxRspTime;
    private long totalRspTime;
    private long lastUsed = System.currentTimeMillis();

    public final synchronized void incrSends(int n) {
        ++this.numSends;
        this.numVbSent += n;
        if (this.countObservers() > 0) {
            this.tellObservers();
        }
    }

    public final synchronized void incrReceives(int n, int n2) {
        ++this.numRecvs;
        this.numVbRecv += n2;
        this.totalRspTime += (long)n;
        if (n < this.minRspTime) {
            this.minRspTime = n;
        }
        if (n > this.maxRspTime) {
            this.maxRspTime = n;
        }
        if (this.countObservers() > 0) {
            this.tellObservers();
        }
    }

    private final synchronized void tellObservers() {
        this.setChanged();
        this.notifyObservers(new BasicSnmpStats(this.numSends, this.numRecvs));
        this.clearChanged();
    }

    public final synchronized void incrRetries() {
        ++this.numRetries;
    }

    public final synchronized void incrTimeouts() {
        ++this.numTimeouts;
    }

    public final synchronized void setLastUsed(long l) {
        this.lastUsed = l;
    }

    public final synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public final synchronized FullSnmpStats getStats() {
        return new FullSnmpStats(this.numSends, this.numRecvs, this.numRetries, this.numTimeouts, this.numVbSent, this.numVbRecv, this.minRspTime, this.maxRspTime, this.totalRspTime);
    }
}

