/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.utils.Orderable;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class Timer
implements Orderable {
    private long popTime;
    private Wakeable sleeper;
    private Object usrData;

    protected Timer(int n, Wakeable wakeable, Object object) {
        this.popTime = System.currentTimeMillis() + (long)n;
        this.sleeper = wakeable;
        this.usrData = object;
    }

    public long getPopTime() {
        return this.popTime;
    }

    public void wakeUp() {
        this.sleeper.wakeUp(this.usrData);
    }

    public int compare(Orderable orderable) {
        Timer timer = (Timer)orderable;
        if (this.popTime < timer.popTime) {
            return 0;
        }
        if (this.popTime == timer.popTime) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Timer: poptime=");
        stringBuffer.append(this.popTime);
        stringBuffer.append(", sleeper=").append(this.sleeper.toString());
        if (this.usrData != null) {
            stringBuffer.append(", userData=").append(this.usrData.toString());
        }
        return stringBuffer.toString();
    }
}

