/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.tsanm.InbandScanner;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.FabricManagerService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.snmpagent.manager.SNMPAgentManager;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FabricActivator
implements BundleActivator {
    protected ServiceRegistration cFabricServiceRegistration;
    protected FabricManagerService cFabricService = null;
    protected ServiceRegistration cSNMPAgentManagerServiceRegistration;
    protected SNMPAgentManager cSNMPAgentManager = null;
    public static final String PROPERTY_NUM_OUTBAND_SCANNERS = "NumOutbandScanners";
    public static final String PROPERTY_NUM_INBAND_SCANNERS = "NumInbandScanners";
    public static final String PROPERTY_NUM_LEGACY_FABRIC_PARSERS = "NumLegacyFabricParsers";
    public static final String PROPERTY_GROUP = "DiscoverService";
    public static final int DEFAULT_NUM_RESOURCES = 5;
    HashSet<OutbandScanner> outbandScanners = null;
    HashSet<InbandScanner> inbandScanners = null;
    HashSet<TSANMLegacyParser> tsanmParsers = null;
    private BundleContext _bundleContext = null;
    public static ServiceHelper _serviceHelper;
    private static IConfigService configServiceProxy;

    static {
        configServiceProxy = null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            this._bundleContext = bundleContext;
            _serviceHelper = new ServiceHelper(this._bundleContext);
            this.startSNMPAgentManagerService(bundleContext);
            Properties properties = this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
            this.startOutbandScanner(properties);
            this.startInbandScanner(properties);
            this.startTSANMParser(properties);
            String[] stringArray = new String[7];
            try {
                clazz7 = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[0] = clazz7.getName();
            try {
                clazz6 = Class.forName("org.eclipse.aperi.fabric.api.IFabricReportingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[1] = clazz6.getName();
            try {
                clazz5 = Class.forName("org.eclipse.aperi.fabric.api.IFabricCollectionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[2] = clazz5.getName();
            try {
                clazz4 = Class.forName("org.eclipse.aperi.fabric.api.IFabricConfigurationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[3] = clazz4.getName();
            try {
                clazz3 = Class.forName("org.eclipse.aperi.fabric.api.IAgentMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[4] = clazz3.getName();
            try {
                clazz2 = Class.forName("org.eclipse.aperi.common.api.IJobMgmtService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[5] = clazz2.getName();
            try {
                clazz = Class.forName("javax.jms.MessageListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            stringArray[6] = clazz.getName();
            String[] stringArray2 = stringArray;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            ((Dictionary)hashtable).put("org.eclipse.aperi.webservice.name", "FabricManagerService");
            this.cFabricService = new FabricManagerService();
            this.cFabricService.startup();
            this.cFabricServiceRegistration = bundleContext.registerService(stringArray2, (Object)this.cFabricService, hashtable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.cFabricServiceRegistration != null) {
            this.cFabricServiceRegistration.unregister();
        }
        if (this.cFabricService != null) {
            this.cFabricService.shutdown();
            this.cFabricService = null;
        }
        this.stopTSANMParser();
        this.stopOutbandScanner();
        this.stopInbandScanner();
        _serviceHelper.dispose();
        _serviceHelper = null;
        this._bundleContext = null;
    }

    protected void startSNMPAgentManagerService(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
        String[] stringArray = new String[1];
        try {
            clazz = Class.forName("org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz.getName();
        String[] stringArray2 = stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ((Dictionary)hashtable).put("org.eclipse.aperi.webservice.name", "SNMPAgentManager");
        this.cSNMPAgentManager = new SNMPAgentManager();
        this.cSNMPAgentManager.startup();
        this.cSNMPAgentManagerServiceRegistration = bundleContext.registerService(stringArray2, (Object)this.cSNMPAgentManager, hashtable);
    }

    public void stopSNMPAgentManagerService(BundleContext bundleContext) throws Exception {
        if (this.cSNMPAgentManagerServiceRegistration != null) {
            this.cSNMPAgentManagerServiceRegistration.unregister();
        }
        this.cSNMPAgentManager.shutdown();
        this.cSNMPAgentManager = null;
    }

    protected void startOutbandScanner(Properties properties) {
        this.outbandScanners = new HashSet();
        int n = this.getCountProperty(PROPERTY_NUM_OUTBAND_SCANNERS, 5, properties);
        int n2 = 0;
        while (n2 < n) {
            this.outbandScanners.add(new OutbandScanner());
            ++n2;
        }
    }

    protected void stopOutbandScanner() {
        Iterator<OutbandScanner> iterator = this.outbandScanners.iterator();
        while (iterator.hasNext()) {
            OutbandScanner outbandScanner = iterator.next();
            outbandScanner.shutdown();
        }
    }

    protected void startInbandScanner(Properties properties) {
        this.inbandScanners = new HashSet();
        int n = this.getCountProperty(PROPERTY_NUM_INBAND_SCANNERS, 5, properties);
        int n2 = 0;
        while (n2 < n) {
            this.inbandScanners.add(new InbandScanner());
            ++n2;
        }
    }

    protected void stopInbandScanner() {
        Iterator<InbandScanner> iterator = this.inbandScanners.iterator();
        while (iterator.hasNext()) {
            InbandScanner inbandScanner = iterator.next();
            inbandScanner.shutdown();
        }
    }

    protected void startTSANMParser(Properties properties) {
        this.tsanmParsers = new HashSet();
        int n = this.getCountProperty(PROPERTY_NUM_LEGACY_FABRIC_PARSERS, 5, properties);
        int n2 = 0;
        while (n2 < n) {
            this.tsanmParsers.add(new TSANMLegacyParser());
            ++n2;
        }
    }

    protected void stopTSANMParser() {
        Iterator<TSANMLegacyParser> iterator = this.tsanmParsers.iterator();
        while (iterator.hasNext()) {
            TSANMLegacyParser tSANMLegacyParser = iterator.next();
            tSANMLegacyParser.shutdown();
        }
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)_serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    private int getCountProperty(String string, int n, Properties properties) {
        int n2 = n;
        try {
            String string2 = properties.getProperty(string);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }
}

