/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.event.SnmpTrapProcessor;
import org.eclipse.aperi.sanmgmt.event.TecEventProcessor;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.snmp.data.OctetString;

public class SANEventMessageHandler
implements MessageListener {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger = null;
    protected transient ILogger traceLogger = null;
    static final String className;
    private DestinationFactory destFactory = null;
    private TecEventProcessor tecEventThread = null;
    private Hashtable snmpThreads = new Hashtable();

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.SANEventMessageHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public SANEventMessageHandler(DestinationFactory destinationFactory) {
        this.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
        this.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
        if (this.msgLogger != null) {
            this.msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        }
        this.destFactory = destinationFactory;
    }

    public void onMessage(Message message) {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "onMessage");
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        new SnmpAddress();
        new OctetString("public", true);
        SANEvent sANEvent = null;
        try {
            sANEvent = (SANEvent)objectMessage.getObject();
            this.logEvent(sANEvent);
        }
        catch (Exception exception) {
            if (this.msgLogger != null) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "onMessage", "SANEventMessage_errorProcessingEvent");
                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "onMessage", (Throwable)exception);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "onMessage", (Throwable)exception);
            }
            return;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "onMessage");
        }
    }

    private void logEvent(SANEvent sANEvent) throws IOException, JMSException {
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)sANEvent);
    }

    public void close() {
        String string = "close";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Enumeration enumeration = this.snmpThreads.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            this.removeSnmpTrapProcessor(string2);
        }
        if (this.tecEventThread != null) {
            this.tecEventThread.stop();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void removeSnmpTrapProcessor(String string) {
        String string2;
        block5: {
            string2 = "removeSnmpTrapProcessor";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            }
            try {
                SnmpTrapProcessor snmpTrapProcessor = (SnmpTrapProcessor)this.snmpThreads.get(string);
                if (snmpTrapProcessor != null) {
                    snmpTrapProcessor.stop();
                }
                this.snmpThreads.remove(string);
                this.traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "SnmpTrapProcessor for " + string + " removed.");
            }
            catch (Exception exception) {
                if (!this.traceLogger.isLogging()) break block5;
                String string3 = "Can't remove SnmpTrapProcessor for " + string + " from hashtable.";
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, string3);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }
}

