/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.LogNode;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class MessageErrorProtocol
extends LogNode
implements ErrorProtocol {
    private boolean showStackTrace = false;
    private long minRepeatTimeSec = 0L;
    private long timeoutMillis = 0L;
    static final long serialVersionUID = -8638012215696764324L;

    public MessageErrorProtocol() {
    }

    public MessageErrorProtocol(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("showStackTrace", new Boolean(this.showStackTrace));
        properties.put("minRepeatTime", Long.toString(this.minRepeatTimeSec));
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("showStackTrace");
        if (string != null) {
            this.showStackTrace = new Boolean(string);
        }
        if ((string = properties.getProperty("minRepeatTime")) != null) {
            this.minRepeatTimeSec = Long.parseLong(string);
        }
    }

    public void error(Handler handler, LogEvent logEvent) {
        this.error(handler, logEvent, null);
    }

    public void error(Handler handler, LogEvent logEvent, Throwable throwable) {
        if (this.minRepeatTimeSec > 0L) {
            long l = logEvent.getTimeStamp();
            if (this.timeoutMillis == 0L || l > this.timeoutMillis) {
                this.timeoutMillis = l + this.minRepeatTimeSec * 1000L;
            } else {
                return;
            }
        }
        String string = LogUtil.getLogMsg("ERR_WRITE_MSG", handler.getName());
        if (throwable != null) {
            String string2 = throwable.getMessage();
            string = string2 != null ? String.valueOf(string) + System.getProperty("line.separator") + string2 : String.valueOf(string) + System.getProperty("line.separator") + throwable.getClass().getName();
        }
        LogUtil.errorMsg(string);
        if (throwable != null && this.showStackTrace) {
            LogUtil.errorStack(throwable);
        }
    }

    public void cleanup(Handler handler) {
    }

    public boolean isCleanupRequired() {
        return false;
    }
}

