/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.util.Properties;

public class RetryErrorProtocol
extends MessageErrorProtocol {
    static final long serialVersionUID = 2730056913313477501L;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_RETRY_INTERVAL = 1000;
    private int maxRetries = 5;
    private int retryInterval = 1000;
    private transient Object retryTimer = new Object();

    public RetryErrorProtocol() {
    }

    public RetryErrorProtocol(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("maxRetries", new Integer(this.getMaxRetries()).toString());
        properties.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("maxRetries");
        if (string != null) {
            this.setMaxRetries(new Integer(string));
        }
        if ((string = properties.getProperty("retryInterval")) != null) {
            this.setRetryInterval(new Integer(string));
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        if (n >= 0) {
            this.maxRetries = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setMaxRetries");
            LogUtil.errorMsg(string);
        }
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int n) {
        if (n >= 0) {
            this.retryInterval = n;
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setRetryInterval");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Handler handler, LogEvent logEvent, Throwable throwable) {
        boolean bl = false;
        int n = 0;
        int n2 = this.getMaxRetries();
        String string = LogUtil.getLogMsg("RETRY_ATTEMPT", handler.getName());
        if (throwable != null) {
            String string2 = throwable.getMessage();
            string = string2 != null ? String.valueOf(string) + System.getProperty("line.separator") + string2 : String.valueOf(string) + System.getProperty("line.separator") + throwable.getClass().getName();
        }
        LogUtil.errorMsg(string);
        while (!bl && n < n2) {
            block9: {
                int n3 = this.getRetryInterval();
                try {
                    if (n3 == 0) break block9;
                    Object object = this.retryTimer;
                    synchronized (object) {
                        this.retryTimer.wait(n3);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                handler.write(logEvent);
                bl = true;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        string = bl ? LogUtil.getLogMsg("RETRY_SUCCEEDED") : LogUtil.getLogMsg("RETRY_FAILED");
        LogUtil.errorMsg(string);
    }

    public void cleanup(Handler handler) {
    }

    public boolean isCleanupRequired() {
        return false;
    }
}

