/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class XMLUtil {
    public static final char AMPERSAND = '&';
    public static final String XML_AMP = "&amp;";
    public static final char LEFT_ANGLE_BRACKET = '<';
    public static final String XML_LT = "&lt;";
    public static final char RIGHT_ANGLE_BRACKET = '>';
    public static final String XML_GT = "&gt;";
    public static final char APOSTROPHE = '\'';
    public static final String XML_APOS = "&apos;";
    public static final char DOUBLE_QUOTE = '\"';
    public static final String XML_QUOT = "&quot;";
    public static final char CARRIAGE_RETURN = '\r';
    public static final String XML_HEX_CR = "&#xD;";
    public static final char LINEFEED = '\n';
    public static final String XML_HEX_LF = "&#xA;";
    public static final char TAB = '\t';
    public static final String XML_HEX_TAB = "&#x9;";
    public static final String UNKNOWN_CHAR = "?";
    public static final char U0020 = ' ';
    public static final char UD7FF = '\ud7ff';
    public static final char UE000 = '\ue000';
    public static final char UFFFD = '\ufffd';

    private XMLUtil() {
    }

    public static String getXMLEscapeIfNeeded(char c) {
        String string = null;
        if ('&' == c) {
            string = XML_AMP;
        } else if ('<' == c) {
            string = XML_LT;
        } else if ('>' == c) {
            string = XML_GT;
        } else if ('\'' == c) {
            string = XML_APOS;
        } else if ('\"' == c) {
            string = XML_QUOT;
        } else if ('\r' == c) {
            string = XML_HEX_CR;
        } else if ('\n' == c) {
            string = XML_HEX_LF;
        } else if ('\t' == c) {
            string = XML_HEX_TAB;
        } else if (!(c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
            string = UNKNOWN_CHAR;
        }
        return string;
    }

    public static String escapeXMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                String string2 = XMLUtil.getXMLEscapeIfNeeded(c);
                if (string2 == null) {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(string2);
                }
                c = stringCharacterIterator.next();
            }
        }
        return stringBuffer.toString();
    }

    public static String[] escapeXMLChunks(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n <= 0) {
            throw new IllegalArgumentException("maxChunkLen<=0");
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            char c = stringCharacterIterator.first();
            while (c != '\uffff') {
                int n3;
                String string2 = XMLUtil.getXMLEscapeIfNeeded(c);
                int n4 = n3 = string2 == null ? 1 : string2.length();
                if (n2 + n3 > n) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    n2 = 0;
                } else {
                    n2 += n3;
                }
                if (string2 == null) {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(string2);
                }
                c = stringCharacterIterator.next();
            }
            arrayList.add(stringBuffer.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

